/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.utils;

import cn.vonce.common.utils.ByteUtil;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HashUtil {
    public static String sha1(String input) {
        return HashUtil.sha1(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha1(byte[] input) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(input);
        byte[] digest = md.digest();
        return ByteUtil.toHexString(digest);
    }

    public static byte[] sha1AsBytes(String input) {
        return HashUtil.sha1AsBytes(input.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha1AsBytes(byte[] input) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(input);
        return md.digest();
    }

    public static String sha256(String input) {
        return HashUtil.sha256(input.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha256AsBytes(String input) {
        return HashUtil.sha256AsBytes(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha256(byte[] input) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(input);
        byte[] digest = md.digest();
        return ByteUtil.toHexString(digest);
    }

    public static byte[] sha256AsBytes(byte[] input) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(input);
        return md.digest();
    }

    public static byte[] sha512AsBytes(byte[] input) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(input);
        return md.digest();
    }

    public static byte[] hmacSha256AsBytes(byte[] data, byte[] key) {
        Mac mac;
        SecretKeySpec skey = new SecretKeySpec(key, "HmacSHA256");
        try {
            mac = Mac.getInstance("HmacSHA256");
            mac.init(skey);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        mac.update(data);
        return mac.doFinal();
    }

    public static String hmacSha256(byte[] data, byte[] key) {
        return ByteUtil.toHexString(HashUtil.hmacSha256AsBytes(data, key));
    }

    public static byte[] hmacSha1(byte[] data, byte[] key) {
        Mac mac;
        SecretKeySpec skey = new SecretKeySpec(key, "HmacSHA1");
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(skey);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        mac.update(data);
        return mac.doFinal();
    }

    public static String hmacSha256(String data, String key) {
        return HashUtil.hmacSha256(data.getBytes(StandardCharsets.UTF_8), key.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] hmacSha256AsBytes(String data, String key) {
        return HashUtil.hmacSha256AsBytes(data.getBytes(StandardCharsets.UTF_8), key.getBytes(StandardCharsets.UTF_8));
    }

    public static String hmacSha256(byte[] data, String key) {
        return HashUtil.hmacSha256(data, key.getBytes(StandardCharsets.UTF_8));
    }
}

