/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdCardUtil {
    public static Result validate(String IDStr) {
        String Ai = "";
        if (IDStr.length() != 15 && IDStr.length() != 18) {
            return new Result(false, "\u8eab\u4efd\u8bc1\u53f7\u7801\u957f\u5ea6\u5e94\u8be5\u4e3a15\u4f4d\u621618\u4f4d");
        }
        if (IDStr.length() == 18) {
            Ai = IDStr.substring(0, 17);
        } else if (IDStr.length() == 15) {
            Ai = IDStr.substring(0, 6) + "19" + IDStr.substring(6, 15);
        }
        if (!IdCardUtil.isNumeric(Ai)) {
            return new Result(false, "\u8eab\u4efd\u8bc115\u4f4d\u53f7\u7801\u90fd\u5e94\u4e3a\u6570\u5b57\uff0c18\u4f4d\u53f7\u7801\u9664\u6700\u540e\u4e00\u4f4d\u5916\uff0c\u90fd\u5e94\u4e3a\u6570\u5b57");
        }
        String strYear = Ai.substring(6, 10);
        String strMonth = Ai.substring(10, 12);
        String strDay = Ai.substring(12, 14);
        if (!IdCardUtil.isDate(strYear + "-" + strMonth + "-" + strDay)) {
            return new Result(false, "\u8eab\u4efd\u8bc1\u51fa\u751f\u65e5\u671f\u65e0\u6548");
        }
        GregorianCalendar gc = new GregorianCalendar();
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (gc.get(1) - Integer.parseInt(strYear) > 150 || gc.getTime().getTime() - s.parse(strYear + "-" + strMonth + "-" + strDay).getTime() < 0L) {
                return new Result(false, "\u8eab\u4efd\u8bc1\u751f\u65e5\u4e0d\u5728\u6709\u6548\u8303\u56f4");
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return new Result(false, "" + e.getMessage());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Result(false, "" + e.getMessage());
        }
        if (Integer.parseInt(strMonth) > 12 || Integer.parseInt(strMonth) == 0) {
            return new Result(false, "\u8eab\u4efd\u8bc1\u6708\u4efd\u65e0\u6548");
        }
        if (Integer.parseInt(strDay) > 31 || Integer.parseInt(strDay) == 0) {
            return new Result(false, "\u8eab\u4efd\u8bc1\u65e5\u671f\u65e0\u6548");
        }
        Map<String, String> areacode = IdCardUtil.GetAreaCode();
        if (areacode.get(Ai.substring(0, 2)) == null) {
            return new Result(false, "\u8eab\u4efd\u8bc1\u5730\u533a\u7f16\u7801\u9519\u8bef");
        }
        if (!IdCardUtil.isVarifyCode(Ai, IDStr)) {
            return new Result(false, "\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u5408\u6cd5");
        }
        return new Result(true, "\u8be5\u8eab\u4efd\u8bc1\u6709\u6548");
    }

    private static boolean isVarifyCode(String Ai, String IDStr) {
        String[] VarifyCode = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
        String[] Wi = new String[]{"7", "9", "10", "5", "8", "4", "2", "1", "6", "3", "7", "9", "10", "5", "8", "4", "2"};
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += Integer.parseInt(String.valueOf(Ai.charAt(i))) * Integer.parseInt(Wi[i]);
        }
        int modValue = sum % 11;
        String strVerifyCode = VarifyCode[modValue];
        Ai = Ai + strVerifyCode;
        return IDStr.length() != 18 || Ai.equals(IDStr);
    }

    private static Map<String, String> GetAreaCode() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("11", "\u5317\u4eac");
        hashtable.put("12", "\u5929\u6d25");
        hashtable.put("13", "\u6cb3\u5317");
        hashtable.put("14", "\u5c71\u897f");
        hashtable.put("15", "\u5185\u8499\u53e4");
        hashtable.put("21", "\u8fbd\u5b81");
        hashtable.put("22", "\u5409\u6797");
        hashtable.put("23", "\u9ed1\u9f99\u6c5f");
        hashtable.put("31", "\u4e0a\u6d77");
        hashtable.put("32", "\u6c5f\u82cf");
        hashtable.put("33", "\u6d59\u6c5f");
        hashtable.put("34", "\u5b89\u5fbd");
        hashtable.put("35", "\u798f\u5efa");
        hashtable.put("36", "\u6c5f\u897f");
        hashtable.put("37", "\u5c71\u4e1c");
        hashtable.put("41", "\u6cb3\u5357");
        hashtable.put("42", "\u6e56\u5317");
        hashtable.put("43", "\u6e56\u5357");
        hashtable.put("44", "\u5e7f\u4e1c");
        hashtable.put("45", "\u5e7f\u897f");
        hashtable.put("46", "\u6d77\u5357");
        hashtable.put("50", "\u91cd\u5e86");
        hashtable.put("51", "\u56db\u5ddd");
        hashtable.put("52", "\u8d35\u5dde");
        hashtable.put("53", "\u4e91\u5357");
        hashtable.put("54", "\u897f\u85cf");
        hashtable.put("61", "\u9655\u897f");
        hashtable.put("62", "\u7518\u8083");
        hashtable.put("63", "\u9752\u6d77");
        hashtable.put("64", "\u5b81\u590f");
        hashtable.put("65", "\u65b0\u7586");
        hashtable.put("71", "\u53f0\u6e7e");
        hashtable.put("81", "\u9999\u6e2f");
        hashtable.put("82", "\u6fb3\u95e8");
        hashtable.put("91", "\u56fd\u5916");
        return hashtable;
    }

    private static boolean isNumeric(String strnum) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(strnum);
        return isNum.matches();
    }

    public static boolean isDate(String strDate) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))?$");
        Matcher m = pattern.matcher(strDate);
        return m.matches();
    }

    public static String getEighteenIDCard(String fifteenIDCard) throws Exception {
        if (fifteenIDCard != null && fifteenIDCard.length() == 15) {
            StringBuilder sb = new StringBuilder();
            sb.append(fifteenIDCard.substring(0, 6)).append("19").append(fifteenIDCard.substring(6));
            sb.append(IdCardUtil.getVerifyCode(sb.toString()));
            return sb.toString();
        }
        throw new Exception("\u4e0d\u662f15\u4f4d\u7684\u8eab\u4efd\u8bc1");
    }

    private static char getVerifyCode(String idCardNumber) throws Exception {
        if (idCardNumber == null || idCardNumber.length() < 17) {
            throw new Exception("\u4e0d\u5408\u6cd5\u7684\u8eab\u4efd\u8bc1\u53f7\u7801");
        }
        char[] Ai = idCardNumber.toCharArray();
        int[] Wi = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        char[] verifyCode = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int S = 0;
        for (int i = 0; i < Wi.length; ++i) {
            S += (Ai[i] - 48) * Wi[i];
        }
        int Y = S % 11;
        return verifyCode[Y];
    }

    public static void main(String[] args) {
        Scanner s = new Scanner(System.in);
        System.out.println("\u8bf7\u8f93\u5165\u4f60\u7684\u8eab\u4efd\u8bc1\u53f7\u7801\uff1a");
        String IdCard = new String(s.next());
        IdCard = IdCard.toUpperCase();
        System.out.println(IdCardUtil.validate(IdCard).isOk());
        s.close();
    }

    public static class Result {
        private boolean ok;
        private String message;

        public Result() {
        }

        public Result(boolean ok, String message) {
            this.ok = ok;
            this.message = message;
        }

        public boolean isOk() {
            return this.ok;
        }

        protected void setOk(boolean ok) {
            this.ok = ok;
        }

        public String getMessage() {
            return this.message;
        }

        protected void setMessage(String message) {
            this.message = message;
        }
    }
}

