/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.utils;

import cn.vonce.common.utils.SystemClock;
import java.net.InetAddress;
import java.util.concurrent.ThreadLocalRandom;

public final class SnowflakeId18 {
    private static final long START_TIME = 1519740777809L;
    private static final long DATA_CENTER_ID_BITS = 2L;
    private static final long WORKER_ID_BITS = 8L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_WORKER_ID = 255L;
    private static final long MAX_DATA_CENTER_ID = 3L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 20L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long workerId;
    private final long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static byte LAST_IP = 0;
    private final boolean clock;
    private final long timeOffset;
    private final boolean randomSequence;
    private final ThreadLocalRandom tlr = ThreadLocalRandom.current();

    public SnowflakeId18(long dataCenterId) {
        this(dataCenterId, 0xFF & SnowflakeId18.getLastIPAddress(), false, 5L, false);
    }

    public SnowflakeId18(long dataCenterId, boolean clock, boolean randomSequence) {
        this(dataCenterId, 0xFF & SnowflakeId18.getLastIPAddress(), clock, 5L, randomSequence);
    }

    public SnowflakeId18(long dataCenterId, long workerId, boolean clock, long timeOffset, boolean randomSequence) {
        if (dataCenterId > 3L || dataCenterId < 0L) {
            throw new IllegalArgumentException("Data Center Id can't be greater than 3 or less than 0");
        }
        if (workerId > 255L || workerId < 0L) {
            throw new IllegalArgumentException("Worker Id can't be greater than 255 or less than 0");
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.clock = clock;
        this.timeOffset = timeOffset;
        this.randomSequence = randomSequence;
    }

    public synchronized Long nextId() {
        long currentTimestamp = this.timeGen();
        if (currentTimestamp < this.lastTimestamp) {
            long offset = this.lastTimestamp - currentTimestamp;
            if (offset > this.timeOffset) {
                throw new RuntimeException("Clock moved backwards, refusing to generate id for [" + offset + "ms]");
            }
            try {
                this.wait(offset << 1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            currentTimestamp = this.timeGen();
            if (currentTimestamp < this.lastTimestamp) {
                throw new RuntimeException("Clock moved backwards, refusing to generate id for [" + offset + "ms]");
            }
        }
        if (this.lastTimestamp == currentTimestamp) {
            long tempSequence = this.sequence + 1L;
            if (this.randomSequence && tempSequence > 4095L) {
                tempSequence %= 4095L;
            }
            this.sequence = tempSequence & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = this.randomSequence ? this.tlr.nextLong(4096L) : 0L;
        }
        this.lastTimestamp = currentTimestamp;
        long currentOffsetTime = currentTimestamp - 1519740777809L;
        return currentOffsetTime << 22 | this.dataCenterId << 20 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return this.clock ? SystemClock.INSTANCE.currentTimeMillis() : System.currentTimeMillis();
    }

    public static byte getLastIPAddress() {
        if (LAST_IP != 0) {
            return LAST_IP;
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] addressByte = inetAddress.getAddress();
            LAST_IP = addressByte[addressByte.length - 1];
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown Host Exception", e);
        }
        return LAST_IP;
    }
}

