/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.utils;

import cn.vonce.common.utils.FastJsonUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlConverUtil {
    public static String map2Xml(Map<String, ?> map) {
        return XmlConverUtil.map2Xml(map, map.getClass().getSimpleName());
    }

    public static String map2Xml(Map<String, ?> map, String elementName) {
        Document document = DocumentHelper.createDocument();
        if (elementName == null || elementName.trim().equals("")) {
            elementName = "xml";
        }
        Element nodeElement = document.addElement(elementName);
        for (String key : map.keySet()) {
            Element keyElement = nodeElement.addElement(key);
            keyElement.setText(map.get(key) == null ? "" : (String)map.get(key));
        }
        return XmlConverUtil.doc2Xml(document);
    }

    public static String map2XmlKey(Map<String, ?> map) {
        return XmlConverUtil.map2XmlKey(map, map.getClass().getSimpleName());
    }

    public static String map2XmlKey(Map<String, ?> map, String elementName) {
        Document document = DocumentHelper.createDocument();
        if (elementName == null || elementName.trim().equals("")) {
            elementName = "xml";
        }
        Element nodeElement = document.addElement(elementName);
        for (String key : map.keySet()) {
            Element keyElement = nodeElement.addElement("key");
            keyElement.addAttribute("label", String.valueOf(key));
            keyElement.setText(String.valueOf(map.get(key)));
        }
        return XmlConverUtil.doc2Xml(document);
    }

    public static String list2Xml(List<?> list) {
        return XmlConverUtil.list2Xml(list, list.getClass().getSimpleName(), null);
    }

    public static String list2Xml(List<?> list, String rootElementName, String elementName) {
        Document document = DocumentHelper.createDocument();
        Element nodesElement = document.addElement(rootElementName);
        int i = 0;
        for (Object o : list) {
            if (elementName == null || elementName.equals("")) {
                elementName = o.getClass().getSimpleName();
            }
            Element nodeElement = nodesElement.addElement(elementName);
            if (o instanceof Map) {
                Map map = (Map)o;
                for (String key : map.keySet()) {
                    Element keyElement = nodeElement.addElement(key);
                    keyElement.setText(map.get(key) == null ? "" : (String)map.get(key));
                }
            } else {
                Element keyElement = nodeElement.addElement(String.valueOf(i));
                keyElement.setText(String.valueOf(o));
            }
            ++i;
        }
        return XmlConverUtil.doc2Xml(document);
    }

    public static String list2XmlKey(List<?> list) {
        return XmlConverUtil.list2XmlKey(list, list.getClass().getSimpleName(), null);
    }

    public static String list2XmlKey(List<?> list, String rootElementName, String elementName) {
        Document document = DocumentHelper.createDocument();
        Element nodesElement = document.addElement(rootElementName);
        int i = 0;
        for (Object o : list) {
            if (elementName == null || elementName.equals("")) {
                elementName = o.getClass().getSimpleName();
            }
            Element nodeElement = nodesElement.addElement(elementName);
            if (o instanceof Map) {
                Map map = (Map)o;
                for (String key : map.keySet()) {
                    Element keyElement = nodeElement.addElement("key");
                    keyElement.addAttribute("label", String.valueOf(key));
                    keyElement.setText(map.get(key) == null ? "" : (String)map.get(key));
                }
            } else {
                Element keyElement = nodeElement.addElement("key");
                keyElement.addAttribute("label", String.valueOf(i));
                keyElement.setText(String.valueOf(o));
            }
            ++i;
        }
        return XmlConverUtil.doc2Xml(document);
    }

    public static List<Map<String, Object>> xml2List(String xml) {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            Document document = DocumentHelper.parseText((String)xml);
            Element nodesElement = document.getRootElement();
            List nodes = nodesElement.elements();
            for (Element nodeElement : nodes) {
                Map<String, Object> map = XmlConverUtil.xml2Map(nodeElement.asXML());
                if (map == null || map.size() <= 0) continue;
                list.add(map);
                map = null;
            }
            nodes = null;
            nodesElement = null;
            document = null;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doc2Xml(Document document) {
        String s = "";
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputFormat format = new OutputFormat(" ", true, "UTF-8");
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.write(document);
            s = out.toString("UTF-8");
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return s;
    }

    public static Map<String, Object> xml2Map(String xml) throws DocumentException {
        Document document = DocumentHelper.parseText((String)xml);
        return XmlConverUtil.element2Map(document.getRootElement());
    }

    public static Map<String, Object> element2Map(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List listAttr = element.attributes();
        for (Attribute attr : listAttr) {
            map.put(attr.getName(), attr.getValue());
        }
        List listElement = element.elements();
        if (!listElement.isEmpty()) {
            for (Element e : listElement) {
                if (e.attributes().isEmpty() && e.elements().isEmpty()) {
                    map.put(e.getName(), e.getTextTrim());
                    continue;
                }
                if (!map.containsKey(e.getName())) {
                    map.put(e.getName(), new ArrayList());
                }
                ((ArrayList)map.get(e.getName())).add(XmlConverUtil.element2Map(e));
            }
        }
        return map;
    }

    public static Map<String, Object> xml2JsonStyleMap(String xml) throws DocumentException {
        Document document = DocumentHelper.parseText((String)xml);
        return XmlConverUtil.xml2JsonStyleMap(document.getRootElement());
    }

    public static Map<String, Object> xml2JsonStyleMap(Element element) {
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!element.attributes().isEmpty()) {
            List attributeList = element.attributes();
            for (Attribute attribute : attributeList) {
                map.put(attribute.getQualifiedName(), attribute.getValue());
            }
        }
        List listElement = element.elements();
        Map<String, Integer> countMap = XmlConverUtil.getCountMap(listElement);
        for (Element childElement : listElement) {
            Map<String, Object> objectMap = XmlConverUtil.xml2JsonStyleMap(childElement);
            if (countMap.containsKey(childElement.getQualifiedName()) && countMap.get(childElement.getQualifiedName()) > 1) {
                Object object = map.get(childElement.getQualifiedName());
                ArrayList<Map<String, Object>> mapList = object instanceof List ? (ArrayList<Map<String, Object>>)object : new ArrayList<Map<String, Object>>();
                mapList.add(objectMap);
                map.put(childElement.getQualifiedName(), mapList);
                continue;
            }
            map.put(childElement.getQualifiedName(), objectMap);
        }
        if (element.isRootElement()) {
            rootMap.put(element.getQualifiedName(), map);
        } else {
            rootMap.putAll(map);
        }
        return rootMap;
    }

    private static Map<String, Integer> getCountMap(List<Element> listElement) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (Element childElement : listElement) {
            if (countMap.containsKey(childElement.getQualifiedName())) {
                int count = (Integer)countMap.get(childElement.getQualifiedName());
                countMap.put(childElement.getQualifiedName(), ++count);
                continue;
            }
            countMap.put(childElement.getQualifiedName(), 1);
        }
        return countMap;
    }

    public static void main(String[] args) {
        String xmlapp = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:context=\"http://www.springframework.org/schema/context\" xmlns:aop=\"http://www.springframework.org/schema/aop\" xmlns:tx=\"http://www.springframework.org/schema/tx\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd http://www.springframework.org/schema/aop http://www.springframework.org/schema/aop/spring-aop.xsd http://www.springframework.org/schema/tx http://www.springframework.org/schema/tx/spring-tx.xsd\"><context:component-scan base-package=\"com.hk.ssm.*\" ><context:exclude-filter type=\"annotation\" expression=\"org.springframework.stereotype.Controller\" /></context:component-scan><bean id=\"mappingJacksonHttpMessageConverter\" class=\"org.springframework.http.converter.json.MappingJackson2HttpMessageConverter\"><property name=\"supportedMediaTypes\"><list><value>text/html;charset=UTF-8</value></list></property></bean><bean class=\"org.springframework.web.servlet.mvc.annotation.AnnotationMethodHandlerAdapter\"><property name=\"messageConverters\"><list><ref bean=\"mappingJacksonHttpMessageConverter\" /></list></property></bean><context:property-placeholder location=\"classpath*:config/*.properties\" /><bean id=\"dataSource\" class=\"com.alibaba.druid.pool.DruidDataSource\" destroy-method=\"close\"><property name=\"url\" value=\"${jdbc.url}\" /><property name=\"username\" value=\"${jdbc.username}\" /><property name=\"password\" value=\"${jdbc.password}\" /><property name=\"driverClassName\" value=\"${jdbc.driverClassName}\" /><property name=\"maxActive\" value=\"${jdbc.maxActive}\" /><property name=\"minIdle\" value=\"${jdbc.minIdle}\" /></bean><bean id=\"sqlSessionFactory\" class=\"org.mybatis.spring.SqlSessionFactoryBean\"><property name=\"dataSource\" ref=\"dataSource\" /><property name=\"configLocation\" value=\"classpath:SqlMapConfig.xml\" /><property name=\"typeAliasesPackage\" value=\"com.hk.ssm.pojo\" /></bean><bean id=\"mapperScanner\" class=\"org.mybatis.spring.mapper.MapperScannerConfigurer\"><property name=\"basePackage\" value=\"com.hk.ssm.mapper\" /><property name=\"sqlSessionFactoryBeanName\" value=\"sqlSessionFactory\" /></bean><bean id=\"transactionManager\" class=\"org.springframework.jdbc.datasource.DataSourceTransactionManager\"><property name=\"dataSource\" ref=\"dataSource\" /></bean><tx:annotation-driven transaction-manager=\"transactionManager\" /><tx:advice id=\"txAdvice\" transaction-manager=\"transactionManager\"><tx:attributes><tx:method name=\"find*\" read-only=\"true\"/><tx:method name=\"*\" isolation=\"DEFAULT\"/></tx:attributes></tx:advice><aop:config><aop:advisor advice-ref=\"txAdvice\" pointcut=\"execution(* com.hk.ssm.service.impl.*ServiceImpl.*(..))\"/></aop:config><tx:annotation-driven transaction-manager=\"transactionManager\" /></beans>";
        try {
            System.out.println(FastJsonUtil.obj2Json(XmlConverUtil.xml2JsonStyleMap(xmlapp)));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }
}

