/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.helper;

import android.content.Context;
import cn.vonce.sql.helper.DatabaseHelper;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.orm.service.SqlBeanService;
import cn.vonce.sql.orm.service.impl.SqlBeanServiceImpl;
import java.util.Map;
import java.util.WeakHashMap;

public class SQLiteHelper {
    private static SQLiteHelper defaultSqLiteHelper;
    private static final Map<String, SQLiteHelper> sqLiteHelperMap;
    private final Map<Class<?>, SqlBeanService> sqlBeanServiceImplMap = new WeakHashMap();
    private Context context;
    private String name;
    private int version;

    private SQLiteHelper(Context context, String name, int version) {
        this.context = context;
        this.name = name;
        this.version = version;
    }

    public static void init(Context context, String name, int version) {
        if (defaultSqLiteHelper == null) {
            defaultSqLiteHelper = new SQLiteHelper(context, name, version);
        }
    }

    public static SQLiteHelper db(Context context, String name, int version) {
        SQLiteHelper sqLiteHelper = sqLiteHelperMap.get(name);
        if (sqLiteHelper == null) {
            sqLiteHelper = new SQLiteHelper(context, name, version);
        } else if (sqLiteHelper.version != version) {
            sqLiteHelper.version = version;
            sqLiteHelperMap.put(name, sqLiteHelper);
            sqLiteHelper.sqlBeanServiceImplMap.clear();
        }
        return sqLiteHelper;
    }

    public static SQLiteHelper db() {
        SqlHelper.isNull(defaultSqLiteHelper, "\u8bf7\u521d\u59cb\u5316\u9ed8\u8ba4\u6570\u636e\u5e93");
        return defaultSqLiteHelper;
    }

    public SqlBeanService get(Class<?> clazz) {
        SqlBeanServiceImpl sqlBeanService = this.sqlBeanServiceImplMap.get(clazz);
        if (sqlBeanService == null) {
            sqlBeanService = new SqlBeanServiceImpl(clazz, new DatabaseHelper(clazz, this.context, this.name, null, this.version));
            this.sqlBeanServiceImplMap.put(clazz, sqlBeanService);
        }
        return sqlBeanService;
    }

    static {
        sqLiteHelperMap = new WeakHashMap<String, SQLiteHelper>();
    }
}

