/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.orm.mapper;

import android.database.Cursor;
import cn.vonce.sql.annotation.SqlJoin;
import cn.vonce.sql.orm.mapper.RowMapper;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SqlBeanMapper<T>
implements RowMapper<T> {
    public Class<?> clazz;
    public Class<?> returnType;

    public SqlBeanMapper(Class<?> clazz, Class<?> returnType) {
        this.clazz = clazz;
        this.returnType = returnType;
    }

    @Override
    public T mapRow(Cursor cursor, int index) {
        Object object = null;
        if (cursor.moveToNext()) {
            object = SqlBeanUtil.isMap(this.returnType.getName()) ? this.mapHandleResultSet(cursor) : (!SqlBeanUtil.isBaseType(this.returnType.getName()) ? this.beanHandleResultSet(this.clazz, cursor) : this.baseHandleResultSet(cursor));
        }
        return (T)object;
    }

    public Object baseHandleResultSet(Cursor cursor) {
        Object value = null;
        value = this.getValue(cursor.getType(0), 0, cursor);
        if (value == null || value.equals("null")) {
            value = SqlBeanMapper.getDefaultValueByColumnType(cursor.getType(0));
        }
        return value;
    }

    public Object mapHandleResultSet(Cursor cursor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 1; i <= cursor.getColumnCount(); ++i) {
            Object value = this.getValue(cursor.getType(i), i, cursor);
            if (value == null || value.equals("null")) {
                value = SqlBeanMapper.getDefaultValueByColumnType(cursor.getType(i));
            }
            map.put(cursor.getColumnName(i), value);
        }
        return map;
    }

    public Object beanHandleResultSet(Class<?> clazz, Cursor cursor) {
        List<String> columnNameList = Arrays.asList(cursor.getColumnNames());
        Object bean = null;
        try {
            bean = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        String tableAlias = SqlBeanUtil.getTable(clazz).getAlias();
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        for (Field field : fieldList) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            SqlJoin sqlJoin = field.getAnnotation(SqlJoin.class);
            String fieldName = field.getName();
            if (sqlJoin != null) {
                if (sqlJoin.isBean()) {
                    Field[] subFields;
                    Class<?> subClazz = field.getType();
                    Object subBean = null;
                    try {
                        subBean = subClazz.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    String subTableAlias = SqlBeanUtil.getTable(subClazz).getAlias();
                    if (StringUtil.isNotEmpty(sqlJoin.table())) {
                        subTableAlias = sqlJoin.table();
                    }
                    if (StringUtil.isNotEmpty(sqlJoin.tableAlias())) {
                        subTableAlias = sqlJoin.tableAlias();
                    }
                    for (Field subField : subFields = subClazz.getDeclaredFields()) {
                        if (Modifier.isStatic(subField.getModifiers())) continue;
                        String subFieldName = subField.getName();
                        subFieldName = subTableAlias + "_" + subFieldName;
                        this.setFieldValue(subBean, subField, subFieldName, cursor);
                    }
                    ReflectUtil.setFieldValue(bean, fieldName, subBean);
                    continue;
                }
                String subTableAlias = sqlJoin.table();
                if (StringUtil.isNotEmpty(sqlJoin.tableAlias())) {
                    subTableAlias = sqlJoin.tableAlias();
                }
                this.setFieldValue(bean, field, subTableAlias + "_" + fieldName, cursor);
                continue;
            }
            if (!columnNameList.contains(fieldName)) {
                fieldName = tableAlias + "_" + fieldName;
            }
            this.setFieldValue(bean, field, fieldName, cursor);
        }
        return bean;
    }

    public void setFieldValue(Object obj, Field field, String fieldName, Cursor cursor) {
        Object value = this.getValue(field.getType().getName(), fieldName, cursor);
        if (value == null || value.equals("null")) {
            value = SqlBeanMapper.getDefaultValue(field.getType().getName());
        }
        ReflectUtil.setFieldValue(obj, field.getName(), value);
    }

    public Object getValue(String fieldType, String fieldName, Cursor cursor) {
        Object value = null;
        int index = cursor.getColumnIndex(fieldName);
        switch (fieldType) {
            case "byte": 
            case "java.lang.Byte": {
                value = Byte.parseByte(cursor.getShort(index) + "");
                break;
            }
            case "short": 
            case "java.lang.Short": {
                value = cursor.getShort(index);
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                value = cursor.getInt(index);
                break;
            }
            case "float": 
            case "java.lang.Float": {
                value = Float.valueOf(cursor.getFloat(index));
                break;
            }
            case "double": 
            case "java.lang.Double": {
                value = cursor.getDouble(index);
                break;
            }
            case "long": 
            case "java.lang.Long": {
                value = cursor.getLong(index);
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                short bool = cursor.getShort(index);
                if (bool > 0) {
                    value = true;
                    break;
                }
                value = false;
                break;
            }
            case "char": 
            case "java.lang.Character": 
            case "java.lang.String": {
                value = cursor.getString(index);
                break;
            }
            case "java.sql.Date": {
                value = new Date(cursor.getLong(index));
                break;
            }
            case "java.sql.Time": {
                value = new Time(cursor.getLong(index));
                break;
            }
            case "java.sql.Timestamp": {
                value = new Timestamp(cursor.getLong(index));
                break;
            }
            case "java.util.Date": {
                long timestamp = cursor.getLong(index);
                String stringTimestamp = timestamp + "";
                if (stringTimestamp.length() == 10 || stringTimestamp.length() == 13) {
                    value = new java.util.Date(timestamp);
                    break;
                }
                value = DateUtil.stringToDate(cursor.getString(index));
                break;
            }
            case "java.math.BigDecimal": {
                value = new BigDecimal(cursor.getDouble(index));
                break;
            }
            default: {
                value = cursor.getBlob(index);
            }
        }
        return value;
    }

    public Object getValue(int jdbcType, int index, Cursor cursor) {
        Object value = null;
        switch (jdbcType) {
            case 1: {
                value = cursor.getLong(index);
                break;
            }
            case 2: {
                value = cursor.getDouble(index);
                break;
            }
            case 3: {
                value = cursor.getString(index);
                break;
            }
            case 4: {
                value = cursor.getBlob(index);
            }
        }
        return value;
    }

    public static Object getDefaultValue(String typeName) {
        Constable value = null;
        switch (typeName) {
            case "byte": 
            case "java.lang.Byte": {
                value = new Byte("0");
                break;
            }
            case "short": 
            case "java.lang.Short": {
                value = new Short("0");
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                value = 0;
                break;
            }
            case "long": 
            case "java.lang.Long": {
                value = 0L;
                break;
            }
            case "float": 
            case "java.lang.Float": {
                value = Float.valueOf(0.0f);
                break;
            }
            case "double": 
            case "java.lang.Double": {
                value = 0.0;
                break;
            }
            case "char": 
            case "java.lang.Char": {
                value = Character.valueOf('\u0000');
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                value = Boolean.valueOf(false);
            }
        }
        return value;
    }

    public static Object getDefaultValueByColumnType(int jdbcType) {
        Number value = null;
        switch (jdbcType) {
            case 1: {
                value = 0;
                break;
            }
            case 2: {
                value = Float.valueOf(0.0f);
                break;
            }
            case 3: 
            case 4: {
                value = null;
            }
        }
        return value;
    }

    public static Object getValueConvert(String typeName, Object value) {
        Object newValue = value;
        switch (typeName) {
            case "byte": 
            case "java.lang.Byte": {
                newValue = new Byte(value.toString());
                break;
            }
            case "short": 
            case "java.lang.Short": {
                newValue = new Short(value.toString());
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                newValue = new Integer(value.toString());
                break;
            }
            case "long": 
            case "java.lang.Long": {
                newValue = new Long(value.toString());
                break;
            }
            case "float": 
            case "java.lang.Float": {
                newValue = new Float(value.toString());
                break;
            }
            case "double": 
            case "java.lang.Double": {
                newValue = new Double(value.toString());
            }
        }
        return newValue;
    }
}

