/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.page;

import android.util.Log;
import cn.vonce.sql.bean.Order;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.PagingRS;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.enumerate.ResultCode;
import cn.vonce.sql.enumerate.SqlSort;
import cn.vonce.sql.page.PagingService;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

public class PageHelper<T> {
    public static final String SELECT = "select";
    public static final String SELECT_MAP_LIST = "selectMapList";
    public static final String COUNT = "count";
    private Integer pagenum;
    private Integer pagesize;
    private Integer totalRecords;
    private Integer totalPage;
    private Order[] orders;
    private String timestamp;
    private List<T> dataList;
    private PagingMethod pagingMethod;

    public PageHelper(Integer pagenum, Integer pagesize, String timestamp) {
        this(pagenum, pagesize, null, timestamp);
    }

    public PageHelper(Integer pagenum, Integer pagesize, Order[] orders, String timestamp) {
        if (pagenum == null) {
            pagenum = 0;
        }
        if (pagesize == null || pagesize == 0) {
            pagesize = 10;
        }
        this.setPagenum(pagenum);
        this.setPagesize(pagesize);
        this.setOrders(orders);
        this.setTimestamp(timestamp);
    }

    public Integer getPagenum() {
        return this.pagenum;
    }

    private void setPagenum(Integer pagenum) {
        this.pagenum = pagenum;
    }

    public Integer getPagesize() {
        return this.pagesize;
    }

    private void setPagesize(Integer pagesize) {
        this.pagesize = pagesize;
    }

    public Integer getTotalRecords() {
        return this.totalRecords;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public Order[] getOrders() {
        return this.orders;
    }

    public void setOrders(Order[] orders) {
        this.orders = orders;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    private void setTimestamp(String timestamp) {
        boolean convertSuccess = true;
        try {
            if (timestamp != null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                format.setLenient(false);
                format.parse(timestamp);
            } else {
                convertSuccess = false;
            }
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        if (convertSuccess) {
            this.timestamp = timestamp;
        }
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

    public PagingMethod getPagingMethod() {
        if (this.pagingMethod == null) {
            this.pagingMethod = new PagingMethod(COUNT, SELECT);
        }
        return this.pagingMethod;
    }

    public void setPagingMethod(PagingMethod pagingMethod) {
        this.pagingMethod = pagingMethod;
    }

    public void dispose(long count) {
        this.totalRecords = (int)count;
        int countPage = this.totalRecords % this.pagesize == 0 ? this.totalRecords / this.pagesize : this.totalRecords / this.pagesize + 1;
        this.totalPage = countPage;
        if (this.pagenum > this.totalPage) {
            this.pagenum = this.totalPage;
        }
    }

    public PageHelper<T> paging(Select select, PagingService pageService) {
        return this.paging(null, select, pageService);
    }

    public PageHelper<T> paging(Class<T> tClazz, Select select, PagingService pageService) {
        try {
            Object obj;
            long count;
            Class<?> clazz = pageService.getClass();
            Method selectMethod = null;
            Method countMethod = null;
            Select sqlBeanSelect = (Select)select.copy();
            select.getColumnList().clear();
            select.column("COUNT( * )");
            if (tClazz != null) {
                countMethod = clazz.getDeclaredMethod(this.getPagingMethod().getCount(), Class.class, Select.class);
                count = (Long)countMethod.invoke((Object)pageService, tClazz, select);
            } else {
                countMethod = clazz.getDeclaredMethod(this.getPagingMethod().getCount(), Select.class);
                count = (Long)countMethod.invoke((Object)pageService, select);
            }
            this.dispose(count);
            sqlBeanSelect.setPage(this.pagenum, this.pagesize);
            sqlBeanSelect.orderBy(this.orders);
            if (tClazz != null) {
                selectMethod = clazz.getDeclaredMethod(this.getPagingMethod().getSelect(), Class.class, Select.class);
                obj = selectMethod.invoke((Object)pageService, tClazz, select);
            } else {
                selectMethod = clazz.getDeclaredMethod(this.getPagingMethod().getSelect(), Select.class);
                obj = selectMethod.invoke((Object)pageService, select);
            }
            this.setDataList((List)obj);
            Log.d((String)"sqlbean", (String)(clazz.getName() + "\u83b7\u53d6\u5206\u9875\u6570\u636e\u6210\u529f"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"sqlbean", (String)("\u83b7\u53d6\u5206\u9875\u6570\u636e\u5931\u8d25:" + e.getMessage()));
        }
        return this;
    }

    private Order[] getOrder(String[] sortdatafields, String[] sortorders) {
        Order[] orders = null;
        if (sortdatafields != null && sortdatafields.length > 0) {
            orders = new Order[sortdatafields.length];
            for (int i = 0; i < sortdatafields.length; ++i) {
                Order order = null;
                String field = sortdatafields[i];
                String sort = null;
                try {
                    sort = sortorders[i];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtil.isNotEmpty(field) && field.indexOf(".") > -1) {
                    String[] tableNameAndField = field.split("\\.");
                    order = new Order("", tableNameAndField[0], tableNameAndField[1], SqlSort.get(sort));
                } else {
                    order = new Order(field, SqlSort.get(sort));
                }
                orders[i] = order;
            }
        }
        return orders;
    }

    public PagingRS toResult(String message) {
        PagingRS result = new PagingRS();
        result.setCode(ResultCode.SUCCESS.getCode());
        result.setMsg(message == null || message.equals("") ? "\u83b7\u53d6\u5217\u8868\u6210\u529f" : message);
        result.setData(this.getDataList());
        result.setPagenum(this.getPagenum());
        result.setPagesize(this.getPagesize());
        result.setTotalRecords(this.getTotalRecords());
        result.setTotalPage(this.getTotalPage());
        result.setTimestamp(this.getTimestamp());
        return result;
    }

    public Paging getPaging() {
        return new Paging(this.pagenum, this.pagesize, this.orders);
    }

    public static class PagingMethod {
        private String count;
        private String select;

        public PagingMethod() {
        }

        public PagingMethod(String count, String select) {
            this.count = count;
            this.select = select;
        }

        public String getCount() {
            return this.count;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }
    }
}

