/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.processor;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.uitls.StringUtil;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"cn.vonce.sql.annotation.SqlConstant"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class SqlConstantProcessor
extends AbstractProcessor {
    private Messager messager;
    private Filer filer;
    public static final String PREFIX = "Sql";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        try {
            for (TypeElement typeElement : annotations) {
                for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                    Element enclosingElement = element.getEnclosingElement();
                    String packageName = ((PackageElement)enclosingElement).getQualifiedName().toString() + ".sql";
                    String className = PREFIX + element.getSimpleName();
                    String schema = "";
                    String tableName = element.getSimpleName().toString();
                    String tableAlias = "";
                    SqlTable sqlTable = element.getAnnotation(SqlTable.class);
                    if (sqlTable != null) {
                        schema = sqlTable.schema();
                        tableName = sqlTable.value();
                        tableAlias = sqlTable.alias();
                    }
                    if (StringUtil.isEmpty(tableAlias)) {
                        tableAlias = tableName;
                    }
                    FieldSpec _schemaField = FieldSpec.builder(String.class, (String)"_schema", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{schema}).build();
                    FieldSpec _tableNameField = FieldSpec.builder(String.class, (String)"_tableName", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{tableName}).build();
                    FieldSpec _tableAliasField = FieldSpec.builder(String.class, (String)"_tableAlias", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{tableAlias}).build();
                    FieldSpec _allField = FieldSpec.builder(String.class, (String)"_all", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{tableAlias + ".*"}).build();
                    FieldSpec _countField = FieldSpec.builder(String.class, (String)"_count", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{"COUNT(*)"}).build();
                    TypeSpec.Builder sqlBeanConsBuilder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(_schemaField).addField(_tableNameField).addField(_tableAliasField).addField(_allField).addField(_countField);
                    for (Element element2 : element.getEnclosedElements()) {
                        if (!element2.getKind().isField() || element2.getModifiers().contains((Object)Modifier.STATIC)) continue;
                        String sqlFieldName = element2.getSimpleName().toString();
                        SqlColumn sqlColumn = element2.getAnnotation(SqlColumn.class);
                        if (sqlColumn != null && StringUtil.isNotEmpty(sqlColumn.value())) {
                            sqlFieldName = sqlColumn.value();
                        }
                        FieldSpec sqlField = FieldSpec.builder(Column.class, (String)sqlFieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.builder().add("new $T($L,$L,$S,\"\")", new Object[]{Column.class, "_schema", "_tableAlias", sqlFieldName}).build()).build();
                        sqlBeanConsBuilder.addField(sqlField);
                    }
                    JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)sqlBeanConsBuilder.build()).addFileComment(" This codes are generated automatically. Do not modify!", new Object[0]).build();
                    try {
                        javaFile.writeTo(this.filer);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        return true;
    }
}

