/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.helper;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import cn.vonce.sql.android.util.PackageUtil;
import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.util.List;

public class DatabaseHelper
extends SQLiteOpenHelper {
    private String dbName;
    private Class<?> clazz;
    private Context context;

    public DatabaseHelper(Class<?> clazz, Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        this.dbName = name;
        this.clazz = clazz;
        this.context = context;
    }

    public void onCreate(SQLiteDatabase db) {
        List<String> classNames = PackageUtil.getClasses(this.context, this.clazz.getPackage().getName());
        try {
            for (String name : classNames) {
                Table table = SqlBeanUtil.getTable(this.clazz);
                if (!StringUtil.isEmpty((Object)table.getSchema()) && !table.getSchema().equals(this.dbName)) continue;
                Class<?> clazz = Class.forName(name);
                Create create = new Create();
                create.setBeanClass(clazz);
                String sql = SqlHelper.buildCreateSql((Create)create);
                db.execSQL(sql);
                Log.i((String)"sqlbean", (String)sql);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Log.i((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }
}

