/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.service;

import android.util.Log;
import cn.vonce.sql.android.helper.DatabaseHelper;
import cn.vonce.sql.android.helper.SQLiteTemplate;
import cn.vonce.sql.android.mapper.SqlBeanMapper;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.provider.SqlBeanProvider;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.service.TableService;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class SqlBeanServiceImpl<T, ID>
extends SqlBeanProvider
implements SqlBeanService<T, ID> {
    private static final long serialVersionUID = 1L;
    private SQLiteTemplate sqliteTemplate;
    private TableService tableService;
    private static final SqlBeanConfig sqlBeanConfig = new SqlBeanConfig(DbType.SQLite);
    public Class<?> clazz;

    public SqlBeanServiceImpl(Class<?> clazz, DatabaseHelper databaseHelper) {
        this(databaseHelper);
        this.clazz = clazz;
    }

    public SqlBeanServiceImpl(DatabaseHelper databaseHelper) {
        this.sqliteTemplate = new SQLiteTemplate(databaseHelper.getWritableDatabase());
        if (this.clazz == null) {
            Type[] typeArray = new Type[]{((Object)((Object)this)).getClass().getGenericSuperclass()};
            if (typeArray == null || typeArray.length == 0) {
                typeArray = ((Object)((Object)this)).getClass().getGenericInterfaces();
            }
            for (Type type : typeArray) {
                if (!(type instanceof ParameterizedType)) continue;
                Class trueTypeClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                try {
                    this.clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(trueTypeClass.getName());
                    return;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public SQLiteTemplate getSQLiteTemplate() {
        return this.sqliteTemplate;
    }

    public TableService getTableService() {
        if (this.tableService == null) {
            this.tableService = new TableService(){

                public long dropTable() {
                    return SqlBeanServiceImpl.this.sqliteTemplate.update(SqlBeanServiceImpl.this.dropTableSql(sqlBeanConfig, SqlBeanServiceImpl.this.clazz));
                }

                public long createTable() {
                    this.dropTable();
                    return SqlBeanServiceImpl.this.sqliteTemplate.update(SqlBeanServiceImpl.this.createTableSql(sqlBeanConfig, SqlBeanServiceImpl.this.clazz));
                }
            };
        }
        return this.tableService;
    }

    public T selectById(ID id) {
        if (id == null) {
            return null;
        }
        try {
            return this.sqliteTemplate.queryForObject(super.selectByIdSql(sqlBeanConfig, this.clazz, id), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <O> O selectById(Class<O> returnType, ID id) {
        if (id == null) {
            return null;
        }
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return (O)this.sqliteTemplate.queryForObject(super.selectByIdSql(sqlBeanConfig, this.clazz, id), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectByIds(ID ... ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        try {
            return (List)this.sqliteTemplate.queryForObject(super.selectByIdsSql(sqlBeanConfig, this.clazz, (Object[])ids), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <O> List<O> selectByIds(Class<O> returnType, ID ... ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return (List)this.sqliteTemplate.queryForObject(super.selectByIdsSql(sqlBeanConfig, this.clazz, (Object[])ids), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T selectOne(Select select) {
        try {
            return this.sqliteTemplate.queryForObject(super.selectSql(sqlBeanConfig, this.clazz, select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <O> O selectOne(Class<O> returnType, Select select) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return (O)this.sqliteTemplate.queryForObject(super.selectSql(sqlBeanConfig, this.clazz, select), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> selectMap(Select select) {
        try {
            return (Map)this.sqliteTemplate.queryForObject(super.selectSql(sqlBeanConfig, this.clazz, select), new SqlBeanMapper(this.clazz, Map.class));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T selectOneByCondition(String where, Object ... args) {
        try {
            return this.sqliteTemplate.queryForObject(super.selectByConditionSql(sqlBeanConfig, this.clazz, null, where, args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <O> O selectOneByCondition(Class<O> returnType, String where, Object ... args) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return (O)this.sqliteTemplate.queryForObject(super.selectByConditionSql(sqlBeanConfig, this.clazz, null, where, args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <O> List<O> selectByCondition(Class<O> returnType, String where, Object ... args) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(super.selectByConditionSql(sqlBeanConfig, this.clazz, null, where, args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <O> List<O> selectByCondition(Class<O> returnType, Paging paging, String where, Object ... args) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(super.selectByConditionSql(sqlBeanConfig, this.clazz, paging, where, args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectByCondition(String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(super.selectByConditionSql(sqlBeanConfig, this.clazz, null, where, args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectByCondition(Paging paging, String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(super.selectByConditionSql(sqlBeanConfig, this.clazz, paging, where, args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public long selectCountByCondition(String where, Object ... args) {
        return (Long)this.sqliteTemplate.queryForObject(super.selectCountByConditionSql(sqlBeanConfig, this.clazz, where, args), new SqlBeanMapper(this.clazz, Long.class));
    }

    public long countAll() {
        return (Long)this.sqliteTemplate.queryForObject(super.selectCountByConditionSql(sqlBeanConfig, this.clazz, null, null), new SqlBeanMapper(this.clazz, Long.class));
    }

    public List<T> selectAll() {
        try {
            return this.sqliteTemplate.query(super.selectAllSql(sqlBeanConfig, this.clazz, null), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectAll(Paging paging) {
        try {
            return this.sqliteTemplate.query(super.selectAllSql(sqlBeanConfig, this.clazz, paging), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <O> List<O> selectAll(Class<O> returnType) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(super.selectAllSql(sqlBeanConfig, this.clazz, null), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <O> List<O> selectAll(Class<O> returnType, Paging paging) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(super.selectAllSql(sqlBeanConfig, this.clazz, paging), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<Map<String, Object>> selectMapList(Select select) {
        try {
            return this.sqliteTemplate.query(super.selectSql(sqlBeanConfig, this.clazz, select), new SqlBeanMapper(this.clazz, Map.class));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <O> List<O> select(Class<O> returnType, Select select) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(super.selectSql(sqlBeanConfig, this.clazz, select), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> select(Select select) {
        try {
            return this.sqliteTemplate.query(super.selectSql(sqlBeanConfig, this.clazz, select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public long count(Select select) {
        return (Long)this.sqliteTemplate.queryForObject(super.countSql(sqlBeanConfig, this.clazz, select), new SqlBeanMapper(this.clazz, Long.class));
    }

    public long count(Class<?> clazz, Select select) {
        return (Long)this.sqliteTemplate.queryForObject(super.countSql(sqlBeanConfig, clazz, select), new SqlBeanMapper(clazz, Long.class));
    }

    public long deleteById(ID ... id) {
        return this.sqliteTemplate.update(super.deleteByIdSql(sqlBeanConfig, this.clazz, id));
    }

    public long deleteByCondition(String where, Object ... args) {
        return this.sqliteTemplate.update(super.deleteByConditionSql(sqlBeanConfig, this.clazz, where, args));
    }

    public long delete(Delete delete) {
        return this.sqliteTemplate.update(super.deleteSql(sqlBeanConfig, this.clazz, delete, false));
    }

    public long delete(Delete delete, boolean ignore) {
        return this.sqliteTemplate.update(super.deleteSql(sqlBeanConfig, this.clazz, delete, ignore));
    }

    public long logicallyDeleteById(ID id) {
        return this.sqliteTemplate.update(super.logicallyDeleteByIdSql(sqlBeanConfig, this.clazz, id));
    }

    public long logicallyDeleteByCondition(String where, Object ... args) {
        return this.sqliteTemplate.update(super.logicallyDeleteByConditionSql(sqlBeanConfig, this.clazz, where, args));
    }

    public long update(Update update) {
        return this.sqliteTemplate.update(super.updateSql(sqlBeanConfig, update, false));
    }

    public long update(Update update, boolean ignore) {
        return this.sqliteTemplate.update(super.updateSql(sqlBeanConfig, update, ignore));
    }

    public long updateById(T bean, ID id, boolean updateNotNull) {
        return this.sqliteTemplate.update(super.updateByIdSql(sqlBeanConfig, bean, id, updateNotNull, null));
    }

    public long updateById(T bean, ID id, boolean updateNotNull, String[] filterFields) {
        return this.sqliteTemplate.update(super.updateByIdSql(sqlBeanConfig, bean, id, updateNotNull, filterFields));
    }

    public long updateByBeanId(T bean, boolean updateNotNull) {
        return this.sqliteTemplate.update(super.updateByBeanIdSql(sqlBeanConfig, bean, updateNotNull, null));
    }

    public long updateByBeanId(T bean, boolean updateNotNull, String[] filterFields) {
        return this.sqliteTemplate.update(super.updateByBeanIdSql(sqlBeanConfig, bean, updateNotNull, filterFields));
    }

    public long updateByCondition(T bean, boolean updateNotNull, String where, Object ... args) {
        return this.sqliteTemplate.update(super.updateByConditionSql(sqlBeanConfig, bean, updateNotNull, null, where, args));
    }

    public long updateByCondition(T bean, boolean updateNotNull, String[] filterFields, String where, Object ... args) {
        return this.sqliteTemplate.update(super.updateByConditionSql(sqlBeanConfig, bean, updateNotNull, filterFields, where, args));
    }

    public long updateByBeanCondition(T bean, boolean updateNotNull, String where) {
        return this.sqliteTemplate.update(super.updateByBeanConditionSql(sqlBeanConfig, bean, updateNotNull, null, where));
    }

    public long updateByBeanCondition(T bean, boolean updateNotNull, String[] filterFields, String where) {
        return this.sqliteTemplate.update(super.updateByBeanConditionSql(sqlBeanConfig, bean, updateNotNull, filterFields, where));
    }

    public long insert(T ... bean) {
        return this.sqliteTemplate.update(super.insertBeanSql(sqlBeanConfig, bean));
    }

    public long insert(List<T> beanList) {
        return this.sqliteTemplate.update(super.insertBeanSql(sqlBeanConfig, beanList));
    }

    public long inset(Insert insert) {
        return this.sqliteTemplate.update(super.insertBeanSql(sqlBeanConfig, (Object)insert));
    }
}

