/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.service;

import android.util.Log;
import cn.vonce.sql.android.helper.DatabaseHelper;
import cn.vonce.sql.android.helper.SQLiteTemplate;
import cn.vonce.sql.android.mapper.SqlBeanMapper;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.provider.SqlBeanProvider;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.service.TableService;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SqlBeanServiceImpl<T, ID>
implements SqlBeanService<T, ID>,
TableService {
    private SQLiteTemplate sqliteTemplate;
    private TableService tableService;
    private SqlBeanDB sqlBeanDB;
    public Class<?> clazz;

    public SqlBeanDB getSqlBeanDB() {
        if (this.sqlBeanDB == null) {
            SqlBeanDB sqlBeanDB = new SqlBeanDB();
            sqlBeanDB.setDbType(DbType.SQLite);
            sqlBeanDB.setSqlBeanConfig(new SqlBeanConfig());
        }
        return this.sqlBeanDB;
    }

    public SqlBeanServiceImpl(Class<?> clazz, DatabaseHelper databaseHelper) {
        this(databaseHelper);
        this.clazz = clazz;
    }

    public SqlBeanServiceImpl(DatabaseHelper databaseHelper) {
        this.sqliteTemplate = new SQLiteTemplate(databaseHelper.getWritableDatabase());
        if (this.clazz == null) {
            Type[] typeArray = new Type[]{this.getClass().getGenericSuperclass()};
            if (typeArray == null || typeArray.length == 0) {
                typeArray = this.getClass().getGenericInterfaces();
            }
            for (Type type : typeArray) {
                if (!(type instanceof ParameterizedType)) continue;
                Class trueTypeClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                try {
                    this.clazz = this.getClass().getClassLoader().loadClass(trueTypeClass.getName());
                    return;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public SQLiteTemplate getSQLiteTemplate() {
        return this.sqliteTemplate;
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    public void dropTable() {
        List nameList;
        SqlBeanDB sqlBeanDB = this.getSqlBeanDB();
        if (sqlBeanDB.getDbType() != DbType.MySQL && sqlBeanDB.getDbType() != DbType.MariaDB && sqlBeanDB.getDbType() != DbType.PostgreSQL && sqlBeanDB.getDbType() != DbType.SQLServer && ((nameList = this.sqliteTemplate.query(SqlBeanProvider.selectTableListSql((SqlBeanDB)this.getSqlBeanDB(), (String)SqlBeanUtil.getTable(this.clazz).getName()), new SqlBeanMapper(this.clazz, String.class))) == null || nameList.isEmpty())) {
            return;
        }
        this.sqliteTemplate.execSQL(SqlBeanProvider.dropTableSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz));
    }

    public void createTable() {
        this.sqliteTemplate.execSQL(SqlBeanProvider.createTableSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz));
    }

    public void dropAndCreateTable() {
        this.dropTable();
        this.createTable();
    }

    public List<TableInfo> getTableList(String tableName) {
        return this.sqliteTemplate.query(SqlBeanProvider.selectTableListSql((SqlBeanDB)this.getSqlBeanDB(), null), new SqlBeanMapper(this.clazz, TableInfo.class));
    }

    public List<ColumnInfo> getColumnInfoList(String tableName) {
        return this.sqliteTemplate.query(SqlBeanProvider.selectTableListSql((SqlBeanDB)this.getSqlBeanDB(), null), new SqlBeanMapper(this.clazz, ColumnInfo.class));
    }

    public String backup() {
        String targetTableName = SqlBeanUtil.getTable(this.clazz).getName() + "_" + DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, null, null));
        return targetTableName;
    }

    public void backup(String targetTableName) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, null, null));
    }

    public void backup(String targetSchema, String targetTableName) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)targetSchema, (String)targetTableName, null, null));
    }

    public void backup(String targetTableName, Column[] columns, Wrapper wrapper) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, (Column[])columns, null));
    }

    public void backup(String targetSchema, String targetTableName, Column[] columns, Wrapper wrapper) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)targetSchema, (String)targetTableName, (Column[])columns, null));
    }

    public int copy(String targetTableName, Wrapper wrapper) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, null, (Wrapper)wrapper));
    }

    public int copy(String targetSchema, String targetTableName, Wrapper wrapper) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)targetSchema, (String)targetTableName, null, (Wrapper)wrapper));
    }

    public int copy(String targetTableName, Column[] columns, Wrapper wrapper) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, (Column[])columns, (Wrapper)wrapper));
    }

    public int copy(String targetSchema, String targetTableName, Column[] columns, Wrapper wrapper) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)targetSchema, (String)targetTableName, (Column[])columns, (Wrapper)wrapper));
    }

    public T selectById(ID id) {
        if (id == null) {
            return null;
        }
        try {
            return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, id), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> R selectById(Class<R> returnType, ID id) {
        if (id == null) {
            return null;
        }
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, id), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectByIds(ID ... ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectByIdsSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Object[])ids), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectByIds(Class<R> returnType, ID ... ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(SqlBeanProvider.selectByIdsSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Object[])ids), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T selectOne(Select select) {
        try {
            return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> R selectOne(Class<R> returnType, Select select) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> selectMap(Select select) {
        try {
            return (Map)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, Map.class));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T selectOneByCondition(String where, Object ... args) {
        try {
            return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> R selectOneByCondition(Class<R> returnType, String where, Object ... args) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T selectOneByCondition(Wrapper where) {
        Select select = new Select();
        select.setWhere(where);
        return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
    }

    public <R> R selectOneByCondition(Class<R> returnType, Wrapper where) {
        Select select = new Select();
        select.setWhere(where);
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectByCondition(Class<R> returnType, String where, Object ... args) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(SqlBeanProvider.selectByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectByCondition(Class<R> returnType, Wrapper where) {
        Select select = new Select();
        select.setWhere(where);
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectByCondition(Class<R> returnType, Paging paging, String where, Object ... args) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(SqlBeanProvider.selectByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Paging)paging, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectByCondition(Class<R> returnType, Paging paging, Wrapper where) {
        Select select = new Select();
        select.setWhere(where);
        select.setPage(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectByCondition(String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectByCondition(Wrapper where) {
        Select select = new Select();
        select.setWhere(where);
        return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
    }

    public List<T> selectByCondition(Paging paging, String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Paging)paging, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectByCondition(Paging paging, Wrapper where) {
        Select select = new Select();
        select.setWhere(where);
        select.setPage(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
    }

    public int selectCountByCondition(String where, Object ... args) {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectCountByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, Long.class));
    }

    public int selectCountByCondition(Wrapper where) {
        Select select = new Select();
        select.setWhere(where);
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, Long.class));
    }

    public int countAll() {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectCountByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, null), new SqlBeanMapper(this.clazz, Long.class));
    }

    public List<T> selectAll() {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectAll(Paging paging) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Paging)paging), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectAll(Class<R> returnType) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectAll(Class<R> returnType, Paging paging) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Paging)paging), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<Map<String, Object>> selectMapList(Select select) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, Map.class));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> select(Class<R> returnType, Select select) {
        try {
            if (!SqlBeanUtil.isBaseType((String)returnType.getName()) && !SqlBeanUtil.isMap((String)returnType.getName())) {
                this.clazz = returnType;
            }
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> select(Select select) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int count(Select select) {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Select)select), new SqlBeanMapper(this.clazz, Long.class));
    }

    public int count(Class<?> clazz, Select select) {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanDB)this.getSqlBeanDB(), clazz, (Select)select), new SqlBeanMapper(clazz, Long.class));
    }

    public int deleteById(ID ... id) {
        return this.sqliteTemplate.update(SqlBeanProvider.deleteByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, id));
    }

    public int deleteByCondition(String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.deleteByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)where, (Object[])args));
    }

    public int deleteByCondition(Wrapper where) {
        Delete delete = new Delete();
        delete.setWhere(where);
        return this.sqliteTemplate.update(SqlBeanProvider.deleteSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Delete)delete, (boolean)false));
    }

    public int delete(Delete delete) {
        return this.sqliteTemplate.update(SqlBeanProvider.deleteSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Delete)delete, (boolean)false));
    }

    public int delete(Delete delete, boolean ignore) {
        return this.sqliteTemplate.update(SqlBeanProvider.deleteSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Delete)delete, (boolean)ignore));
    }

    public int logicallyDeleteById(ID ... id) {
        return this.sqliteTemplate.update(SqlBeanProvider.logicallyDeleteByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, id));
    }

    public int logicallyDeleteByCondition(String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.logicallyDeleteByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)where, (Object[])args));
    }

    public int logicallyDeleteByCondition(Wrapper where) {
        return this.sqliteTemplate.update(SqlBeanProvider.logicallyDeleteByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)where));
    }

    public int update(Update update) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    public int update(Update update, boolean ignore) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)ignore));
    }

    public int updateById(T bean, ID id) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, id, (boolean)true, (boolean)false, null));
    }

    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, id, (boolean)updateNotNull, (boolean)optimisticLock, null));
    }

    public int updateByBeanId(T bean) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)true, (boolean)false, null));
    }

    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, String[] filterFields) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, id, (boolean)updateNotNull, (boolean)optimisticLock, (String[])filterFields));
    }

    public int updateByCondition(T bean, String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)true, (boolean)false, null, (String)where, (Object[])args));
    }

    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, null));
    }

    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String[])filterFields));
    }

    public int updateByCondition(T bean, boolean updateNotNull, boolean optimisticLock, String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, null, (String)where, (Object[])args));
    }

    public int updateByCondition(T bean, Wrapper where) {
        Update update = new Update();
        update.setUpdateBean(bean);
        update.setUpdateNotNull(true);
        update.setOptimisticLock(false);
        update.setWhere(where);
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    public int updateByCondition(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper where) {
        Update update = new Update();
        update.setUpdateBean(bean);
        update.setUpdateNotNull(updateNotNull);
        update.setOptimisticLock(optimisticLock);
        update.setWhere(where);
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    public int updateByCondition(T bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields, String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String[])filterFields, (String)where, (Object[])args));
    }

    public int updateByCondition(T bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields, Wrapper where) {
        Update update = new Update();
        update.setUpdateBean(bean);
        update.setUpdateNotNull(updateNotNull);
        update.setOptimisticLock(optimisticLock);
        update.setFilterFields(filterFields);
        update.setWhere(where);
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    public int updateByBeanCondition(T bean, String where) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)true, (boolean)false, null, (String)where));
    }

    public int updateByBeanCondition(T bean, boolean updateNotNull, boolean optimisticLock, String where) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, null, (String)where));
    }

    public int updateByBeanCondition(T bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields, String where) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanConditionSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String[])filterFields, (String)where));
    }

    public int insert(T ... bean) {
        return this.sqliteTemplate.update(SqlBeanProvider.insertBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean));
    }

    public int insert(List<T> beanList) {
        return this.sqliteTemplate.update(SqlBeanProvider.insertBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, beanList));
    }

    public int insert(Insert insert) {
        return this.sqliteTemplate.update(SqlBeanProvider.insertBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Object)insert));
    }
}

