/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.mapper;

import android.database.Cursor;
import cn.vonce.sql.android.mapper.RowMapper;
import cn.vonce.sql.annotation.SqlJoin;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SqlBeanMapper<T>
implements RowMapper<T> {
    public Class<?> clazz;
    public Class<?> returnType;

    public SqlBeanMapper(Class<?> clazz, Class<?> returnType) {
        this.clazz = clazz;
        this.returnType = returnType;
    }

    @Override
    public T mapRow(Cursor cursor, int index) {
        T object = null;
        if (cursor.moveToNext()) {
            if (this.returnType.getName().equals(ColumnInfo.class.getName()) || this.returnType.getName().equals(TableInfo.class.getName())) {
                return (T)this.beanHandleResultSet(this.returnType, cursor);
            }
            if (SqlBeanUtil.isBaseType((String)this.returnType.getName())) {
                return (T)this.baseHandleResultSet(cursor, this.returnType);
            }
            if (SqlBeanUtil.isMap((String)this.returnType.getName())) {
                return (T)this.mapHandleResultSet(cursor);
            }
            return (T)this.beanHandleResultSet(this.clazz, cursor);
        }
        return object;
    }

    public Object baseHandleResultSet(Cursor cursor, Class<?> returnType) {
        Object value = null;
        value = this.getValue(cursor.getType(0), 0, cursor);
        if (value != null && !value.getClass().getName().equals(returnType.getName())) {
            value = SqlBeanMapper.getValueConvert(returnType.getName(), value);
        }
        if (value == null || value.equals("null")) {
            value = SqlBeanMapper.getDefaultValueByColumnType(cursor.getType(0));
        }
        return value;
    }

    public Object mapHandleResultSet(Cursor cursor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 1; i <= cursor.getColumnCount(); ++i) {
            Object value = this.getValue(cursor.getType(i), i, cursor);
            if (value == null || value.equals("null")) {
                value = SqlBeanMapper.getDefaultValueByColumnType(cursor.getType(i));
            }
            map.put(cursor.getColumnName(i), value);
        }
        return map;
    }

    public Object beanHandleResultSet(Class<?> clazz, Cursor cursor) {
        List<String> columnNameList = Arrays.asList(cursor.getColumnNames());
        Object bean = null;
        try {
            bean = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        String tableAlias = SqlBeanUtil.getTable(clazz).getAlias();
        List fieldList = SqlBeanUtil.getBeanAllField(clazz);
        for (Field field : fieldList) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            SqlJoin sqlJoin = field.getAnnotation(SqlJoin.class);
            String fieldName = field.getName();
            if (sqlJoin != null) {
                if (sqlJoin.isBean()) {
                    Field[] subFields;
                    Class<?> subClazz = field.getType();
                    Object subBean = ReflectUtil.instance().newObject(subClazz);
                    String subTableAlias = SqlBeanUtil.getTable(subClazz).getAlias();
                    if (StringUtil.isNotEmpty((Object)sqlJoin.table())) {
                        subTableAlias = sqlJoin.table();
                    }
                    if (StringUtil.isNotEmpty((Object)sqlJoin.tableAlias())) {
                        subTableAlias = sqlJoin.tableAlias();
                    }
                    for (Field subField : subFields = subClazz.getDeclaredFields()) {
                        if (Modifier.isStatic(subField.getModifiers())) continue;
                        String subFieldName = subField.getName();
                        subFieldName = subTableAlias + "_" + subFieldName;
                        this.setFieldValue(subBean, subField, subFieldName, cursor);
                    }
                    ReflectUtil.instance().set(bean.getClass(), bean, fieldName, subBean);
                    continue;
                }
                String subTableAlias = sqlJoin.table();
                if (StringUtil.isNotEmpty((Object)sqlJoin.tableAlias())) {
                    subTableAlias = sqlJoin.tableAlias();
                }
                this.setFieldValue(bean, field, subTableAlias + "_" + fieldName, cursor);
                continue;
            }
            String newFieldName = tableAlias + "_" + fieldName;
            if (!columnNameList.contains(newFieldName) && !columnNameList.contains(newFieldName = StringUtil.humpToUnderline((String)fieldName))) {
                newFieldName = fieldName;
            }
            this.setFieldValue(bean, field, newFieldName, cursor);
        }
        return bean;
    }

    public void setFieldValue(Object obj, Field field, String fieldName, Cursor cursor) {
        Object value = this.getValue(field.getType().getName(), fieldName, cursor);
        if (value == null || value.equals("null")) {
            value = SqlBeanMapper.getDefaultValue(field.getType().getName());
        }
        ReflectUtil.instance().set(obj.getClass(), obj, field.getName(), value);
    }

    public Object getValue(String fieldType, String fieldName, Cursor cursor) {
        Object value = null;
        int index = cursor.getColumnIndex(fieldName);
        if (index == -1) {
            return null;
        }
        switch (fieldType) {
            case "byte": 
            case "java.lang.Byte": {
                value = Byte.parseByte(cursor.getShort(index) + "");
                break;
            }
            case "short": 
            case "java.lang.Short": {
                value = cursor.getShort(index);
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                value = cursor.getInt(index);
                break;
            }
            case "float": 
            case "java.lang.Float": {
                value = Float.valueOf(cursor.getFloat(index));
                break;
            }
            case "double": 
            case "java.lang.Double": {
                value = cursor.getDouble(index);
                break;
            }
            case "long": 
            case "java.lang.Long": {
                value = cursor.getLong(index);
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                short bool = cursor.getShort(index);
                if (bool > 0) {
                    value = true;
                    break;
                }
                value = false;
                break;
            }
            case "char": 
            case "java.lang.Character": {
                value = cursor.getString(index);
                if (!StringUtil.isNotEmpty((Object)value)) break;
                value = Character.valueOf(value.toString().charAt(0));
                break;
            }
            case "java.lang.String": {
                value = cursor.getString(index);
                break;
            }
            case "java.sql.Date": {
                value = new Date(cursor.getLong(index));
                break;
            }
            case "java.sql.Time": {
                value = new Time(cursor.getLong(index));
                break;
            }
            case "java.sql.Timestamp": {
                value = new Timestamp(cursor.getLong(index));
                break;
            }
            case "java.util.Date": {
                long timestamp = cursor.getLong(index);
                if (timestamp == 0L) break;
                String stringTimestamp = timestamp + "";
                if (stringTimestamp.length() == 10 || stringTimestamp.length() == 13) {
                    value = new java.util.Date(timestamp);
                    break;
                }
                value = DateUtil.stringToDate((String)cursor.getString(index));
                break;
            }
            case "java.math.BigDecimal": {
                value = new BigDecimal(cursor.getDouble(index));
                break;
            }
            default: {
                value = cursor.getBlob(index);
            }
        }
        return value;
    }

    public Object getValue(int jdbcType, int index, Cursor cursor) {
        Object value = null;
        switch (jdbcType) {
            case 1: {
                value = cursor.getLong(index);
                break;
            }
            case 2: {
                value = cursor.getDouble(index);
                break;
            }
            case 3: {
                value = cursor.getString(index);
                break;
            }
            case 4: {
                value = cursor.getBlob(index);
            }
        }
        return value;
    }

    public static Object getDefaultValue(String typeName) {
        Constable value = null;
        switch (typeName) {
            case "byte": 
            case "java.lang.Byte": {
                value = new Byte("0");
                break;
            }
            case "short": 
            case "java.lang.Short": {
                value = new Short("0");
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                value = 0;
                break;
            }
            case "long": 
            case "java.lang.Long": {
                value = 0L;
                break;
            }
            case "float": 
            case "java.lang.Float": {
                value = Float.valueOf(0.0f);
                break;
            }
            case "double": 
            case "java.lang.Double": {
                value = 0.0;
                break;
            }
            case "char": 
            case "java.lang.Char": {
                value = Character.valueOf('\u0000');
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                value = Boolean.valueOf(false);
            }
        }
        return value;
    }

    public static Object getDefaultValueByColumnType(int jdbcType) {
        Number value = null;
        switch (jdbcType) {
            case 1: {
                value = 0;
                break;
            }
            case 2: {
                value = Float.valueOf(0.0f);
                break;
            }
            case 3: 
            case 4: {
                value = null;
            }
        }
        return value;
    }

    public static Object getValueConvert(String typeName, Object value) {
        Object newValue = value;
        switch (typeName) {
            case "byte": 
            case "java.lang.Byte": {
                newValue = new Byte(value.toString());
                break;
            }
            case "short": 
            case "java.lang.Short": {
                newValue = new Short(value.toString());
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                newValue = new Integer(value.toString());
                break;
            }
            case "long": 
            case "java.lang.Long": {
                newValue = new Long(value.toString());
                break;
            }
            case "float": 
            case "java.lang.Float": {
                newValue = new Float(value.toString());
                break;
            }
            case "double": 
            case "java.lang.Double": {
                newValue = new Double(value.toString());
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                newValue = new Boolean(value.toString());
                break;
            }
            case "char": 
            case "java.lang.Character": {
                newValue = Character.valueOf(value.toString().charAt(0));
                break;
            }
            case "java.lang.String": {
                newValue = value.toString();
            }
        }
        return newValue;
    }
}

