/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.helper;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import cn.vonce.sql.android.util.PackageUtil;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.util.List;

public class DatabaseHelper
extends SQLiteOpenHelper {
    private String dbName;
    private Class<?> clazz;
    private Context context;

    public DatabaseHelper(Class<?> clazz, Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        this.dbName = name;
        this.clazz = clazz;
        this.context = context;
    }

    public void onCreate(SQLiteDatabase db) {
        List<String> classNames = PackageUtil.getClasses(this.context, this.clazz.getPackage().getName());
        try {
            SqlBeanDB sqlBeanDB = new SqlBeanDB();
            sqlBeanDB.setDbType(DbType.SQLite);
            sqlBeanDB.setSqlBeanConfig(new SqlBeanConfig());
            for (String className : classNames) {
                Class<?> clazz;
                SqlTable sqlTable;
                Table table = SqlBeanUtil.getTable(this.clazz);
                if (!StringUtil.isEmpty((Object)table.getSchema()) && !table.getSchema().equals(this.dbName) || (sqlTable = (clazz = Class.forName(className)).getAnnotation(SqlTable.class)) != null && !sqlTable.autoCreate()) continue;
                Create create = new Create();
                create.setSqlBeanDB(sqlBeanDB);
                create.setBeanClass(clazz);
                create.setTable(clazz);
                String sql = SqlHelper.buildCreateSql((Create)create);
                db.execSQL(sql);
                Log.d((String)"sqlbean", (String)sql);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }
}

