/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.service;

import android.util.Log;
import cn.vonce.sql.android.helper.DatabaseHelper;
import cn.vonce.sql.android.helper.SQLiteTemplate;
import cn.vonce.sql.android.mapper.SqlBeanMapper;
import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.define.ColumnFun;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.page.PageHelper;
import cn.vonce.sql.page.PagingService;
import cn.vonce.sql.page.ResultData;
import cn.vonce.sql.provider.SqlBeanProvider;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.service.TableService;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SqlBeanServiceImpl<T, ID>
implements SqlBeanService<T, ID>,
TableService<T> {
    private SQLiteTemplate sqliteTemplate;
    private SqlBeanDB sqlBeanDB;
    public Class<?> clazz;

    public SqlBeanDB getSqlBeanDB() {
        if (this.sqlBeanDB == null) {
            this.sqlBeanDB = new SqlBeanDB();
            this.sqlBeanDB.setDbType(DbType.SQLite);
            this.sqlBeanDB.setSqlBeanConfig(new SqlBeanConfig());
        }
        return this.sqlBeanDB;
    }

    public SqlBeanServiceImpl() {
    }

    public SqlBeanServiceImpl(Class<?> clazz, DatabaseHelper databaseHelper) {
        this.clazz = clazz;
        this.sqliteTemplate = new SQLiteTemplate(databaseHelper.getWritableDatabase());
    }

    public SQLiteTemplate getSQLiteTemplate() {
        return this.sqliteTemplate;
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    public void dropTable() {
        SqlBeanDB sqlBeanDB = this.getSqlBeanDB();
        List nameList = this.sqliteTemplate.query(SqlBeanProvider.selectTableListSql((SqlBeanDB)this.getSqlBeanDB(), null, (String)SqlBeanUtil.getTable(this.clazz).getName()), new SqlBeanMapper(this.clazz, String.class));
        if (nameList == null || nameList.isEmpty()) {
            return;
        }
        this.sqliteTemplate.execSQL(SqlBeanProvider.dropTableSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz));
    }

    public void createTable() {
        this.sqliteTemplate.execSQL(SqlBeanProvider.createTableSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz));
    }

    public void dropAndCreateTable() {
        this.dropTable();
        this.createTable();
    }

    public List<TableInfo> getTableList(String tableName) {
        return this.sqliteTemplate.query(SqlBeanProvider.selectTableListSql((SqlBeanDB)this.getSqlBeanDB(), null, null), new SqlBeanMapper(this.clazz, TableInfo.class));
    }

    public List<TableInfo> getTableList(String schema, String tableName) {
        return this.getTableList(tableName);
    }

    public List<ColumnInfo> getColumnInfoList(String tableName) {
        return this.sqliteTemplate.query(SqlBeanProvider.selectTableListSql((SqlBeanDB)this.getSqlBeanDB(), null, null), new SqlBeanMapper(this.clazz, ColumnInfo.class));
    }

    public List<ColumnInfo> getColumnInfoList(String schema, String tableName) {
        return this.getColumnInfoList(tableName);
    }

    public String backup() {
        String targetTableName = SqlBeanUtil.getTable(this.clazz).getName() + "_" + DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, null, null));
        return targetTableName;
    }

    public void backup(String targetTableName) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, null, null));
    }

    public void backup(String targetSchema, String targetTableName) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetSchema, (String)targetTableName, null));
    }

    public void backup(Wrapper wrapper, String targetTableName, Column ... columns) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper, null, (String)targetTableName, (Column[])columns));
    }

    public <R> void backup(Wrapper wrapper, String targetTableName, ColumnFun<T, R> ... columns) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper, null, (String)targetTableName, (Column[])SqlBeanUtil.funToColumn(columns)));
    }

    public void backup(Wrapper wrapper, String targetSchema, String targetTableName, Column ... columns) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, (Column[])columns));
    }

    public <R> void backup(Wrapper wrapper, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, (Column[])SqlBeanUtil.funToColumn(columns)));
    }

    public int copy(Wrapper wrapper, String targetTableName) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper, null, (String)targetTableName, null));
    }

    public int copy(Wrapper wrapper, String targetSchema, String targetTableName) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, null));
    }

    public int copy(Wrapper wrapper, String targetTableName, Column ... columns) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper, null, (String)targetTableName, (Column[])columns));
    }

    public <R> int copy(Wrapper wrapper, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper, null, (String)targetTableName, (Column[])SqlBeanUtil.funToColumn(columns)));
    }

    public int copy(Wrapper wrapper, String targetSchema, String targetTableName, Column[] columns) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, (Column[])columns));
    }

    public <R> int copy(Wrapper wrapper, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, (Column[])SqlBeanUtil.funToColumn(columns)));
    }

    public int alter(Table table, List<ColumnInfo> columnInfoList) {
        List sqlList = SqlBeanProvider.buildAlterSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, columnInfoList);
        int count = 0;
        if (sqlList != null && sqlList.size() > 0) {
            for (String sql : sqlList) {
                count += this.sqliteTemplate.update(sql);
            }
        }
        return count;
    }

    public int alter(Alter alter) {
        ArrayList<Alter> alterList = new ArrayList<Alter>();
        alterList.add(alter);
        return this.alter(alterList);
    }

    public int alter(List<Alter> alterList) {
        List sqlList = SqlBeanProvider.alterSql((DbType)this.getSqlBeanDB().getDbType(), alterList);
        int count = 0;
        if (sqlList != null && sqlList.size() > 0) {
            for (String sql : sqlList) {
                count += this.sqliteTemplate.update(sql);
            }
        }
        return count;
    }

    public int alterRemarks(String remarks) {
        return 0;
    }

    public T selectById(ID id) {
        if (id == null) {
            return null;
        }
        try {
            return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, id), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> R selectById(Class<R> returnType, ID id) {
        if (id == null) {
            return null;
        }
        try {
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, id), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectByIds(ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectByIdsSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Object[])ids), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectByIds(Class<R> returnType, ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectByIdsSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Object[])ids), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T selectOne(Select select) {
        try {
            return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> R selectOne(Class<R> returnType, Select select) {
        try {
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> selectMap(Select select) {
        try {
            return (Map)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SqlBeanMapper(this.clazz, Map.class));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T selectOneBy(String where, Object ... args) {
        try {
            return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, null, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> R selectOneBy(Class<R> returnType, String where, Object ... args) {
        try {
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, null, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T selectOneBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
    }

    public <R> R selectOneBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        try {
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectBy(Class<R> returnType, String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, null, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectBy(Class<R> returnType, Paging paging, String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Paging)paging, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> selectBy(Class<R> returnType, Paging paging, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectBy(String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, null, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectBy(Wrapper where) {
        Select select = new Select();
        select.where(where);
        return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
    }

    public List<T> selectBy(Paging paging, String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Paging)paging, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> selectBy(Paging paging, Wrapper where) {
        Select select = new Select();
        select.where(where);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
    }

    public int countBy(String where, Object ... args) {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)where, (Object[])args), new SqlBeanMapper(this.clazz, Integer.class));
    }

    public int countBy(Wrapper where) {
        Select select = new Select();
        select.where(where);
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanDB)this.getSqlBeanDB(), null, this.clazz, (Select)select), new SqlBeanMapper(this.clazz, Integer.class));
    }

    public int count() {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, null), new SqlBeanMapper(this.clazz, Integer.class));
    }

    public List<T> select() {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, null), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> select(Paging paging) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Paging)paging), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> select(Class<R> returnType) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, null), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> select(Class<R> returnType, Paging paging) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Paging)paging), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<Map<String, Object>> selectMapList(Select select) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SqlBeanMapper(this.clazz, Map.class));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <R> List<R> select(Class<R> returnType, Select select) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<T> select(Select select) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int count(Select select) {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SqlBeanMapper(this.clazz, Integer.class));
    }

    public int count(Class<?> clazz, Select select) {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanDB)this.getSqlBeanDB(), clazz, null, (Select)select), new SqlBeanMapper(clazz, Integer.class));
    }

    public ResultData<T> paging(Select select, PageHelper<T> pageHelper) {
        pageHelper.paging(select, (PagingService)this);
        return pageHelper.getResultData();
    }

    public ResultData<T> paging(Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(Integer.valueOf(pagenum), Integer.valueOf(pagesize));
        pageHelper.paging(select, (PagingService)this);
        return pageHelper.getResultData();
    }

    public <R> ResultData<R> paging(Class<R> tClazz, Select select, PageHelper<R> pageHelper) {
        pageHelper.paging(tClazz, select, (PagingService)this);
        return pageHelper.getResultData();
    }

    public <R> ResultData<R> paging(Class<R> tClazz, Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(Integer.valueOf(pagenum), Integer.valueOf(pagesize));
        pageHelper.paging(tClazz, select, (PagingService)this);
        return pageHelper.getResultData();
    }

    public int deleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("deleteById\u65b9\u6cd5id\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.sqliteTemplate.update(SqlBeanProvider.deleteByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, id));
    }

    public int deleteBy(String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.deleteBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)where, (Object[])args));
    }

    public int deleteBy(Wrapper where) {
        Delete delete = new Delete();
        delete.setLogicallyDelete(SqlBeanUtil.checkLogically(this.clazz));
        delete.where(where);
        return this.sqliteTemplate.update(SqlBeanProvider.deleteSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Delete)delete, (boolean)false));
    }

    public int delete(Delete delete) {
        return this.sqliteTemplate.update(SqlBeanProvider.deleteSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Delete)delete, (boolean)false));
    }

    public int delete(Delete delete, boolean ignore) {
        return this.sqliteTemplate.update(SqlBeanProvider.deleteSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Delete)delete, (boolean)ignore));
    }

    public int logicallyDeleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("logicallyDeleteById\u65b9\u6cd5id\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.sqliteTemplate.update(SqlBeanProvider.logicallyDeleteByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, id));
    }

    public int logicallyDeleteBy(String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.logicallyDeleteBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)where, (Object[])args));
    }

    public int logicallyDeleteBy(Wrapper where) {
        return this.sqliteTemplate.update(SqlBeanProvider.logicallyDeleteBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)where));
    }

    public int update(Update update) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    public int update(Update update, boolean ignore) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)ignore));
    }

    public int updateById(T bean, ID id) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, id, (boolean)true, (boolean)false, null));
    }

    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, id, (boolean)updateNotNull, (boolean)optimisticLock, null));
    }

    public int updateByBeanId(T bean) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)true, (boolean)false, null));
    }

    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, Column ... filterColumns) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, id, (boolean)updateNotNull, (boolean)optimisticLock, (Column[])filterColumns));
    }

    public <R> int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, ColumnFun<T, R> ... filterColumns) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, id, (boolean)updateNotNull, (boolean)optimisticLock, (Column[])SqlBeanUtil.funToColumn(filterColumns)));
    }

    public int updateBy(T bean, String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)true, (boolean)false, null, (String)where, (Object[])args));
    }

    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, null));
    }

    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, Column ... filterColumns) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (Column[])filterColumns));
    }

    public <R> int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, ColumnFun<T, R> ... filterColumns) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (Column[])SqlBeanUtil.funToColumn(filterColumns)));
    }

    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, null, (String)where, (Object[])args));
    }

    public int updateBy(T bean, Wrapper where) {
        Update update = new Update();
        update.setUpdateBean(bean);
        update.setUpdateNotNull(true);
        update.setOptimisticLock(false);
        update.where(where);
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper where) {
        Update update = new Update();
        update.setUpdateBean(bean);
        update.setUpdateNotNull(updateNotNull);
        update.setOptimisticLock(optimisticLock);
        update.where(where);
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Column[] filterColumns, String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (Column[])filterColumns, (String)where, (Object[])args));
    }

    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper where, Column ... filterColumns) {
        Update update = new Update();
        update.setUpdateBean(bean);
        update.setUpdateNotNull(updateNotNull);
        update.setOptimisticLock(optimisticLock);
        update.filterFields(filterColumns);
        update.where(where);
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    public <R> int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper, ColumnFun<T, R> ... filterColumns) {
        return this.updateBy(bean, updateNotNull, optimisticLock, wrapper, SqlBeanUtil.funToColumn(filterColumns));
    }

    public int updateByBean(T bean, String where) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)true, (boolean)false, (String)where, null));
    }

    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String)where, null));
    }

    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where, Column ... filterColumns) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String)where, (Column[])filterColumns));
    }

    public <R> int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where, ColumnFun<T, R>[] filterColumns) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String)where, (Column[])SqlBeanUtil.funToColumn(filterColumns)));
    }

    public int insert(T ... bean) {
        if (bean == null || bean.length == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5bean\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.sqliteTemplate.insert(SqlBeanProvider.insertBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean));
    }

    public int insert(Collection<T> beanList) {
        if (beanList == null || beanList.size() == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5beanList\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.sqliteTemplate.insert(SqlBeanProvider.insertBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, beanList));
    }

    public int insert(Insert insert) {
        return this.sqliteTemplate.insert(SqlBeanProvider.insertBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Object)insert));
    }
}

