/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.helper;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import cn.vonce.sql.android.mapper.RowMapper;
import cn.vonce.sql.mapper.ResultSetDelegate;
import java.util.ArrayList;
import java.util.List;

public class SQLiteTemplate {
    private SQLiteDatabase db;

    public SQLiteTemplate(SQLiteDatabase db) {
        this.db = db;
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) {
        ArrayList<T> list = new ArrayList<T>();
        ResultSetDelegate<Cursor> resultSetDelegate = new ResultSetDelegate<Cursor>(this.db.rawQuery(sql, null));
        Log.d((String)"sqlbean", (String)("query: " + sql));
        for (int i = 0; i < resultSetDelegate.getDelegate().getCount(); ++i) {
            list.add(rowMapper.mapRow(resultSetDelegate, i));
        }
        resultSetDelegate.getDelegate().close();
        return list;
    }

    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) {
        Cursor cursor = this.db.rawQuery(sql, null);
        Log.d((String)"sqlbean", (String)("queryForObject: " + sql));
        T t = rowMapper.mapRow(new ResultSetDelegate<Cursor>(cursor), 0);
        cursor.close();
        return t;
    }

    public int insert(String sql) {
        Log.d((String)"sqlbean", (String)("updateSQL: " + sql));
        return (int)this.db.compileStatement(sql).executeInsert();
    }

    public int update(String sql) {
        Log.d((String)"sqlbean", (String)("updateSQL: " + sql));
        return this.db.compileStatement(sql).executeUpdateDelete();
    }

    public void execSQL(String sql) {
        Log.d((String)"sqlbean", (String)("execSQL: " + sql));
        this.db.execSQL(sql);
    }
}

