/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.dialect;

import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.dialect.SqlDialect;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.enumerate.JavaMapDerbyType;
import cn.vonce.sql.enumerate.JdbcType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class DerbyDialect
implements SqlDialect<JavaMapDerbyType> {
    @Override
    public JavaMapDerbyType getType(Field field) {
        Class<?> clazz = SqlBeanUtil.getEntityClassFieldType(field);
        for (JavaMapDerbyType javaType : JavaMapDerbyType.values()) {
            for (Class<?> thisClazz : javaType.getClasses()) {
                if (thisClazz != clazz) continue;
                return javaType;
            }
        }
        throw new SqlBeanException(field.getDeclaringClass().getName() + "\u5b9e\u4f53\u7c7b\u4e0d\u652f\u6301\u6b64\u5b57\u6bb5\u7c7b\u578b\uff1a" + clazz.getSimpleName());
    }

    @Override
    public JdbcType getJdbcType(Field field) {
        return JdbcType.getType(this.getType(field).name());
    }

    @Override
    public String getTableListSql(SqlBeanMeta sqlBeanMeta, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT tb.TABLENAME AS \"name\", sc.SCHEMANAME AS \"schema\" ");
        sql.append("FROM SYS.SYSTABLES tb ");
        sql.append("INNER JOIN SYS.SYSSCHEMAS sc ");
        sql.append("ON sc.SCHEMAID = tb.SCHEMAID ");
        sql.append("WHERE TABLETYPE = 'T' AND sc.SCHEMANAME = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("'SA'");
        }
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND tablename = '" + tableName + "'");
        }
        return sql.toString();
    }

    @Override
    public String getColumnListSql(SqlBeanMeta sqlBeanMeta, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT cl.COLUMNNUMBER AS cid, cl.COLUMNNAME AS name, cl.COLUMNDATATYPE AS type, cl.COLUMNDEFAULT AS dflt_value, ");
        sql.append("(CASE WHEN cl.COLUMNNUMBER = 1 THEN '1' ELSE '0' END) AS pk, 0 AS pk ");
        sql.append("FROM SYS.SYSTABLES AS tb ");
        sql.append("INNER JOIN SYS.SYSCOLUMNS cl ");
        sql.append("ON cl.REFERENCEID = tb.TABLEID ");
        sql.append("INNER JOIN SYS.SYSSCHEMAS sc ");
        sql.append("ON sc.SCHEMAID = tb.SCHEMAID ");
        sql.append("WHERE sc.SCHEMANAME = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("'SA'");
        }
        sql.append(" AND tb.TABLENAME = '");
        sql.append(tableName);
        sql.append("' ORDER BY cl.COLUMNNUMBER");
        return sql.toString();
    }

    @Override
    public List<String> alterTable(List<Alter> alterList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (int i = 0; i < alterList.size(); ++i) {
            StringBuffer sql;
            Alter alter = alterList.get(i);
            if (alter.getType() == AlterType.ADD) {
                sql = new StringBuffer();
                sql.append("ALTER TABLE ");
                sql.append(this.getFullName(alter, alter.getTable(), null));
                sql.append("ADD ");
                sql.append("COLUMN ");
                sql.append(SqlBeanUtil.addColumn(alter, alter.getColumnInfo(), alter.getAfterColumnName()));
                sqlList.add(sql.toString());
                continue;
            }
            if (alter.getType() == AlterType.CHANGE) {
                sqlList.add(this.changeColumn(alter));
                StringBuffer modifySql = this.modifyColumn(alter);
                if (modifySql.length() <= 0) continue;
                sqlList.add("ALTER TABLE " + modifySql);
                continue;
            }
            if (alter.getType() == AlterType.MODIFY) {
                sqlList.add("ALTER TABLE " + this.modifyColumn(alter));
                continue;
            }
            if (alter.getType() != AlterType.DROP) continue;
            sql = new StringBuffer();
            sql.append("ALTER TABLE ");
            sql.append(this.getFullName(alter, alter.getTable(), null));
            sql.append("DROP ");
            sql.append("COLUMN ");
            sql.append(alter.getColumnInfo().getName(SqlBeanUtil.isToUpperCase(alter)));
            sqlList.add(sql.toString());
        }
        return sqlList;
    }

    @Override
    public String addRemarks(boolean isTable, Alter item, String escape) {
        return null;
    }

    private String getFullName(Alter alter, Table table, String columnName) {
        boolean rename = alter.getType() == AlterType.CHANGE && StringUtil.isNotBlank(columnName);
        boolean toUpperCase = SqlBeanUtil.isToUpperCase(alter);
        StringBuffer sql = new StringBuffer();
        if (StringUtil.isNotBlank(table.getSchema())) {
            sql.append(table.getSchema(toUpperCase));
            sql.append(".");
        }
        sql.append(table.getName(toUpperCase));
        if (rename) {
            sql.append(".");
            sql.append(toUpperCase ? columnName.toUpperCase() : columnName);
        }
        sql.append(" ");
        return sql.toString();
    }

    private StringBuffer modifyColumn(Alter alter) {
        ColumnInfo columnInfo = alter.getColumnInfo();
        StringBuffer modifySql = new StringBuffer();
        modifySql.append(this.getFullName(alter, alter.getTable(), null));
        modifySql.append("ALTER ");
        modifySql.append("COLUMN ");
        modifySql.append(SqlBeanUtil.getTableFieldName(alter, columnInfo.getName()));
        if (columnInfo.getNotnull() != null && columnInfo.getNotnull().booleanValue()) {
            modifySql.append(" ");
            modifySql.append("NOT NULL");
        } else if (alter.getType() == AlterType.MODIFY && columnInfo.getNotnull() != null && !columnInfo.getNotnull().booleanValue()) {
            modifySql.append(" ");
            modifySql.append("NULL");
        }
        return modifySql;
    }

    private String changeColumn(Alter alter) {
        StringBuffer changeSql = new StringBuffer();
        changeSql.append("RENAME ");
        changeSql.append("COLUMN ");
        changeSql.append(this.getFullName(alter, alter.getTable(), alter.getOldColumnName()));
        changeSql.append(" TO ");
        changeSql.append(alter.getColumnInfo().getName(SqlBeanUtil.isToUpperCase(alter)));
        return changeSql.toString();
    }

    @Override
    public String getSchemaSql(SqlBeanMeta sqlBeanMeta, String schemaName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SCHEMANAME as \"name\" FROM SYS.SYSSCHEMAS ");
        if (StringUtil.isNotEmpty(schemaName)) {
            sql.append("WHERE SCHEMANAME = ");
            sql.append("'" + this.getSchemaName(sqlBeanMeta, schemaName) + "'");
        }
        return sql.toString();
    }

    @Override
    public String getCreateSchemaSql(SqlBeanMeta sqlBeanMeta, String schemaName) {
        return "CREATE SCHEMA AUTHORIZATION " + this.getSchemaName(sqlBeanMeta, schemaName);
    }

    @Override
    public String getDropSchemaSql(SqlBeanMeta sqlBeanMeta, String schemaName) {
        return "DROP SCHEMA " + this.getSchemaName(sqlBeanMeta, schemaName) + " RESTRICT";
    }
}

