/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.json;

import cn.vonce.sql.json.JSONArray;
import cn.vonce.sql.json.JSONObject;
import cn.vonce.sql.json.JSONReader;
import cn.vonce.sql.uitls.BeanUtil;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JSONParser {
    public static Object parse(String json) throws Exception {
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("JSON string is null or empty");
        }
        json = json.trim();
        return JSONParser.parseValue(new JSONReader(json));
    }

    private static Object parseValue(JSONReader reader) throws Exception {
        reader.skipWhitespace();
        char current = reader.peek();
        switch (current) {
            case '{': {
                return JSONParser.parseObject(reader);
            }
            case '[': {
                return JSONParser.parseArray(reader);
            }
            case '\"': {
                return JSONParser.parseString(reader);
            }
            case 'n': {
                reader.expect("null");
                return null;
            }
            case 't': {
                reader.expect("true");
                return true;
            }
            case 'f': {
                reader.expect("false");
                return false;
            }
        }
        return JSONParser.parseNumber(reader);
    }

    private static JSONObject parseObject(JSONReader reader) throws Exception {
        JSONObject jsonObject = new JSONObject();
        reader.expect('{');
        reader.skipWhitespace();
        while (reader.peek() != '}') {
            String key = JSONParser.parseString(reader);
            reader.skipWhitespace();
            reader.expect(':');
            Object value = JSONParser.parseValue(reader);
            jsonObject.put(key, value);
            reader.skipWhitespace();
            if (reader.peek() != ',') break;
            reader.next();
            reader.skipWhitespace();
        }
        reader.expect('}');
        return jsonObject;
    }

    private static JSONArray parseArray(JSONReader reader) throws Exception {
        JSONArray jsonArray = new JSONArray();
        reader.expect('[');
        reader.skipWhitespace();
        while (reader.peek() != ']') {
            Object value = JSONParser.parseValue(reader);
            jsonArray.add(value);
            reader.skipWhitespace();
            if (reader.peek() != ',') break;
            reader.next();
            reader.skipWhitespace();
        }
        reader.expect(']');
        return jsonArray;
    }

    private static String parseString(JSONReader reader) throws Exception {
        char c;
        reader.expect('\"');
        StringBuilder sb = new StringBuilder();
        while ((c = reader.next()) != '\"') {
            if (c == '\\') {
                char escaped = reader.next();
                switch (escaped) {
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '/': {
                        sb.append('/');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'u': {
                        String hex = reader.read(4);
                        sb.append((char)Integer.parseInt(hex, 16));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid escape sequence: \\" + escaped);
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static Number parseNumber(JSONReader reader) throws Exception {
        StringBuilder sb = new StringBuilder();
        while (Character.isDigit(reader.peek()) || "-+eE.".indexOf(reader.peek()) >= 0) {
            sb.append(reader.next());
        }
        String numberStr = sb.toString();
        if (numberStr.contains(".") || numberStr.contains("e") || numberStr.contains("E")) {
            return Double.parseDouble(numberStr);
        }
        return Long.parseLong(numberStr);
    }

    public static JSONArray parseArray(String json) {
        try {
            return (JSONArray)JSONParser.parse(json);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> parseArray(String json, Class<T> clazz) {
        try {
            Object object = JSONParser.parse(json);
            if (!(object instanceof JSONArray)) {
                throw new IllegalArgumentException("JSON is not a JSONArray");
            }
            List list = (List)object;
            if (clazz != null) {
                ArrayList<Object> resultList = new ArrayList<Object>();
                for (Object item : list) {
                    if (item instanceof JSONObject) {
                        JSONObject jsonObject = (JSONObject)item;
                        resultList.add(BeanUtil.toBean(clazz, jsonObject));
                        continue;
                    }
                    resultList.add(item);
                }
                return resultList;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONObject parseObject(String json) {
        try {
            return (JSONObject)JSONParser.parse(json);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parseObject(String json, Class<T> clazz) {
        try {
            Object object = JSONParser.parse(json);
            if (!(object instanceof JSONObject)) {
                throw new IllegalArgumentException("JSON is not a JSONObject");
            }
            if (clazz != null) {
                return BeanUtil.toBean(clazz, (Map)object);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String toJSONString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String || obj instanceof Character || obj instanceof Enum) {
            return "\"" + JSONParser.escapeString(obj.toString()) + "\"";
        }
        if (obj instanceof Number || obj instanceof Boolean || obj instanceof BigDecimal) {
            return obj.toString();
        }
        if (JSONParser.isDate(obj)) {
            return "\"" + DateUtil.unifyDateToString(obj) + "\"";
        }
        if (obj instanceof Map) {
            return JSONParser.mapToJSONString((Map)obj);
        }
        if (obj instanceof Collection) {
            return JSONParser.collectionToJSONString((Collection)obj);
        }
        if (obj.getClass().isArray()) {
            return JSONParser.arrayToJSONString(obj);
        }
        return JSONParser.mapToJSONString(BeanUtil.toMap(obj));
    }

    private static boolean isDate(Object obj) {
        if (!SqlBeanUtil.isAndroidEnv()) {
            return obj instanceof Date || obj instanceof LocalDate || obj instanceof LocalDateTime || obj instanceof LocalTime;
        }
        return obj instanceof Date;
    }

    private static String mapToJSONString(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(JSONParser.toJSONString(entry.getKey().toString()));
            sb.append(":");
            sb.append(JSONParser.toJSONString(entry.getValue()));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String collectionToJSONString(Collection<?> collection) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Object item : collection) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(JSONParser.toJSONString(item));
        }
        sb.append("]");
        return sb.toString();
    }

    private static String arrayToJSONString(Object array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(JSONParser.toJSONString(Array.get(array, i)));
        }
        sb.append("]");
        return sb.toString();
    }

    private static String escapeString(String str) {
        StringBuilder sb = new StringBuilder();
        block9: for (char c : str.toCharArray()) {
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        sb.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

