/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.provider;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Backup;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Common;
import cn.vonce.sql.bean.Copy;
import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Drop;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.enumerate.AlterDifference;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.provider.DynSchemaContextHolder;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SqlBeanProvider {
    public static String selectByIdSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Class<?> returnType, Object id) {
        return SqlBeanProvider.selectByIdsSql(sqlBeanMeta, clazz, returnType, id);
    }

    public static String selectByIdsSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Class<?> returnType, Object ... ids) {
        Field idField;
        Select select;
        if (returnType != null && SqlBeanUtil.sqlTableIsConsistent(clazz, returnType)) {
            clazz = returnType;
        }
        try {
            select = SqlBeanProvider.newSelect(sqlBeanMeta, clazz, false);
            idField = SqlBeanUtil.getIdField(clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        Column column = SqlBeanUtil.getColumnByField(idField, clazz);
        if (ids.length > 1) {
            select.where().in(column, (Object)ids);
        } else {
            select.where().eq(column, ids[0]);
        }
        return SqlHelper.buildSelectSql(select);
    }

    public static String selectBySql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Class<?> returnType, Paging paging, String where, Object ... args) {
        if (returnType != null && SqlBeanUtil.sqlTableIsConsistent(clazz, returnType)) {
            clazz = returnType;
        }
        Select select = SqlBeanProvider.newSelect(sqlBeanMeta, clazz, false);
        select.where(where, args);
        SqlBeanProvider.setPaging(select, paging, clazz);
        return SqlHelper.buildSelectSql(select);
    }

    public static String countBySql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, String where, Object[] args) {
        Select select = SqlBeanProvider.newSelect(sqlBeanMeta, clazz, true);
        select.where(where, args);
        return SqlHelper.buildSelectSql(select);
    }

    public static String selectAllSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Class<?> returnType, Paging paging) {
        if (returnType != null && SqlBeanUtil.sqlTableIsConsistent(clazz, returnType)) {
            clazz = returnType;
        }
        Select select = SqlBeanProvider.newSelect(sqlBeanMeta, clazz, false);
        SqlBeanProvider.setPaging(select, paging, clazz);
        return SqlHelper.buildSelectSql(select);
    }

    public static String selectSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Class<?> returnType, Select select) {
        if (returnType != null && SqlBeanUtil.sqlTableIsConsistent(clazz, returnType)) {
            clazz = returnType;
        }
        if (select.getSqlBeanMeta() == null) {
            select.setSqlBeanMeta(sqlBeanMeta);
        }
        try {
            SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
            select.setColumnList(SqlBeanUtil.getSelectColumns(clazz, select.getFilterColumns(), select.getColumnList()));
            if (select.getPage() != null && select.getSqlBeanMeta().getDbType() == DbType.SQLServer) {
                select.getPage().setIdName(SqlBeanUtil.getTableFieldName(SqlBeanUtil.getIdField(clazz), sqlTable));
            }
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlBeanProvider.setSelectAndBuild(clazz, select);
    }

    public static String countSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Class<?> returnType, Select select) {
        if (returnType != null && SqlBeanUtil.sqlTableIsConsistent(clazz, returnType)) {
            clazz = returnType;
        }
        if (select.getSqlBeanMeta() == null) {
            select.setSqlBeanMeta(sqlBeanMeta);
        }
        select.count(true);
        return SqlBeanProvider.setSelectAndBuild(clazz, select);
    }

    public static String deleteByIdSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Object id) {
        Field idField;
        if (SqlBeanUtil.checkLogically(clazz)) {
            return SqlBeanProvider.logicallyDeleteByIdSql(sqlBeanMeta, clazz, id);
        }
        if (StringUtil.isEmpty(id)) {
            try {
                throw new SqlBeanException("deleteByIdSql id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (SqlBeanException e) {
                e.printStackTrace();
                return null;
            }
        }
        Delete delete = new Delete();
        delete.setSqlBeanMeta(sqlBeanMeta);
        delete.setTable(clazz);
        delete.setBeanClass(clazz);
        SqlBeanProvider.setSchema(delete, clazz);
        try {
            idField = SqlBeanUtil.getIdField(clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
        delete.where().in(SqlBeanUtil.getTableFieldName(idField, sqlTable), id);
        return SqlHelper.buildDeleteSql(delete);
    }

    public static String deleteBySql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, String where, Object[] args) {
        if (SqlBeanUtil.checkLogically(clazz)) {
            return SqlBeanProvider.logicallyDeleteBySql(sqlBeanMeta, clazz, where, args);
        }
        Delete delete = new Delete();
        delete.setSqlBeanMeta(sqlBeanMeta);
        delete.setTable(clazz);
        delete.where(where, args);
        SqlBeanProvider.setSchema(delete, clazz);
        return SqlHelper.buildDeleteSql(delete);
    }

    public static String deleteSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Delete delete, boolean ignore) {
        if (delete.isLogicallyDelete() && SqlBeanUtil.checkLogically(clazz)) {
            Update<Object> update = new Update<Object>();
            update.setSqlBeanMeta(sqlBeanMeta);
            update.setTable(clazz);
            update.bean(SqlBeanProvider.newLogicallyDeleteBean(clazz));
            update.where(delete.getWhereWrapper());
            update.where(delete.getWhere(), delete.getArgs());
            update.where().setDataList(delete.where().getDataList());
            return SqlBeanProvider.updateSql(sqlBeanMeta, clazz, update, ignore);
        }
        if (delete.getSqlBeanMeta() == null) {
            delete.setSqlBeanMeta(sqlBeanMeta);
        }
        if (delete.getTable().isNotSet()) {
            delete.setTable(clazz);
        }
        if (delete.getBeanClass() == null) {
            delete.setBeanClass(clazz);
        }
        SqlBeanProvider.setSchema(delete, clazz);
        if (ignore || !delete.where().getDataList().isEmpty() || StringUtil.isNotEmpty(delete.getWhere()) || !delete.getWhereWrapper().getDataList().isEmpty()) {
            return SqlHelper.buildDeleteSql(delete);
        }
        try {
            throw new SqlBeanException("\u8be5delete sql\u672a\u8bbe\u7f6ewhere\u6761\u4ef6\uff0c\u5982\u679c\u786e\u5b9e\u4e0d\u9700\u8981where\u6761\u4ef6\uff0c\u8bf7\u4f7f\u7528delete(Select select, boolean ignore)");
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String logicallyDeleteByIdSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Object id) {
        Update<Object> update = new Update<Object>();
        try {
            update.setSqlBeanMeta(sqlBeanMeta);
            update.setTable(clazz);
            update.bean(SqlBeanProvider.newLogicallyDeleteBean(clazz));
            Field idField = SqlBeanUtil.getIdField(clazz);
            SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
            update.where().in(SqlBeanUtil.getTableFieldName(idField, sqlTable), id);
            SqlBeanProvider.setSchema(update, clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public static String logicallyDeleteBySql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, String where, Object[] args) {
        Update<Object> update = new Update<Object>();
        try {
            update.setSqlBeanMeta(sqlBeanMeta);
            update.setTable(clazz);
            update.bean(SqlBeanProvider.newLogicallyDeleteBean(clazz));
            update.where(where, args);
            SqlBeanProvider.setSchema(update, clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public static String logicallyDeleteBySql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Wrapper wrapper) {
        Update<Object> update = new Update<Object>();
        try {
            update.setSqlBeanMeta(sqlBeanMeta);
            update.setTable(clazz);
            update.bean(SqlBeanProvider.newLogicallyDeleteBean(clazz));
            update.where(wrapper);
            SqlBeanProvider.setSchema(update, clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public static String updateSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Update update, boolean ignore) {
        if (update.getSqlBeanMeta() == null) {
            update.setSqlBeanMeta(sqlBeanMeta);
        }
        if (update.getTable().isNotSet()) {
            update.setTable(clazz);
        }
        if (update.getBeanClass() == null) {
            update.setBeanClass(clazz);
        }
        SqlBeanProvider.setSchema(update, clazz);
        if (ignore || !update.where().getDataList().isEmpty() || StringUtil.isNotEmpty(update.getWhere()) || !update.getWhereWrapper().getDataList().isEmpty()) {
            return SqlHelper.buildUpdateSql(update);
        }
        try {
            throw new SqlBeanException("\u8be5update sql\u672a\u8bbe\u7f6ewhere\u6761\u4ef6\uff0c\u5982\u679c\u786e\u5b9e\u4e0d\u9700\u8981where\u6761\u4ef6\uff0c\u8bf7\u4f7f\u7528update(Select select, boolean ignore)");
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String updateByIdSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Object bean, Object id, boolean updateNotNull, boolean optimisticLock, Column[] filterColumns) {
        Field idField;
        if (StringUtil.isEmpty(id)) {
            try {
                throw new SqlBeanException("updateByIdSql id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (SqlBeanException e) {
                e.printStackTrace();
                return null;
            }
        }
        Update update = SqlBeanProvider.newUpdate(sqlBeanMeta, clazz, bean, updateNotNull, optimisticLock);
        update.filterFields(filterColumns);
        try {
            idField = SqlBeanUtil.getIdField(bean.getClass());
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
        update.where().eq(SqlBeanUtil.getTableFieldName(idField, sqlTable), id);
        return SqlHelper.buildUpdateSql(update);
    }

    public static String updateByBeanIdSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Object bean, boolean updateNotNull, boolean optimisticLock, Column[] filterColumns) {
        Update update = SqlBeanProvider.newUpdate(sqlBeanMeta, clazz, bean, updateNotNull, optimisticLock);
        update.filterFields(filterColumns);
        try {
            Field idField = SqlBeanUtil.getIdField(bean.getClass());
            Object id = ReflectUtil.instance().get(bean.getClass(), bean, idField.getName());
            if (StringUtil.isEmpty(id)) {
                try {
                    throw new SqlBeanException("updateByBeanIdSql id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                catch (SqlBeanException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
            update.where().eq(SqlBeanUtil.getTableFieldName(idField, sqlTable), id);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public static String updateBySql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Object bean, boolean updateNotNull, boolean optimisticLock, Column[] filterColumns, String where, Object[] args) {
        Update update = SqlBeanProvider.newUpdate(sqlBeanMeta, clazz, bean, updateNotNull, optimisticLock);
        update.filterFields(filterColumns);
        update.where(where, args);
        return SqlHelper.buildUpdateSql(update);
    }

    public static String updateByBeanSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Object bean, boolean updateNotNull, boolean optimisticLock, String where, Column[] filterColumns) {
        Update update = SqlBeanProvider.newUpdate(sqlBeanMeta, clazz, bean, updateNotNull, optimisticLock);
        update.filterFields(filterColumns);
        update.where(where, new Object[0]);
        return SqlHelper.buildUpdateSql(update);
    }

    public static String insertBeanSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Object bean) {
        Insert<Object[]> insert = new Insert<Object[]>();
        insert.setSqlBeanMeta(sqlBeanMeta);
        insert.setTable(clazz);
        insert.setBeanClass(clazz);
        insert.setBean(SqlBeanUtil.getObjectArray(bean));
        SqlBeanProvider.setSchema(insert, clazz);
        return SqlHelper.buildInsertSql(insert);
    }

    public static String insertSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Insert insert) {
        if (insert.getSqlBeanMeta() == null) {
            insert.setSqlBeanMeta(sqlBeanMeta);
        }
        if (insert.getTable().isNotSet()) {
            insert.setTable(clazz);
        }
        if (insert.getBeanClass() == null) {
            insert.setBeanClass(clazz);
        }
        SqlBeanProvider.setSchema(insert, clazz);
        return SqlHelper.buildInsertSql(insert);
    }

    public static String dropTableSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz) {
        Drop drop = new Drop();
        drop.setSqlBeanMeta(sqlBeanMeta);
        drop.setTable(clazz);
        SqlBeanProvider.setSchema(drop, clazz);
        return SqlHelper.buildDrop(drop);
    }

    public static String createTableSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz) {
        Create create = new Create();
        create.setSqlBeanMeta(sqlBeanMeta);
        create.setTable(clazz);
        create.setBeanClass(clazz);
        SqlBeanProvider.setSchema(create, clazz);
        return SqlHelper.buildCreateSql(create);
    }

    public static String selectTableListSql(SqlBeanMeta sqlBeanMeta, String schema, String name) {
        if (sqlBeanMeta.getSqlBeanConfig().getToUpperCase() != null && sqlBeanMeta.getSqlBeanConfig().getToUpperCase().booleanValue() && StringUtil.isNotEmpty(name)) {
            name = name.toUpperCase();
        }
        return sqlBeanMeta.getDbType().getSqlDialect().getTableListSql(sqlBeanMeta, schema, name);
    }

    public static String selectColumnListSql(SqlBeanMeta sqlBeanMeta, String schema, String name) {
        if (sqlBeanMeta.getSqlBeanConfig().getToUpperCase() != null && sqlBeanMeta.getSqlBeanConfig().getToUpperCase().booleanValue() && StringUtil.isNotEmpty(name)) {
            name = name.toUpperCase();
        }
        return sqlBeanMeta.getDbType().getSqlDialect().getColumnListSql(sqlBeanMeta, schema, name);
    }

    public static String backupSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Wrapper wrapper, String targetSchema, String targetTableName, Column[] columns) {
        Backup backup = new Backup();
        backup.setSqlBeanMeta(sqlBeanMeta);
        backup.setTable(clazz);
        backup.setColumns(columns);
        backup.setTargetSchema(targetSchema);
        backup.setTargetTableName(targetTableName);
        backup.where(wrapper);
        SqlBeanProvider.setSchema(backup, clazz);
        return SqlHelper.buildBackup(backup);
    }

    public static String copySql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Wrapper wrapper, String targetSchema, String targetTableName, Column[] columns) {
        Copy copy = new Copy();
        copy.setSqlBeanMeta(sqlBeanMeta);
        copy.setTable(clazz);
        copy.setColumns(columns);
        copy.setTargetSchema(targetSchema);
        copy.setTargetTableName(targetTableName);
        copy.where(wrapper);
        return SqlHelper.buildCopy(copy);
    }

    public static String lastInsertIdSql() {
        return "select last_insert_id()";
    }

    public static List<String> buildAlterSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, List<ColumnInfo> columnInfoList) {
        SqlTable sqlTable = clazz.getAnnotation(SqlTable.class);
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        fieldList = fieldList.stream().filter(item -> !SqlBeanUtil.isIgnore(item)).collect(Collectors.toList());
        ArrayList<Alter> alterList = new ArrayList<Alter>();
        Class<?> constantClass = SqlBeanUtil.getConstantClass(clazz);
        for (int i = 0; i < fieldList.size(); ++i) {
            List<AlterDifference> alterDifferenceList;
            int j;
            Field field = fieldList.get(i);
            if (SqlBeanUtil.isIgnore(field)) continue;
            SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
            Alter alter = new Alter();
            alter.setSqlBeanMeta(sqlBeanMeta);
            alter.setTable(clazz);
            String oldName = sqlColumn == null ? "" : (sqlBeanMeta.getSqlBeanConfig().getToUpperCase() != null && sqlBeanMeta.getSqlBeanConfig().getToUpperCase() != false ? sqlColumn.oldName().toUpperCase() : sqlColumn.oldName());
            ColumnInfo columnInfo = SqlBeanUtil.buildColumnInfo(alter.getSqlBeanMeta(), field, sqlTable, sqlColumn, constantClass);
            boolean exist = false;
            for (j = 0; j < columnInfoList.size(); ++j) {
                if (sqlColumn == null || !oldName.equalsIgnoreCase(columnInfoList.get(j).getName())) continue;
                exist = true;
                alterDifferenceList = SqlBeanUtil.columnInfoCompare(sqlBeanMeta, columnInfo, columnInfoList.get(j));
                if (alterDifferenceList.size() <= 0) break;
                alter.setType(AlterType.CHANGE);
                alter.setColumnInfo(columnInfo);
                alter.setOldColumnName(oldName);
                alter.setDifferences(alterDifferenceList);
                if ((sqlBeanMeta.getDbType() == DbType.MySQL || sqlBeanMeta.getDbType() == DbType.MariaDB) && j > 0) {
                    alter.setAfterColumnName(SqlBeanUtil.getTableFieldName(fieldList.get(i - 1), sqlTable));
                }
                alterList.add(alter);
                break;
            }
            if (alter.getDifferences() != null) continue;
            for (j = 0; j < columnInfoList.size(); ++j) {
                if (!columnInfo.getName().equalsIgnoreCase(columnInfoList.get(j).getName())) continue;
                exist = true;
                alterDifferenceList = SqlBeanUtil.columnInfoCompare(sqlBeanMeta, columnInfo, columnInfoList.get(j));
                if (alterDifferenceList.size() <= 0) break;
                alter.setType(AlterType.MODIFY);
                alter.setColumnInfo(columnInfo);
                alter.setDifferences(alterDifferenceList);
                if ((sqlBeanMeta.getDbType() == DbType.MySQL || sqlBeanMeta.getDbType() == DbType.MariaDB) && i > 0) {
                    alter.setAfterColumnName(SqlBeanUtil.getTableFieldName(fieldList.get(i - 1), sqlTable));
                }
                alterList.add(alter);
                break;
            }
            if (alter.getDifferences() != null || exist) continue;
            alter.setType(AlterType.ADD);
            alter.setColumnInfo(columnInfo);
            if ((sqlBeanMeta.getDbType() == DbType.MySQL || sqlBeanMeta.getDbType() == DbType.MariaDB) && i > 0) {
                alter.setAfterColumnName(SqlBeanUtil.getTableFieldName(fieldList.get(i - 1), sqlTable));
            }
            alterList.add(alter);
        }
        if (alterList.size() > 0) {
            return SqlBeanProvider.alterSql(sqlBeanMeta.getDbType(), alterList);
        }
        return null;
    }

    public static List<String> alterSql(DbType dbType, List<Alter> alterList) {
        return dbType.getSqlDialect().alterTable(alterList);
    }

    public static String alterRemarksSql(SqlBeanMeta sqlBeanMeta, Class<?> clazz, String remarks) {
        Alter alter = new Alter();
        alter.setSqlBeanMeta(sqlBeanMeta);
        alter.setTable(clazz);
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setRemarks(remarks);
        alter.setColumnInfo(columnInfo);
        String escape = SqlBeanUtil.getEscape(alter);
        return sqlBeanMeta.getDbType().getSqlDialect().addRemarks(true, alter, escape);
    }

    public static String databaseSql(SqlBeanMeta sqlBeanMeta, String schemaName) {
        return sqlBeanMeta.getDbType().getSqlDialect().getSchemaSql(sqlBeanMeta, schemaName);
    }

    public static String createSchemaSql(SqlBeanMeta sqlBeanMeta, String schemaName) {
        return sqlBeanMeta.getDbType().getSqlDialect().getCreateSchemaSql(sqlBeanMeta, schemaName);
    }

    public static String dropSchemaSql(SqlBeanMeta sqlBeanMeta, String schemaName) {
        return sqlBeanMeta.getDbType().getSqlDialect().getDropSchemaSql(sqlBeanMeta, schemaName);
    }

    private static Select newSelect(SqlBeanMeta sqlBeanMeta, Class<?> clazz, boolean isCount) {
        Select select = new Select();
        select.setSqlBeanMeta(sqlBeanMeta);
        select.setTable(clazz);
        select.setBeanClass(clazz);
        select.count(isCount);
        try {
            if (!isCount) {
                select.setColumnList(SqlBeanUtil.getSelectColumns(clazz, select.getFilterColumns(), null));
            }
            SqlBeanUtil.setJoin(select, clazz);
            SqlBeanProvider.setSchema(select, clazz);
        }
        catch (SqlBeanException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return select;
    }

    private static String setSelectAndBuild(Class<?> clazz, Select select) {
        if (StringUtil.isEmpty(select.getTable().getName())) {
            Table table = SqlBeanUtil.getTable(clazz);
            select.getTable().setName(table.getName());
            if (StringUtil.isEmpty(select.getTable().getAlias())) {
                select.getTable().setAlias(table.getAlias());
            }
        }
        if (select.getBeanClass() == null) {
            select.setBeanClass(clazz);
        }
        SqlBeanProvider.setSchema(select, clazz);
        try {
            SqlBeanUtil.setJoin(select, clazz);
        }
        catch (SqlBeanException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildSelectSql(select);
    }

    private static Object newLogicallyDeleteBean(Class<?> clazz) throws SqlBeanException {
        Object bean = null;
        try {
            bean = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        Field field = SqlBeanUtil.getLogicallyField(clazz);
        ReflectUtil.instance().set(bean.getClass(), bean, field.getName(), field.getType() == Boolean.class || field.getType() == Boolean.TYPE ? (Comparable<Boolean>)Boolean.valueOf(true) : (Comparable<Boolean>)Integer.valueOf(1));
        return bean;
    }

    private static Update newUpdate(SqlBeanMeta sqlBeanMeta, Class<?> clazz, Object bean, boolean updateNotNull, boolean optimisticLock) {
        Update<Object> update = new Update<Object>();
        update.setSqlBeanMeta(sqlBeanMeta);
        update.setTable(clazz);
        update.setBeanClass(clazz);
        update.bean(bean).notNull(updateNotNull).optimisticLock(optimisticLock);
        SqlBeanProvider.setSchema(update, clazz);
        return update;
    }

    private static void setPaging(Select select, Paging paging, Class<?> clazz) {
        if (paging != null) {
            if (select.getSqlBeanMeta().getDbType() == DbType.SQLServer) {
                try {
                    SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
                    select.page(SqlBeanUtil.getTableFieldName(SqlBeanUtil.getIdField(clazz), sqlTable), paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
                }
                catch (SqlBeanException e) {
                    e.printStackTrace();
                }
            } else {
                select.page(null, paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
            }
            select.orderBy(paging.getOrders());
        }
    }

    private static void setSchema(Common common, Class<?> clazz) {
        if (StringUtil.isEmpty(common.getTable().getSchema())) {
            common.getTable().setSchema(SqlBeanProvider.getSchema(clazz));
        }
    }

    private static String getSchema(Class<?> clazz) {
        String schema = DynSchemaContextHolder.getSchema();
        if (StringUtil.isEmpty(schema)) {
            return SqlBeanUtil.getTable(clazz).getSchema();
        }
        return schema;
    }
}

