/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.config;

import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.enumerate.DbType;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;

public class SqlBeanMeta
implements Serializable {
    private DbType dbType;
    private String productName;
    private int databaseMajorVersion;
    private int databaseMinorVersion;
    private String databaseProductVersion;
    private int jdbcMajorVersion;
    private int jdbcMinorVersion;
    private int driverMajorVersion;
    private int driverMinorVersion;
    private String driverVersion;
    private String driverName;
    private SqlBeanConfig sqlBeanConfig;

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        if (this.dbType == null) {
            this.dbType = dbType;
        }
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public void setDatabaseMajorVersion(int databaseMajorVersion) {
        this.databaseMajorVersion = databaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public void setDatabaseMinorVersion(int databaseMinorVersion) {
        this.databaseMinorVersion = databaseMinorVersion;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
    }

    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    public void setJdbcMajorVersion(int jdbcMajorVersion) {
        this.jdbcMajorVersion = jdbcMajorVersion;
    }

    public int getJdbcMinorVersion() {
        return this.jdbcMinorVersion;
    }

    public void setJdbcMinorVersion(int jdbcMinorVersion) {
        this.jdbcMinorVersion = jdbcMinorVersion;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public void setDriverMajorVersion(int driverMajorVersion) {
        this.driverMajorVersion = driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public void setDriverMinorVersion(int driverMinorVersion) {
        this.driverMinorVersion = driverMinorVersion;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public SqlBeanConfig getSqlBeanConfig() {
        return this.sqlBeanConfig;
    }

    public void setSqlBeanConfig(SqlBeanConfig sqlBeanConfig) {
        if (this.sqlBeanConfig == null) {
            this.sqlBeanConfig = sqlBeanConfig;
        }
    }

    public static SqlBeanMeta build(SqlBeanConfig sqlBeanConfig, DatabaseMetaData metaData) throws SQLException {
        SqlBeanMeta sqlBeanMeta = new SqlBeanMeta();
        sqlBeanMeta.setProductName(metaData.getDatabaseProductName());
        sqlBeanMeta.setDatabaseMajorVersion(metaData.getDatabaseMajorVersion());
        sqlBeanMeta.setDatabaseMinorVersion(metaData.getDatabaseMinorVersion());
        sqlBeanMeta.setDatabaseProductVersion(metaData.getDatabaseProductVersion());
        sqlBeanMeta.setJdbcMajorVersion(metaData.getJDBCMajorVersion());
        sqlBeanMeta.setJdbcMinorVersion(metaData.getJDBCMinorVersion());
        sqlBeanMeta.setDriverMajorVersion(metaData.getDatabaseMajorVersion());
        sqlBeanMeta.setDriverMinorVersion(metaData.getDriverMinorVersion());
        sqlBeanMeta.setDriverVersion(metaData.getDriverVersion());
        sqlBeanMeta.setDriverName(metaData.getDriverName());
        sqlBeanMeta.setDbType(DbType.getDbType(sqlBeanMeta.getProductName()));
        if (sqlBeanConfig == null) {
            sqlBeanMeta.setSqlBeanConfig(new SqlBeanConfig());
            switch (Objects.requireNonNull(sqlBeanMeta.getDbType())) {
                case Oracle: 
                case DB2: 
                case Derby: 
                case Hsql: 
                case H2: {
                    sqlBeanMeta.getSqlBeanConfig().setToUpperCase(true);
                }
            }
        } else {
            sqlBeanMeta.setSqlBeanConfig(sqlBeanConfig);
        }
        return sqlBeanMeta;
    }

    public String toString() {
        return "SqlBeanMeta{dbType=" + (Object)((Object)this.dbType) + ", productName='" + this.productName + '\'' + ", databaseMajorVersion=" + this.databaseMajorVersion + ", databaseMinorVersion=" + this.databaseMinorVersion + ", databaseProductVersion='" + this.databaseProductVersion + '\'' + ", jdbcMajorVersion=" + this.jdbcMajorVersion + ", jdbcMinorVersion=" + this.jdbcMinorVersion + ", driverMajorVersion=" + this.driverMajorVersion + ", driverMinorVersion=" + this.driverMinorVersion + ", driverVersion='" + this.driverVersion + '\'' + ", driverName='" + this.driverName + '\'' + ", sqlBeanConfig=" + this.sqlBeanConfig + '}';
    }
}

