/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.uitls;

import cn.vonce.sql.uitls.SqlBeanUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanUtil {
    public static <T> T toBean(Class<T> clazz, Map<String, Object> map) {
        if (clazz == null || map == null) {
            throw new IllegalArgumentException("Class and Map cannot be null");
        }
        try {
            T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            List<Field> fields = BeanUtil.getAllFields(clazz);
            for (Field field : fields) {
                Object genericType;
                String fieldName = field.getName();
                if (!map.containsKey(fieldName)) continue;
                Object value = map.get(fieldName);
                if (value != null) {
                    ParameterizedType parameterizedType;
                    Type actualType;
                    Class<?> fieldType = field.getType();
                    if (value instanceof Map && BeanUtil.isBean(fieldType)) {
                        value = BeanUtil.toBean(fieldType, (Map)value);
                    } else if (List.class.isAssignableFrom(fieldType) && value instanceof List && (genericType = field.getGenericType()) instanceof ParameterizedType && (actualType = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class && BeanUtil.isBean((Class)actualType)) {
                        value = BeanUtil.toBeanList((List)value, (Class)actualType);
                    }
                }
                try {
                    if (field.getType().isEnum() && value != null) {
                        ?[] constants;
                        genericType = constants = field.getType().getEnumConstants();
                        int parameterizedType = ((?[])genericType).length;
                        for (int i = 0; i < parameterizedType; ++i) {
                            Object constant = genericType[i];
                            if (!constant.toString().equals(value.toString())) continue;
                            value = constant;
                            break;
                        }
                    }
                    field.setAccessible(true);
                    field.set(obj, BeanUtil.convertValue(field.getType(), value));
                }
                catch (Exception e) {
                    try {
                        String setterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                        Method setter = clazz.getMethod(setterName, field.getType());
                        setter.invoke(obj, BeanUtil.convertValue(field.getType(), value));
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to set property: " + fieldName + " - " + ex.getMessage());
                    }
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate or populate JavaBean: " + e.getMessage(), e);
        }
    }

    public static Map<String, Object> toMap(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("Bean cannot be null");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Class<?> clazz = bean.getClass();
        List<Field> fields = BeanUtil.getAllFields(clazz);
        for (Field field : fields) {
            String fieldName = field.getName();
            if ("class".equals(fieldName)) continue;
            try {
                field.setAccessible(true);
                Object value = field.get(bean);
                if (value != null) {
                    if (BeanUtil.isBean(value.getClass())) {
                        value = BeanUtil.toMap(value);
                    } else if (value instanceof List) {
                        value = BeanUtil.toMapList((List)value);
                    }
                }
                resultMap.put(fieldName, value);
            }
            catch (Exception e) {
                try {
                    String getterName = BeanUtil.getGetterName(field);
                    Method getter = clazz.getMethod(getterName, new Class[0]);
                    Object value = getter.invoke(bean, new Object[0]);
                    if (value != null) {
                        if (BeanUtil.isBean(value.getClass())) {
                            value = BeanUtil.toMap(value);
                        } else if (value instanceof List) {
                            value = BeanUtil.toMapList((List)value);
                        }
                    }
                    resultMap.put(fieldName, value);
                }
                catch (Exception ex) {
                    System.err.println("Failed to read property: " + fieldName + " - " + ex.getMessage());
                }
            }
        }
        return resultMap;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
        }
        return fields;
    }

    private static String getGetterName(Field field) {
        String fieldName = field.getName();
        if (field.getType() == Boolean.TYPE) {
            return "is" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        }
        return "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    private static boolean isBean(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.equals(String.class) && !Number.class.isAssignableFrom(clazz) && !Boolean.class.equals(clazz) && !Character.class.equals(clazz) && !Enum.class.isAssignableFrom(clazz) && !Calendar.class.isAssignableFrom(clazz) && !Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz) && !BigDecimal.class.isAssignableFrom(clazz) && !BeanUtil.isDate(clazz);
    }

    private static boolean isDate(Class<?> clazz) {
        if (!SqlBeanUtil.isAndroidEnv()) {
            return Date.class.isAssignableFrom(clazz) || LocalDate.class.isAssignableFrom(clazz) || LocalDateTime.class.isAssignableFrom(clazz) || LocalTime.class.isAssignableFrom(clazz);
        }
        return Date.class.isAssignableFrom(clazz);
    }

    private static <T> List<T> toBeanList(List<Map<String, Object>> mapList, Class<T> clazz) {
        ArrayList<T> beanList = new ArrayList<T>();
        if (mapList != null) {
            for (Map<String, Object> map : mapList) {
                beanList.add(BeanUtil.toBean(clazz, map));
            }
        }
        return beanList;
    }

    private static List<Map<String, Object>> toMapList(List<?> beanList) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (beanList != null) {
            for (Object bean : beanList) {
                mapList.add(BeanUtil.toMap(bean));
            }
        }
        return mapList;
    }

    private static Object convertValue(Class<?> targetType, Object value) {
        if (value == null) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return value;
        }
        try {
            return SqlBeanUtil.getValueConvert(targetType, value);
        }
        catch (Exception e) {
            System.err.println("Failed to convert value " + value + " to type " + targetType.getName() + ": " + e.getMessage());
            return value;
        }
    }
}

