/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.config;

import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.enumerate.DbType;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;

public class SqlBeanDB
implements Serializable {
    private DbType dbType;
    private String productName;
    private int databaseMajorVersion;
    private int databaseMinorVersion;
    private String databaseProductVersion;
    private int jdbcMajorVersion;
    private int jdbcMinorVersion;
    private int driverMajorVersion;
    private int driverMinorVersion;
    private String driverVersion;
    private String driverName;
    private SqlBeanConfig sqlBeanConfig;

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        if (this.dbType == null) {
            this.dbType = dbType;
        }
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public void setDatabaseMajorVersion(int databaseMajorVersion) {
        this.databaseMajorVersion = databaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public void setDatabaseMinorVersion(int databaseMinorVersion) {
        this.databaseMinorVersion = databaseMinorVersion;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
    }

    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    public void setJdbcMajorVersion(int jdbcMajorVersion) {
        this.jdbcMajorVersion = jdbcMajorVersion;
    }

    public int getJdbcMinorVersion() {
        return this.jdbcMinorVersion;
    }

    public void setJdbcMinorVersion(int jdbcMinorVersion) {
        this.jdbcMinorVersion = jdbcMinorVersion;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public void setDriverMajorVersion(int driverMajorVersion) {
        this.driverMajorVersion = driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public void setDriverMinorVersion(int driverMinorVersion) {
        this.driverMinorVersion = driverMinorVersion;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public SqlBeanConfig getSqlBeanConfig() {
        return this.sqlBeanConfig;
    }

    public void setSqlBeanConfig(SqlBeanConfig sqlBeanConfig) {
        if (this.sqlBeanConfig == null) {
            this.sqlBeanConfig = sqlBeanConfig;
        }
    }

    public static SqlBeanDB build(SqlBeanConfig sqlBeanConfig, DatabaseMetaData metaData) throws SQLException {
        SqlBeanDB sqlBeanDB = new SqlBeanDB();
        sqlBeanDB.setProductName(metaData.getDatabaseProductName());
        sqlBeanDB.setDatabaseMajorVersion(metaData.getDatabaseMajorVersion());
        sqlBeanDB.setDatabaseMinorVersion(metaData.getDatabaseMinorVersion());
        sqlBeanDB.setDatabaseProductVersion(metaData.getDatabaseProductVersion());
        sqlBeanDB.setJdbcMajorVersion(metaData.getJDBCMajorVersion());
        sqlBeanDB.setJdbcMinorVersion(metaData.getJDBCMinorVersion());
        sqlBeanDB.setDriverMajorVersion(metaData.getDatabaseMajorVersion());
        sqlBeanDB.setDriverMinorVersion(metaData.getDriverMinorVersion());
        sqlBeanDB.setDriverVersion(metaData.getDriverVersion());
        sqlBeanDB.setDriverName(metaData.getDriverName());
        sqlBeanDB.setDbType(DbType.getDbType(sqlBeanDB.getProductName()));
        if (sqlBeanConfig == null) {
            sqlBeanDB.setSqlBeanConfig(new SqlBeanConfig());
            switch (Objects.requireNonNull(sqlBeanDB.getDbType())) {
                case Oracle: 
                case DB2: 
                case Derby: 
                case Hsql: 
                case H2: {
                    sqlBeanDB.getSqlBeanConfig().setToUpperCase(true);
                }
            }
        } else {
            sqlBeanDB.setSqlBeanConfig(sqlBeanConfig);
        }
        return sqlBeanDB;
    }

    public String toString() {
        return "SqlBeanDB{dbType=" + (Object)((Object)this.dbType) + ", productName='" + this.productName + '\'' + ", databaseMajorVersion=" + this.databaseMajorVersion + ", databaseMinorVersion=" + this.databaseMinorVersion + ", databaseProductVersion='" + this.databaseProductVersion + '\'' + ", jdbcMajorVersion=" + this.jdbcMajorVersion + ", jdbcMinorVersion=" + this.jdbcMinorVersion + ", driverMajorVersion=" + this.driverMajorVersion + ", driverMinorVersion=" + this.driverMinorVersion + ", driverVersion='" + this.driverVersion + '\'' + ", driverName='" + this.driverName + '\'' + ", sqlBeanConfig=" + this.sqlBeanConfig + '}';
    }
}

