/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.service;

import android.util.Log;
import cn.vonce.sql.android.helper.DatabaseHelper;
import cn.vonce.sql.android.helper.SQLiteTemplate;
import cn.vonce.sql.android.mapper.SqlBeanMapper;
import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.page.PageHelper;
import cn.vonce.sql.page.ResultData;
import cn.vonce.sql.provider.SqlBeanProvider;
import cn.vonce.sql.service.DbManageService;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SqlBeanServiceImpl<T, ID>
implements SqlBeanService<T, ID>,
DbManageService<T> {
    private SQLiteTemplate sqliteTemplate;
    private SqlBeanMeta sqlBeanMeta;
    public Class<?> clazz;

    @Override
    public SqlBeanMeta getSqlBeanMeta() {
        if (this.sqlBeanMeta == null) {
            this.sqlBeanMeta = new SqlBeanMeta();
            this.sqlBeanMeta.setDbType(DbType.SQLite);
            this.sqlBeanMeta.setSqlBeanConfig(new SqlBeanConfig());
        }
        return this.sqlBeanMeta;
    }

    public SqlBeanServiceImpl() {
    }

    public SqlBeanServiceImpl(Class<?> clazz, DatabaseHelper databaseHelper) {
        this.clazz = clazz;
        this.sqliteTemplate = new SQLiteTemplate(databaseHelper.getWritableDatabase());
    }

    public SQLiteTemplate getSQLiteTemplate() {
        return this.sqliteTemplate;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.clazz;
    }

    @Override
    public void dropTable() {
        List nameList = this.sqliteTemplate.query(SqlBeanProvider.selectTableListSql(this.getSqlBeanMeta(), null, SqlBeanUtil.getTable(this.clazz).getName()), new SqlBeanMapper(this.clazz, String.class));
        if (nameList == null || nameList.isEmpty()) {
            return;
        }
        this.sqliteTemplate.execSQL(SqlBeanProvider.dropTableSql(this.getSqlBeanMeta(), this.clazz));
    }

    @Override
    public void createTable() {
        this.sqliteTemplate.execSQL(SqlBeanProvider.createTableSql(this.getSqlBeanMeta(), this.clazz));
    }

    @Override
    public void dropAndCreateTable() {
        this.dropTable();
        this.createTable();
    }

    @Override
    public List<TableInfo> getTableList() {
        return this.getTableList(null);
    }

    @Override
    public List<TableInfo> getTableList(String tableName) {
        return this.sqliteTemplate.query(SqlBeanProvider.selectTableListSql(this.getSqlBeanMeta(), null, tableName), new SqlBeanMapper(this.clazz, TableInfo.class));
    }

    @Override
    public List<TableInfo> getTableList(String schema, String tableName) {
        return this.getTableList(tableName);
    }

    @Override
    public List<ColumnInfo> getColumnInfoList() {
        return this.getColumnInfoList(null);
    }

    @Override
    public List<ColumnInfo> getColumnInfoList(String tableName) {
        return this.sqliteTemplate.query(SqlBeanProvider.selectColumnListSql(this.getSqlBeanMeta(), null, tableName), new SqlBeanMapper(this.clazz, ColumnInfo.class));
    }

    @Override
    public List<ColumnInfo> getColumnInfoList(String schema, String tableName) {
        return this.getColumnInfoList(tableName);
    }

    @Override
    public String backup() {
        String targetTableName = SqlBeanUtil.getTable(this.clazz).getName() + "_" + DateUtil.dateToString(new Date(), "yyyyMMddHHmmssSSS");
        this.sqliteTemplate.update(SqlBeanProvider.backupSql(this.getSqlBeanMeta(), this.clazz, null, null, targetTableName, null));
        return targetTableName;
    }

    @Override
    public void backup(String targetTableName) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql(this.getSqlBeanMeta(), this.clazz, null, null, targetTableName, null));
    }

    @Override
    public void backup(String targetSchema, String targetTableName) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql(this.getSqlBeanMeta(), this.clazz, null, targetSchema, targetTableName, null));
    }

    @Override
    public void backup(Wrapper wrapper, String targetSchema, String targetTableName) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql(this.getSqlBeanMeta(), this.clazz, wrapper, null, targetTableName, null));
    }

    @Override
    public void backup(Wrapper wrapper, String targetTableName, Column ... columns) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql(this.getSqlBeanMeta(), this.clazz, wrapper, null, targetTableName, columns));
    }

    @Override
    public void backup(Wrapper wrapper, String targetSchema, String targetTableName, Column ... columns) {
        this.sqliteTemplate.update(SqlBeanProvider.backupSql(this.getSqlBeanMeta(), this.clazz, wrapper, targetSchema, targetTableName, columns));
    }

    @Override
    public int copy(Wrapper wrapper, String targetTableName) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql(this.getSqlBeanMeta(), this.clazz, wrapper, null, targetTableName, null));
    }

    @Override
    public int copy(Wrapper wrapper, String targetSchema, String targetTableName) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql(this.getSqlBeanMeta(), this.clazz, wrapper, targetSchema, targetTableName, null));
    }

    @Override
    public int copy(Wrapper wrapper, String targetTableName, Column ... columns) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql(this.getSqlBeanMeta(), this.clazz, wrapper, null, targetTableName, columns));
    }

    @Override
    public int copy(Wrapper wrapper, String targetSchema, String targetTableName, Column[] columns) {
        return this.sqliteTemplate.update(SqlBeanProvider.copySql(this.getSqlBeanMeta(), this.clazz, wrapper, targetSchema, targetTableName, columns));
    }

    @Override
    public int alter(Table table, List<ColumnInfo> columnInfoList) {
        List<String> sqlList = SqlBeanProvider.buildAlterSql(this.getSqlBeanMeta(), this.clazz != null ? this.clazz : this.clazz, columnInfoList);
        int count = 0;
        if (sqlList != null && sqlList.size() > 0) {
            for (String sql : sqlList) {
                count += this.sqliteTemplate.update(sql);
            }
        }
        return count;
    }

    @Override
    public int alter(Alter alter) {
        ArrayList<Alter> alterList = new ArrayList<Alter>();
        alterList.add(alter);
        return this.alter(alterList);
    }

    @Override
    public int alter(List<Alter> alterList) {
        List<String> sqlList = SqlBeanProvider.alterSql(this.getSqlBeanMeta().getDbType(), alterList);
        int count = 0;
        if (sqlList != null && sqlList.size() > 0) {
            for (String sql : sqlList) {
                count += this.sqliteTemplate.update(sql);
            }
        }
        return count;
    }

    @Override
    public T selectById(ID id) {
        if (id == null) {
            return null;
        }
        try {
            return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectByIdSql(this.getSqlBeanMeta(), this.clazz, null, id), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> R selectById(Class<R> returnType, ID id) {
        if (id == null) {
            return null;
        }
        try {
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectByIdSql(this.getSqlBeanMeta(), this.clazz, returnType, id), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<T> selectByIds(ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectByIdsSql(this.getSqlBeanMeta(), this.clazz, null, ids), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> List<R> selectByIds(Class<R> returnType, ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectByIdsSql(this.getSqlBeanMeta(), this.clazz, returnType, ids), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public T selectOne(Select select) {
        try {
            return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, null, select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> R selectOne(Class<R> returnType, Select select) {
        try {
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, returnType, select), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> selectMap(Select select) {
        try {
            return (Map)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, null, select), new SqlBeanMapper(this.clazz, Map.class));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public T selectOneBy(String where, Object ... args) {
        try {
            return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectBySql(this.getSqlBeanMeta(), this.clazz, null, null, where, args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> R selectOneBy(Class<R> returnType, String where, Object ... args) {
        try {
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectBySql(this.getSqlBeanMeta(), this.clazz, returnType, null, where, args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public T selectOneBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, null, select), new SqlBeanMapper(this.clazz, this.clazz));
    }

    @Override
    public <R> R selectOneBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        try {
            return (R)this.sqliteTemplate.queryForObject(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, returnType, select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> List<R> selectBy(Class<R> returnType, String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectBySql(this.getSqlBeanMeta(), this.clazz, returnType, null, where, args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> List<R> selectBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, returnType, select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectBySql(this.getSqlBeanMeta(), this.clazz, returnType, paging, where, args), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, returnType, select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<T> selectBy(String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectBySql(this.getSqlBeanMeta(), this.clazz, null, null, where, args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<T> selectBy(Wrapper where) {
        Select select = new Select();
        select.where(where);
        return this.sqliteTemplate.query(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, null, select), new SqlBeanMapper(this.clazz, this.clazz));
    }

    @Override
    public List<T> selectBy(Paging paging, String where, Object ... args) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectBySql(this.getSqlBeanMeta(), this.clazz, null, paging, where, args), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<T> selectBy(Paging paging, Wrapper where) {
        Select select = new Select();
        select.where(where);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.sqliteTemplate.query(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, null, select), new SqlBeanMapper(this.clazz, this.clazz));
    }

    @Override
    public int countBy(String where, Object ... args) {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countBySql(this.getSqlBeanMeta(), this.clazz, where, args), new SqlBeanMapper(this.clazz, Integer.class));
    }

    @Override
    public int countBy(Wrapper where) {
        Select select = new Select();
        select.where(where);
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countSql(this.getSqlBeanMeta(), null, this.clazz, select), new SqlBeanMapper(this.clazz, Integer.class));
    }

    @Override
    public int count() {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countBySql(this.getSqlBeanMeta(), this.clazz, null, null), new SqlBeanMapper(this.clazz, Integer.class));
    }

    @Override
    public List<T> select() {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql(this.getSqlBeanMeta(), this.clazz, null, null), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<T> select(Paging paging) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql(this.getSqlBeanMeta(), this.clazz, null, paging), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> List<R> select(Class<R> returnType) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql(this.getSqlBeanMeta(), this.clazz, returnType, null), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> List<R> select(Class<R> returnType, Paging paging) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectAllSql(this.getSqlBeanMeta(), this.clazz, returnType, paging), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> selectMapList(Select select) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, null, select), new SqlBeanMapper(this.clazz, Map.class));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <R> List<R> select(Class<R> returnType, Select select) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, returnType, select), new SqlBeanMapper(this.clazz, returnType));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<T> select(Select select) {
        try {
            return this.sqliteTemplate.query(SqlBeanProvider.selectSql(this.getSqlBeanMeta(), this.clazz, null, select), new SqlBeanMapper(this.clazz, this.clazz));
        }
        catch (Exception e) {
            Log.e((String)"sqlbean", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public int count(Select select) {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countSql(this.getSqlBeanMeta(), this.clazz, null, select), new SqlBeanMapper(this.clazz, Integer.class));
    }

    @Override
    public int count(Class<?> clazz, Select select) {
        return (Integer)this.sqliteTemplate.queryForObject(SqlBeanProvider.countSql(this.getSqlBeanMeta(), clazz, null, select), new SqlBeanMapper(clazz, Integer.class));
    }

    @Override
    public ResultData<T> paging(Select select, PageHelper<T> pageHelper) {
        pageHelper.paging(select, this);
        return pageHelper.getResultData();
    }

    @Override
    public ResultData<T> paging(Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(pagenum, pagesize);
        pageHelper.paging(select, this);
        return pageHelper.getResultData();
    }

    @Override
    public <R> ResultData<R> paging(Class<R> tClazz, Select select, PageHelper<R> pageHelper) {
        pageHelper.paging(tClazz, select, this);
        return pageHelper.getResultData();
    }

    @Override
    public <R> ResultData<R> paging(Class<R> tClazz, Select select, int pagenum, int pagesize) {
        PageHelper<R> pageHelper = new PageHelper<R>(pagenum, pagesize);
        pageHelper.paging(tClazz, select, this);
        return pageHelper.getResultData();
    }

    @Override
    public int deleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("deleteById\u65b9\u6cd5id\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.sqliteTemplate.update(SqlBeanProvider.deleteByIdSql(this.getSqlBeanMeta(), this.clazz, id));
    }

    @Override
    public int deleteBy(String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.deleteBySql(this.getSqlBeanMeta(), this.clazz, where, args));
    }

    @Override
    public int deleteBy(Wrapper where) {
        Delete delete = new Delete();
        delete.setLogicallyDelete(SqlBeanUtil.checkLogically(this.clazz));
        delete.where(where);
        return this.sqliteTemplate.update(SqlBeanProvider.deleteSql(this.getSqlBeanMeta(), this.clazz, delete, false));
    }

    @Override
    public int delete(Delete delete) {
        return this.sqliteTemplate.update(SqlBeanProvider.deleteSql(this.getSqlBeanMeta(), this.clazz, delete, false));
    }

    @Override
    public int delete(Delete delete, boolean ignore) {
        return this.sqliteTemplate.update(SqlBeanProvider.deleteSql(this.getSqlBeanMeta(), this.clazz, delete, ignore));
    }

    @Override
    public int logicallyDeleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("logicallyDeleteById\u65b9\u6cd5id\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.sqliteTemplate.update(SqlBeanProvider.logicallyDeleteByIdSql(this.getSqlBeanMeta(), this.clazz, id));
    }

    @Override
    public int logicallyDeleteBy(String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.logicallyDeleteBySql(this.getSqlBeanMeta(), this.clazz, where, args));
    }

    @Override
    public int logicallyDeleteBy(Wrapper where) {
        return this.sqliteTemplate.update(SqlBeanProvider.logicallyDeleteBySql(this.getSqlBeanMeta(), this.clazz, where));
    }

    @Override
    public int update(Update update) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql(this.getSqlBeanMeta(), this.clazz, update, false));
    }

    @Override
    public int update(Update update, boolean ignore) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql(this.getSqlBeanMeta(), this.clazz, update, ignore));
    }

    @Override
    public int updateById(T bean, ID id) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByIdSql(this.getSqlBeanMeta(), this.clazz, bean, id, true, false, null));
    }

    @Override
    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByIdSql(this.getSqlBeanMeta(), this.clazz, bean, id, updateNotNull, optimisticLock, null));
    }

    @Override
    public int updateByBeanId(T bean) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanIdSql(this.getSqlBeanMeta(), this.clazz, bean, true, false, null));
    }

    @Override
    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, Column ... filterColumns) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByIdSql(this.getSqlBeanMeta(), this.clazz, bean, id, updateNotNull, optimisticLock, filterColumns));
    }

    @Override
    public int updateBy(T bean, String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateBySql(this.getSqlBeanMeta(), this.clazz, bean, true, false, null, where, args));
    }

    @Override
    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanIdSql(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, null));
    }

    @Override
    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, Column ... filterColumns) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanIdSql(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, filterColumns));
    }

    @Override
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateBySql(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, null, where, args));
    }

    @Override
    public int updateBy(T bean, Wrapper wrapper) {
        Update<T> update = new Update<T>();
        update.bean(bean).notNull(true).optimisticLock(false).where(wrapper);
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql(this.getSqlBeanMeta(), this.clazz, update, false));
    }

    @Override
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper) {
        Update<T> update = new Update<T>();
        update.bean(bean).notNull(updateNotNull).optimisticLock(optimisticLock).where(wrapper);
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql(this.getSqlBeanMeta(), this.clazz, update, false));
    }

    @Override
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Column[] filterColumns, String where, Object ... args) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateBySql(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, filterColumns, where, args));
    }

    @Override
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper, Column ... filterColumns) {
        Update<T> update = new Update<T>();
        update.bean(bean).notNull(updateNotNull).optimisticLock(optimisticLock).filterFields(filterColumns).where(wrapper);
        return this.sqliteTemplate.update(SqlBeanProvider.updateSql(this.getSqlBeanMeta(), this.clazz, update, false));
    }

    @Override
    public int updateByBean(T bean, String where) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanSql(this.getSqlBeanMeta(), this.clazz, bean, true, false, where, null));
    }

    @Override
    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanSql(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, where, null));
    }

    @Override
    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where, Column ... filterColumns) {
        return this.sqliteTemplate.update(SqlBeanProvider.updateByBeanSql(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, where, filterColumns));
    }

    @Override
    public int insert(T ... bean) {
        if (bean == null || bean.length == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5bean\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.sqliteTemplate.insert(SqlBeanProvider.insertBeanSql(this.getSqlBeanMeta(), this.clazz, bean));
    }

    @Override
    public int insert(Collection<T> beanList) {
        if (beanList == null || beanList.size() == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5beanList\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.sqliteTemplate.insert(SqlBeanProvider.insertBeanSql(this.getSqlBeanMeta(), this.clazz, beanList));
    }

    @Override
    public int insert(Insert insert) {
        return this.sqliteTemplate.insert(SqlBeanProvider.insertBeanSql(this.getSqlBeanMeta(), this.clazz, insert));
    }
}

