/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.uitls;

import cn.vonce.sql.uitls.SqlBeanUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanUtil {
    public static <T> T toBean(Class<T> clazz, Map<String, Object> map) {
        if (clazz == null || map == null) {
            throw new IllegalArgumentException("Class and Map cannot be null");
        }
        try {
            T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                String propertyName = descriptor.getName();
                if (!map.containsKey(propertyName)) continue;
                Object value = map.get(propertyName);
                if (value != null) {
                    Class<?> propertyType = descriptor.getPropertyType();
                    if (value instanceof Map) {
                        value = BeanUtil.toBean(propertyType, (Map)value);
                    } else if (BeanUtil.isListOfBean(propertyType, descriptor)) {
                        value = BeanUtil.toBeanList((List)value, BeanUtil.getListGenericType(descriptor));
                    }
                }
                try {
                    if (descriptor.getPropertyType().isEnum()) {
                        ?[] constants;
                        for (Object constant : constants = descriptor.getPropertyType().getEnumConstants()) {
                            if (!constant.toString().equals(value)) continue;
                            value = constant;
                            break;
                        }
                        descriptor.getWriteMethod().invoke(obj, value);
                        continue;
                    }
                    descriptor.getWriteMethod().invoke(obj, value);
                }
                catch (Exception e) {
                    try {
                        value = SqlBeanUtil.getValueConvert(descriptor.getPropertyType(), value);
                        descriptor.getWriteMethod().invoke(obj, value);
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to set property: " + propertyName + " - " + ex.getMessage());
                    }
                }
            }
            return obj;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Failed to analyze bean properties: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate JavaBean: " + e.getMessage(), e);
        }
    }

    public static Map<String, Object> toMap(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("Bean cannot be null");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                String propertyName = descriptor.getName();
                if ("class".equals(propertyName)) continue;
                try {
                    Object value = descriptor.getReadMethod().invoke(bean, new Object[0]);
                    if (value != null) {
                        if (BeanUtil.isBean(value.getClass())) {
                            value = BeanUtil.toMap(value);
                        } else if (value instanceof List) {
                            value = BeanUtil.toMapList((List)value);
                        }
                    }
                    resultMap.put(propertyName, value);
                }
                catch (Exception e) {
                    System.err.println("Failed to read property: " + propertyName + " - " + e.getMessage());
                }
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Failed to analyze bean properties: " + e.getMessage(), e);
        }
        return resultMap;
    }

    private static boolean isBean(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.equals(String.class) && !Number.class.isAssignableFrom(clazz) && !Boolean.class.equals(clazz) && !Character.class.equals(clazz) && !Enum.class.isAssignableFrom(clazz) && !Calendar.class.isAssignableFrom(clazz) && !Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz) && !BigDecimal.class.isAssignableFrom(clazz) && !BeanUtil.isDate(clazz);
    }

    private static boolean isDate(Class<?> clazz) {
        if (!SqlBeanUtil.isAndroidEnv()) {
            return Date.class.isAssignableFrom(clazz) || LocalDate.class.isAssignableFrom(clazz) || LocalDateTime.class.isAssignableFrom(clazz) || LocalTime.class.isAssignableFrom(clazz);
        }
        return Date.class.isAssignableFrom(clazz);
    }

    private static boolean isListOfBean(Class<?> clazz, PropertyDescriptor descriptor) {
        if (List.class.isAssignableFrom(clazz)) {
            ParameterizedType type = (ParameterizedType)descriptor.getReadMethod().getGenericReturnType();
            Class genericType = (Class)type.getActualTypeArguments()[0];
            return BeanUtil.isBean(genericType);
        }
        return false;
    }

    private static Class<?> getListGenericType(PropertyDescriptor descriptor) {
        ParameterizedType type = (ParameterizedType)descriptor.getReadMethod().getGenericReturnType();
        return (Class)type.getActualTypeArguments()[0];
    }

    private static <T> List<T> toBeanList(List<Map<String, Object>> mapList, Class<T> clazz) {
        ArrayList<T> beanList = new ArrayList<T>();
        if (mapList != null) {
            for (Map<String, Object> map : mapList) {
                beanList.add(BeanUtil.toBean(clazz, map));
            }
        }
        return beanList;
    }

    private static List<Map<String, Object>> toMapList(List<?> beanList) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (beanList != null) {
            for (Object bean : beanList) {
                mapList.add(BeanUtil.toMap(bean));
            }
        }
        return mapList;
    }
}

