/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.json;

import cn.vonce.sql.json.JSONArray;
import cn.vonce.sql.json.JSONParser;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class JSONObject
extends JSONParser
implements Map<String, Object>,
Cloneable,
Serializable {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<String, Object> map;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null.");
        }
        this.map = map;
    }

    public JSONObject(boolean ordered) {
        this(16, ordered);
    }

    public JSONObject(int initialCapacity) {
        this(initialCapacity, false);
    }

    public JSONObject(int initialCapacity, boolean ordered) {
        this.map = ordered ? new LinkedHashMap<String, Object>(initialCapacity) : new HashMap<String, Object>(initialCapacity);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean result = this.map.containsKey(key);
        if (!result && (key instanceof Number || key instanceof Character || key instanceof Boolean || key instanceof UUID)) {
            result = this.map.containsKey(key.toString());
        }
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        Object val = this.map.get(key);
        if (val == null && (key instanceof Number || key instanceof Character || key instanceof Boolean || key instanceof UUID)) {
            val = this.map.get(key.toString());
        }
        return val;
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.remove(key.toString());
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    public String getString(String key) {
        String str;
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((str = (String)value).length() == 0 || str.equalsIgnoreCase("null"))) {
            return null;
        }
        return value.toString();
    }

    public Integer getInteger(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            if (str.indexOf(44) != -1) {
                str = str.replaceAll(",", "");
            }
            return Integer.valueOf(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        return Integer.valueOf(value.toString());
    }

    public Long getLong(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            if (str.indexOf(44) != -1) {
                str = str.replaceAll(",", "");
            }
            return Long.valueOf(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        return Long.valueOf(value.toString());
    }

    public Double getDouble(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            if (str.indexOf(44) != -1) {
                str = str.replaceAll(",", "");
            }
            return Double.valueOf(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        return Double.valueOf(value.toString());
    }

    public Float getFloat(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            if (str.indexOf(44) != -1) {
                str = str.replaceAll(",", "");
            }
            return Float.valueOf(str);
        }
        if (value instanceof Boolean) {
            return Float.valueOf((Boolean)value != false ? 1.0f : 0.0f);
        }
        return Float.valueOf(value.toString());
    }

    public Short getShort(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            if (str.indexOf(44) != -1) {
                str = str.replaceAll(",", "");
            }
            return Short.valueOf(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? (short)1 : 0;
        }
        return Short.valueOf(value.toString());
    }

    public Byte getByte(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            if (str.indexOf(44) != -1) {
                str = str.replaceAll(",", "");
            }
            return Byte.valueOf(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? (byte)1 : 0;
        }
        return Byte.valueOf(value.toString());
    }

    public BigDecimal getBigDecimal(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    public Boolean getBoolean(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).intValue() == 1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            if (str.indexOf(44) != -1) {
                str = str.replaceAll(",", "");
            }
            if ("true".equalsIgnoreCase(str) || "1".equals(str)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(str) || "0".equals(str)) {
                return Boolean.FALSE;
            }
            if ("Y".equalsIgnoreCase(str) || "T".equals(str)) {
                return Boolean.TRUE;
            }
            if ("F".equalsIgnoreCase(str) || "N".equals(str)) {
                return Boolean.FALSE;
            }
        }
        return Boolean.valueOf(value.toString());
    }

    public JSONObject getJSONObject(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        return value instanceof JSONObject ? (JSONObject)value : null;
    }

    public JSONArray getJSONArray(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        return value instanceof JSONArray ? (JSONArray)value : null;
    }
}

