/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.processor;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.uitls.StringUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class SqlConstantProcessor
extends AbstractProcessor {
    private Messager messager;
    private Filer filer;
    public static final String PREFIX = "Sql";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        try {
            for (TypeElement typeElement : annotations) {
                for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                    SqlTable sqlTable = element.getAnnotation(SqlTable.class);
                    if (!sqlTable.generate()) continue;
                    Element enclosingElement = element.getEnclosingElement();
                    String packageName = ((PackageElement)enclosingElement).getQualifiedName().toString() + ".sql";
                    String className = PREFIX + element.getSimpleName();
                    String schema = sqlTable.schema();
                    String tableName = sqlTable.value();
                    String tableAlias = sqlTable.alias();
                    if (StringUtil.isEmpty(tableAlias)) {
                        tableAlias = tableName;
                    }
                    try {
                        StringBuffer code = new StringBuffer();
                        code.append("/** The code is generated by the Sqlbean. */\n\n");
                        code.append(String.format("package %s;\n\n", packageName));
                        code.append("import cn.vonce.sql.bean.Column;\n\n");
                        code.append(String.format("public class %s {\n\n", className));
                        code.append(String.format("\tpublic static final String _schema = \"%s\";\n", schema));
                        code.append(String.format("\tpublic static final String _tableName = \"%s\";\n", tableName));
                        code.append(String.format("\tpublic static final String _tableAlias = \"%s\";\n", tableAlias));
                        code.append(String.format("\tpublic static final String _all = \"%s.*\";\n", tableAlias));
                        code.append("\tpublic static final String _count = \"COUNT(*)\";\n");
                        for (Element element2 : element.getEnclosedElements()) {
                            if (!element2.getKind().isField() || element2.getModifiers().contains((Object)Modifier.STATIC)) continue;
                            String sqlFieldName = element2.getSimpleName().toString();
                            SqlColumn sqlColumn = element2.getAnnotation(SqlColumn.class);
                            if (sqlColumn != null && StringUtil.isNotEmpty(sqlColumn.value())) {
                                sqlFieldName = sqlColumn.value();
                            }
                            code.append(String.format("\tpublic static final Column %s = new Column(_schema,_tableAlias,\"%s\",\"\");\n", sqlFieldName, sqlFieldName));
                        }
                        code.append("\n}");
                        JavaFileObject fileObject = this.processingEnv.getFiler().createSourceFile(packageName + "." + className, enclosingElement);
                        Writer writer = fileObject.openWriter();
                        writer.write(code.toString());
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        return true;
    }
}

