/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.helper;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlId;
import cn.vonce.sql.annotation.SqlUnion;
import cn.vonce.sql.annotation.SqlVersion;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Common;
import cn.vonce.sql.bean.Condition;
import cn.vonce.sql.bean.ConditionInfo;
import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Join;
import cn.vonce.sql.bean.Original;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.SqlField;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.enumerate.ConditionType;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.GenerateType;
import cn.vonce.sql.enumerate.JavaType;
import cn.vonce.sql.enumerate.JdbcType;
import cn.vonce.sql.enumerate.SQLiteJavaType;
import cn.vonce.sql.enumerate.SqlLogic;
import cn.vonce.sql.enumerate.SqlOperator;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import com.google.common.collect.ListMultimap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class SqlHelper {
    public static void isNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void check(Common common) {
        SqlHelper.isNull(common.getSqlBeanConfig(), "\u8bf7\u8bbe\u7f6esqlBeanConfig");
        SqlHelper.isNull((Object)common.getSqlBeanConfig().getDbType(), "\u8bf7\u8bbe\u7f6esqlBeanConfig -> dbType");
    }

    public static String buildSelectSql(Select select) {
        SqlHelper.check(select);
        StringBuffer sqlSb = new StringBuffer();
        Integer[] pageParam = null;
        String orderSql = SqlHelper.orderBySql(select);
        if (select.getSqlBeanConfig().getDbType() == DbType.SQLServer2008 && SqlBeanUtil.isUsePage(select)) {
            pageParam = SqlHelper.pageParam(select);
            sqlSb.append("SELECT ");
            sqlSb.append(" * ");
            sqlSb.append(" FROM ");
            sqlSb.append("(");
        }
        sqlSb.append(select.isUseDistinct() ? "SELECT DISTINCT" : "SELECT ");
        if (select.getSqlBeanConfig().getDbType() == DbType.SQLServer2008 && SqlBeanUtil.isUsePage(select)) {
            sqlSb.append(" TOP ");
            sqlSb.append(pageParam[0]);
            sqlSb.append(" ROW_NUMBER()  OVER (" + orderSql + ")" + " ROWNUM " + ", ");
        }
        sqlSb.append(SqlHelper.column(select));
        sqlSb.append(" FROM ");
        sqlSb.append(SqlHelper.fromFullName(select));
        sqlSb.append(SqlHelper.joinSql(select));
        sqlSb.append(SqlHelper.whereSql(select, null));
        String groupBySql = SqlHelper.groupBySql(select);
        sqlSb.append(groupBySql);
        sqlSb.append(SqlHelper.havingSql(select));
        if (!SqlBeanUtil.isCount(select)) {
            sqlSb.append(orderSql);
        }
        if (select.getSqlBeanConfig().getDbType() == DbType.SQLServer2008 && SqlBeanUtil.isUsePage(select)) {
            sqlSb.append(")");
            sqlSb.append(" T");
            sqlSb.append(" WHERE ");
            sqlSb.append(" T. ROWNUM ");
            sqlSb.append(" > ");
            sqlSb.append(pageParam[1]);
        }
        if (SqlBeanUtil.isCount(select) && StringUtil.isNotEmpty(groupBySql)) {
            sqlSb.insert(0, "SELECT COUNT( * ) FROM (");
            sqlSb.append(") AS  T");
        }
        if (select.getSqlBeanConfig().getDbType() == DbType.MySQL || select.getSqlBeanConfig().getDbType() == DbType.MariaDB || select.getSqlBeanConfig().getDbType() == DbType.H2) {
            SqlHelper.mysqlPageDispose(select, sqlSb);
        } else if (select.getSqlBeanConfig().getDbType() == DbType.PostgreSQL || select.getSqlBeanConfig().getDbType() == DbType.SQLite || select.getSqlBeanConfig().getDbType() == DbType.Hsql) {
            SqlHelper.postgreSqlPageDispose(select, sqlSb);
        } else if (select.getSqlBeanConfig().getDbType() == DbType.Oracle) {
            SqlHelper.oraclePageDispose(select, sqlSb);
        } else if (select.getSqlBeanConfig().getDbType() == DbType.DB2) {
            SqlHelper.db2PageDispose(select, sqlSb);
        } else if (select.getSqlBeanConfig().getDbType() == DbType.Derby) {
            SqlHelper.derbyPageDispose(select, sqlSb);
        }
        return sqlSb.toString();
    }

    public static String buildUpdateSql(Update update) {
        SqlHelper.check(update);
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("UPDATE ");
        sqlSb.append(SqlHelper.getTableName(SqlBeanUtil.getTable(update.getUpdateBean().getClass()), update));
        sqlSb.append(" SET ");
        sqlSb.append(SqlHelper.setSql(update));
        sqlSb.append(SqlHelper.whereSql(update, update.getUpdateBean()));
        return sqlSb.toString();
    }

    public static String buildInsertSql(Insert insert) {
        Object[] objects;
        SqlHelper.check(insert);
        if (insert.getInsertBean().getClass().isArray()) {
            objects = (Object[])insert.getInsertBean();
        } else if (insert.getInsertBean() instanceof Collection) {
            Collection list = (Collection)insert.getInsertBean();
            objects = list.toArray();
        } else {
            objects = new Object[]{insert.getInsertBean()};
        }
        String sql = null;
        try {
            sql = SqlHelper.fieldAndValuesSql(insert, objects);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return sql;
    }

    public static String buildDeleteSql(Delete delete) {
        SqlHelper.check(delete);
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("DELETE FROM ");
        sqlSb.append(SqlHelper.getTableName(delete.getTable(), delete));
        sqlSb.append(SqlHelper.whereSql(delete, null));
        return sqlSb.toString();
    }

    public static String buildCreateSql(Create create) {
        Field[] fields;
        SqlHelper.check(create);
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("CREATE TABLE ");
        sqlSb.append(SqlHelper.getTableName(SqlBeanUtil.getTable(create.getBeanClass()), create));
        sqlSb.append("(");
        Field idField = null;
        for (Field field : fields = create.getBeanClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (idField == null && field.getAnnotation(SqlId.class) != null) {
                idField = field;
            }
            SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
            ColumnInfo columnInfo = SqlHelper.getColumnInfo(create.getSqlBeanConfig().getDbType(), field.getType(), sqlColumn);
            String columnName = field.getName();
            if (sqlColumn != null) {
                columnName = sqlColumn.value();
            }
            sqlSb.append(columnName);
            sqlSb.append(" ");
            sqlSb.append(columnInfo.getType().name());
            sqlSb.append("(");
            sqlSb.append(columnInfo.getLength());
            if (columnInfo.getType().isFloat()) {
                sqlSb.append(", ");
                sqlSb.append(columnInfo.getDecimal());
            }
            sqlSb.append(")");
            if (columnInfo.getNotNull()) {
                sqlSb.append("NOT NULL");
            }
            if (StringUtil.isNotEmpty(columnInfo.getDef())) {
                sqlSb.append("DEFAULT ");
                sqlSb.append(SqlBeanUtil.getSqlValue(create, columnInfo.getDef()));
            }
            sqlSb.append(", ");
        }
        if (idField != null) {
            sqlSb.append("PRIMARY KEY");
            sqlSb.append("(");
            sqlSb.append(SqlBeanUtil.getTableFieldName(idField));
            sqlSb.append(")");
        } else {
            sqlSb.deleteCharAt(sqlSb.length() - 1);
        }
        sqlSb.append(")");
        return sqlSb.toString();
    }

    private static ColumnInfo getColumnInfo(DbType dbType, Class<?> clazz, SqlColumn sqlColumn) {
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setNotNull(sqlColumn.notNull());
        if (sqlColumn.type() != JdbcType.NULL) {
            columnInfo.setType(sqlColumn.type());
        } else if (dbType == DbType.SQLite) {
            columnInfo.setType(JdbcType.getType(SQLiteJavaType.getType(clazz).name()));
        } else {
            columnInfo.setType(JdbcType.getType(JavaType.getType(clazz).name()));
        }
        if (sqlColumn.length() != 0) {
            columnInfo.setLength(sqlColumn.length());
            columnInfo.setDecimal(sqlColumn.decimal());
        } else {
            columnInfo.setLength(columnInfo.getType().getLength());
        }
        if (sqlColumn.decimal() != 0) {
            columnInfo.setDecimal(sqlColumn.decimal());
        } else {
            columnInfo.setDecimal(columnInfo.getType().getDecimal());
        }
        if (StringUtil.isNotEmpty(sqlColumn.def())) {
            columnInfo.setDef(sqlColumn.def());
        }
        return columnInfo;
    }

    private static String getTableName(Table table, Common common) {
        String schema = table.getSchema();
        String tableName = table.getName();
        if (StringUtil.isNotEmpty(schema)) {
            tableName = schema + "." + tableName;
        }
        return SqlBeanUtil.isToUpperCase(common) ? tableName.toUpperCase() : tableName;
    }

    private static String column(Select select) {
        StringBuffer columnSql = new StringBuffer();
        if (select.getColumnList() != null && select.getColumnList().size() != 0) {
            for (int i = 0; i < select.getColumnList().size(); ++i) {
                boolean existAlias;
                String schema = select.getColumnList().get(i).getSchema();
                String tableAlias = select.getColumnList().get(i).getTableAlias();
                String columnName = select.getColumnList().get(i).getName();
                String transferred = SqlBeanUtil.getTransferred(select);
                if (SqlBeanUtil.isToUpperCase(select)) {
                    schema = schema.toUpperCase();
                    columnName = columnName.toUpperCase();
                }
                if (existAlias = StringUtil.isNotEmpty(select.getColumnList().get(i).getAlias())) {
                    columnSql.append("(");
                }
                if (StringUtil.isNotEmpty(tableAlias)) {
                    if (StringUtil.isNotEmpty(schema)) {
                        columnSql.append(schema);
                        columnSql.append(".");
                    }
                    columnSql.append(transferred);
                    columnSql.append(tableAlias);
                    columnSql.append(transferred);
                    columnSql.append(".");
                }
                columnSql.append(columnName);
                if (existAlias) {
                    columnSql.append(")");
                    columnSql.append(" AS ");
                    columnSql.append(transferred);
                    columnSql.append(select.getColumnList().get(i).getAlias());
                    columnSql.append(transferred);
                }
                columnSql.append(", ");
            }
            columnSql.deleteCharAt(columnSql.length() - ", ".length());
        }
        return columnSql.toString();
    }

    private static String fromFullName(Select select) {
        String transferred = SqlBeanUtil.getTransferred(select);
        StringBuffer fromSql = new StringBuffer();
        String tableName = select.getTable().getName();
        String schema = select.getTable().getSchema();
        if (SqlBeanUtil.isToUpperCase(select)) {
            tableName = tableName.toUpperCase();
            schema = schema.toUpperCase();
        }
        if (StringUtil.isNotEmpty(schema)) {
            fromSql.append(schema);
            fromSql.append(".");
        }
        fromSql.append(tableName);
        fromSql.append(" ");
        fromSql.append(transferred);
        fromSql.append(select.getTable().getAlias());
        fromSql.append(transferred);
        return fromSql.toString();
    }

    private static String joinSql(Select select) {
        StringBuffer joinSql = new StringBuffer();
        if (select != null && select.getJoin().size() != 0) {
            for (int i = 0; i < select.getJoin().size(); ++i) {
                Join join = select.getJoin().get(i);
                switch (join.getJoinType()) {
                    case INNER_JOIN: {
                        joinSql.append(" INNER JOIN ");
                        break;
                    }
                    case LEFT_JOIN: {
                        joinSql.append(" LEFT JOIN ");
                        break;
                    }
                    case RIGHT_JOIN: {
                        joinSql.append(" RIGHT JOIN ");
                        break;
                    }
                    case FULL_JOIN: {
                        joinSql.append(" FULL JOIN ");
                    }
                }
                String schema = join.getSchema();
                String tableName = join.getTableName();
                String tableAlias = join.getTableAlias();
                String tableKeyword = SqlBeanUtil.getTableFieldFullName(select, schema, tableAlias, join.getTableKeyword());
                String mainKeyword = SqlBeanUtil.getTableFieldFullName(select, select.getTable().getSchema(), select.getTable().getAlias(), join.getMainKeyword());
                if (SqlBeanUtil.isToUpperCase(select)) {
                    schema = schema.toUpperCase();
                    tableName = tableName.toUpperCase();
                    tableAlias = tableAlias.toUpperCase();
                    tableKeyword = tableKeyword.toUpperCase();
                    mainKeyword = mainKeyword.toUpperCase();
                }
                if (StringUtil.isNotEmpty(schema)) {
                    joinSql.append(schema);
                    joinSql.append(".");
                }
                joinSql.append(tableName);
                joinSql.append(" ");
                String transferred = SqlBeanUtil.getTransferred(select);
                joinSql.append(transferred);
                joinSql.append(tableAlias);
                joinSql.append(transferred);
                joinSql.append(" ON ");
                joinSql.append(tableKeyword);
                joinSql.append(" = ");
                joinSql.append(mainKeyword);
                if (i >= select.getJoin().size() - 1) continue;
                joinSql.append(" ");
            }
        }
        return joinSql.toString();
    }

    private static String fieldAndValuesSql(Common common, Object[] objects) throws IllegalArgumentException {
        int k;
        String tableName = SqlHelper.getTableName(SqlBeanUtil.getTable(objects[0].getClass()), common);
        StringBuffer fieldSql = new StringBuffer();
        StringBuffer valueSql = new StringBuffer();
        StringBuffer fieldAndValuesSql = new StringBuffer();
        ArrayList<String> valueSqlList = new ArrayList<String>();
        String transferred = SqlBeanUtil.getTransferred(common);
        Field[] fields = objects[0].getClass().getAnnotation(SqlUnion.class) != null ? objects[0].getClass().getSuperclass().getDeclaredFields() : objects[0].getClass().getDeclaredFields();
        if (common.getSqlBeanConfig().getDbType() == DbType.Oracle) {
            if (common.getSqlBeanConfig().getToUpperCase().booleanValue()) {
                tableName = tableName.toUpperCase();
            }
            if (objects != null && objects.length > 1) {
                fieldAndValuesSql.append("INSERT ALL INTO ");
            } else {
                fieldAndValuesSql.append("INSERT INTO ");
            }
        } else {
            fieldAndValuesSql.append("INSERT INTO ");
        }
        for (int i = 0; i < objects.length; ++i) {
            valueSql.delete(0, valueSql.length());
            if (i == 0) {
                fieldSql.append("(");
            }
            valueSql.append("(");
            int existId = 0;
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers()) || SqlBeanUtil.isIgnore(field)) continue;
                SqlId sqlId = field.getAnnotation(SqlId.class);
                if (sqlId != null) {
                    ++existId;
                }
                if (existId > 1) {
                    throw new SqlBeanException("\u8bf7\u6b63\u786e\u7684\u6807\u8bc6id\u5b57\u6bb5\uff0cid\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728'" + field.getDeclaringClass().getName() + "'\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
                }
                if (i == 0) {
                    String tableFieldName = SqlBeanUtil.getTableFieldName(field);
                    if (sqlId == null || sqlId != null && sqlId.generateType() != GenerateType.AUTO) {
                        fieldSql.append(transferred + (SqlBeanUtil.isToUpperCase(common) ? tableFieldName.toUpperCase() : tableFieldName) + transferred);
                        fieldSql.append(", ");
                    }
                }
                if (sqlId != null && sqlId.generateType() != GenerateType.AUTO && sqlId.generateType() != GenerateType.NORMAL) {
                    Object value = ReflectUtil.instance().get(objects[i].getClass(), objects[i], field.getName());
                    if (StringUtil.isEmpty(value)) {
                        value = common.getSqlBeanConfig().getUniqueIdProcessor().uniqueId(sqlId.generateType());
                    }
                    valueSql.append(SqlBeanUtil.getSqlValue(common, value));
                    valueSql.append(", ");
                    continue;
                }
                valueSql.append(SqlBeanUtil.getSqlValue(common, ReflectUtil.instance().get(objects[i].getClass(), objects[i], field.getName())));
                valueSql.append(", ");
            }
            valueSql.deleteCharAt(valueSql.length() - ", ".length());
            valueSql.append(")");
            valueSqlList.add(valueSql.toString());
            if (i != 0) continue;
            fieldSql.deleteCharAt(fieldSql.length() - ", ".length());
            fieldSql.append(")");
        }
        if (common.getSqlBeanConfig().getDbType() == DbType.Oracle) {
            for (k = 0; k < valueSqlList.size(); ++k) {
                if (k > 0) {
                    fieldAndValuesSql.append(" INTO ");
                }
                fieldAndValuesSql.append(tableName);
                fieldAndValuesSql.append(fieldSql.toString());
                fieldAndValuesSql.append("VALUES");
                fieldAndValuesSql.append((String)valueSqlList.get(k));
            }
            if (objects != null && objects.length > 1) {
                fieldAndValuesSql.append(" SELECT 1 FROM DUAL ");
            }
        } else {
            for (k = 0; k < valueSqlList.size(); ++k) {
                if (k == 0) {
                    fieldAndValuesSql.append(tableName);
                    fieldAndValuesSql.append(fieldSql.toString());
                    fieldAndValuesSql.append("VALUES");
                }
                fieldAndValuesSql.append((String)valueSqlList.get(k));
                fieldAndValuesSql.append(", ");
            }
            fieldAndValuesSql.deleteCharAt(fieldAndValuesSql.length() - ", ".length());
        }
        return fieldAndValuesSql.toString();
    }

    private static String setSql(Update update) {
        Object objectValue;
        String name;
        int i;
        StringBuffer setSql = new StringBuffer();
        String transferred = SqlBeanUtil.getTransferred(update);
        String[] filterFields = update.getFilterFields();
        Object bean = update.getUpdateBean();
        Field[] fields = bean.getClass().getAnnotation(SqlUnion.class) != null ? bean.getClass().getSuperclass().getDeclaredFields() : bean.getClass().getDeclaredFields();
        ArrayList<Field> filterAfterList = new ArrayList<Field>();
        for (i = 0; i < fields.length; ++i) {
            if (Modifier.isStatic(fields[i].getModifiers())) continue;
            name = SqlBeanUtil.getTableFieldName(fields[i]);
            objectValue = ReflectUtil.instance().get(bean.getClass(), bean, fields[i].getName());
            if (update.isUpdateNotNull() && objectValue == null || SqlBeanUtil.isIgnore(fields[i]) || SqlBeanUtil.isFilter(filterFields, name)) continue;
            filterAfterList.add(fields[i]);
        }
        for (i = 0; i < filterAfterList.size(); ++i) {
            name = SqlBeanUtil.getTableFieldName((Field)filterAfterList.get(i));
            objectValue = ReflectUtil.instance().get(bean.getClass(), bean, ((Field)filterAfterList.get(i)).getName());
            setSql.append(transferred);
            setSql.append(SqlBeanUtil.isToUpperCase(update) ? name.toUpperCase() : name);
            setSql.append(transferred);
            setSql.append(" = ");
            if (((Field)filterAfterList.get(i)).getAnnotation(SqlVersion.class) != null) {
                Object o = SqlBeanUtil.updateVersion(((Field)filterAfterList.get(i)).getType().getName(), objectValue);
                setSql.append(SqlBeanUtil.getSqlValue(update, o));
            } else {
                setSql.append(SqlBeanUtil.getSqlValue(update, objectValue));
            }
            setSql.append(", ");
        }
        setSql.deleteCharAt(setSql.length() - ", ".length());
        return setSql.toString();
    }

    private static String whereSql(Condition condition, Object bean) {
        return SqlHelper.conditionHandle(ConditionType.WHERE, condition, condition.getWhere(), condition.getAgrs(), bean, condition.getWhereMap());
    }

    private static String groupBySql(Select select) {
        return SqlHelper.groupByAndOrderBySql(" GROUP BY ", select);
    }

    private static String havingSql(Select select) {
        return SqlHelper.conditionHandle(ConditionType.HAVING, select, select.getHaving(), select.getHavingArgs(), null, select.getHavingMap());
    }

    private static String orderBySql(Select select) {
        return SqlHelper.groupByAndOrderBySql(" ORDER BY ", select);
    }

    private static String groupByAndOrderBySql(String type, Select select) {
        StringBuffer groupByAndOrderBySql = new StringBuffer();
        SqlField[] sqlFields = " ORDER BY ".equals(type) ? select.getOrderBy().toArray(new SqlField[0]) : select.getGroupBy().toArray(new SqlField[0]);
        if (sqlFields != null && sqlFields.length != 0) {
            groupByAndOrderBySql.append(type);
            for (int i = 0; i < sqlFields.length; ++i) {
                SqlField sqlField = sqlFields[i];
                if (StringUtil.isNotEmpty(sqlField.getTableAlias())) {
                    if (StringUtil.isNotEmpty(sqlField.getSchema())) {
                        groupByAndOrderBySql.append(sqlField.getSchema());
                        groupByAndOrderBySql.append(".");
                    }
                    groupByAndOrderBySql.append(sqlField.getTableAlias());
                    groupByAndOrderBySql.append(".");
                }
                groupByAndOrderBySql.append(sqlField.getName());
                if (" ORDER BY ".equals(type)) {
                    groupByAndOrderBySql.append(" ");
                    groupByAndOrderBySql.append(select.getOrderBy().get(i).getSqlSort().name());
                    groupByAndOrderBySql.append(" ");
                }
                groupByAndOrderBySql.append(", ");
            }
            groupByAndOrderBySql.deleteCharAt(groupByAndOrderBySql.length() - ", ".length());
        } else if (" ORDER BY ".equals(type) && select.getSqlBeanConfig().getDbType() == DbType.SQLServer2008 && SqlBeanUtil.isUsePage(select) && !SqlBeanUtil.isCount(select)) {
            groupByAndOrderBySql.append(type);
            String tableFieldFullName = SqlBeanUtil.getTableFieldFullName(select, select.getTable().getSchema(), select.getTable().getAlias(), select.getPage().getIdName());
            groupByAndOrderBySql.append(SqlBeanUtil.isToUpperCase(select) ? tableFieldFullName.toUpperCase() : tableFieldFullName);
        }
        return groupByAndOrderBySql.toString();
    }

    private static String conditionHandle(ConditionType conditionType, Common common, String where, Object[] args, Object bean, ListMultimap<String, ConditionInfo> whereMap) {
        StringBuffer conditionSql = new StringBuffer();
        StringBuffer versionConditionSql = null;
        Field versionField = null;
        boolean versionEffectiveness = false;
        if (common instanceof Update) {
            versionConditionSql = new StringBuffer();
            if (bean != null) {
                versionField = SqlBeanUtil.getVersionField(bean.getClass());
            }
            if (versionField != null && (versionEffectiveness = SqlBeanUtil.versionEffectiveness(versionField.getType().getName()))) {
                versionConditionSql.append("(");
                versionConditionSql.append(SqlBeanUtil.getTableFieldName(versionField));
                Object versionValue = ReflectUtil.instance().get(bean.getClass(), bean, versionField.getName());
                versionConditionSql.append(versionValue == null ? " IS " : " = ");
                versionConditionSql.append(SqlBeanUtil.getSqlValue(common, versionValue));
                versionConditionSql.append(")");
                versionConditionSql.append(" AND ");
            }
        }
        if (where != null && !"".equals(where)) {
            conditionSql.append(ConditionType.WHERE == conditionType ? " WHERE " : " HAVING ");
            if (versionField != null && versionEffectiveness) {
                conditionSql.append(versionConditionSql);
            }
            conditionSql.append("(");
            if (args != null && args.length > 0) {
                conditionSql.append(SqlBeanUtil.getCondition(common, where, args));
            } else if (where.indexOf("${") > -1 && bean != null) {
                conditionSql.append(SqlBeanUtil.getCondition(common, where, bean));
            } else {
                conditionSql.append(where);
            }
            conditionSql.append(")");
        } else {
            if (whereMap.size() > 0) {
                if (versionField != null && versionEffectiveness) {
                    conditionSql.append(versionConditionSql);
                }
                conditionSql.append("(");
                int i = 0;
                Collection sqlConditionEntryCollection = whereMap.entries();
                for (Map.Entry sqlConditionEntry : sqlConditionEntryCollection) {
                    ConditionInfo conditionInfo = (ConditionInfo)sqlConditionEntry.getValue();
                    if (i != 0 && i < sqlConditionEntryCollection.size()) {
                        conditionSql.append(SqlHelper.getLogic(conditionInfo.getSqlLogic()));
                    }
                    if (SqlBeanUtil.isToUpperCase(common)) {
                        conditionInfo.setName(conditionInfo.getName().toUpperCase());
                    }
                    conditionSql.append(SqlHelper.valueOperator(common, conditionInfo));
                    ++i;
                }
                conditionSql.append(")");
            }
            if (conditionSql.length() != 0) {
                conditionSql.insert(0, ConditionType.WHERE == conditionType ? " WHERE " : " HAVING ");
            }
        }
        return conditionSql.toString();
    }

    private static String getOperator(ConditionInfo conditionInfo) {
        String operator = "";
        if (conditionInfo.getSqlOperator() != null) {
            SqlOperator sqlOperator = conditionInfo.getSqlOperator();
            if (sqlOperator == SqlOperator.IS) {
                operator = " IS ";
            } else if (sqlOperator == SqlOperator.IS_NOT) {
                operator = " IS NOT ";
            } else if (sqlOperator == SqlOperator.IN) {
                operator = " IN (";
            } else if (sqlOperator == SqlOperator.NOT_IN) {
                operator = " NOT IN (";
            } else if (sqlOperator == SqlOperator.LIKE || sqlOperator == SqlOperator.LIKE_L || sqlOperator == SqlOperator.LIKE_R) {
                operator = " LIKE ";
            } else if (sqlOperator == SqlOperator.NOT_LIKE || sqlOperator == SqlOperator.NOT_LIKE_L || sqlOperator == SqlOperator.NOT_LIKE_R) {
                operator = " NOT LIKE ";
            } else if (sqlOperator == SqlOperator.BETWEEN) {
                operator = " BETWEEN ";
            } else if (sqlOperator == SqlOperator.GREATER_THAN) {
                operator = " > ";
            } else if (sqlOperator == SqlOperator.GREAT_THAN_OR_EQUAL_TO) {
                operator = " >= ";
            } else if (sqlOperator == SqlOperator.LESS_THAN) {
                operator = " < ";
            } else if (sqlOperator == SqlOperator.LESS_THAN_OR_EQUAL_TO) {
                operator = " <= ";
            } else if (sqlOperator == SqlOperator.EQUAL_TO) {
                operator = " = ";
            } else if (sqlOperator == SqlOperator.NOT_EQUAL_TO) {
                operator = " <> ";
            }
        } else {
            operator = " = ";
        }
        return operator;
    }

    private static String getLogic(SqlLogic sqlLogic) {
        String logic = null;
        if (sqlLogic != null && !"".equals((Object)sqlLogic)) {
            switch (sqlLogic) {
                case AND: {
                    logic = " AND ";
                    break;
                }
                case OR: {
                    logic = " OR ";
                    break;
                }
                case ORBracket: {
                    logic = ") OR (";
                    break;
                }
                case ANDBracket: {
                    logic = ") AND (";
                }
            }
        } else {
            logic = " AND ";
        }
        return logic;
    }

    private static StringBuffer valueOperator(Common common, ConditionInfo conditionInfo) {
        StringBuffer sql = new StringBuffer();
        String operator = SqlHelper.getOperator(conditionInfo);
        String transferred = SqlBeanUtil.getTransferred(common);
        boolean needEndBracket = false;
        Object[] betweenValues = null;
        Object value = conditionInfo.getValue();
        if (conditionInfo.getSqlOperator() == SqlOperator.BETWEEN) {
            betweenValues = SqlHelper.getObjects(value);
            if (betweenValues == null) {
                try {
                    throw new SqlBeanException("between \u6761\u4ef6\u7684\u503c\u5fc5\u987b\u4e3aArray\u6216ArrayList");
                }
                catch (SqlBeanException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        } else if (conditionInfo.getSqlOperator() == SqlOperator.IN || conditionInfo.getSqlOperator() == SqlOperator.NOT_IN) {
            needEndBracket = true;
            Object[] in_notInValues = SqlHelper.getObjects(value);
            if (in_notInValues == null) {
                in_notInValues = new Object[]{value};
            }
            StringBuffer in_notIn = new StringBuffer();
            if (in_notInValues != null && in_notInValues.length > 0) {
                for (int k = 0; k < in_notInValues.length; ++k) {
                    if (in_notInValues[k] instanceof Original) {
                        Original original = (Original)in_notInValues[k];
                        in_notIn.append(original.getValue());
                    } else {
                        in_notIn.append(SqlBeanUtil.getSqlValue(common, in_notInValues[k]));
                    }
                    in_notIn.append(", ");
                }
                in_notIn.deleteCharAt(in_notIn.length() - ", ".length());
                value = in_notIn.toString();
            }
        } else {
            value = conditionInfo.getValue();
            if (operator.indexOf(" LIKE ") > -1) {
                if (conditionInfo.getSqlOperator() == SqlOperator.LIKE || conditionInfo.getSqlOperator() == SqlOperator.LIKE_L || conditionInfo.getSqlOperator() == SqlOperator.NOT_LIKE || conditionInfo.getSqlOperator() == SqlOperator.NOT_LIKE_L) {
                    value = "%" + value;
                }
                if (conditionInfo.getSqlOperator() == SqlOperator.LIKE || conditionInfo.getSqlOperator() == SqlOperator.LIKE_R || conditionInfo.getSqlOperator() == SqlOperator.NOT_LIKE || conditionInfo.getSqlOperator() == SqlOperator.NOT_LIKE_R) {
                    value = value + "%";
                }
                value = "'" + value + "'";
            } else if (value instanceof Original) {
                Original original = (Original)conditionInfo.getValue();
                value = original.getValue();
            } else {
                value = SqlBeanUtil.getSqlValue(common, value);
            }
        }
        if (StringUtil.isNotEmpty(conditionInfo.getTableAlias())) {
            if (StringUtil.isNotEmpty(conditionInfo.getSchema())) {
                sql.append(conditionInfo.getSchema());
                sql.append(".");
            }
            sql.append(transferred);
            sql.append(conditionInfo.getTableAlias());
            sql.append(transferred);
            sql.append(".");
        }
        sql.append(conditionInfo.getName());
        sql.append(operator);
        if (conditionInfo.getSqlOperator() == SqlOperator.BETWEEN) {
            sql.append(SqlBeanUtil.getSqlValue(common, betweenValues[0]));
            sql.append(" AND ");
            sql.append(SqlBeanUtil.getSqlValue(common, betweenValues[1]));
        } else {
            sql.append(value);
        }
        if (needEndBracket) {
            sql.append(")");
        }
        return sql;
    }

    private static Object[] getObjects(Object value) {
        if (value == null) {
            return null;
        }
        Object[] objects = null;
        if (value.getClass().isArray()) {
            objects = (Object[])value;
        } else if (value instanceof Collection) {
            Collection list = (Collection)value;
            objects = list.toArray();
        }
        return objects;
    }

    private static void mysqlPageDispose(Select select, StringBuffer sqlSb) {
        if (SqlBeanUtil.isUsePage(select)) {
            Integer[] param = SqlHelper.pageParam(select);
            sqlSb.append(" LIMIT ");
            sqlSb.append(param[0]);
            sqlSb.append(", ");
            sqlSb.append(param[1]);
        }
    }

    private static void postgreSqlPageDispose(Select select, StringBuffer sqlSb) {
        if (SqlBeanUtil.isUsePage(select)) {
            Integer[] param = SqlHelper.pageParam(select);
            sqlSb.append(" LIMIT ");
            sqlSb.append(param[1]);
            sqlSb.append(" OFFSET ");
            sqlSb.append(param[0]);
        }
    }

    private static void oraclePageDispose(Select select, StringBuffer sqlSb) {
        if (SqlBeanUtil.isUsePage(select)) {
            Integer[] param = SqlHelper.pageParam(select);
            StringBuffer beginSqlSb = new StringBuffer();
            beginSqlSb.append("SELECT  *  FROM (");
            beginSqlSb.append("SELECT  TB . * ,  ROWNUM RN FROM (");
            sqlSb.insert(0, beginSqlSb);
            StringBuffer endSb = new StringBuffer();
            endSb.append(") TB  WHERE  ROWNUM  <= ");
            endSb.append(param[1]);
            endSb.append(") WHERE RN > ");
            endSb.append(param[0]);
            sqlSb.append(endSb);
        }
    }

    private static void db2PageDispose(Select select, StringBuffer sqlSb) {
        if (SqlBeanUtil.isUsePage(select)) {
            Integer[] param = SqlHelper.pageParam(select);
            StringBuffer beginSqlSb = new StringBuffer();
            beginSqlSb.append("SELECT  *  FROM (");
            beginSqlSb.append("SELECT  T. * ,  ROWNUMBER() ");
            beginSqlSb.append(" OVER ( ) AS RN FROM (");
            sqlSb.insert(0, beginSqlSb);
            StringBuffer endSb = new StringBuffer();
            endSb.append(") T ) TB  WHERE  TB .RN BETWEEN ");
            endSb.append(param[0]);
            endSb.append(" AND ");
            endSb.append(param[1]);
            sqlSb.append(endSb);
        }
    }

    private static void derbyPageDispose(Select select, StringBuffer sqlSb) {
        if (SqlBeanUtil.isUsePage(select)) {
            Integer[] param = SqlHelper.pageParam(select);
            sqlSb.append(" OFFSET ");
            sqlSb.append(param[0]);
            sqlSb.append(" ROWS FETCH NEXT ");
            sqlSb.append(param[1]);
            sqlSb.append(" ROWS ONLY");
        }
    }

    public static Integer[] pageParam(Select select) {
        Integer[] param;
        if (DbType.SQLServer2008 == select.getSqlBeanConfig().getDbType()) {
            int top = (select.getPage().getPagenum() + 1) * select.getPage().getPagesize();
            int begin = top - select.getPage().getPagesize();
            param = new Integer[]{top, begin};
        } else if (DbType.Oracle == select.getSqlBeanConfig().getDbType() || DbType.DB2 == select.getSqlBeanConfig().getDbType()) {
            int startIndex = select.getPage().getPagenum() * select.getPage().getPagesize();
            int endIndex = select.getPage().getPagenum() * select.getPage().getPagesize() + select.getPage().getPagesize();
            param = new Integer[]{startIndex, endIndex};
        } else {
            int limitOffset = select.getPage().getPagenum() * select.getPage().getPagesize();
            int limitAmount = select.getPage().getPagesize();
            param = new Integer[]{limitOffset, limitAmount};
        }
        return param;
    }
}

