/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.provider;

import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Order;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.SqlOperator;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;

public class SqlBeanProvider {
    public String selectByIdSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, Object id) {
        return this.selectByIdsSql(sqlBeanConfig, clazz, id);
    }

    public String selectByIdsSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, Object ... ids) {
        Field idField;
        Select select;
        try {
            select = this.newSelect(sqlBeanConfig, clazz, false);
            idField = SqlBeanUtil.getIdField(clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        if (ids.length > 1) {
            select.where(SqlBeanUtil.getTable(clazz).getAlias(), SqlBeanUtil.getTableFieldName(idField), (Object)ids, SqlOperator.IN);
        } else {
            select.where(SqlBeanUtil.getTable(clazz).getAlias(), SqlBeanUtil.getTableFieldName(idField), ids[0], SqlOperator.EQUAL_TO);
        }
        return SqlHelper.buildSelectSql(select);
    }

    public String selectByConditionSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, Paging paging, String where, Object ... args) {
        Select select = this.newSelect(sqlBeanConfig, clazz, false);
        select.setWhere(where, args);
        this.setPaging(select, paging, clazz);
        return SqlHelper.buildSelectSql(select);
    }

    public String selectCountByConditionSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, String where, Object[] args) {
        Select select = this.newSelect(sqlBeanConfig, clazz, true);
        select.setWhere(where, args);
        return SqlHelper.buildSelectSql(select);
    }

    public String selectAllSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, Paging paging) {
        Select select = this.newSelect(sqlBeanConfig, clazz, false);
        this.setPaging(select, paging, clazz);
        return SqlHelper.buildSelectSql(select);
    }

    public String selectSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, Select select) {
        if (select.getSqlBeanConfig() == null) {
            select.setSqlBeanConfig(sqlBeanConfig);
        }
        if (select.getColumnList().isEmpty()) {
            try {
                select.setColumnList(SqlBeanUtil.getSelectColumns(clazz, select.getFilterFields()));
                if (select.getPage() != null && select.getSqlBeanConfig().getDbType() == DbType.SQLServer2008) {
                    select.getPage().setIdName(SqlBeanUtil.getTableFieldName(SqlBeanUtil.getIdField(clazz)));
                }
            }
            catch (SqlBeanException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.setSelectAndBuild(clazz, select);
    }

    public String countSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, Select select) {
        if (select.getSqlBeanConfig() == null) {
            select.setSqlBeanConfig(sqlBeanConfig);
        }
        if (select.getColumnList() == null || select.getColumnList().isEmpty()) {
            select.column("COUNT( * )");
        }
        return this.setSelectAndBuild(clazz, select);
    }

    public String deleteByIdSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, Object id) {
        Field idField;
        if (StringUtil.isEmpty(id)) {
            try {
                throw new SqlBeanException("deleteByIdSql id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (SqlBeanException e) {
                e.printStackTrace();
                return null;
            }
        }
        Delete delete = new Delete();
        delete.setSqlBeanConfig(sqlBeanConfig);
        delete.setTable(clazz);
        try {
            idField = SqlBeanUtil.getIdField(clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        delete.where("", SqlBeanUtil.getTableFieldName(idField), id, SqlOperator.IN);
        return SqlHelper.buildDeleteSql(delete);
    }

    public String deleteByConditionSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, String where, Object[] args) {
        Delete delete = new Delete();
        delete.setSqlBeanConfig(sqlBeanConfig);
        delete.setTable(clazz);
        delete.setWhere(where, args);
        return SqlHelper.buildDeleteSql(delete);
    }

    public String deleteSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, Delete delete, boolean ignore) {
        if (delete.getSqlBeanConfig() == null) {
            delete.setSqlBeanConfig(sqlBeanConfig);
        }
        if (delete.getTable() == null || StringUtil.isEmpty(delete.getTable().getName())) {
            delete.setTable(clazz);
        }
        if (ignore || !delete.getWhereMap().isEmpty()) {
            return SqlHelper.buildDeleteSql(delete);
        }
        try {
            throw new SqlBeanException("\u8be5delete sql\u672a\u8bbe\u7f6ewhere\u6761\u4ef6\uff0c\u5982\u679c\u786e\u5b9e\u4e0d\u9700\u8981where\u6761\u4ef6\uff0c\u8bf7\u4f7f\u7528delete(Select select, boolean ignore)");
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String logicallyDeleteByIdSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, Object id) {
        Update update = new Update();
        update.setSqlBeanConfig(sqlBeanConfig);
        try {
            Object bean = this.newLogicallyDeleteBean(clazz);
            update.setUpdateBean(bean);
            Field idField = SqlBeanUtil.getIdField(bean.getClass());
            update.where(SqlBeanUtil.getTableFieldName(idField), id);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public String logicallyDeleteByConditionSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz, String where, Object[] args) {
        Update update = new Update();
        update.setSqlBeanConfig(sqlBeanConfig);
        try {
            update.setUpdateBean(this.newLogicallyDeleteBean(clazz));
            update.setWhere(where, args);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public String updateSql(SqlBeanConfig sqlBeanConfig, Update update, boolean ignore) {
        if (update.getSqlBeanConfig() == null) {
            update.setSqlBeanConfig(sqlBeanConfig);
        }
        if (ignore || !update.getWhereMap().isEmpty() || StringUtil.isNotEmpty(update.getWhere())) {
            return SqlHelper.buildUpdateSql(update);
        }
        try {
            throw new SqlBeanException("\u8be5update sql\u672a\u8bbe\u7f6ewhere\u6761\u4ef6\uff0c\u5982\u679c\u786e\u5b9e\u4e0d\u9700\u8981where\u6761\u4ef6\uff0c\u8bf7\u4f7f\u7528update(Select select, boolean ignore)");
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String updateByIdSql(SqlBeanConfig sqlBeanConfig, Object bean, Object id, boolean updateNotNull, String[] filterFields) {
        Field idField;
        if (StringUtil.isEmpty(id)) {
            try {
                throw new SqlBeanException("updateByIdSql id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (SqlBeanException e) {
                e.printStackTrace();
                return null;
            }
        }
        Update update = this.newUpdate(sqlBeanConfig, bean, updateNotNull);
        update.setFilterFields(filterFields);
        try {
            idField = SqlBeanUtil.getIdField(bean.getClass());
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        update.where(SqlBeanUtil.getTableFieldName(idField), id);
        return SqlHelper.buildUpdateSql(update);
    }

    public String updateByBeanIdSql(SqlBeanConfig sqlBeanConfig, Object bean, boolean updateNotNull, String[] filterFields) {
        Update update = this.newUpdate(sqlBeanConfig, bean, updateNotNull);
        update.setFilterFields(filterFields);
        try {
            Field idField = SqlBeanUtil.getIdField(bean.getClass());
            Object id = ReflectUtil.instance().get(bean.getClass(), bean, idField.getName());
            if (StringUtil.isEmpty(id)) {
                try {
                    throw new SqlBeanException("updateByBeanIdSql id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                catch (SqlBeanException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            update.where(SqlBeanUtil.getTableFieldName(idField), id);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public String updateByConditionSql(SqlBeanConfig sqlBeanConfig, Object bean, boolean updateNotNull, String[] filterFields, String where, Object[] args) {
        Update update = this.newUpdate(sqlBeanConfig, bean, updateNotNull);
        update.setFilterFields(filterFields);
        update.setWhere(where, args);
        return SqlHelper.buildUpdateSql(update);
    }

    public String updateByBeanConditionSql(SqlBeanConfig sqlBeanConfig, Object bean, boolean updateNotNull, String[] filterFields, String where) {
        Update update = this.newUpdate(sqlBeanConfig, bean, updateNotNull);
        update.setFilterFields(filterFields);
        update.setWhere(where, null);
        return SqlHelper.buildUpdateSql(update);
    }

    public String insertBeanSql(SqlBeanConfig sqlBeanConfig, Object bean) {
        Insert insert = new Insert();
        insert.setSqlBeanConfig(sqlBeanConfig);
        insert.setInsertBean(bean);
        return SqlHelper.buildInsertSql(insert);
    }

    public String insertSql(SqlBeanConfig sqlBeanConfig, Insert insert) {
        if (insert.getSqlBeanConfig() == null) {
            insert.setSqlBeanConfig(sqlBeanConfig);
        }
        return SqlHelper.buildInsertSql(insert);
    }

    public String dropTableSql(Class<?> clazz) {
        return "DROP TABLE IF EXISTS " + SqlBeanUtil.getTable(clazz).getName();
    }

    public String createTableSql(SqlBeanConfig sqlBeanConfig, Class<?> clazz) {
        Create create = new Create();
        create.setSqlBeanConfig(sqlBeanConfig);
        create.setBeanClass(clazz);
        return SqlHelper.buildCreateSql(create);
    }

    public String selectTableListSql(SqlBeanConfig sqlBeanConfig) {
        switch (sqlBeanConfig.getDbType()) {
            case MySQL: 
            case MariaDB: {
                return "select table_name as `name` from information_schema.tables where table_schema = database() and table_type = 'BASE TABLE'";
            }
            case SQLServer2008: {
                return "select name from sysobjects where xtype='U'";
            }
            case Oracle: {
                return "select table_name as \"name\" from user_tables";
            }
            case PostgreSQL: {
                return "select tablename as \"name\" from pg_tables where schemaname = 'public'";
            }
            case DB2: {
                return "select name from sysibm.systables where type = 'T' and creator = current user";
            }
            case H2: {
                return "select table_name as \"name\" from information_schema.tables where table_type = 'TABLE'";
            }
            case Hsql: {
                return "select table_name as \"name\" from information_schema.tables where table_type = 'BASE TABLE'";
            }
            case Derby: {
                return "select tablename as \"name\" from SYS.systables where tabletype = 'T'";
            }
            case SQLite: {
                return "select name from sqlite_master where type='table'";
            }
        }
        throw new SqlBeanException("\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u6570\u636e\u5e93");
    }

    private Select newSelect(SqlBeanConfig sqlBeanConfig, Class<?> clazz, boolean isCount) {
        Select select = new Select();
        select.setSqlBeanConfig(sqlBeanConfig);
        select.setTable(clazz);
        try {
            if (isCount) {
                select.column("COUNT( * )");
            } else {
                select.setColumnList(SqlBeanUtil.getSelectColumns(clazz, select.getFilterFields()));
            }
            SqlBeanUtil.setJoin(select, clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return select;
    }

    private String setSelectAndBuild(Class<?> clazz, Select select) {
        if (StringUtil.isEmpty(select.getTable().getName())) {
            Table table = SqlBeanUtil.getTable(clazz);
            select.getTable().setName(table.getName());
            if (StringUtil.isEmpty(select.getTable().getAlias())) {
                select.getTable().setAlias(table.getAlias());
            }
        }
        try {
            SqlBeanUtil.setJoin(select, clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        if (!select.getOrderBy().isEmpty()) {
            for (Order order : select.getOrderBy()) {
                if (!StringUtil.isEmpty(order.getTableAlias())) continue;
                order.setTableAlias(select.getTable().getAlias());
            }
        }
        return SqlHelper.buildSelectSql(select);
    }

    private Object newLogicallyDeleteBean(Class<?> clazz) throws SqlBeanException {
        Object bean = null;
        try {
            bean = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        Field field = SqlBeanUtil.getLogicallyField(clazz);
        ReflectUtil.instance().set(bean.getClass(), bean, field.getName(), true);
        return bean;
    }

    private Update newUpdate(SqlBeanConfig sqlBeanConfig, Object bean, boolean updateNotNull) {
        Update update = new Update();
        update.setSqlBeanConfig(sqlBeanConfig);
        update.setUpdateBean(bean);
        update.setUpdateNotNull(updateNotNull);
        return update;
    }

    private void setPaging(Select select, Paging paging, Class<?> clazz) {
        if (paging != null) {
            if (select.getSqlBeanConfig().getDbType() == DbType.SQLServer2008) {
                try {
                    select.setPage(SqlBeanUtil.getTableFieldName(SqlBeanUtil.getIdField(clazz)), paging.getPagenum(), paging.getPagesize());
                }
                catch (SqlBeanException e) {
                    e.printStackTrace();
                }
            } else {
                select.setPage(null, paging.getPagenum(), paging.getPagesize());
            }
            select.orderBy(paging.getOrders());
        }
    }
}

