/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.uitls;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlId;
import cn.vonce.sql.annotation.SqlJoin;
import cn.vonce.sql.annotation.SqlLogically;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.annotation.SqlUnion;
import cn.vonce.sql.annotation.SqlVersion;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.Common;
import cn.vonce.sql.bean.Join;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.JdbcType;
import cn.vonce.sql.enumerate.WhatType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.uitls.ReflectJdkUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SqlBeanUtil {
    public static SqlTable getSqlTable(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        SqlUnion sqlUnion = clazz.getAnnotation(SqlUnion.class);
        SqlTable sqlTable = sqlUnion != null ? clazz.getSuperclass().getAnnotation(SqlTable.class) : clazz.getAnnotation(SqlTable.class);
        return sqlTable;
    }

    public static Table getTable(Class<?> clazz) {
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
        String className = "";
        String schema = "";
        String tableName = "";
        String tableAlias = "";
        if (sqlTable != null) {
            schema = sqlTable.schema();
            tableName = sqlTable.value();
            tableAlias = sqlTable.alias();
        } else {
            tableAlias = tableName = className;
        }
        if (StringUtil.isEmpty(tableAlias)) {
            tableAlias = tableName;
        }
        return new Table(schema, tableName, tableAlias);
    }

    public static Table getTable(Class<?> clazz, SqlJoin sqlJoin) {
        Table table = new Table();
        if (sqlJoin != null) {
            table.setSchema(sqlJoin.schema());
            table.setName(sqlJoin.table());
            table.setAlias(sqlJoin.tableAlias());
        }
        Table classTable = SqlBeanUtil.getTable(clazz);
        if (StringUtil.isEmpty(table.getSchema())) {
            table.setSchema(classTable.getSchema());
        }
        if (StringUtil.isEmpty(table.getName())) {
            table.setName(classTable.getName());
        }
        if (StringUtil.isEmpty(table.getAlias())) {
            table.setAlias(classTable.getAlias());
        }
        if (StringUtil.isEmpty(table.getAlias())) {
            table.setAlias(classTable.getName());
        }
        return table;
    }

    public static String getTableName(Table table, Common common) {
        String schema = table.getSchema();
        String tableName = table.getName();
        if (StringUtil.isNotEmpty(schema)) {
            tableName = schema + "." + tableName;
        }
        return SqlBeanUtil.isToUpperCase(common) ? tableName.toUpperCase() : tableName;
    }

    public static String getTableFieldName(Field field) {
        SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
        String name = field.getName();
        if (sqlColumn != null) {
            name = sqlColumn.value();
        } else {
            SqlTable sqlTable = SqlBeanUtil.getSqlTable(field.getDeclaringClass());
            if (sqlTable != null && sqlTable.mapUsToCc()) {
                name = StringUtil.humpToUnderline(name);
            }
        }
        return name;
    }

    public static Field getIdField(Class<?> clazz) throws SqlBeanException {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        Field idField = null;
        int existId = 0;
        for (Field field : fieldList) {
            SqlId sqlBeanField = field.getAnnotation(SqlId.class);
            if (sqlBeanField != null) {
                idField = field;
                ++existId;
            }
            if (existId <= 1) continue;
            throw new SqlBeanException("\u8bf7\u6b63\u786e\u6807\u8bc6@SqlId\u6ce8\u89e3\uff0cid\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728'" + field.getDeclaringClass().getName() + "'\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
        }
        if (existId == 0) {
            throw new SqlBeanException("\u8bf7\u68c0\u67e5\u5b9e\u4f53\u7c7b\u7684id\u5b57\u6bb5\u662f\u5426\u6b63\u786e\u6807\u8bc6@SqlId\u6ce8\u89e3");
        }
        return idField;
    }

    public static Field getLogicallyField(Class<?> clazz) throws SqlBeanException {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        Field logicallyField = null;
        int existLogicallyField = 0;
        for (Field field : fieldList) {
            SqlLogically sqlLogically = field.getAnnotation(SqlLogically.class);
            if (sqlLogically != null) {
                logicallyField = field;
                ++existLogicallyField;
            }
            if (existLogicallyField <= 1) continue;
            throw new SqlBeanException("\u8bf7\u6b63\u786e\u6807\u8bc6@SqlLogically\u6ce8\u89e3\uff0c\u903b\u8f91\u5220\u9664\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728'" + field.getDeclaringClass().getName() + "'\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
        }
        if (existLogicallyField == 0) {
            throw new SqlBeanException("\u8bf7\u68c0\u67e5\u5b9e\u4f53\u7c7b\u7533\u660e\u903b\u8f91\u5220\u9664\u7684\u5b57\u6bb5\u662f\u5426\u6b63\u786e\u6807\u8bc6@SqlLogically\u6ce8\u89e3");
        }
        return logicallyField;
    }

    public static Field getVersionField(Class<?> clazz) throws SqlBeanException {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        Field versionField = null;
        int existVersionField = 0;
        for (Field field : fieldList) {
            SqlVersion sqlVersion = field.getAnnotation(SqlVersion.class);
            if (sqlVersion != null) {
                versionField = field;
                ++existVersionField;
            }
            if (existVersionField <= 1) continue;
            throw new SqlBeanException("\u8bf7\u6b63\u786e\u6807\u8bc6SqlVersion\u6ce8\u89e3\uff0cversion\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728'" + field.getDeclaringClass().getName() + "'\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
        }
        return versionField;
    }

    public static boolean isIgnore(Field field) {
        SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
        if (sqlColumn != null) {
            return sqlColumn.ignore();
        }
        return false;
    }

    public static boolean isFilter(String[] filterTableFields, String tableFieldName) {
        if (filterTableFields != null) {
            for (String filter : filterTableFields) {
                if (!tableFieldName.equals(filter)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean sqlBeanJoinIsNotEmpty(SqlJoin sqlJoin) {
        return SqlBeanUtil.joinIsNotEmpty(sqlJoin.table(), sqlJoin.tableKeyword(), sqlJoin.mainKeyword());
    }

    public static boolean joinIsNotEmpty(String table, String tableKeyword, String mainKeyword) {
        return table != null && !table.equals("") && tableKeyword != null && !tableKeyword.equals("") && mainKeyword != null && !mainKeyword.equals("");
    }

    public static List<Field> getBeanAllField(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        SqlUnion sqlUnion = clazz.getAnnotation(SqlUnion.class);
        if (sqlUnion != null) {
            fieldList.addAll(Arrays.asList(clazz.getSuperclass().getDeclaredFields()));
        }
        return fieldList;
    }

    public static Field getFieldByTableFieldName(List<Field> fieldList, String tableFieldName) {
        Field thisField = null;
        for (Field field : fieldList) {
            SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
            if (sqlColumn != null && sqlColumn.value().equals(tableFieldName)) {
                thisField = field;
                continue;
            }
            if (!field.getName().equals(tableFieldName)) continue;
            thisField = field;
        }
        return thisField;
    }

    public static List<Column> getSelectColumns(Class<?> clazz, String[] filterTableFields) throws SqlBeanException {
        if (clazz == null) {
            return null;
        }
        LinkedHashSet<Column> columnSet = new LinkedHashSet<Column>();
        Table table = SqlBeanUtil.getTable(clazz);
        String tableAlias = table.getAlias();
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        for (Field field : fieldList) {
            if (Modifier.isStatic(field.getModifiers()) || SqlBeanUtil.isIgnore(field) || SqlBeanUtil.isFilter(filterTableFields, SqlBeanUtil.getTableFieldName(field))) continue;
            SqlJoin sqlJoin = field.getAnnotation(SqlJoin.class);
            if (sqlJoin != null && sqlJoin.isBean()) {
                Class<?> subBeanClazz = field.getType();
                if (SqlBeanUtil.sqlBeanJoinIsNotEmpty(sqlJoin) && sqlJoin.value().length > 0 && !sqlJoin.value()[0].equals("")) {
                    List<Field> subBeanFieldList = SqlBeanUtil.getBeanAllField(subBeanClazz);
                    for (String fieldName : sqlJoin.value()) {
                        Field javaField = SqlBeanUtil.getFieldByTableFieldName(subBeanFieldList, fieldName);
                        if (javaField == null) {
                            throw new SqlBeanException("\u8be5\u7c7b\u7684\u8868\u8fde\u63a5\u67e5\u8be2\u5b57\u6bb5\u672a\u4e0ejava\u5b57\u6bb5\u5173\u8054\uff1a" + clazz.getName() + ">" + field.getName() + ">" + fieldName);
                        }
                        Table subTable = SqlBeanUtil.getTable(subBeanClazz, sqlJoin);
                        columnSet.add(new Column(sqlJoin.table(), fieldName, SqlBeanUtil.getColumnAlias(subTable.getAlias(), javaField.getName())));
                    }
                    continue;
                }
                Field[] subBeanFields = subBeanClazz.getDeclaredFields();
                Table subTable = SqlBeanUtil.getTable(subBeanClazz, sqlJoin);
                for (Field subBeanField : subBeanFields) {
                    if (Modifier.isStatic(subBeanField.getModifiers()) || SqlBeanUtil.isIgnore(field)) continue;
                    columnSet.add(new Column(subTable.getAlias(), SqlBeanUtil.getTableFieldName(subBeanField), SqlBeanUtil.getColumnAlias(subTable.getAlias(), subBeanField.getName())));
                }
                continue;
            }
            if (sqlJoin != null) {
                if (!SqlBeanUtil.sqlBeanJoinIsNotEmpty(sqlJoin)) continue;
                String tableFieldName = sqlJoin.value()[0];
                if (StringUtil.isEmpty(tableFieldName)) {
                    throw new SqlBeanException("\u8be5\u7c7b\u7684\u8868\u8fde\u63a5\u67e5\u8be2\u5b57\u6bb5\u672a\u4e0ejava\u5b57\u6bb5\u5173\u8054\uff1a");
                }
                String subTableAlias = StringUtil.isEmpty(sqlJoin.tableAlias()) ? sqlJoin.table() : sqlJoin.tableAlias();
                columnSet.add(new Column(subTableAlias, tableFieldName, SqlBeanUtil.getColumnAlias(subTableAlias, field.getName())));
                continue;
            }
            columnSet.add(new Column(tableAlias, SqlBeanUtil.getTableFieldName(field), SqlBeanUtil.getColumnAlias(tableAlias, field.getName())));
        }
        return new ArrayList<Column>(columnSet);
    }

    public static Map<String, Join> getJoin(Class<?> clazz) throws SqlBeanException {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        HashMap<String, Join> joinFieldMap = new HashMap<String, Join>();
        for (Field field : fieldList) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            SqlJoin sqlJoin = field.getAnnotation(SqlJoin.class);
            Join join = new Join();
            if (sqlJoin != null && SqlBeanUtil.sqlBeanJoinIsNotEmpty(sqlJoin)) {
                join.setJoinType(sqlJoin.type());
                join.setSchema(sqlJoin.schema());
                join.setTableName(sqlJoin.table());
                join.setTableAlias(StringUtil.isEmpty(sqlJoin.tableAlias()) ? sqlJoin.table() : sqlJoin.tableAlias());
                join.setTableKeyword(sqlJoin.tableKeyword());
                join.setMainKeyword(sqlJoin.mainKeyword());
                joinFieldMap.put(sqlJoin.table().toLowerCase() + sqlJoin.tableKeyword().toLowerCase() + sqlJoin.mainKeyword().toLowerCase(), join);
                continue;
            }
            if (sqlJoin == null || !sqlJoin.isBean()) continue;
            Class<?> subClazz = field.getType();
            Table table = SqlBeanUtil.getTable(subClazz, sqlJoin);
            String tableKeyword = SqlBeanUtil.getTableFieldName(SqlBeanUtil.getIdField(subClazz));
            join.setJoinType(sqlJoin.type());
            join.setSchema(table.getSchema());
            join.setTableName(table.getName());
            join.setTableAlias(table.getAlias());
            join.setTableKeyword(tableKeyword);
            join.setMainKeyword(sqlJoin.mainKeyword());
            joinFieldMap.put(join.getTableName().toLowerCase() + tableKeyword.toLowerCase() + sqlJoin.mainKeyword().toLowerCase(), join);
        }
        return joinFieldMap;
    }

    public static void setJoin(Select select, Class<?> clazz) throws SqlBeanException {
        Map<String, Join> joinFieldMap = SqlBeanUtil.getJoin(clazz);
        for (Join join : joinFieldMap.values()) {
            String schema = join.getSchema();
            String tableName = join.getTableName();
            String tableAlias = join.getTableAlias();
            String tableKeyword = join.getTableKeyword();
            String mainKeyword = join.getMainKeyword();
            select.join(join.getJoinType(), schema, tableName, tableAlias, tableKeyword, mainKeyword);
        }
    }

    public static String getColumnAlias(String tableAlias, String fieldName) {
        return tableAlias + "_" + fieldName;
    }

    public static String getTableFieldFullName(Common common, String schema, String tableAlias, String tableFieldName) {
        String transferred = SqlBeanUtil.getTransferred(common);
        StringBuffer fullName = new StringBuffer();
        if (StringUtil.isNotEmpty(schema)) {
            fullName.append(schema);
            fullName.append(".");
        }
        fullName.append(transferred);
        fullName.append(tableAlias);
        fullName.append(transferred);
        fullName.append(".");
        fullName.append(tableFieldName);
        return fullName.toString();
    }

    public static String getCondition(Common common, String where, Object[] args) {
        if (where == null || where.equals("")) {
            return "";
        }
        StringBuffer conditionSql = new StringBuffer();
        int index = 0;
        for (char c : where.toCharArray()) {
            if ('?' == c) {
                StringBuffer value = new StringBuffer();
                Object[] objects = null;
                objects = args[index] == null ? null : (args[index].getClass().isArray() ? (Object[])args[index] : (args[index] instanceof Collection ? ((Collection)args[index]).toArray() : new Object[]{args[index]}));
                if (objects != null) {
                    for (int i = 0; i < objects.length; ++i) {
                        value.append(SqlBeanUtil.getSqlValue(common, objects[i]));
                        value.append(", ");
                    }
                    value.delete(value.length() - ", ".length(), value.length());
                }
                conditionSql.append(value);
                ++index;
                continue;
            }
            if ('&' == c) {
                conditionSql.append(args[index]);
                ++index;
                continue;
            }
            conditionSql.append(c);
        }
        return conditionSql.toString();
    }

    public static String getCondition(Common common, String where, Object bean) {
        if (where == null || bean == null) {
            return "";
        }
        String prefix = "${";
        String suffix = "}";
        StringBuffer conditionSql = new StringBuffer(where);
        int startIndex = conditionSql.indexOf(prefix);
        while (startIndex != -1) {
            int endIndex = conditionSql.indexOf(suffix, startIndex + prefix.length());
            if (endIndex != -1) {
                String name = conditionSql.substring(startIndex + prefix.length(), endIndex);
                int nextIndex = endIndex + suffix.length();
                String value = SqlBeanUtil.getSqlValue(common, ReflectJdkUtil.instance().get(bean.getClass(), bean, name));
                conditionSql.replace(startIndex, endIndex + suffix.length(), value);
                nextIndex = startIndex + value.length();
                startIndex = conditionSql.indexOf(prefix, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return conditionSql.toString();
    }

    public static WhatType whatType(String typeName) {
        WhatType whatType;
        switch (typeName) {
            case "java.lang.String": 
            case "char": 
            case "java.lang.Character": {
                whatType = WhatType.STRING_TYPE;
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                whatType = WhatType.BOOL_TYPE;
                break;
            }
            case "byte": 
            case "java.lang.Byte": 
            case "short": 
            case "java.lang.Short": 
            case "int": 
            case "java.lang.Integer": 
            case "long": 
            case "java.lang.Long": 
            case "float": 
            case "java.lang.Float": 
            case "double": 
            case "java.lang.Double": {
                whatType = WhatType.VALUE_TYPE;
                break;
            }
            case "java.util.Date": 
            case "java.sql.Date": 
            case "java.sql.Timestamp": 
            case "java.sql.Time": {
                whatType = WhatType.DATE_TYPE;
                break;
            }
            default: {
                whatType = WhatType.OBJECT_TYPE;
            }
        }
        return whatType;
    }

    public static WhatType whatType(JdbcType jdbcType) {
        WhatType whatType;
        switch (jdbcType) {
            case CHAR: 
            case NCHAR: 
            case VARCHAR: 
            case VARCHAR2: 
            case NVARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case NTEXT: 
            case LONGTEXT: 
            case CLOB: 
            case NCLOB: {
                whatType = WhatType.STRING_TYPE;
                break;
            }
            case BIT: {
                whatType = WhatType.BOOL_TYPE;
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case NUMERIC: 
            case MONEY: 
            case SMALLMONEY: {
                whatType = WhatType.VALUE_TYPE;
                break;
            }
            case DATE: 
            case TIME: 
            case DATETIME: 
            case DATETIME2: 
            case TIMESTAMP: {
                whatType = WhatType.DATE_TYPE;
                break;
            }
            default: {
                whatType = WhatType.OBJECT_TYPE;
            }
        }
        return whatType;
    }

    public static boolean isBaseType(String typeName) {
        boolean isTrue;
        switch (typeName) {
            case "java.lang.String": 
            case "java.lang.Character": 
            case "java.lang.Boolean": 
            case "java.lang.Byte": 
            case "java.lang.Short": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Float": 
            case "java.lang.Double": 
            case "java.util.Date": 
            case "java.math.BigDecimal": {
                isTrue = true;
                break;
            }
            default: {
                isTrue = false;
            }
        }
        return isTrue;
    }

    public static boolean isMap(String typeName) {
        boolean isTrue;
        switch (typeName) {
            case "java.util.Map": 
            case "java.util.HashMap": {
                isTrue = true;
                break;
            }
            default: {
                isTrue = false;
            }
        }
        return isTrue;
    }

    public static String getSqlValue(Common common, Object value) {
        return SqlBeanUtil.getSqlValue(common, value, null);
    }

    public static String getSqlValue(Common common, Object value, JdbcType jdbcType) {
        String sqlValue;
        if (value == null) {
            return "NULL";
        }
        String single_quotation_mark = "'";
        WhatType whatType = jdbcType == null ? SqlBeanUtil.whatType(value.getClass().getName()) : SqlBeanUtil.whatType(jdbcType);
        block0 : switch (whatType) {
            case VALUE_TYPE: {
                sqlValue = value.toString();
                break;
            }
            case BOOL_TYPE: {
                if (jdbcType != null) {
                    sqlValue = (String)value;
                    break;
                }
                sqlValue = Boolean.parseBoolean(value.toString()) ? "1" : "0";
                break;
            }
            case DATE_TYPE: {
                String dateString;
                if (jdbcType != null) {
                    dateString = (String)value;
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    dateString = sdf.format(value);
                }
                switch (common.getSqlBeanDB().getDbType()) {
                    case Oracle: {
                        sqlValue = "to_timestamp(" + single_quotation_mark + dateString + single_quotation_mark + ", 'syyyy-mm-dd hh24:mi:ss.ff')";
                        break block0;
                    }
                }
                sqlValue = single_quotation_mark + dateString + single_quotation_mark;
                break;
            }
            default: {
                sqlValue = single_quotation_mark + SqlBeanUtil.filterSQLInject(value.toString()) + single_quotation_mark;
            }
        }
        return sqlValue;
    }

    public static boolean isCount(Select select) {
        boolean isTrue = true;
        if (select.getColumnList() != null && !select.getColumnList().contains("COUNT( * )")) {
            isTrue = false;
        }
        return isTrue;
    }

    public static boolean isUsePage(Select select) {
        return select.getPage() != null;
    }

    public static String filterSQLInject(String str) {
        return str.replaceAll("([';])+|(--)+", "");
    }

    public static String getTransferred(Common common) {
        String transferred = "\"";
        DbType dbType = common.getSqlBeanDB().getDbType();
        if (dbType == DbType.MySQL || dbType == DbType.MariaDB) {
            transferred = "`";
        }
        return transferred;
    }

    public static boolean isToUpperCase(Common common) {
        return common.getSqlBeanDB().getSqlBeanConfig().getToUpperCase() != null && common.getSqlBeanDB().getSqlBeanConfig().getToUpperCase() != false;
    }

    public static Object updateVersion(String typeName, Object value) {
        switch (typeName) {
            case "int": 
            case "java.lang.Integer": 
            case "long": 
            case "java.lang.Long": {
                long val = 0L;
                if (value != null) {
                    val = Long.parseLong(value.toString());
                }
                value = val + 1L;
                break;
            }
            case "java.util.Date": 
            case "java.sql.Timestamp": {
                value = new Date();
            }
        }
        return value;
    }

    public static boolean versionEffectiveness(String typeName) {
        switch (typeName) {
            case "int": 
            case "java.lang.Integer": 
            case "long": 
            case "java.lang.Long": 
            case "java.util.Date": 
            case "java.sql.Timestamp": {
                return true;
            }
        }
        return false;
    }

    public static Object[] getObjectArray(Object bean) {
        Object[] objects;
        if (bean.getClass().isArray()) {
            objects = (Object[])bean;
        } else if (bean instanceof Collection) {
            Collection list = (Collection)bean;
            objects = list.toArray();
        } else {
            objects = new Object[]{bean};
        }
        return objects;
    }
}

