/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.mapper;

import cn.vonce.sql.annotation.SqlJoin;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SqlBeanMapper {
    public Object baseHandleResultSet(ResultSet resultSet) {
        Object value = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            value = this.getValue(resultSetMetaData.getColumnTypeName(1), 1, resultSet);
            if (value == null || value.equals("null")) {
                value = SqlBeanMapper.getDefaultValueByColumnType(resultSetMetaData.getColumnTypeName(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return value;
    }

    public Object mapHandleResultSet(ResultSet resultSet) {
        HashMap<String, Object> map = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int columns = resultSetMetaData.getColumnCount();
            map = new HashMap<String, Object>();
            for (int i = 1; i <= columns; ++i) {
                Object value = this.getValue(resultSetMetaData.getColumnTypeName(i), i, resultSet);
                if (value == null || value.equals("null")) {
                    value = SqlBeanMapper.getDefaultValueByColumnType(resultSetMetaData.getColumnTypeName(i));
                }
                map.put(resultSetMetaData.getColumnLabel(i), value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    public Object beanHandleResultSet(Class<?> clazz, ResultSet resultSet, List<String> columnNameList) {
        Object bean = ReflectUtil.instance().newObject(clazz);
        String tableAlias = SqlBeanUtil.getTable(clazz).getAlias();
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        for (Field field : fieldList) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            SqlJoin sqlJoin = field.getAnnotation(SqlJoin.class);
            String fieldName = field.getName();
            if (sqlJoin != null) {
                if (sqlJoin.isBean()) {
                    Field[] subFields;
                    Class<?> subClazz = field.getType();
                    Object subBean = ReflectUtil.instance().newObject(subClazz);
                    String subTableAlias = SqlBeanUtil.getTable(subClazz).getAlias();
                    if (StringUtil.isNotEmpty(sqlJoin.table())) {
                        subTableAlias = sqlJoin.table();
                    }
                    if (StringUtil.isNotEmpty(sqlJoin.tableAlias())) {
                        subTableAlias = sqlJoin.tableAlias();
                    }
                    for (Field subField : subFields = subClazz.getDeclaredFields()) {
                        if (Modifier.isStatic(subField.getModifiers())) continue;
                        String subFieldName = subField.getName();
                        subFieldName = subTableAlias + "_" + subFieldName;
                        this.setFieldValue(subBean, subField, subFieldName, resultSet);
                    }
                    ReflectUtil.instance().set(bean.getClass(), bean, fieldName, subBean);
                    continue;
                }
                if (!columnNameList.contains(fieldName)) {
                    String subTableAlias = sqlJoin.table();
                    if (StringUtil.isNotEmpty(sqlJoin.tableAlias())) {
                        subTableAlias = sqlJoin.tableAlias();
                    }
                    fieldName = subTableAlias + "_" + fieldName;
                }
                if (!columnNameList.contains(fieldName)) continue;
                this.setFieldValue(bean, field, fieldName, resultSet);
                continue;
            }
            String newFieldName = tableAlias + "_" + fieldName;
            if (!(columnNameList.contains(newFieldName) || columnNameList.contains(newFieldName = StringUtil.humpToUnderline(fieldName)) || columnNameList.contains(newFieldName = newFieldName.toUpperCase()) || columnNameList.contains(newFieldName = fieldName))) {
                newFieldName = fieldName.toUpperCase();
            }
            if (!columnNameList.contains(newFieldName)) continue;
            this.setFieldValue(bean, field, newFieldName, resultSet);
        }
        return bean;
    }

    public List<String> getColumnNameList(ResultSet resultSet) {
        ArrayList<String> columnNameList = new ArrayList<String>();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int columns = resultSetMetaData.getColumnCount();
            if (columnNameList.size() == 0) {
                for (int i = 1; i <= columns; ++i) {
                    columnNameList.add(resultSetMetaData.getColumnLabel(i));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return columnNameList;
    }

    public void setFieldValue(Object obj, Field field, String fieldName, ResultSet resultSet) {
        Object value = this.getValue(field.getType().getName(), fieldName, resultSet);
        if (value == null || value.equals("null")) {
            value = SqlBeanMapper.getDefaultValue(field.getType().getName());
        }
        ReflectUtil.instance().set(obj.getClass(), obj, field.getName(), value);
    }

    public Object getValue(String fieldType, String fieldName, ResultSet resultSet) {
        Object value = null;
        try {
            switch (fieldType) {
                case "byte": {
                    value = resultSet.getByte(fieldName);
                    break;
                }
                case "java.lang.Byte": {
                    value = resultSet.getObject(fieldName);
                    if (value != null) {
                        value = resultSet.getByte(fieldName);
                    }
                    break;
                }
                case "short": {
                    value = resultSet.getShort(fieldName);
                    break;
                }
                case "java.lang.Short": {
                    value = resultSet.getObject(fieldName);
                    if (value != null) {
                        value = resultSet.getShort(fieldName);
                    }
                    break;
                }
                case "int": {
                    value = resultSet.getInt(fieldName);
                    break;
                }
                case "java.lang.Integer": {
                    value = resultSet.getObject(fieldName);
                    if (value != null) {
                        value = resultSet.getInt(fieldName);
                    }
                    break;
                }
                case "float": {
                    value = Float.valueOf(resultSet.getFloat(fieldName));
                    break;
                }
                case "java.lang.Float": {
                    value = resultSet.getObject(fieldName);
                    if (value != null) {
                        value = Float.valueOf(resultSet.getFloat(fieldName));
                    }
                    break;
                }
                case "double": {
                    value = resultSet.getDouble(fieldName);
                    break;
                }
                case "java.lang.Double": {
                    value = resultSet.getObject(fieldName);
                    if (value != null) {
                        value = resultSet.getDouble(fieldName);
                    }
                    break;
                }
                case "long": {
                    value = resultSet.getLong(fieldName);
                    break;
                }
                case "java.lang.Long": {
                    value = resultSet.getObject(fieldName);
                    if (value != null) {
                        value = resultSet.getLong(fieldName);
                    }
                    break;
                }
                case "boolean": {
                    value = resultSet.getBoolean(fieldName);
                    break;
                }
                case "java.lang.Boolean": {
                    value = resultSet.getObject(fieldName);
                    if (value != null) {
                        value = resultSet.getBoolean(fieldName);
                    }
                    break;
                }
                case "char": 
                case "java.lang.Character": {
                    value = resultSet.getString(fieldName);
                    if (StringUtil.isNotEmpty(value)) {
                        value = Character.valueOf(value.toString().charAt(0));
                    }
                    break;
                }
                case "java.lang.String": {
                    value = resultSet.getString(fieldName);
                    break;
                }
                case "java.sql.Date": {
                    value = resultSet.getDate(fieldName);
                    break;
                }
                case "java.sql.Time": {
                    value = resultSet.getTime(fieldName);
                    break;
                }
                case "java.util.Date": 
                case "java.sql.Timestamp": {
                    value = resultSet.getTimestamp(fieldName);
                    break;
                }
                case "java.math.BigDecimal": {
                    value = resultSet.getBigDecimal(fieldName);
                    break;
                }
                default: {
                    value = resultSet.getObject(fieldName);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value;
    }

    public Object getValue(String jdbcType, int index, ResultSet resultSet) {
        Object value = null;
        try {
            switch (jdbcType) {
                case "TINYINT": {
                    value = resultSet.getByte(index);
                    break;
                }
                case "SMALLINT": {
                    value = resultSet.getShort(index);
                    break;
                }
                case "INTEGER": {
                    value = resultSet.getInt(index);
                    break;
                }
                case "BIGINT": {
                    value = resultSet.getLong(index);
                    break;
                }
                case "REAL": {
                    value = Float.valueOf(resultSet.getFloat(index));
                    break;
                }
                case "FLOAT": 
                case "DOUBLE": {
                    value = resultSet.getDouble(index);
                    break;
                }
                case "BIT": 
                case "BOOLEAN": {
                    value = resultSet.getBoolean(index);
                    break;
                }
                case "CHAR": 
                case "VARCHAR": 
                case "LONGVARCHAR": {
                    value = resultSet.getString(index);
                    break;
                }
                case "NUMERIC": 
                case "DECIMAL": {
                    value = resultSet.getBigDecimal(index);
                    break;
                }
                default: {
                    value = resultSet.getObject(index);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value;
    }

    public static Object getDefaultValue(String typeName) {
        Constable value = null;
        switch (typeName) {
            case "byte": {
                value = new Byte("0");
                break;
            }
            case "short": {
                value = new Short("0");
                break;
            }
            case "int": {
                value = 0;
                break;
            }
            case "long": {
                value = 0L;
                break;
            }
            case "float": {
                value = Float.valueOf(0.0f);
                break;
            }
            case "double": {
                value = 0.0;
                break;
            }
            case "char": {
                value = Character.valueOf('\u0000');
                break;
            }
            case "boolean": {
                value = Boolean.valueOf(false);
            }
        }
        return value;
    }

    public static Object getDefaultValueByColumnType(String typeName) {
        Constable value = null;
        switch (typeName) {
            case "BIGINT": 
            case "INTEGER": 
            case "TINYINT": 
            case "SMALLINT": {
                value = 0;
                break;
            }
            case "FLOAT": {
                value = Float.valueOf(0.0f);
                break;
            }
            case "DOUBLE": 
            case "NUMERIC": {
                value = 0.0;
                break;
            }
            case "BIT": {
                value = Boolean.valueOf(false);
                break;
            }
            case "CHAR": 
            case "VARCHAR": 
            case "LONGVARCHAR": {
                value = null;
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public static Object getValueConvert(String typeName, Object value) {
        Object newValue = value;
        switch (typeName) {
            case "byte": 
            case "java.lang.Byte": {
                newValue = new Byte(value.toString());
                break;
            }
            case "short": 
            case "java.lang.Short": {
                newValue = new Short(value.toString());
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                newValue = new Integer(value.toString());
                break;
            }
            case "long": 
            case "java.lang.Long": {
                newValue = new Long(value.toString());
                break;
            }
            case "float": 
            case "java.lang.Float": {
                newValue = new Float(value.toString());
                break;
            }
            case "double": 
            case "java.lang.Double": {
                newValue = new Double(value.toString());
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                newValue = new Boolean(value.toString());
                break;
            }
            case "char": 
            case "java.lang.Character": {
                newValue = Character.valueOf(value.toString().charAt(0));
                break;
            }
            case "java.lang.String": {
                newValue = value.toString();
            }
        }
        return newValue;
    }
}

