/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.uitls;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static String getInterval(String createTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date date = sdf.parse(createTime, pos);
        return DateUtil.getInterval(date);
    }

    public static String getInterval(Date date) {
        String interval = null;
        long time = (new Date().getTime() - date.getTime()) / 1000L;
        interval = time > 0L && time < 60L ? time + "\u79d2\u524d" : (time > 60L && time < 3600L ? time / 60L + "\u5206\u949f\u524d" : (time >= 3600L && time < 86400L ? time / 3600L + "\u5c0f\u65f6\u524d" : (time >= 86400L && time < 172800L ? "\u6628\u5929" : (time >= 172800L && time < 259200L ? "\u524d\u5929" : DateUtil.dateToString(date, "yyyy-MM-dd HH:mm")))));
        return interval;
    }

    public static String dateToString(Date date) {
        if (date != null) {
            return DateUtil.dateToString(date, "yyyy-MM-dd HH:mm:ss");
        }
        return "";
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date != null) {
            return sdf.format(date);
        }
        return "";
    }

    public static Date stringToDate(String createTime) {
        return DateUtil.stringToDate(createTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date stringToDate(String createTime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        ParsePosition pos = new ParsePosition(0);
        return sdf.parse(createTime, pos);
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }
}

