/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.enumerate;

import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.uitls.StringUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public enum JavaMapDerbyType {
    INTEGER(new Class[]{Integer.TYPE, Integer.class}),
    BIGINT(new Class[]{Long.TYPE, Long.class}),
    SMALLINT(new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Boolean.TYPE, Boolean.class}),
    FLOAT(new Class[]{Float.TYPE, Float.class}),
    DOUBLE(new Class[]{Double.TYPE, Double.class}),
    NUMERIC(new Class[]{BigDecimal.class}),
    CHAR(new Class[]{Character.TYPE, Character.class}),
    VARCHAR(new Class[]{String.class}),
    DATE(new Class[]{java.sql.Date.class}),
    TIME(new Class[]{Time.class}),
    TIMESTAMP(new Class[]{Timestamp.class, Date.class}),
    CLOB(new Class[]{Clob.class}),
    BLOB(new Class[]{Blob.class, Object.class});

    private Class<?>[] classes;

    private JavaMapDerbyType(Class<?>[] classes) {
        this.classes = classes;
    }

    public static JavaMapDerbyType getType(Class<?> clazz) {
        for (JavaMapDerbyType javaType : JavaMapDerbyType.values()) {
            for (Class<?> thisClazz : javaType.classes) {
                if (thisClazz != clazz) continue;
                return javaType;
            }
        }
        return null;
    }

    public static String getTypeName(Class<?> clazz) {
        return JavaMapDerbyType.getType(clazz).name();
    }

    public static String getTableListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT tb.TABLENAME AS \"name\", sc.SCHEMANAME AS \"schema\" ");
        sql.append("FROM SYS.SYSTABLES tb ");
        sql.append("INNER JOIN SYS.SYSSCHEMAS sc ");
        sql.append("ON sc.SCHEMAID = tb.SCHEMAID ");
        sql.append("WHERE TABLETYPE = 'T' AND sc.SCHEMANAME = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("'SA'");
        }
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND tablename = '" + tableName + "'");
        }
        return sql.toString();
    }

    public static String getColumnListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT cl.COLUMNNUMBER AS cid, cl.COLUMNNAME AS name, cl.COLUMNDATATYPE AS type, cl.COLUMNDEFAULT AS dflt_value, ");
        sql.append("(CASE WHEN cl.COLUMNNUMBER = 1 THEN '1' ELSE '0' END) AS pk, 0 AS pk ");
        sql.append("FROM SYS.SYSTABLES AS tb ");
        sql.append("INNER JOIN SYS.SYSCOLUMNS cl ");
        sql.append("ON cl.REFERENCEID = tb.TABLEID ");
        sql.append("INNER JOIN SYS.SYSSCHEMAS sc ");
        sql.append("ON sc.SCHEMAID = tb.SCHEMAID ");
        sql.append("WHERE sc.SCHEMANAME = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("'SA'");
        }
        sql.append(" AND tb.TABLENAME = '");
        sql.append(tableName);
        sql.append("' ORDER BY cl.COLUMNNUMBER");
        return sql.toString();
    }
}

