/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.uitls;

import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    private static final String UNDERLINE = "_";
    private static final String HYPHEN = "-";

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static boolean isNotEmpty(Object str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isBlank(Object str) {
        if (StringUtil.isEmpty(str)) {
            return true;
        }
        if (str instanceof CharSequence) {
            int strLen;
            CharSequence cs = (CharSequence)str;
            if (cs != null && (strLen = cs.length()) != 0) {
                for (int i = 0; i < strLen; ++i) {
                    if (Character.isWhitespace(cs.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean isNotBlank(Object str) {
        return !StringUtil.isBlank(str);
    }

    public static String getUUid() {
        return UUID.randomUUID().toString().replace(HYPHEN, "");
    }

    public static String randomCode(int length) {
        String base = "1234567890";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String resolvePlaceholders(String text, Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text);
        int startIndex = buf.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                int nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                try {
                    String propVal = params.get(placeholder);
                    if (propVal != null) {
                        buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                        nextIndex = startIndex + propVal.length();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    public static String underlineToHump(String para) {
        StringBuilder result = new StringBuilder();
        String[] a = para.split(UNDERLINE);
        if (a.length == 1) {
            return a[0];
        }
        for (String s : a) {
            if (!para.contains(UNDERLINE)) {
                result.append(s.toLowerCase());
                continue;
            }
            if (StringUtil.isEmpty(s)) continue;
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String humpToUnderline(String hump) {
        return StringUtil.humpTo(hump, UNDERLINE);
    }

    public static String humpToHyphen(String hump) {
        return StringUtil.humpTo(hump, HYPHEN);
    }

    public static String humpTo(String hump, String symbol) {
        StringBuilder sb = new StringBuilder(hump);
        int temp = 0;
        if (!hump.contains(symbol)) {
            for (int i = 0; i < hump.length(); ++i) {
                if (!Character.isUpperCase(hump.charAt(i)) || i - 1 < 0 || !Character.isLowerCase(hump.charAt(i - 1))) continue;
                sb.insert(i + temp, symbol);
                ++temp;
            }
        }
        return sb.toString().toLowerCase();
    }

    public static String getBracketContent(String content) {
        String[] arr = new String[]{};
        Pattern p = Pattern.compile("(?<=\\()[^\\)]+");
        Matcher m = p.matcher(content);
        while (m.find()) {
            arr = Arrays.copyOf(arr, arr.length + 1);
            arr[arr.length - 1] = m.group();
        }
        return arr.length == 0 ? "" : arr[0];
    }

    public static String getWord(String content) {
        return content.replaceAll("[\\[][^\\[\\]]+[\\]]|[\\(][^\\(\\)]+[\\)]", "");
    }
}

