/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.helper;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlDefaultValue;
import cn.vonce.sql.annotation.SqlId;
import cn.vonce.sql.annotation.SqlLogically;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.annotation.SqlVersion;
import cn.vonce.sql.bean.Backup;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.Common;
import cn.vonce.sql.bean.CommonCondition;
import cn.vonce.sql.bean.Condition;
import cn.vonce.sql.bean.ConditionData;
import cn.vonce.sql.bean.ConditionInfo;
import cn.vonce.sql.bean.Copy;
import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Drop;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Join;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.SetInfo;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.define.SqlFun;
import cn.vonce.sql.enumerate.ConditionType;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.FillWith;
import cn.vonce.sql.enumerate.IdType;
import cn.vonce.sql.enumerate.SqlLogic;
import cn.vonce.sql.enumerate.SqlOperator;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.Cond;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class SqlHelper {
    public static String buildSelectSql(Select select) {
        SqlBeanUtil.check(select);
        StringBuffer sqlSb = new StringBuffer();
        Integer[] pageParam = null;
        String orderSql = SqlHelper.orderBySql(select);
        if (select.getSqlBeanDB().getDbType() == DbType.SQLServer && SqlBeanUtil.isUsePage(select)) {
            pageParam = SqlHelper.pageParam(select);
            sqlSb.append("SELECT ");
            sqlSb.append(" * ");
            sqlSb.append(" FROM ");
            sqlSb.append("(");
        }
        sqlSb.append(select.isDistinct() ? "SELECT DISTINCT " : "SELECT ");
        if (select.getSqlBeanDB().getDbType() == DbType.SQLServer && SqlBeanUtil.isUsePage(select)) {
            sqlSb.append(" TOP ");
            sqlSb.append(pageParam[0]);
            sqlSb.append(" ROW_NUMBER()  OVER (" + orderSql + ")" + " ROWNUM " + ", ");
        }
        if (select.isCount() && !select.isDistinct()) {
            sqlSb.append("COUNT( * )");
        } else {
            sqlSb.append(SqlHelper.column(select));
        }
        sqlSb.append(" FROM ");
        sqlSb.append(SqlBeanUtil.fromFullName(select.getTable().getSchema(), select.getTable().getName(), select.getTable().getAlias(), select));
        sqlSb.append(SqlHelper.joinSql(select));
        sqlSb.append(SqlHelper.whereSql(select, null));
        String groupBySql = SqlHelper.groupBySql(select);
        sqlSb.append(groupBySql);
        sqlSb.append(SqlHelper.havingSql(select));
        if (!select.isCount()) {
            sqlSb.append(orderSql);
        }
        if (select.getSqlBeanDB().getDbType() == DbType.SQLServer && SqlBeanUtil.isUsePage(select)) {
            sqlSb.append(")");
            sqlSb.append(" T");
            sqlSb.append(" WHERE ");
            sqlSb.append(" T. ROWNUM ");
            sqlSb.append(" > ");
            sqlSb.append(pageParam[1]);
        }
        if (select.isCount() && select.isDistinct() || select.isCount() && StringUtil.isNotEmpty(groupBySql)) {
            sqlSb.insert(0, "SELECT COUNT( * ) FROM (");
            sqlSb.append(") AS  T");
        }
        if (select.getSqlBeanDB().getDbType() == DbType.MySQL || select.getSqlBeanDB().getDbType() == DbType.MariaDB || select.getSqlBeanDB().getDbType() == DbType.H2) {
            SqlHelper.mysqlPageDispose(select, sqlSb);
        } else if (select.getSqlBeanDB().getDbType() == DbType.Postgresql || select.getSqlBeanDB().getDbType() == DbType.SQLite || select.getSqlBeanDB().getDbType() == DbType.Hsql) {
            SqlHelper.PostgresqlPageDispose(select, sqlSb);
        } else if (select.getSqlBeanDB().getDbType() == DbType.Oracle) {
            SqlHelper.oraclePageDispose(select, sqlSb);
        } else if (select.getSqlBeanDB().getDbType() == DbType.DB2) {
            SqlHelper.db2PageDispose(select, sqlSb);
        } else if (select.getSqlBeanDB().getDbType() == DbType.Derby) {
            SqlHelper.derbyPageDispose(select, sqlSb);
        }
        return sqlSb.toString();
    }

    public static String buildUpdateSql(Update update) {
        SqlBeanUtil.check(update);
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("UPDATE ");
        if (update.getSqlBeanDB().getDbType() == DbType.H2 || update.getSqlBeanDB().getDbType() == DbType.Oracle) {
            sqlSb.append(SqlBeanUtil.fromFullName(update.getTable().getSchema(), update.getTable().getName(), update.getTable().getAlias(), update));
        } else {
            sqlSb.append(SqlHelper.getTableName(update.getTable(), update));
        }
        sqlSb.append(" SET ");
        sqlSb.append(SqlHelper.setSql(update));
        sqlSb.append(SqlHelper.whereSql(update, update.getUpdateBean()));
        return sqlSb.toString();
    }

    public static String buildInsertSql(Insert insert) {
        SqlBeanUtil.check(insert);
        String sql = null;
        try {
            sql = SqlHelper.fieldAndValuesSql(insert, insert.getInsertBean());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return sql;
    }

    public static String buildDeleteSql(Delete delete) {
        SqlBeanUtil.check(delete);
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("DELETE FROM ");
        if (delete.getSqlBeanDB().getDbType() == DbType.H2 || delete.getSqlBeanDB().getDbType() == DbType.Oracle) {
            sqlSb.append(SqlBeanUtil.fromFullName(delete.getTable().getSchema(), delete.getTable().getName(), delete.getTable().getAlias(), delete));
        } else {
            sqlSb.append(SqlHelper.getTableName(delete.getTable(), delete));
        }
        sqlSb.append(SqlHelper.whereSql(delete, null));
        return sqlSb.toString();
    }

    public static String buildCreateSql(Create create) {
        SqlBeanUtil.check(create);
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("CREATE TABLE ");
        sqlSb.append(SqlHelper.getTableName(create.getTable(), create));
        sqlSb.append("(");
        Field idField = null;
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(create.getBeanClass());
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(create.getBeanClass());
        DbType dbType = create.getSqlBeanDB().getDbType();
        for (int i = 0; i < fieldList.size(); ++i) {
            if (SqlBeanUtil.isIgnore(fieldList.get(i))) continue;
            if (idField == null && fieldList.get(i).getAnnotation(SqlId.class) != null) {
                idField = fieldList.get(i);
            }
            SqlColumn sqlColumn = fieldList.get(i).getAnnotation(SqlColumn.class);
            sqlSb.append(SqlBeanUtil.addColumn(create, SqlBeanUtil.getColumnInfo(create.getSqlBeanDB(), fieldList.get(i), sqlTable, sqlColumn), null));
            sqlSb.append(", ");
        }
        if (idField != null) {
            String idFieldName = SqlBeanUtil.getTableFieldName(create, idField, sqlTable);
            sqlSb.append("PRIMARY KEY");
            sqlSb.append("(");
            sqlSb.append(idFieldName);
            sqlSb.append(")");
        } else {
            sqlSb.deleteCharAt(sqlSb.length() - ", ".length());
        }
        sqlSb.append(")");
        if (sqlTable != null && StringUtil.isNotBlank(sqlTable.remarks()) && (dbType == DbType.MySQL || dbType == DbType.MariaDB)) {
            sqlSb.append(" ");
            sqlSb.append("COMMENT");
            sqlSb.append(" = ");
            sqlSb.append("'");
            sqlSb.append(sqlTable.remarks());
            sqlSb.append("'");
        }
        return sqlSb.toString();
    }

    public static String buildBackup(Backup backup) {
        SqlBeanUtil.check(backup);
        String targetSchema = backup.getTargetSchema();
        if (StringUtil.isEmpty(targetSchema)) {
            targetSchema = backup.getTable().getSchema();
        }
        StringBuffer backupSql = new StringBuffer();
        if (DbType.SQLServer != backup.getSqlBeanDB().getDbType() && DbType.Postgresql != backup.getSqlBeanDB().getDbType()) {
            backupSql.append("CREATE TABLE ");
            backupSql.append(SqlHelper.getTableName(targetSchema, backup.getTargetTableName()));
            backupSql.append(" ");
            backupSql.append(" AS ");
        }
        backupSql.append("SELECT ");
        if (backup.getColumns() != null && backup.getColumns().length > 0) {
            for (Column column : backup.getColumns()) {
                backupSql.append(column.getName());
                backupSql.append(", ");
            }
            backupSql.delete(backupSql.length() - ", ".length(), backupSql.length());
        } else {
            backupSql.append(" * ");
        }
        if (DbType.SQLServer == backup.getSqlBeanDB().getDbType() || DbType.Postgresql == backup.getSqlBeanDB().getDbType()) {
            backupSql.append(" INTO ");
            backupSql.append(SqlHelper.getTableName(targetSchema, backup.getTargetTableName()));
        }
        backupSql.append(" FROM ");
        backupSql.append(SqlHelper.getTableName(backup.getTable(), backup));
        if (DbType.Derby == backup.getSqlBeanDB().getDbType()) {
            backupSql.append(" WITH NO DATA");
        } else {
            backupSql.append(SqlHelper.whereSql(backup, null));
        }
        return backupSql.toString();
    }

    public static String buildCopy(Copy copy) {
        SqlBeanUtil.check(copy);
        String targetSchema = copy.getTargetSchema();
        if (StringUtil.isEmpty(targetSchema)) {
            targetSchema = copy.getTable().getSchema();
        }
        StringBuffer copySql = new StringBuffer();
        StringBuffer columnSql = new StringBuffer();
        copySql.append("INSERT INTO ");
        copySql.append(SqlHelper.getTableName(copy.getTable(), copy));
        if (copy.getColumns() != null && copy.getColumns().length > 0) {
            for (Column column : copy.getColumns()) {
                columnSql.append(column.getName());
                columnSql.append(", ");
            }
            columnSql.delete(columnSql.length() - ", ".length(), columnSql.length());
            copySql.append(" ");
            copySql.append("(");
            copySql.append(columnSql);
            copySql.append(")");
        }
        copySql.append(" ");
        copySql.append("SELECT ");
        if (copy.getTargetColumns() != null && copy.getTargetColumns().length > 0) {
            StringBuffer targetColumnSql = new StringBuffer();
            for (Column column : copy.getTargetColumns()) {
                targetColumnSql.append(column.getName());
                targetColumnSql.append(", ");
            }
            targetColumnSql.delete(targetColumnSql.length() - ", ".length(), targetColumnSql.length());
            copySql.append(targetColumnSql);
        } else if (copy.getTargetColumns() != null && copy.getTargetColumns().length > 0) {
            copySql.append(columnSql);
        } else {
            copySql.append(" * ");
        }
        copySql.append(" FROM ");
        copySql.append(SqlHelper.getTableName(targetSchema, copy.getTargetTableName()));
        copySql.append(SqlHelper.whereSql(copy, null));
        return copySql.toString();
    }

    public static String buildDrop(Drop drop) {
        StringBuffer dropSql = new StringBuffer();
        String tableName = SqlHelper.getTableName(drop.getTable(), drop);
        if (drop.getSqlBeanDB().getDbType() == DbType.MySQL || drop.getSqlBeanDB().getDbType() == DbType.MariaDB || drop.getSqlBeanDB().getDbType() == DbType.Postgresql || drop.getSqlBeanDB().getDbType() == DbType.H2) {
            dropSql.append("DROP TABLE IF EXISTS ");
            dropSql.append(tableName);
        } else if (drop.getSqlBeanDB().getDbType() == DbType.MySQL) {
            dropSql.append("IF OBJECT_ID(N'" + tableName + "', N'U') IS NOT NULL ");
            dropSql.append("DROP TABLE " + tableName + " ");
        } else {
            dropSql.append("DROP TABLE ");
            dropSql.append(tableName);
        }
        return dropSql.toString();
    }

    private static String getTableName(Table table, Common common) {
        String tableName = SqlHelper.getTableName(table.getSchema(), table.getName());
        return SqlBeanUtil.isToUpperCase(common) ? tableName.toUpperCase() : tableName;
    }

    private static String getTableName(String schema, String tableName) {
        if (StringUtil.isNotEmpty(schema)) {
            tableName = schema + "." + tableName;
        }
        return tableName;
    }

    private static String column(Select select) {
        StringBuffer columnSql = new StringBuffer();
        if (select.getColumnList() != null && select.getColumnList().size() != 0) {
            for (int i = 0; i < select.getColumnList().size(); ++i) {
                String columnName;
                Column column = select.getColumnList().get(i);
                String tableAlias = null;
                if (column instanceof SqlFun) {
                    columnName = SqlBeanUtil.getSqlFunction(select, (SqlFun)column);
                } else {
                    tableAlias = select.getColumnList().get(i).getTableAlias();
                    columnName = select.getColumnList().get(i).getName();
                    if (SqlBeanUtil.isToUpperCase(select)) {
                        columnName = columnName.toUpperCase();
                    }
                }
                String transferred = SqlBeanUtil.getTransferred(select);
                boolean existAlias = StringUtil.isNotEmpty(column.getAlias());
                if (existAlias) {
                    columnSql.append("(");
                }
                if (StringUtil.isNotEmpty(tableAlias)) {
                    columnSql.append(SqlBeanUtil.getTableFieldFullName(select, tableAlias, columnName));
                } else {
                    columnSql.append(columnName);
                }
                if (existAlias) {
                    columnSql.append(")");
                    columnSql.append(" AS ");
                    columnSql.append(transferred);
                    columnSql.append(select.getColumnList().get(i).getAlias());
                    columnSql.append(transferred);
                }
                columnSql.append(", ");
            }
            columnSql.deleteCharAt(columnSql.length() - ", ".length());
        }
        return columnSql.toString();
    }

    private static String joinSql(Select select) {
        StringBuffer joinSql = new StringBuffer();
        if (select != null && select.getJoin().size() != 0) {
            for (int i = 0; i < select.getJoin().size(); ++i) {
                Join join = select.getJoin().get(i);
                switch (join.getJoinType()) {
                    case INNER_JOIN: {
                        joinSql.append(" INNER JOIN ");
                        break;
                    }
                    case LEFT_JOIN: {
                        joinSql.append(" LEFT JOIN ");
                        break;
                    }
                    case RIGHT_JOIN: {
                        joinSql.append(" RIGHT JOIN ");
                        break;
                    }
                    case FULL_JOIN: {
                        joinSql.append(" FULL JOIN ");
                    }
                }
                String schema = join.getSchema();
                String tableName = join.getTableName();
                String tableAlias = join.getTableAlias();
                joinSql.append(SqlBeanUtil.fromFullName(schema, tableName, tableAlias, select));
                joinSql.append(" ON ");
                if (join.on() != null && join.on().getDataList().size() > 0) {
                    joinSql.append(SqlHelper.simpleConditionHandle(select, join.on().getDataList()));
                    continue;
                }
                String tableKeyword = SqlBeanUtil.getTableFieldFullName(select, tableAlias, join.getTableKeyword());
                String mainKeyword = SqlBeanUtil.getTableFieldFullName(select, select.getTable().getAlias(), join.getMainKeyword());
                if (StringUtil.isNotEmpty(join.getOn())) {
                    joinSql.append(join.getOn());
                } else {
                    joinSql.append(tableKeyword);
                    joinSql.append(" = ");
                    joinSql.append(mainKeyword);
                }
                if (i >= select.getJoin().size() - 1) continue;
                joinSql.append(" ");
            }
        }
        return joinSql.toString();
    }

    private static String fieldAndValuesSql(Common common, List objectList) throws IllegalArgumentException {
        int k;
        String tableName = SqlHelper.getTableName(common.getTable(), common);
        StringBuffer fieldSql = new StringBuffer();
        StringBuffer valueSql = new StringBuffer();
        StringBuffer fieldAndValuesSql = new StringBuffer();
        ArrayList<String> valueSqlList = new ArrayList<String>();
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(objectList.get(0).getClass());
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(objectList.get(0).getClass());
        if (common.getSqlBeanDB().getDbType() == DbType.Oracle) {
            if (objectList != null && objectList.size() > 1) {
                fieldAndValuesSql.append("INSERT ALL INTO ");
            } else {
                fieldAndValuesSql.append("INSERT INTO ");
            }
        } else {
            fieldAndValuesSql.append("INSERT INTO ");
        }
        for (int i = 0; i < objectList.size(); ++i) {
            valueSql.delete(0, valueSql.length());
            if (i == 0) {
                fieldSql.append("(");
            }
            valueSql.append("(");
            int existId = 0;
            for (Field field : fieldList) {
                if (SqlBeanUtil.isIgnore(field)) continue;
                SqlId sqlId = field.getAnnotation(SqlId.class);
                SqlDefaultValue sqlDefaultValue = field.getAnnotation(SqlDefaultValue.class);
                if (sqlId != null) {
                    ++existId;
                }
                if (existId > 1) {
                    throw new SqlBeanException("\u8bf7\u6b63\u786e\u7684\u6807\u8bc6id\u5b57\u6bb5\uff0cid\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728'" + field.getDeclaringClass().getName() + "'\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
                }
                if (i == 0) {
                    String tableFieldName = SqlBeanUtil.getTableFieldName(common, field, sqlTable);
                    if (sqlId == null || sqlId != null && sqlId.type() != IdType.AUTO) {
                        fieldSql.append(tableFieldName);
                        fieldSql.append(", ");
                    }
                }
                if (sqlId != null && sqlId.type() == IdType.AUTO) continue;
                Object value = ReflectUtil.instance().get(objectList.get(i).getClass(), objectList.get(i), field.getName());
                if (sqlId != null && sqlId.type() != IdType.AUTO && sqlId.type() != IdType.NORMAL) {
                    if (StringUtil.isEmpty(value)) {
                        value = common.getSqlBeanDB().getSqlBeanConfig().getUniqueIdProcessor().uniqueId(sqlId.type());
                        ReflectUtil.instance().set(objectList.get(i).getClass(), objectList.get(i), field.getName(), value);
                    }
                    valueSql.append(SqlBeanUtil.getSqlValue(common, value));
                } else if (field.isAnnotationPresent(SqlLogically.class) && value == null) {
                    valueSql.append(0);
                    ReflectUtil.instance().set(objectList.get(i).getClass(), objectList.get(i), field.getName(), field.getType() == Boolean.class || field.getType() == Boolean.TYPE ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0));
                } else if (value == null && sqlDefaultValue != null && (sqlDefaultValue.with() == FillWith.INSERT || sqlDefaultValue.with() == FillWith.TOGETHER)) {
                    Object defaultValue = SqlBeanUtil.getDefaultValue(field.getType().getName());
                    valueSql.append(SqlBeanUtil.getSqlValue(common, defaultValue));
                    ReflectUtil.instance().set(objectList.get(i).getClass(), objectList.get(i), field.getName(), defaultValue);
                } else {
                    valueSql.append(SqlBeanUtil.getSqlValue(common, ReflectUtil.instance().get(objectList.get(i).getClass(), objectList.get(i), field.getName())));
                }
                valueSql.append(", ");
            }
            valueSql.deleteCharAt(valueSql.length() - ", ".length());
            valueSql.append(")");
            valueSqlList.add(valueSql.toString());
            if (i != 0) continue;
            fieldSql.deleteCharAt(fieldSql.length() - ", ".length());
            fieldSql.append(")");
        }
        if (common.getSqlBeanDB().getDbType() == DbType.Oracle) {
            for (k = 0; k < valueSqlList.size(); ++k) {
                if (k > 0) {
                    fieldAndValuesSql.append(" INTO ");
                }
                fieldAndValuesSql.append(tableName);
                fieldAndValuesSql.append(fieldSql.toString());
                fieldAndValuesSql.append("VALUES");
                fieldAndValuesSql.append((String)valueSqlList.get(k));
            }
            if (objectList != null && objectList.size() > 1) {
                fieldAndValuesSql.append(" SELECT 1 FROM DUAL ");
            }
        } else {
            for (k = 0; k < valueSqlList.size(); ++k) {
                if (k == 0) {
                    fieldAndValuesSql.append(tableName);
                    fieldAndValuesSql.append(fieldSql.toString());
                    fieldAndValuesSql.append("VALUES");
                }
                fieldAndValuesSql.append((String)valueSqlList.get(k));
                fieldAndValuesSql.append(", ");
            }
            fieldAndValuesSql.deleteCharAt(fieldAndValuesSql.length() - ", ".length());
        }
        return fieldAndValuesSql.toString();
    }

    private static String setSql(Update update) {
        StringBuffer setSql = new StringBuffer();
        String transferred = SqlBeanUtil.getTransferred(update);
        List<Column> filterColumns = update.getFilterColumns();
        Object bean = update.getUpdateBean();
        boolean isToUpperCase = SqlBeanUtil.isToUpperCase(update);
        if (bean != null) {
            Table table = SqlBeanUtil.getTable(bean.getClass());
            SqlTable sqlTable = SqlBeanUtil.getSqlTable(bean.getClass());
            List<Field> fieldList = SqlBeanUtil.getBeanAllField(bean.getClass());
            for (Field field : fieldList) {
                Column column;
                if (SqlBeanUtil.isIgnore(field) || SqlBeanUtil.isFilter(filterColumns, column = SqlBeanUtil.getTableColumn(field, table, sqlTable))) continue;
                Object objectValue = ReflectUtil.instance().get(bean.getClass(), bean, field.getName());
                SqlDefaultValue sqlDefaultValue = field.getAnnotation(SqlDefaultValue.class);
                SqlVersion sqlVersion = field.getAnnotation(SqlVersion.class);
                if (update.isUpdateNotNull() && objectValue == null && sqlVersion == null && (sqlDefaultValue == null || sqlDefaultValue.with() == FillWith.INSERT) || !update.isOptimisticLock() && objectValue == null && sqlVersion != null) continue;
                if (StringUtil.isNotBlank(sqlTable.alias())) {
                    setSql.append(transferred);
                    setSql.append(isToUpperCase ? sqlTable.alias().toUpperCase() : sqlTable.alias());
                    setSql.append(transferred);
                    setSql.append(".");
                }
                setSql.append(transferred);
                setSql.append(isToUpperCase ? column.getName().toUpperCase() : column.getName());
                setSql.append(transferred);
                setSql.append(" = ");
                if (update.isOptimisticLock() && sqlVersion != null) {
                    Object o = SqlBeanUtil.updateVersion(field.getType().getName(), objectValue);
                    setSql.append(SqlBeanUtil.getSqlValue(update, o));
                } else if (objectValue == null && sqlDefaultValue != null && (sqlDefaultValue.with() == FillWith.UPDATE || sqlDefaultValue.with() == FillWith.TOGETHER)) {
                    Object defaultValue = SqlBeanUtil.getDefaultValue(field.getType().getName());
                    setSql.append(SqlBeanUtil.getSqlValue(update, defaultValue));
                    ReflectUtil.instance().set(bean.getClass(), bean, field.getName(), defaultValue);
                } else {
                    setSql.append(SqlBeanUtil.getSqlValue(update, objectValue));
                }
                setSql.append(", ");
            }
            setSql.deleteCharAt(setSql.length() - ", ".length());
        } else {
            List<SetInfo> setInfoList = update.getSetInfoList();
            if (setInfoList != null && setInfoList.size() > 0) {
                for (SetInfo setInfo : setInfoList) {
                    if (StringUtil.isNotBlank(setInfo.getTableAlias())) {
                        setSql.append(transferred);
                        setSql.append(isToUpperCase ? setInfo.getTableAlias().toUpperCase() : setInfo.getTableAlias());
                        setSql.append(transferred);
                        setSql.append(".");
                    }
                    setSql.append(transferred);
                    setSql.append(isToUpperCase ? setInfo.getName().toUpperCase() : setInfo.getName());
                    setSql.append(transferred);
                    setSql.append(" = ");
                    if (setInfo.getValue() != null && setInfo.getValue().getClass().isArray()) {
                        Object[] values = (Object[])setInfo.getValue();
                        setSql.append(SqlBeanUtil.getOriginal(update, values[0]));
                        if (setInfo.getOperator() == SetInfo.Operator.ADDITION) {
                            setSql.append(" + ");
                        } else if (setInfo.getOperator() == SetInfo.Operator.SUBTRACT) {
                            setSql.append(" - ");
                        }
                        setSql.append(SqlBeanUtil.getOriginal(update, values[1]));
                    } else {
                        setSql.append(SqlBeanUtil.getOriginal(update, setInfo.getValue()));
                    }
                    setSql.append(", ");
                }
                setSql.deleteCharAt(setSql.length() - ", ".length());
            }
        }
        return setSql.toString();
    }

    public static String whereSql(CommonCondition commonCondition, Object bean) {
        return SqlHelper.conditionHandle(ConditionType.WHERE, commonCondition, commonCondition.getWhere(), commonCondition.getAgrs(), bean, commonCondition.where(), commonCondition.getWhereWrapper());
    }

    private static String groupBySql(Select select) {
        return SqlHelper.groupByAndOrderBySql(" GROUP BY ", select);
    }

    private static String havingSql(Select select) {
        return SqlHelper.conditionHandle(ConditionType.HAVING, select, select.getHaving(), select.getHavingArgs(), null, select.having(), select.getHavingWrapper());
    }

    private static String orderBySql(Select select) {
        return SqlHelper.groupByAndOrderBySql(" ORDER BY ", select);
    }

    private static String groupByAndOrderBySql(String type, Select select) {
        StringBuffer groupByAndOrderBySql = new StringBuffer();
        Column[] columns = " ORDER BY ".equals(type) ? select.getOrderBy().toArray(new Column[0]) : select.getGroupBy().toArray(new Column[0]);
        String transferred = SqlBeanUtil.getTransferred(select);
        boolean isToUpperCase = SqlBeanUtil.isToUpperCase(select);
        if (columns != null && columns.length != 0) {
            groupByAndOrderBySql.append(type);
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                if (StringUtil.isNotEmpty(column.getTableAlias())) {
                    groupByAndOrderBySql.append(transferred);
                    groupByAndOrderBySql.append(column.getTableAlias());
                    groupByAndOrderBySql.append(transferred);
                    groupByAndOrderBySql.append(".");
                    groupByAndOrderBySql.append(transferred);
                    groupByAndOrderBySql.append(isToUpperCase ? column.getName().toUpperCase() : column.getName());
                    groupByAndOrderBySql.append(transferred);
                } else {
                    groupByAndOrderBySql.append(isToUpperCase ? column.getName().toUpperCase() : column.getName());
                }
                if (" ORDER BY ".equals(type)) {
                    groupByAndOrderBySql.append(" ");
                    groupByAndOrderBySql.append(select.getOrderBy().get(i).getSqlSort().name());
                    groupByAndOrderBySql.append(" ");
                }
                groupByAndOrderBySql.append(", ");
            }
            groupByAndOrderBySql.deleteCharAt(groupByAndOrderBySql.length() - ", ".length());
        } else if (" ORDER BY ".equals(type) && select.getSqlBeanDB().getDbType() == DbType.SQLServer && SqlBeanUtil.isUsePage(select) && !select.isCount()) {
            groupByAndOrderBySql.append(type);
            String tableFieldFullName = SqlBeanUtil.getTableFieldFullName(select, select.getTable().getAlias(), select.getPage().getIdName());
            groupByAndOrderBySql.append(SqlBeanUtil.isToUpperCase(select) ? tableFieldFullName.toUpperCase() : tableFieldFullName);
        }
        return groupByAndOrderBySql.toString();
    }

    private static String conditionHandle(ConditionType conditionType, Common common, String conditionString, Object[] args, Object bean, Condition condition, Wrapper wrapper) {
        StringBuffer conditionSql = new StringBuffer();
        if (ConditionType.WHERE == conditionType && StringUtil.isBlank(conditionString)) {
            conditionSql.append(SqlHelper.versionCondition(common, bean));
            conditionSql.append(SqlHelper.logicallyDeleteCondition(common));
        }
        if (StringUtil.isNotBlank(conditionString)) {
            conditionSql.append("(");
            if (args != null && args.length > 0) {
                conditionSql.append(SqlBeanUtil.getCondition(common, conditionString, args));
            } else if (conditionString.indexOf("${") > -1 && bean != null) {
                conditionSql.append(SqlBeanUtil.getCondition(common, conditionString, bean));
            } else {
                conditionSql.append(conditionString);
            }
            conditionSql.append(")");
        } else if (wrapper != null && !wrapper.getDataList().isEmpty()) {
            if (conditionSql.length() > 0) {
                conditionSql.append(" AND ");
            }
            conditionSql.append(SqlHelper.wrapperConditionHandle(common, wrapper));
        } else if (condition != null && condition.getDataList().size() > 0) {
            if (conditionSql.length() > 0) {
                conditionSql.append(" AND ");
            }
            conditionSql.append("(");
            conditionSql.append(SqlHelper.simpleConditionHandle(common, condition.getDataList()));
            conditionSql.append(")");
        }
        if (conditionSql.length() != 0) {
            conditionSql.insert(0, ConditionType.WHERE == conditionType ? " WHERE " : " HAVING ");
        }
        return conditionSql.toString();
    }

    private static String simpleConditionHandle(Common common, List<ConditionData> conditionDataList) {
        StringBuffer conditionSql = new StringBuffer();
        for (int i = 0; i < conditionDataList.size(); ++i) {
            ConditionInfo conditionInfo = (ConditionInfo)conditionDataList.get(i).getItem();
            if (i != 0 && i < conditionDataList.size()) {
                conditionSql.append(SqlHelper.getLogic(conditionDataList.get(i).getSqlLogic()));
            }
            conditionSql.append(SqlHelper.valueOperator(common, conditionInfo));
        }
        return conditionSql.toString();
    }

    private static String wrapperConditionHandle(Common common, Wrapper wrapper) {
        StringBuffer conditionSql = new StringBuffer();
        if (!wrapper.getDataList().isEmpty()) {
            conditionSql.append("(");
            for (int i = 0; i < wrapper.getDataList().size(); ++i) {
                Object item;
                ConditionData data = wrapper.getDataList().get(i);
                if (i != 0 && i < wrapper.getDataList().size()) {
                    conditionSql.append(SqlHelper.getLogic(data.getSqlLogic()));
                }
                if ((item = data.getItem()) instanceof Cond) {
                    conditionSql.append(SqlHelper.valueOperator(common, (Cond)item));
                    continue;
                }
                conditionSql.append(SqlHelper.wrapperConditionHandle(common, (Wrapper)item));
            }
            conditionSql.append(")");
        }
        return conditionSql.toString();
    }

    private static String versionCondition(Common common, Object bean) {
        boolean versionEffectiveness;
        if (!(common instanceof Update) || !((Update)common).isOptimisticLock()) {
            return "";
        }
        StringBuffer versionConditionSql = new StringBuffer();
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(bean.getClass());
        Field versionField = null;
        if (bean != null) {
            versionField = SqlBeanUtil.getVersionField(bean.getClass());
        }
        if (versionField != null && (versionEffectiveness = SqlBeanUtil.versionEffectiveness(versionField.getType().getName()))) {
            versionConditionSql.append("(");
            versionConditionSql.append(SqlBeanUtil.getTableFieldName(versionField, sqlTable));
            Object versionValue = ReflectUtil.instance().get(bean.getClass(), bean, versionField.getName());
            versionConditionSql.append(versionValue == null ? " IS " : " = ");
            versionConditionSql.append(SqlBeanUtil.getSqlValue(common, versionValue));
            versionConditionSql.append(")");
        }
        return versionConditionSql.toString();
    }

    private static String logicallyDeleteCondition(Common common) {
        if (common instanceof Select && SqlBeanUtil.checkLogically(common.getBeanClass())) {
            StringBuffer logicallyDeleteSql = new StringBuffer();
            SqlTable sqlTable = SqlBeanUtil.getSqlTable(common.getBeanClass());
            Field logicallyDeleteField = SqlBeanUtil.getLogicallyField(common.getBeanClass());
            if (logicallyDeleteField != null) {
                logicallyDeleteSql.append("(");
                logicallyDeleteSql.append(SqlBeanUtil.getTableFieldFullName(common, common.getTable().getAlias(), SqlBeanUtil.getTableFieldName(logicallyDeleteField, sqlTable)));
                logicallyDeleteSql.append(" = ");
                DbType dbType = common.getSqlBeanDB().getDbType();
                if (dbType == DbType.Postgresql) {
                    logicallyDeleteSql.append("'0'");
                } else if (dbType == DbType.H2 || dbType == DbType.Hsql) {
                    logicallyDeleteSql.append("false");
                } else {
                    logicallyDeleteSql.append(0);
                }
                logicallyDeleteSql.append(")");
            }
            return logicallyDeleteSql.toString();
        }
        return "";
    }

    private static String getOperator(ConditionInfo conditionInfo) {
        String operator = "";
        if (conditionInfo.getSqlOperator() != null) {
            SqlOperator sqlOperator = conditionInfo.getSqlOperator();
            if (sqlOperator == SqlOperator.IS || sqlOperator == SqlOperator.IS_NULL) {
                operator = " IS ";
            } else if (sqlOperator == SqlOperator.IS_NOT || sqlOperator == SqlOperator.IS_NOT_NULL) {
                operator = " IS NOT ";
            } else if (sqlOperator == SqlOperator.IN) {
                operator = " IN (";
            } else if (sqlOperator == SqlOperator.NOT_IN) {
                operator = " NOT IN (";
            } else if (sqlOperator == SqlOperator.LIKE || sqlOperator == SqlOperator.LIKE_L || sqlOperator == SqlOperator.LIKE_R) {
                operator = " LIKE ";
            } else if (sqlOperator == SqlOperator.NOT_LIKE || sqlOperator == SqlOperator.NOT_LIKE_L || sqlOperator == SqlOperator.NOT_LIKE_R) {
                operator = " NOT LIKE ";
            } else if (sqlOperator == SqlOperator.BETWEEN) {
                operator = " BETWEEN ";
            } else if (sqlOperator == SqlOperator.GREATER_THAN) {
                operator = " > ";
            } else if (sqlOperator == SqlOperator.GREAT_THAN_OR_EQUAL_TO) {
                operator = " >= ";
            } else if (sqlOperator == SqlOperator.LESS_THAN) {
                operator = " < ";
            } else if (sqlOperator == SqlOperator.LESS_THAN_OR_EQUAL_TO) {
                operator = " <= ";
            } else if (sqlOperator == SqlOperator.EQUAL_TO) {
                operator = " = ";
            } else if (sqlOperator == SqlOperator.NOT_EQUAL_TO) {
                operator = " <> ";
            }
        } else {
            operator = " = ";
        }
        return operator;
    }

    private static String getLogic(SqlLogic sqlLogic) {
        String logic = null;
        if (sqlLogic != null && !"".equals((Object)sqlLogic)) {
            switch (sqlLogic) {
                case AND: {
                    logic = " AND ";
                    break;
                }
                case OR: {
                    logic = " OR ";
                    break;
                }
                case ORBracket: {
                    logic = ") OR (";
                    break;
                }
                case ANDBracket: {
                    logic = ") AND (";
                }
            }
        } else {
            logic = " AND ";
        }
        return logic;
    }

    private static StringBuffer valueOperator(Common common, ConditionInfo conditionInfo) {
        Column column;
        StringBuffer sql = new StringBuffer();
        String operator = SqlHelper.getOperator(conditionInfo);
        boolean needEndBracket = false;
        Object[] betweenValues = null;
        Object value = conditionInfo.getValue();
        if (conditionInfo.getSqlOperator() == SqlOperator.BETWEEN) {
            betweenValues = SqlBeanUtil.getObjectArray(value);
            if (betweenValues == null) {
                try {
                    throw new SqlBeanException("between \u6761\u4ef6\u7684\u503c\u5fc5\u987b\u4e3aArray\u6216ArrayList");
                }
                catch (SqlBeanException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        } else if (conditionInfo.getSqlOperator() == SqlOperator.IN || conditionInfo.getSqlOperator() == SqlOperator.NOT_IN) {
            needEndBracket = true;
            Object[] in_notInValues = SqlBeanUtil.getObjectArray(value);
            StringBuffer in_notIn = new StringBuffer();
            if (in_notInValues != null && in_notInValues.length > 0) {
                for (int k = 0; k < in_notInValues.length; ++k) {
                    in_notIn.append(SqlBeanUtil.getOriginal(common, in_notInValues[k]));
                    in_notIn.append(", ");
                }
                in_notIn.deleteCharAt(in_notIn.length() - ", ".length());
                value = in_notIn.toString();
            }
        } else {
            value = conditionInfo.getValue();
            if (operator.indexOf(" LIKE ") > -1) {
                if (conditionInfo.getSqlOperator() == SqlOperator.LIKE || conditionInfo.getSqlOperator() == SqlOperator.LIKE_L || conditionInfo.getSqlOperator() == SqlOperator.NOT_LIKE || conditionInfo.getSqlOperator() == SqlOperator.NOT_LIKE_L) {
                    value = "%" + value;
                }
                if (conditionInfo.getSqlOperator() == SqlOperator.LIKE || conditionInfo.getSqlOperator() == SqlOperator.LIKE_R || conditionInfo.getSqlOperator() == SqlOperator.NOT_LIKE || conditionInfo.getSqlOperator() == SqlOperator.NOT_LIKE_R) {
                    value = value + "%";
                }
                value = "'" + value + "'";
            } else {
                value = SqlBeanUtil.getOriginal(common, value);
            }
        }
        if ((column = conditionInfo.getColumn()) instanceof SqlFun) {
            sql.append(SqlBeanUtil.getSqlFunction(common, (SqlFun)column));
        } else if (StringUtil.isNotEmpty(column.getTableAlias())) {
            sql.append(SqlBeanUtil.getTableFieldFullName(common, column.getTableAlias(), column.getName()));
        } else {
            sql.append(column.getName());
        }
        sql.append(operator);
        if (conditionInfo.getSqlOperator() == SqlOperator.BETWEEN) {
            sql.append(betweenValues[0] instanceof SqlFun ? SqlBeanUtil.getSqlFunction(common, (SqlFun)betweenValues[0]) : SqlBeanUtil.getSqlValue(common, betweenValues[0]));
            sql.append(" AND ");
            sql.append(betweenValues[1] instanceof SqlFun ? SqlBeanUtil.getSqlFunction(common, (SqlFun)betweenValues[1]) : SqlBeanUtil.getSqlValue(common, betweenValues[1]));
        } else if (conditionInfo.getSqlOperator() == SqlOperator.IS_NULL || conditionInfo.getSqlOperator() == SqlOperator.IS_NOT_NULL) {
            sql.append("NULL ");
        } else {
            sql.append(value);
        }
        if (needEndBracket) {
            sql.append(")");
        }
        return sql;
    }

    private static void mysqlPageDispose(Select select, StringBuffer sqlSb) {
        if (SqlBeanUtil.isUsePage(select)) {
            Integer[] param = SqlHelper.pageParam(select);
            sqlSb.append(" LIMIT ");
            sqlSb.append(param[0]);
            sqlSb.append(", ");
            sqlSb.append(param[1]);
        }
    }

    private static void PostgresqlPageDispose(Select select, StringBuffer sqlSb) {
        if (SqlBeanUtil.isUsePage(select)) {
            Integer[] param = SqlHelper.pageParam(select);
            sqlSb.append(" LIMIT ");
            sqlSb.append(param[1]);
            sqlSb.append(" OFFSET ");
            sqlSb.append(param[0]);
        }
    }

    private static void oraclePageDispose(Select select, StringBuffer sqlSb) {
        if (SqlBeanUtil.isUsePage(select)) {
            Integer[] param = SqlHelper.pageParam(select);
            StringBuffer beginSqlSb = new StringBuffer();
            beginSqlSb.append("SELECT  *  FROM (");
            beginSqlSb.append("SELECT  TB . * ,  ROWNUM RN FROM (");
            sqlSb.insert(0, beginSqlSb);
            StringBuffer endSb = new StringBuffer();
            endSb.append(") TB  WHERE  ROWNUM  <= ");
            endSb.append(param[1]);
            endSb.append(") WHERE RN > ");
            endSb.append(param[0]);
            sqlSb.append(endSb);
        }
    }

    private static void db2PageDispose(Select select, StringBuffer sqlSb) {
        if (SqlBeanUtil.isUsePage(select)) {
            Integer[] param = SqlHelper.pageParam(select);
            StringBuffer beginSqlSb = new StringBuffer();
            beginSqlSb.append("SELECT  *  FROM (");
            beginSqlSb.append("SELECT  T. * ,  ROWNUMBER() ");
            beginSqlSb.append(" OVER ( ) AS RN FROM (");
            sqlSb.insert(0, beginSqlSb);
            StringBuffer endSb = new StringBuffer();
            endSb.append(") T ) TB ");
            endSb.append(" WHERE ( TB .RN <= ");
            endSb.append(param[1]);
            endSb.append(" AND  TB .RN > ");
            endSb.append(param[0]);
            endSb.append(")");
            sqlSb.append(endSb);
        }
    }

    private static void derbyPageDispose(Select select, StringBuffer sqlSb) {
        if (SqlBeanUtil.isUsePage(select)) {
            Integer[] param = SqlHelper.pageParam(select);
            sqlSb.append(" OFFSET ");
            sqlSb.append(param[0]);
            sqlSb.append(" ROWS FETCH NEXT ");
            sqlSb.append(param[1]);
            sqlSb.append(" ROWS ONLY");
        }
    }

    public static Integer[] pageParam(Select select) {
        Integer[] param;
        if (select.getPage().getPagenum() < 0) {
            throw new SqlBeanException("\u5f53\u524d\u9875\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (select.getPage().getPagesize() < 0) {
            throw new SqlBeanException("\u6bcf\u9875\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (DbType.SQLServer == select.getSqlBeanDB().getDbType()) {
            int pagenum = select.getPage().getStartByZero() ? select.getPage().getPagenum() + 1 : (select.getPage().getPagenum() == 0 ? select.getPage().getPagenum() + 1 : select.getPage().getPagenum());
            int top = pagenum * select.getPage().getPagesize();
            int begin = top - select.getPage().getPagesize();
            param = new Integer[]{top, begin};
        } else if (DbType.Oracle == select.getSqlBeanDB().getDbType() || DbType.DB2 == select.getSqlBeanDB().getDbType()) {
            int pagenum = select.getPage().getStartByZero() ? select.getPage().getPagenum() : (select.getPage().getPagenum() > 0 ? select.getPage().getPagenum() - 1 : select.getPage().getPagenum());
            int startIndex = pagenum * select.getPage().getPagesize();
            int endIndex = pagenum * select.getPage().getPagesize() + select.getPage().getPagesize();
            param = new Integer[]{startIndex, endIndex};
        } else {
            int pagenum = select.getPage().getStartByZero() ? select.getPage().getPagenum() : (select.getPage().getPagenum() > 0 ? select.getPage().getPagenum() - 1 : select.getPage().getPagenum());
            int limitOffset = pagenum * select.getPage().getPagesize();
            int limitAmount = select.getPage().getPagesize();
            param = new Integer[]{limitOffset, limitAmount};
        }
        return param;
    }
}

