/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.uitls;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlId;
import cn.vonce.sql.annotation.SqlJoin;
import cn.vonce.sql.annotation.SqlLogically;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.annotation.SqlVersion;
import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Common;
import cn.vonce.sql.bean.Condition;
import cn.vonce.sql.bean.Join;
import cn.vonce.sql.bean.Original;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.define.ColumnFun;
import cn.vonce.sql.define.JoinOn;
import cn.vonce.sql.define.SqlFun;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.IdType;
import cn.vonce.sql.enumerate.JdbcType;
import cn.vonce.sql.enumerate.SqlEnum;
import cn.vonce.sql.enumerate.WhatType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.LambdaUtil;
import cn.vonce.sql.uitls.Md5Util;
import cn.vonce.sql.uitls.ReflectJdkUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class SqlBeanUtil {
    private static final WeakHashMap<Class<?>, SqlTable> sqlTableMap = new WeakHashMap();

    public static SqlTable getSqlTable(Class<?> clazz) {
        if (sqlTableMap.containsKey(clazz)) {
            return sqlTableMap.get(clazz);
        }
        SqlTable sqlTable = clazz.getAnnotation(SqlTable.class);
        if (sqlTable == null) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                return null;
            }
            do {
                if (superClass.getName().equals("java.lang.Object")) continue;
                sqlTable = superClass.getAnnotation(SqlTable.class);
                if (sqlTable != null) break;
                superClass = superClass.getSuperclass();
            } while (!superClass.getName().equals("java.lang.Object") && !superClass.getName().equals("java.lang.Object"));
        }
        sqlTableMap.put(clazz, sqlTable);
        return sqlTable;
    }

    public static boolean sqlTableIsConsistent(Class<?> clazz1, Class<?> clazz2) {
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz1);
        SqlTable sqlTable2 = SqlBeanUtil.getSqlTable(clazz2);
        return sqlTable != null && sqlTable2 != null && sqlTable.schema().equals(sqlTable2.schema()) && sqlTable.value().equals(sqlTable2.value());
    }

    public static Table getTable(Class<?> clazz) {
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
        if (sqlTable != null) {
            return new Table(sqlTable.schema(), sqlTable.value(), StringUtil.isEmpty(sqlTable.alias()) ? sqlTable.value() : sqlTable.alias());
        }
        String tableName = clazz.getSimpleName();
        return new Table("", tableName, tableName);
    }

    public static Table getTable(Class<?> clazz, SqlJoin sqlJoin) {
        Table table = new Table();
        if (sqlJoin != null) {
            table.setSchema(sqlJoin.schema());
            table.setName(sqlJoin.table());
            table.setAlias(sqlJoin.tableAlias());
        }
        Table classTable = SqlBeanUtil.getTable(clazz);
        if (StringUtil.isEmpty(table.getSchema())) {
            table.setSchema(classTable.getSchema());
        }
        if (StringUtil.isEmpty(table.getName())) {
            table.setName(classTable.getName());
        }
        if (StringUtil.isEmpty(table.getAlias())) {
            table.setAlias(classTable.getAlias());
        }
        if (StringUtil.isEmpty(table.getAlias())) {
            table.setAlias(classTable.getName());
        }
        return table;
    }

    public static String getTableName(Table table, Common common) {
        String schema = table.getSchema();
        String tableName = table.getName();
        if (StringUtil.isNotEmpty(schema)) {
            tableName = schema + "." + tableName;
        }
        return SqlBeanUtil.isToUpperCase(common) ? tableName.toUpperCase() : tableName;
    }

    public static String getTableFieldName(Common common, Field field, SqlTable sqlTable) {
        return SqlBeanUtil.getTableFieldName(common, SqlBeanUtil.getTableFieldName(field, sqlTable));
    }

    public static String getTableFieldName(Common common, String name) {
        if (SqlBeanUtil.isToUpperCase(common)) {
            name = name.toUpperCase();
        }
        String transferred = SqlBeanUtil.getTransferred(common);
        return transferred + name + transferred;
    }

    public static String getTableFieldName(Field field, SqlTable sqlTable) {
        SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
        String name = field.getName();
        if (sqlColumn != null && StringUtil.isNotBlank(sqlColumn.value())) {
            name = sqlColumn.value();
        } else if (sqlTable == null || sqlTable.mapUsToCc()) {
            name = StringUtil.humpToUnderline(name);
        }
        return name;
    }

    public static Column getTableColumn(Field field, Table table, SqlTable sqlTable) {
        return new Column(table.getAlias(), SqlBeanUtil.getTableFieldName(field, sqlTable), "");
    }

    public static String getTableFieldFullName(Common common, String tableAlias, String tableFieldName) {
        String transferred = SqlBeanUtil.getTransferred(common);
        StringBuffer fullName = new StringBuffer();
        fullName.append(transferred);
        fullName.append(tableAlias);
        fullName.append(transferred);
        fullName.append(".");
        fullName.append(transferred);
        fullName.append(SqlBeanUtil.isToUpperCase(common) ? tableFieldName.toUpperCase() : tableFieldName);
        fullName.append(transferred);
        return fullName.toString();
    }

    public static String getTableFieldFullName(Common common, String tableAlias, Field field, SqlTable sqlTable) {
        return SqlBeanUtil.getTableFieldFullName(common, tableAlias, SqlBeanUtil.getTableFieldName(field, sqlTable));
    }

    public static String fromFullName(String schema, String tableName, String tableAlias, Common common) {
        String transferred = SqlBeanUtil.getTransferred(common);
        StringBuffer fromSql = new StringBuffer();
        if (SqlBeanUtil.isToUpperCase(common)) {
            tableName = tableName.toUpperCase();
            schema = schema.toUpperCase();
        }
        if (StringUtil.isNotEmpty(schema)) {
            fromSql.append(schema);
            fromSql.append(".");
        }
        fromSql.append(tableName);
        fromSql.append(" ");
        fromSql.append(transferred);
        fromSql.append(tableAlias);
        fromSql.append(transferred);
        return fromSql.toString();
    }

    public static Field getIdField(Class<?> clazz) throws SqlBeanException {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        Field idField = null;
        int existId = 0;
        for (Field field : fieldList) {
            SqlId sqlBeanField = field.getAnnotation(SqlId.class);
            if (sqlBeanField != null) {
                idField = field;
                ++existId;
            }
            if (existId <= 1) continue;
            throw new SqlBeanException("\u8bf7\u6b63\u786e\u6807\u8bc6@SqlId\u6ce8\u89e3\uff0cid\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728'" + field.getDeclaringClass().getName() + "'\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
        }
        if (existId == 0) {
            throw new SqlBeanException("\u8bf7\u68c0\u67e5\u5b9e\u4f53\u7c7b\u7684id\u5b57\u6bb5\u662f\u5426\u6b63\u786e\u6807\u8bc6@SqlId\u6ce8\u89e3");
        }
        return idField;
    }

    public static Field getLogicallyField(Class<?> clazz) throws SqlBeanException {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        Field logicallyField = null;
        int existLogicallyField = 0;
        for (Field field : fieldList) {
            SqlLogically sqlLogically = field.getAnnotation(SqlLogically.class);
            if (sqlLogically != null) {
                logicallyField = field;
                ++existLogicallyField;
            }
            if (existLogicallyField <= 1) continue;
            throw new SqlBeanException("\u8bf7\u6b63\u786e\u6807\u8bc6@SqlLogically\u6ce8\u89e3\uff0c\u903b\u8f91\u5220\u9664\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728'" + field.getDeclaringClass().getName() + "'\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
        }
        if (existLogicallyField == 0) {
            throw new SqlBeanException("\u8bf7\u68c0\u67e5\u5b9e\u4f53\u7c7b\u7533\u660e\u903b\u8f91\u5220\u9664\u7684\u5b57\u6bb5\u662f\u5426\u6b63\u786e\u6807\u8bc6@SqlLogically\u6ce8\u89e3");
        }
        return logicallyField;
    }

    public static ColumnInfo buildColumnInfo(SqlBeanDB sqlBeanDB, Field field) {
        return SqlBeanUtil.buildColumnInfo(sqlBeanDB, field, field.getDeclaringClass().getAnnotation(SqlTable.class), field.getAnnotation(SqlColumn.class));
    }

    public static ColumnInfo buildColumnInfo(SqlBeanDB sqlBeanDB, Field field, SqlTable sqlTable, SqlColumn sqlColumn) {
        String columnName = SqlBeanUtil.getTableFieldName(field, sqlTable);
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setName(SqlBeanUtil.isToUpperCase(sqlBeanDB) ? columnName.toUpperCase() : columnName);
        SqlId sqlId = field.getAnnotation(SqlId.class);
        columnInfo.setPk(sqlId != null);
        columnInfo.setAutoIncr(sqlId == null ? false : sqlId.type() == IdType.AUTO);
        JdbcType jdbcType = sqlColumn != null && sqlColumn.type() != JdbcType.NOTHING ? sqlColumn.type() : JdbcType.getType(sqlBeanDB.getDbType(), field);
        columnInfo.setType(jdbcType.name());
        if (sqlColumn != null) {
            if (columnInfo.getPk().booleanValue()) {
                columnInfo.setNotnull(true);
            } else {
                columnInfo.setNotnull(sqlColumn.notNull());
            }
        }
        if (sqlColumn != null && sqlColumn.length() != 0L) {
            columnInfo.setLength(sqlColumn.length());
            columnInfo.setScale(sqlColumn.scale());
        } else {
            columnInfo.setLength(jdbcType.getLength() > 0L ? Long.valueOf(jdbcType.getLength()) : null);
        }
        if (sqlColumn != null && sqlColumn.scale() != 0) {
            columnInfo.setScale(sqlColumn.scale());
        } else {
            columnInfo.setScale(jdbcType.getScale() > 0 ? Integer.valueOf(jdbcType.getScale()) : null);
        }
        if (sqlColumn != null && StringUtil.isNotEmpty(sqlColumn.def())) {
            columnInfo.setDfltValue(sqlColumn.def());
        }
        if (sqlColumn != null && StringUtil.isNotEmpty(sqlColumn.remarks())) {
            columnInfo.setRemarks(sqlColumn.remarks());
        } else {
            columnInfo.setRemarks("");
        }
        return columnInfo;
    }

    public static boolean columnInfoCompare(SqlBeanDB sqlBeanDB, ColumnInfo columnInfo, ColumnInfo toColumnInfo) {
        if (!columnInfo.getPk().equals(toColumnInfo.getPk())) {
            return false;
        }
        if (!columnInfo.getName().equals(toColumnInfo.getName())) {
            return false;
        }
        if (!columnInfo.getType().equalsIgnoreCase(toColumnInfo.getType())) {
            return false;
        }
        if (columnInfo.getNotnull() != null && !columnInfo.getNotnull().equals(toColumnInfo.getNotnull())) {
            return false;
        }
        if (columnInfo.getDfltValue() == null && columnInfo.getDfltValue() != toColumnInfo.getDfltValue() || columnInfo.getDfltValue() != null && toColumnInfo.getDfltValue() != null && !columnInfo.getDfltValue().equals(toColumnInfo.getDfltValue())) {
            return false;
        }
        if (columnInfo.getLength() != null && !columnInfo.getLength().equals(toColumnInfo.getLength())) {
            return false;
        }
        if (columnInfo.getScale() != null && !columnInfo.getScale().equals(toColumnInfo.getScale())) {
            return false;
        }
        if (sqlBeanDB.getDbType() != DbType.SQLite && sqlBeanDB.getDbType() != DbType.Derby && StringUtil.isNotBlank(columnInfo.getRemarks()) && !columnInfo.getRemarks().equals(toColumnInfo.getRemarks())) {
            return false;
        }
        return sqlBeanDB.getDbType() != DbType.MySQL && sqlBeanDB.getDbType() != DbType.MariaDB || columnInfo.getAutoIncr().equals(toColumnInfo.getAutoIncr());
    }

    public static boolean checkLogically(Class<?> clazz) {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        for (Field field : fieldList) {
            SqlLogically sqlLogically = field.getAnnotation(SqlLogically.class);
            if (sqlLogically == null) continue;
            return true;
        }
        return false;
    }

    public static Field getVersionField(Class<?> clazz) throws SqlBeanException {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        Field versionField = null;
        int existVersionField = 0;
        for (Field field : fieldList) {
            SqlVersion sqlVersion = field.getAnnotation(SqlVersion.class);
            if (sqlVersion != null) {
                versionField = field;
                ++existVersionField;
            }
            if (existVersionField <= 1) continue;
            throw new SqlBeanException("\u8bf7\u6b63\u786e\u6807\u8bc6SqlVersion\u6ce8\u89e3\uff0cversion\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728'" + field.getDeclaringClass().getName() + "'\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
        }
        return versionField;
    }

    public static boolean isIgnore(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return true;
        }
        SqlJoin sqlJoin = field.getAnnotation(SqlJoin.class);
        if (sqlJoin != null) {
            return true;
        }
        SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
        if (sqlColumn != null) {
            return sqlColumn.ignore();
        }
        return false;
    }

    public static boolean isFilter(String[] filterTableFields, String tableFieldName) {
        if (filterTableFields != null) {
            for (String filter : filterTableFields) {
                if (!tableFieldName.equals(filter)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFilter(List<Column> filterColumns, Column column) {
        if (filterColumns != null) {
            for (Column item : filterColumns) {
                if ((!StringUtil.isNotBlank(item.getTableAlias()) || !column.getTableAlias().equals(item.getTableAlias()) || !column.getName().equals(item.getName())) && (!StringUtil.isBlank(item.getTableAlias()) || !column.getName().equals(item.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Field> getBeanAllField(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> superClass = clazz.getSuperclass();
        do {
            if (superClass == null || superClass.getName().equals("java.lang.Object")) continue;
            fieldList.addAll(Arrays.asList(superClass.getDeclaredFields()));
            superClass = superClass.getSuperclass();
        } while ((superClass == null || !superClass.getName().equals("java.lang.Object")) && superClass != null && !superClass.getName().equals("java.lang.Object"));
        fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fieldList;
    }

    public static Field getFieldByTableFieldName(List<Field> fieldList, String tableFieldName) {
        Field thisField = null;
        for (Field field : fieldList) {
            SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
            if ((sqlColumn == null || !sqlColumn.value().equals(tableFieldName)) && !StringUtil.humpToUnderline(field.getName()).equals(tableFieldName) && !field.getName().equals(tableFieldName)) continue;
            thisField = field;
        }
        return thisField;
    }

    public static List<Column> getSelectColumns(Class<?> clazz, List<Column> filterColumns, List<Column> columnList) throws SqlBeanException {
        if (clazz == null) {
            return null;
        }
        LinkedHashSet<Column> columnSet = new LinkedHashSet<Column>();
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
        Table table = SqlBeanUtil.getTable(clazz);
        String tableAlias = table.getAlias();
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        for (Field field : fieldList) {
            SqlColumn sqlColumn;
            if (Modifier.isStatic(field.getModifiers()) || (sqlColumn = field.getAnnotation(SqlColumn.class)) != null && sqlColumn.ignore() || SqlBeanUtil.isFilter(filterColumns, SqlBeanUtil.getTableColumn(field, table, sqlTable))) continue;
            SqlJoin sqlJoin = field.getAnnotation(SqlJoin.class);
            if (sqlJoin != null && sqlJoin.isBean()) {
                Class<?> subBeanClazz = field.getType();
                if (sqlJoin.from() != null && sqlJoin.from() != Void.TYPE) {
                    subBeanClazz = sqlJoin.from();
                }
                SqlTable subSqlTable = SqlBeanUtil.getSqlTable(subBeanClazz);
                List<Field> subBeanFieldList = SqlBeanUtil.getBeanAllField(subBeanClazz);
                if (sqlJoin.value().length > 0 && !sqlJoin.value()[0].equals("")) {
                    for (String fieldName : sqlJoin.value()) {
                        Field javaField = SqlBeanUtil.getFieldByTableFieldName(subBeanFieldList, fieldName);
                        if (javaField == null) {
                            throw new SqlBeanException("\u8be5\u8868\u8fde\u63a5\u67e5\u8be2\u7684\u5b57\u6bb5\u672a\u4e0ejava\u5b57\u6bb5\u5173\u8054\uff1a" + subBeanClazz.getName() + "\u7c7b\u4e2d\u627e\u4e0d\u5230" + fieldName);
                        }
                        Table subTable = SqlBeanUtil.getTable(subBeanClazz, sqlJoin);
                        columnSet.add(new Column(subSqlTable == null ? "" : subTable.getAlias(), fieldName, SqlBeanUtil.getColumnAlias(subSqlTable == null ? "" : subTable.getAlias(), javaField.getName())));
                    }
                    continue;
                }
                Table subTable = SqlBeanUtil.getTable(subBeanClazz, sqlJoin);
                for (Field subBeanField : subBeanFieldList) {
                    SqlColumn subSqlColumn;
                    if (Modifier.isStatic(subBeanField.getModifiers()) || (subSqlColumn = subBeanField.getAnnotation(SqlColumn.class)) != null && subSqlColumn.ignore() || SqlBeanUtil.isFilter(filterColumns, SqlBeanUtil.getTableColumn(subBeanField, subTable, subSqlTable))) continue;
                    columnSet.add(new Column(subTable.getAlias(), SqlBeanUtil.getTableFieldName(subBeanField, subSqlTable), SqlBeanUtil.getColumnAlias(subTable.getAlias(), subBeanField.getName())));
                }
                continue;
            }
            if (sqlJoin != null) {
                String tableFieldName = sqlJoin.value()[0];
                if (StringUtil.isEmpty(tableFieldName)) {
                    throw new SqlBeanException("\u9700\u6307\u5b9a\u8fde\u63a5\u67e5\u8be2\u7684\u5b57\u6bb5\uff1a@SqlJoin > value = {\u201cxxx\u201d}");
                }
                String subTableAlias = StringUtil.isEmpty(sqlJoin.tableAlias()) ? sqlJoin.table() : sqlJoin.tableAlias();
                columnSet.add(new Column(subTableAlias, tableFieldName, SqlBeanUtil.getColumnAlias(subTableAlias, field.getName())));
                continue;
            }
            if (columnList != null && columnList.size() != 0) continue;
            columnSet.add(new Column(tableAlias, SqlBeanUtil.getTableFieldName(field, sqlTable), field.getName()));
        }
        return new ArrayList<Column>(columnSet);
    }

    public static Map<String, Join> setJoin(Select select, Class<?> clazz) throws SqlBeanException, InstantiationException, IllegalAccessException {
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        HashMap<String, Join> joinFieldMap = new HashMap<String, Join>();
        for (Field field : fieldList) {
            SqlJoin sqlJoin;
            if (Modifier.isStatic(field.getModifiers()) || (sqlJoin = field.getAnnotation(SqlJoin.class)) == null) continue;
            String key = null;
            Class<?> subClazz = field.getType();
            Table table = null;
            if (sqlJoin != null && sqlJoin.isBean()) {
                if (sqlJoin.from() != null && sqlJoin.from() != Void.TYPE) {
                    subClazz = sqlJoin.from();
                }
                table = SqlBeanUtil.getTable(subClazz, sqlJoin);
            }
            Join join = new Join();
            join.setJoinType(sqlJoin.type());
            join.setSchema(table != null ? table.getSchema() : sqlJoin.schema());
            join.setTableName(table != null ? table.getName() : sqlJoin.table());
            join.setTableAlias(table != null ? table.getAlias() : (StringUtil.isEmpty(sqlJoin.tableAlias()) ? sqlJoin.table() : sqlJoin.tableAlias()));
            if (sqlJoin.on() != null && sqlJoin.on() != Void.TYPE) {
                key = Md5Util.encode(sqlJoin.on() + sqlJoin.on().getClassLoader().toString());
                if (joinFieldMap.containsKey(key)) {
                    join = null;
                    continue;
                }
                select.addJoin(join);
                JoinOn joinOn = (JoinOn)sqlJoin.on().newInstance();
                Condition condition = new Condition();
                joinOn.on(condition);
                join.on().setDataList(condition.getDataList());
            } else if (sqlJoin != null && !sqlJoin.isBean()) {
                key = Md5Util.encode(sqlJoin.table().toLowerCase() + sqlJoin.tableKeyword().toLowerCase() + sqlJoin.mainKeyword().toLowerCase());
                if (joinFieldMap.containsKey(key)) {
                    join = null;
                    continue;
                }
                select.addJoin(join);
                join.on(SqlBeanUtil.getTableFieldFullName(select, join.getTableAlias(), sqlJoin.tableKeyword()), (Object)new Original(SqlBeanUtil.getTableFieldFullName(select, select.getTable().getAlias(), sqlJoin.mainKeyword())));
            } else if (sqlJoin != null && sqlJoin.isBean()) {
                String tableKeyword = SqlBeanUtil.getTableFieldName(SqlBeanUtil.getIdField(subClazz), sqlTable);
                key = Md5Util.encode(join.getTableName().toLowerCase() + tableKeyword.toLowerCase() + sqlJoin.mainKeyword().toLowerCase());
                if (joinFieldMap.containsKey(key)) {
                    join = null;
                    continue;
                }
                select.addJoin(join);
                join.on(SqlBeanUtil.getTableFieldFullName(select, join.getTableAlias(), tableKeyword), (Object)new Original(SqlBeanUtil.getTableFieldFullName(select, select.getTable().getAlias(), sqlJoin.mainKeyword())));
            }
            joinFieldMap.put(key, join);
        }
        return joinFieldMap;
    }

    public static String getColumnAlias(String tableAlias, String fieldName) {
        return tableAlias + "_" + fieldName;
    }

    public static String getCondition(Common common, String where, Object[] args) {
        if (where == null || where.equals("")) {
            return "";
        }
        StringBuffer conditionSql = new StringBuffer();
        int index = 0;
        for (char c : where.toCharArray()) {
            if ('?' == c) {
                StringBuffer value = new StringBuffer();
                Object[] objects = null;
                objects = args[index] == null ? null : (args[index].getClass().isArray() ? (Object[])args[index] : (args[index] instanceof Collection ? ((Collection)args[index]).toArray() : new Object[]{args[index]}));
                if (objects != null) {
                    for (int i = 0; i < objects.length; ++i) {
                        value.append(SqlBeanUtil.getOriginal(common, objects[i]));
                        value.append(", ");
                    }
                    value.delete(value.length() - ", ".length(), value.length());
                }
                conditionSql.append(value);
                ++index;
                continue;
            }
            if ('&' == c) {
                conditionSql.append(SqlBeanUtil.getColumn(common, args[index]));
                ++index;
                continue;
            }
            conditionSql.append(c);
        }
        return conditionSql.toString();
    }

    public static String getColumn(Common common, Object columnObject) {
        StringBuffer value = new StringBuffer();
        Column column = null;
        if (columnObject instanceof Column) {
            column = (Column)columnObject;
        }
        if (column != null) {
            String transferred = SqlBeanUtil.getTransferred(common);
            if (StringUtil.isNotEmpty(column.getTableAlias())) {
                value.append(transferred);
                value.append(column.getTableAlias());
                value.append(transferred);
                value.append(".");
            }
            value.append(column.getName());
        } else {
            value.append(columnObject);
        }
        return value.toString();
    }

    public static Object getOriginal(Common common, Object value) {
        if (value instanceof SqlFun) {
            return SqlBeanUtil.getSqlFunction(common, (SqlFun)value);
        }
        if (value instanceof Column) {
            Column column = (Column)value;
            return SqlBeanUtil.getTableFieldFullName(common, column.getTableAlias(), column.getName());
        }
        if (value instanceof ColumnFun) {
            Column column = LambdaUtil.getColumn((ColumnFun)value);
            return SqlBeanUtil.getTableFieldFullName(common, column.getTableAlias(), column.getName());
        }
        if (value instanceof Original) {
            Original original = (Original)value;
            return original.getValue();
        }
        return SqlBeanUtil.getSqlValue(common, value);
    }

    public static String getSqlFunction(Common common, SqlFun sqlFun) {
        StringBuffer fun = new StringBuffer();
        fun.append(sqlFun.getFunName());
        fun.append("(");
        if (sqlFun.getValues() != null && sqlFun.getValues().length > 0) {
            for (Object value : sqlFun.getValues()) {
                fun.append(SqlBeanUtil.getOriginal(common, value));
                fun.append(", ");
            }
            fun.deleteCharAt(fun.length() - ", ".length());
        }
        fun.append(")");
        return fun.toString();
    }

    public static String getCondition(Common common, String where, Object bean) {
        if (where == null || bean == null) {
            return "";
        }
        String prefix = "${";
        String suffix = "}";
        StringBuffer conditionSql = new StringBuffer(where);
        int startIndex = conditionSql.indexOf(prefix);
        while (startIndex != -1) {
            int endIndex = conditionSql.indexOf(suffix, startIndex + prefix.length());
            if (endIndex != -1) {
                String name = conditionSql.substring(startIndex + prefix.length(), endIndex);
                int nextIndex = endIndex + suffix.length();
                String value = SqlBeanUtil.getSqlValue(common, ReflectJdkUtil.instance().get(bean.getClass(), bean, name));
                conditionSql.replace(startIndex, endIndex + suffix.length(), value);
                nextIndex = startIndex + value.length();
                startIndex = conditionSql.indexOf(prefix, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return conditionSql.toString();
    }

    public static WhatType whatType(Class<?> type) {
        if (type == String.class || type == Character.TYPE || type == Character.class) {
            return WhatType.STRING_TYPE;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return WhatType.BOOL_TYPE;
        }
        if (type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class || type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == Float.TYPE || type == Float.class || type == Double.TYPE || type == Double.class) {
            return WhatType.VALUE_TYPE;
        }
        if (type == java.util.Date.class || type == Date.class || type == Timestamp.class || type == Timestamp.class || type == Time.class || type == LocalDate.class || type == LocalTime.class || type == LocalDateTime.class) {
            return WhatType.DATE_TYPE;
        }
        return WhatType.OBJECT_TYPE;
    }

    public static WhatType whatType(JdbcType jdbcType) {
        WhatType whatType;
        switch (jdbcType) {
            case CHAR: 
            case NCHAR: 
            case VARCHAR: 
            case VARCHAR2: 
            case NVARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case NTEXT: 
            case LONGTEXT: 
            case CLOB: 
            case NCLOB: {
                whatType = WhatType.STRING_TYPE;
                break;
            }
            case BIT: {
                whatType = WhatType.BOOL_TYPE;
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case NUMERIC: 
            case MONEY: 
            case SMALLMONEY: {
                whatType = WhatType.VALUE_TYPE;
                break;
            }
            case DATE: 
            case TIME: 
            case DATETIME: 
            case DATETIME2: 
            case TIMESTAMP: {
                whatType = WhatType.DATE_TYPE;
                break;
            }
            default: {
                whatType = WhatType.OBJECT_TYPE;
            }
        }
        return whatType;
    }

    public static boolean isBaseType(Class<?> type) {
        return type == String.class || type == Character.TYPE || type == Character.class || type == Boolean.TYPE || type == Boolean.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class || type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == Float.TYPE || type == Float.class || type == Double.TYPE || type == Double.class || type == java.util.Date.class || type == Date.class || type == Timestamp.class || type == Timestamp.class || type == Time.class || type == LocalDate.class || type == LocalTime.class || type == LocalDateTime.class || type == BigDecimal.class;
    }

    public static boolean isMap(Class<?> type) {
        return type == Map.class || type == HashMap.class;
    }

    public static String getSqlValue(Common common, Object value) {
        return SqlBeanUtil.getSqlValue(common, value, null);
    }

    public static String getSqlValue(Common common, Object value, JdbcType jdbcType) {
        String sqlValue;
        if (value == null) {
            return "NULL";
        }
        String single_quotation_mark = "'";
        WhatType whatType = jdbcType == null ? SqlBeanUtil.whatType(value.getClass()) : SqlBeanUtil.whatType(jdbcType);
        block0 : switch (whatType) {
            case VALUE_TYPE: {
                sqlValue = value.toString();
                break;
            }
            case BOOL_TYPE: {
                if (jdbcType != null) {
                    sqlValue = (String)value;
                    break;
                }
                DbType dbType = common.getSqlBeanDB().getDbType();
                if (dbType == DbType.Postgresql) {
                    sqlValue = Boolean.parseBoolean(value.toString()) ? "'1'" : "'0'";
                    break;
                }
                if (dbType == DbType.H2 || dbType == DbType.Hsql) {
                    sqlValue = Boolean.parseBoolean(value.toString()) ? "true" : "false";
                    break;
                }
                sqlValue = Boolean.parseBoolean(value.toString()) ? "1" : "0";
                break;
            }
            case DATE_TYPE: {
                String dateString = jdbcType != null ? (String)value : DateUtil.unifyDateToString(value);
                switch (common.getSqlBeanDB().getDbType()) {
                    case Oracle: {
                        sqlValue = "to_timestamp(" + single_quotation_mark + dateString + single_quotation_mark + ", 'syyyy-mm-dd hh24:mi:ss.ff')";
                        break block0;
                    }
                }
                sqlValue = single_quotation_mark + dateString + single_quotation_mark;
                break;
            }
            default: {
                sqlValue = value instanceof SqlEnum ? ((SqlEnum)value).getCode().toString() : single_quotation_mark + SqlBeanUtil.filterSQLInject(value.toString()) + single_quotation_mark;
            }
        }
        return sqlValue;
    }

    public static boolean isUsePage(Select select) {
        return select.getPage() != null && select.getPage().getPagenum() != null && select.getPage().getPagesize() != null;
    }

    public static String filterSQLInject(String str) {
        return str.replaceAll("([';])+|(--)+", "");
    }

    public static String getTransferred(Common common) {
        String transferred = "\"";
        DbType dbType = common.getSqlBeanDB().getDbType();
        if (dbType == DbType.MySQL || dbType == DbType.MariaDB) {
            transferred = "`";
        }
        return transferred;
    }

    public static boolean isToUpperCase(Common common) {
        return common.getSqlBeanDB().getSqlBeanConfig().getToUpperCase() != null && common.getSqlBeanDB().getSqlBeanConfig().getToUpperCase() != false;
    }

    public static boolean isToUpperCase(SqlBeanDB sqlBeanDB) {
        return sqlBeanDB.getSqlBeanConfig().getToUpperCase() != null && sqlBeanDB.getSqlBeanConfig().getToUpperCase() != false;
    }

    public static Object updateVersion(Class<?> type, Object value) {
        if (type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class) {
            long val = 0L;
            if (value != null) {
                val = Long.parseLong(value.toString());
            }
            ++val;
            if (type == Integer.TYPE || type == Integer.class) {
                return (int)val;
            }
            return val;
        }
        if (type == java.util.Date.class || type == Timestamp.class) {
            return new java.util.Date();
        }
        if (type == LocalDateTime.class) {
            return LocalDateTime.now();
        }
        return null;
    }

    public static boolean versionEffectiveness(Class<?> type) {
        return type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == java.util.Date.class || type == Timestamp.class || type == LocalDateTime.class;
    }

    public static Object[] getObjectArray(Object bean) {
        Object[] objects;
        if (bean.getClass().isArray()) {
            objects = (Object[])bean;
        } else if (bean instanceof Collection) {
            Collection list = (Collection)bean;
            objects = list.toArray();
        } else {
            objects = new Object[]{bean};
        }
        return objects;
    }

    public static Object getDefaultValue(Class<?> type) {
        if (type == Byte.class || type == Byte.TYPE) {
            return new Byte("0");
        }
        if (type == Short.class || type == Short.TYPE) {
            return new Short("0");
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.class || type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.class || type == Double.TYPE) {
            return 0.0;
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return false;
        }
        if (type == String.class) {
            return "";
        }
        if (type == java.util.Date.class) {
            return new java.util.Date();
        }
        if (type == Timestamp.class) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(0);
        }
        if (type == LocalDate.class) {
            return LocalDate.now();
        }
        if (type == LocalTime.class) {
            return LocalTime.now();
        }
        if (type == LocalDateTime.class) {
            return LocalDateTime.now();
        }
        return null;
    }

    public static Object getValueConvert(Class<?> type, Object value) {
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.parseByte(value.toString());
        }
        if (type == Short.class || type == Short.TYPE) {
            return Short.parseShort(value.toString());
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(value.toString());
        }
        if (type == Long.class || type == Long.TYPE) {
            return Integer.parseInt(value.toString());
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.parseDouble(value.toString());
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf(value.toString().charAt(0));
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Boolean.parseBoolean(value.toString());
        }
        if (type == String.class) {
            return value.toString();
        }
        if (type == java.util.Date.class || type == Timestamp.class) {
            return DateUtil.stringToDate(value.toString());
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value.toString());
        }
        if (type == LocalDate.class) {
            LocalDateTime localDateTime = DateUtil.strTimeToLocalDateTime(value.toString());
            return localDateTime == null ? null : localDateTime.toLocalDate();
        }
        if (type == LocalTime.class) {
            LocalDateTime localDateTime = DateUtil.strTimeToLocalDateTime(value.toString());
            return localDateTime == null ? null : localDateTime.toLocalTime();
        }
        if (type == LocalDateTime.class) {
            return DateUtil.strTimeToLocalDateTime(value.toString());
        }
        return null;
    }

    public static String addColumn(Common common, ColumnInfo columnInfo, String afterColumnName) {
        Alter alter;
        StringBuffer sql = new StringBuffer();
        JdbcType jdbcType = JdbcType.getType(columnInfo.getType());
        sql.append(SqlBeanUtil.getTableFieldName(common, columnInfo.getName()));
        sql.append(" ");
        sql.append(jdbcType.name());
        if (columnInfo.getLength() != null && columnInfo.getLength() > 0L) {
            sql.append("(");
            sql.append(columnInfo.getLength());
            if (jdbcType.isFloat()) {
                sql.append(", ");
                sql.append(columnInfo.getScale() == null ? 0 : columnInfo.getScale());
            }
            sql.append(")");
        }
        if (columnInfo.getNotnull() != null && columnInfo.getNotnull().booleanValue() || columnInfo.getPk().booleanValue()) {
            sql.append(" ");
            sql.append("NOT NULL");
        } else if (common instanceof Alter && (alter = (Alter)common).getType() == AlterType.MODIFY && columnInfo.getNotnull() != null && !columnInfo.getNotnull().booleanValue()) {
            sql.append(" ");
            sql.append("NULL");
        }
        if (columnInfo.getAutoIncr() != null && columnInfo.getAutoIncr().booleanValue() && (common.getSqlBeanDB().getDbType() == DbType.MySQL || common.getSqlBeanDB().getDbType() == DbType.MariaDB)) {
            sql.append(" ");
            sql.append("AUTO_INCREMENT");
        }
        if (StringUtil.isNotEmpty(columnInfo.getDfltValue())) {
            sql.append(" ");
            sql.append("DEFAULT");
            sql.append(" ");
            sql.append(SqlBeanUtil.getSqlValue(common, columnInfo.getDfltValue(), jdbcType));
        }
        if (common.getSqlBeanDB().getDbType() == DbType.MySQL || common.getSqlBeanDB().getDbType() == DbType.MariaDB) {
            if (StringUtil.isNotBlank(columnInfo.getRemarks())) {
                sql.append(" ");
                sql.append("COMMENT");
                sql.append(" ");
                sql.append("'");
                sql.append(columnInfo.getRemarks());
                sql.append("'");
            }
            if (StringUtil.isNotBlank(afterColumnName)) {
                String transferred = SqlBeanUtil.getTransferred(common);
                sql.append(" ");
                sql.append("AFTER ");
                sql.append(" ");
                sql.append(transferred);
                sql.append(afterColumnName);
                sql.append(transferred);
            }
        }
        return sql.toString();
    }

    public static void isNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void check(Common common) {
        SqlBeanUtil.isNull(common.getSqlBeanDB(), "\u8bf7\u8bbe\u7f6esqlBeanConfig");
        SqlBeanUtil.isNull((Object)common.getSqlBeanDB().getDbType(), "\u8bf7\u8bbe\u7f6esqlBeanConfig -> dbType");
    }

    public static Column getColumnByLambda(SerializedLambda lambda) {
        String getter = lambda.getImplMethodName();
        String fieldName = Introspector.decapitalize(getter.replace("get", ""));
        try {
            Class<?> tableClass = Class.forName(lambda.getImplClass().replace("/", "."));
            Field field = tableClass.getDeclaredField(fieldName);
            String methodType = lambda.getInstantiatedMethodType();
            SqlTable sqlTable = SqlBeanUtil.getSqlTable(Class.forName(methodType.substring(methodType.indexOf("(L") + 2, methodType.indexOf(";")).replace("/", ".")));
            String tableAlias = sqlTable != null ? (StringUtil.isNotBlank(sqlTable.alias()) ? sqlTable.alias() : sqlTable.value()) : tableClass.getSimpleName();
            String columnName = SqlBeanUtil.getTableFieldName(field, sqlTable);
            return new Column(tableAlias, columnName, "");
        }
        catch (ClassNotFoundException e) {
            throw new SqlBeanException("\u627e\u4e0d\u5230\u7c7b\uff1a" + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new SqlBeanException("\u627e\u4e0d\u5230\u5b57\u6bb5,\u8bf7\u68c0\u67e5:" + getter + "\u65b9\u6cd5\u540d\u4e0e\u6240\u5bf9\u5e94\u7684\u5b57\u6bb5\u540d\u662f\u5426\u7b26\u5408\u6807\u51c6,\u5982\uff1aid\u5b57\u6bb5\u5bf9\u5e94\u7684get\u65b9\u6cd5\u540d\u5e94\u8be5\u4e3agetId()");
        }
    }

    public static <T, R> Column[] funToColumn(ColumnFun<T, R>[] filterColumns) {
        Column[] columns = new Column[filterColumns.length];
        for (int i = 0; i < filterColumns.length; ++i) {
            columns[i] = LambdaUtil.getColumn(filterColumns[i]);
        }
        return columns;
    }

    public static <T> T copy(T target) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(target);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            return (T)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class<?> getGenericType(Class<?> clazz) {
        Type[] typeArray = new Type[]{clazz.getGenericSuperclass()};
        if (typeArray == null || typeArray.length == 0) {
            typeArray = clazz.getGenericInterfaces();
        }
        return SqlBeanUtil.getGenericType(typeArray);
    }

    public static Class<?> getGenericType(Type[] typeArray) {
        Class<?> clazz = null;
        for (Type type : typeArray) {
            if (!(type instanceof ParameterizedType)) continue;
            Class trueTypeClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            try {
                clazz = SqlBeanUtil.class.getClassLoader().loadClass(trueTypeClass.getName());
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    public static Class<?> getEntityClassFieldType(Field field) {
        Class<?> clazz = field.getType();
        if (clazz.isEnum() && SqlEnum.class.isAssignableFrom(clazz)) {
            Type[] typeArray = clazz.getGenericInterfaces();
            if ((clazz = SqlBeanUtil.getGenericType(typeArray)) == null) {
                throw new SqlBeanException(field.getDeclaringClass().getName() + "\u5b9e\u4f53\u7c7b\u4e2d\u7684\u679a\u4e3e\u7c7b\u5b57\u6bb5\uff1a" + field.getType().getSimpleName() + "\u5728\u5b9e\u73b0SqlEnum\u63a5\u53e3\u65f6\u5fc5\u987b\u6307\u5b9a\u6cdb\u578b\u7c7b\u578b");
            }
            if (!SqlBeanUtil.isBaseType(clazz)) {
                throw new SqlBeanException(field.getDeclaringClass().getName() + "\u5b9e\u4f53\u7c7b\u4e2d\u7684\u679a\u4e3e\u7c7b\u5b57\u6bb5\uff1a" + field.getType().getSimpleName() + "\u5728\u5b9e\u73b0SqlEnum\u63a5\u53e3\u65f6\u6307\u5b9a\u7684\u6cdb\u578b\u7c7b\u578b\u4e0d\u652f\u6301");
            }
        }
        return clazz;
    }
}

