/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.enumerate;

import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.Copy;
import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public enum JavaMapSqliteType {
    NULL(new Class[0]),
    INTEGER(new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class}),
    REAL(new Class[]{Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class}),
    TEXT(new Class[]{Clob.class, Character.TYPE, Character.class, String.class, Date.class, Time.class, Timestamp.class, java.util.Date.class, LocalDateTime.class, LocalDate.class, LocalTime.class}),
    BLOB(new Class[]{Blob.class, Object.class});

    private Class<?>[] classes;

    private JavaMapSqliteType(Class<?>[] classes) {
        this.classes = classes;
    }

    public static JavaMapSqliteType getType(Field field) {
        Class<?> clazz = SqlBeanUtil.getEntityClassFieldType(field);
        for (JavaMapSqliteType javaType : JavaMapSqliteType.values()) {
            for (Class<?> thisClazz : javaType.classes) {
                if (thisClazz != clazz) continue;
                return javaType;
            }
        }
        throw new SqlBeanException(field.getDeclaringClass().getName() + "\u5b9e\u4f53\u7c7b\u4e0d\u652f\u6301\u6b64\u5b57\u6bb5\u7c7b\u578b\uff1a" + clazz.getSimpleName());
    }

    public static String getTableListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT name ");
        sql.append("FROM sqlite_master ");
        sql.append("WHERE type='table'");
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND name = '" + tableName + "'");
        }
        return sql.toString();
    }

    public static String getColumnListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("pragma table_info('");
        sql.append(tableName);
        sql.append("')");
        return sql.toString();
    }

    public static List<String> alterTable(List<Alter> alterList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        SqlBeanDB sqlBeanDB = alterList.get(0).getSqlBeanDB();
        Table table = alterList.get(0).getTable();
        Class<?> beanClass = alterList.get(0).getBeanClass();
        SqlTable sqlTable = beanClass.getAnnotation(SqlTable.class);
        String oldTableName = "_" + table.getName() + "_" + "old" + "_" + DateUtil.dateToString(new java.util.Date(), "yyyyMMddHHmmss");
        StringBuffer alterTableSql = new StringBuffer();
        alterTableSql.append("ALTER TABLE ");
        alterTableSql.append("\"");
        alterTableSql.append(table.getName());
        alterTableSql.append("\"");
        alterTableSql.append(" ");
        alterTableSql.append("RENAME TO ");
        alterTableSql.append("\"");
        alterTableSql.append(oldTableName);
        alterTableSql.append("\"");
        sqlList.add(alterTableSql.toString());
        Create create = new Create();
        create.setSqlBeanDB(sqlBeanDB);
        create.setBeanClass(beanClass);
        create.setTable(beanClass);
        sqlList.add(SqlHelper.buildCreateSql(create));
        HashMap<String, Alter> alterMap = new HashMap<String, Alter>();
        for (Alter alter : alterList) {
            alterMap.put(alter.getColumnInfo().getName(), alter);
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        ArrayList<Column> targetColumnList = new ArrayList<Column>();
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(beanClass);
        for (Field field : fieldList) {
            String columnName;
            Alter alter;
            if (SqlBeanUtil.isIgnore(field) || (alter = (Alter)alterMap.get(columnName = SqlBeanUtil.getTableFieldName(field, sqlTable))) != null && (alter.getType() == AlterType.ADD || alter.getType() == AlterType.DROP)) continue;
            String targetColumnName = alter != null && alter.getType() == AlterType.CHANGE ? alter.getOldColumnName() : columnName;
            Column column = new Column();
            column.setTableAlias(table.getAlias());
            column.setName(columnName);
            column.setAlias(column.getName());
            columnList.add(column);
            Column targetColumn = new Column();
            targetColumn.setTableAlias(table.getAlias());
            targetColumn.setName(targetColumnName);
            targetColumn.setAlias(column.getName());
            targetColumnList.add(targetColumn);
        }
        Copy copy = new Copy();
        copy.setSqlBeanDB(sqlBeanDB);
        copy.setBeanClass(beanClass);
        copy.setTable(beanClass);
        copy.setColumns(columnList.toArray(new Column[0]));
        copy.setTargetTableName(oldTableName);
        copy.setTargetColumns(targetColumnList.toArray(new Column[0]));
        sqlList.add(SqlHelper.buildCopy(copy));
        return sqlList;
    }
}

