/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.enumerate;

import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Common;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public enum JavaMapHsqlType {
    INTEGER(new Class[]{Integer.TYPE, Integer.class}),
    BIGINT(new Class[]{Long.TYPE, Long.class}),
    TINYINT(new Class[]{Byte.TYPE, Byte.class}),
    SMALLINT(new Class[]{Short.TYPE, Short.class}),
    BOOLEAN(new Class[]{Boolean.TYPE, Boolean.class}),
    FLOAT(new Class[]{Float.TYPE, Float.class}),
    DOUBLE(new Class[]{Double.TYPE, Double.class}),
    DECIMAL(new Class[]{BigDecimal.class}),
    CHAR(new Class[]{Character.TYPE, Character.class}),
    VARCHAR(new Class[]{String.class}),
    DATE(new Class[]{Date.class, LocalDate.class}),
    TIME(new Class[]{Time.class, LocalTime.class}),
    TIMESTAMP(new Class[]{Timestamp.class, java.util.Date.class, LocalDateTime.class}),
    CLOB(new Class[]{Clob.class}),
    BLOB(new Class[]{Blob.class, Object.class}),
    ARRAY(new Class[]{Object[].class});

    private Class<?>[] classes;

    private JavaMapHsqlType(Class<?>[] classes) {
        this.classes = classes;
    }

    public static JavaMapHsqlType getType(Field field) {
        Class<?> clazz = SqlBeanUtil.getEntityClassFieldType(field);
        for (JavaMapHsqlType javaType : JavaMapHsqlType.values()) {
            for (Class<?> thisClazz : javaType.classes) {
                if (thisClazz != clazz) continue;
                return javaType;
            }
        }
        throw new SqlBeanException(field.getDeclaringClass().getName() + "\u5b9e\u4f53\u7c7b\u4e0d\u652f\u6301\u6b64\u5b57\u6bb5\u7c7b\u578b\uff1a" + clazz.getSimpleName());
    }

    public static String getTableListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t.TABLE_SCHEMA AS schema, t.TABLE_NAME AS name, sc.COMMENT AS remarks ");
        sql.append("FROM information_schema.tables t ");
        sql.append("LEFT JOIN INFORMATION_SCHEMA.SYSTEM_COMMENTS sc ");
        sql.append("ON sc.OBJECT_NAME = t.TABLE_NAME AND sc.OBJECT_TYPE = 'TABLE' ");
        sql.append("WHERE TABLE_TYPE = 'BASE TABLE'");
        sql.append(" AND TABLE_SCHEMA = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("'PUBLIC'");
        }
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND table_name = '" + tableName + "'");
        }
        return sql.toString();
    }

    public static String getColumnListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT cl.ORDINAL_POSITION AS cid, ");
        sql.append("cl.COLUMN_NAME AS name,");
        sql.append("cl.DTD_IDENTIFIER AS type, ");
        sql.append("CASE WHEN cl.IS_NULLABLE  = 'NO' THEN 1 ELSE 0 END AS notnull, ");
        sql.append("cl.COLUMN_DEFAULT AS dflt_value, ");
        sql.append("cl.CHARACTER_MAXIMUM_LENGTH AS length, ");
        sql.append("cl.NUMERIC_SCALE AS scale, ");
        sql.append("CASE WHEN kcu.TABLE_NAME = cl.TABLE_NAME AND kcu.POSITION_IN_UNIQUE_CONSTRAINT is null THEN 1 ELSE 0 END AS pk, ");
        sql.append("CASE WHEN kcu.TABLE_NAME = cl.TABLE_NAME AND kcu.POSITION_IN_UNIQUE_CONSTRAINT = 1 THEN 1 ELSE 0 END AS fk, ");
        sql.append("sc.COMMENT AS remarks ");
        sql.append("FROM INFORMATION_SCHEMA.COLUMNS cl ");
        sql.append("LEFT JOIN INFORMATION_SCHEMA.SYSTEM_COMMENTS sc ");
        sql.append("ON sc.OBJECT_NAME = cl.TABLE_NAME AND sc.COLUMN_NAME = cl.COLUMN_NAME ");
        sql.append("LEFT JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu ");
        sql.append("ON kcu.TABLE_NAME = cl.TABLE_NAME AND kcu.COLUMN_NAME = cl.COLUMN_NAME ");
        sql.append("WHERE cl.TABLE_SCHEMA = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("'PUBLIC'");
        }
        sql.append(" AND cl.TABLE_NAME = '");
        sql.append(tableName);
        sql.append("'");
        return sql.toString();
    }

    public static List<String> alterTable(List<Alter> alterList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        String transferred = SqlBeanUtil.getTransferred(alterList.get(0));
        StringBuffer sql = new StringBuffer();
        StringBuffer remarksSql = new StringBuffer();
        for (int i = 0; i < alterList.size(); ++i) {
            Alter alter = alterList.get(i);
            if (alter.getType() == AlterType.ADD) {
                sql.append("ALTER TABLE ");
                sql.append(JavaMapHsqlType.getFullName(alter, alter.getTable()));
                sql.append("ADD ");
                sql.append(SqlBeanUtil.addColumn(alter, alter.getColumnInfo(), alter.getAfterColumnName()));
                remarksSql.append(JavaMapHsqlType.addRemarks(false, alter, transferred));
            } else if (alter.getType() == AlterType.CHANGE) {
                sql.append(JavaMapHsqlType.changeColumn(alter));
                sql.append(";");
                StringBuffer modifySql = JavaMapHsqlType.modifyColumn(alter);
                if (modifySql.length() > 0) {
                    sql.append("ALTER TABLE ");
                    sql.append(modifySql);
                }
                remarksSql.append(JavaMapHsqlType.addRemarks(false, alter, transferred));
            } else if (alter.getType() == AlterType.MODIFY) {
                sql.append("ALTER TABLE ");
                sql.append(JavaMapHsqlType.modifyColumn(alter));
                remarksSql.append(JavaMapHsqlType.addRemarks(false, alter, transferred));
            } else if (alter.getType() == AlterType.DROP) {
                sql.append("ALTER TABLE ");
                sql.append(JavaMapHsqlType.getFullName(alter, alter.getTable()));
                sql.append("DROP ");
                sql.append("COLUMN ");
                sql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getColumnInfo().getName().toUpperCase() : alter.getColumnInfo().getName());
            }
            sql.append(" ");
            sql.append(";");
        }
        sqlList.add(sql.toString());
        sqlList.add(remarksSql.toString());
        return sqlList;
    }

    private static String getFullName(Common common, Table table) {
        String transferred = SqlBeanUtil.getTransferred(common);
        boolean toUpperCase = SqlBeanUtil.isToUpperCase(common);
        StringBuffer sql = new StringBuffer();
        if (StringUtil.isNotBlank(table.getSchema())) {
            sql.append(transferred);
            sql.append(toUpperCase ? table.getSchema().toUpperCase() : table.getSchema());
            sql.append(transferred);
            sql.append(".");
        }
        sql.append(transferred);
        sql.append(toUpperCase ? table.getName().toUpperCase() : table.getName());
        sql.append(transferred);
        sql.append(" ");
        return sql.toString();
    }

    private static StringBuffer modifyColumn(Alter alter) {
        StringBuffer modifySql = new StringBuffer();
        modifySql.append(JavaMapHsqlType.getFullName(alter, alter.getTable()));
        modifySql.append("ALTER ");
        modifySql.append("COLUMN ");
        modifySql.append(SqlBeanUtil.addColumn(alter, alter.getColumnInfo(), alter.getAfterColumnName()));
        return modifySql;
    }

    private static String changeColumn(Alter alter) {
        StringBuffer changeSql = new StringBuffer();
        changeSql.append("ALTER TABLE ");
        changeSql.append(JavaMapHsqlType.getFullName(alter, alter.getTable()));
        changeSql.append("RENAME ");
        changeSql.append("COLUMN ");
        changeSql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getOldColumnName().toUpperCase() : alter.getOldColumnName());
        changeSql.append(" TO ");
        changeSql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getColumnInfo().getName().toUpperCase() : alter.getColumnInfo().getName());
        return changeSql.toString();
    }

    public static String addRemarks(boolean isTable, Alter item, String transferred) {
        StringBuffer remarksSql = new StringBuffer();
        if (StringUtil.isNotBlank(item.getColumnInfo().getRemarks())) {
            remarksSql.append("COMMENT");
            remarksSql.append(" ON ");
            remarksSql.append(isTable ? "TABLE " : "COLUMN ");
            remarksSql.append(JavaMapHsqlType.getFullName(item, item.getTable()));
            if (!isTable) {
                remarksSql.append(".");
                remarksSql.append(transferred);
                remarksSql.append(item.getColumnInfo().getName());
                remarksSql.append(transferred);
            }
            remarksSql.append(" IS ");
            remarksSql.append("'");
            remarksSql.append(item.getColumnInfo().getRemarks());
            remarksSql.append("'");
        }
        return remarksSql.toString();
    }
}

