/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.enumerate;

import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Common;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.enumerate.JdbcType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public enum JavaMapPostgresqlType {
    INTEGER(new Class[]{Integer.TYPE, Integer.class}),
    BIGINT(new Class[]{Long.TYPE, Long.class}),
    SMALLINT(new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class}),
    FLOAT(new Class[]{Float.TYPE, Float.class}),
    DOUBLE(new Class[]{Double.TYPE, Double.class}),
    NUMERIC(new Class[]{BigDecimal.class}),
    CHAR(new Class[]{Character.TYPE, Character.class}),
    VARCHAR(new Class[]{String.class}),
    BIT(new Class[]{Boolean.TYPE, Boolean.class}),
    DATE(new Class[]{Date.class, LocalDate.class}),
    TIME(new Class[]{Time.class, LocalTime.class}),
    TIMESTAMP(new Class[]{Timestamp.class, java.util.Date.class, LocalDateTime.class}),
    TEXT(new Class[]{Clob.class}),
    BYTEA(new Class[]{Blob.class, Object.class});

    private Class<?>[] classes;

    private JavaMapPostgresqlType(Class<?>[] classes) {
        this.classes = classes;
    }

    public static JavaMapPostgresqlType getType(Field field) {
        Class<?> clazz = SqlBeanUtil.getEntityClassFieldType(field);
        for (JavaMapPostgresqlType javaType : JavaMapPostgresqlType.values()) {
            for (Class<?> thisClazz : javaType.classes) {
                if (thisClazz != clazz && !thisClazz.isAssignableFrom(clazz)) continue;
                return javaType;
            }
        }
        throw new SqlBeanException(field.getDeclaringClass().getName() + "\u5b9e\u4f53\u7c7b\u4e0d\u652f\u6301\u6b64\u5b57\u6bb5\u7c7b\u578b\uff1a" + clazz.getSimpleName());
    }

    public static String getTableListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT pt.tablename AS \"name\", pd.description AS remarks ");
        sql.append("FROM pg_tables pt ");
        sql.append("INNER JOIN pg_class pc ON pc.relname = pt.tablename ");
        sql.append("INNER JOIN pg_namespace pn ON pn.oid = pc.relnamespace AND pn.nspname = pt.schemaname ");
        sql.append("LEFT JOIN pg_description pd ON pd.objoid = pc.oid AND pd.objsubid = 0 ");
        sql.append("WHERE pt.schemaname = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("current_schema()");
        }
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND tablename = '" + tableName + "'");
        }
        return sql.toString();
    }

    public static String getColumnListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT cl.ordinal_position as cid, cl.column_name as name, cl.data_type as type, ");
        sql.append("CASE WHEN cl.is_nullable = 'NO' THEN 1 ELSE 0 END as notnull, ");
        sql.append("cl.column_default as dflt_value, cl.character_maximum_length as length, cl.numeric_scale as scale, ");
        sql.append("CASE WHEN tc.constraint_type = 'PRIMARY KEY' THEN 1 ELSE 0 END AS pk, ");
        sql.append("CASE WHEN tc.constraint_type = 'FOREIGN KEY' THEN 1 ELSE 0 END AS fk, ");
        sql.append("(SELECT pd.description ");
        sql.append("FROM pg_description pd ");
        sql.append("INNER JOIN pg_class pc ON pc.oid = pd.objoid ");
        sql.append("INNER JOIN pg_namespace pn ON pn.oid = pc.relnamespace ");
        sql.append("WHERE pn.nspname = cl.table_schema AND pc.relname = cl.table_name AND pd.objsubid = cl.ordinal_position) AS remarks ");
        sql.append("FROM information_schema.columns cl ");
        sql.append("LEFT JOIN information_schema.key_column_usage kcu ON kcu.table_name = cl.table_name AND kcu.column_name = cl.column_name AND kcu.table_schema = cl.table_schema ");
        sql.append("LEFT JOIN information_schema.table_constraints tc ON tc.constraint_name = kcu.constraint_name AND tc.table_schema = cl.table_schema ");
        sql.append("WHERE cl.table_schema = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("current_schema()");
        }
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND cl.table_name = '" + tableName + "'");
        }
        return sql.toString();
    }

    public static List<String> alterTable(List<Alter> alterList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        String transferred = SqlBeanUtil.getTransferred(alterList.get(0));
        Table table = alterList.get(0).getTable();
        StringBuffer alertSql = new StringBuffer();
        alertSql.append("ALTER TABLE ");
        alertSql.append(JavaMapPostgresqlType.getFullName(alterList.get(0), table));
        StringBuffer addOrModifySql = new StringBuffer();
        for (int i = 0; i < alterList.size(); ++i) {
            Alter alter = alterList.get(i);
            if (alter.getType() == AlterType.ADD) {
                if (addOrModifySql.length() > 0) {
                    addOrModifySql.append(", ");
                }
                addOrModifySql.append("ADD ");
                addOrModifySql.append("COLUMN ");
                addOrModifySql.append(SqlBeanUtil.addColumn(alter, alter.getColumnInfo(), null));
                sqlList.add(JavaMapPostgresqlType.addRemarks(false, alter, transferred));
                continue;
            }
            if (alter.getType() == AlterType.MODIFY) {
                if (addOrModifySql.length() > 0) {
                    addOrModifySql.append(", ");
                }
                addOrModifySql.append(JavaMapPostgresqlType.modifyColumn(alter));
                sqlList.add(JavaMapPostgresqlType.addRemarks(false, alter, transferred));
                continue;
            }
            if (alter.getType() == AlterType.DROP) {
                StringBuffer dropSql = new StringBuffer();
                dropSql.append("ALTER TABLE ");
                dropSql.append(JavaMapPostgresqlType.getFullName(alter, table));
                dropSql.append("DROP ");
                dropSql.append("(");
                dropSql.append(transferred);
                dropSql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getColumnInfo().getName().toUpperCase() : alter.getColumnInfo().getName());
                dropSql.append(transferred);
                dropSql.append(")");
                sqlList.add(dropSql.toString());
                continue;
            }
            if (alter.getType() != AlterType.CHANGE) continue;
            sqlList.add(JavaMapPostgresqlType.changeColumn(alter));
            sqlList.add(JavaMapPostgresqlType.addRemarks(false, alter, transferred));
            if (addOrModifySql.length() > 0) {
                addOrModifySql.append(", ");
            }
            alter.getColumnInfo().setName(alter.getOldColumnName());
            addOrModifySql.append(JavaMapPostgresqlType.modifyColumn(alter));
        }
        alertSql.append(addOrModifySql);
        sqlList.add(0, alertSql.toString());
        return sqlList;
    }

    private static String getFullName(Common common, Table table) {
        String transferred = SqlBeanUtil.getTransferred(common);
        boolean toUpperCase = SqlBeanUtil.isToUpperCase(common);
        StringBuffer sql = new StringBuffer();
        if (StringUtil.isNotBlank(table.getSchema())) {
            sql.append(transferred);
            sql.append(toUpperCase ? table.getSchema().toUpperCase() : table.getSchema());
            sql.append(transferred);
            sql.append(".");
        }
        sql.append(transferred);
        sql.append(toUpperCase ? table.getName().toUpperCase() : table.getName());
        sql.append(transferred);
        sql.append(" ");
        return sql.toString();
    }

    private static String modifyColumn(Alter alter) {
        ColumnInfo columnInfo = alter.getColumnInfo();
        JdbcType jdbcType = JdbcType.getType(columnInfo.getType());
        StringBuffer modifySql = new StringBuffer();
        modifySql.append("ALTER ");
        modifySql.append("COLUMN ");
        String columnName = SqlBeanUtil.getTableFieldName(alter, columnInfo.getName());
        modifySql.append(columnName);
        modifySql.append(" ");
        modifySql.append("TYPE ");
        StringBuffer typeSql = new StringBuffer();
        typeSql.append(jdbcType.name());
        if (columnInfo.getLength() != null && columnInfo.getLength() > 0L) {
            typeSql.append("(");
            typeSql.append(columnInfo.getLength());
            if (jdbcType.isFloat()) {
                typeSql.append(", ");
                typeSql.append(columnInfo.getScale() == null ? 0 : columnInfo.getScale());
            }
            typeSql.append(")");
        }
        modifySql.append(typeSql);
        modifySql.append(" USING ");
        modifySql.append(columnName);
        modifySql.append("::");
        modifySql.append(typeSql);
        if (columnInfo.getPk().booleanValue()) {
            modifySql.append(", ");
            modifySql.append("DROP ");
            modifySql.append("CONSTRAINT ");
            modifySql.append("\"");
            modifySql.append(alter.getTable().getName());
            modifySql.append("_");
            modifySql.append("pkey");
            modifySql.append("\"");
            modifySql.append(", ");
            modifySql.append("ADD ");
            modifySql.append("PRIMARY KEY");
            modifySql.append("(");
            modifySql.append(columnName);
            modifySql.append(")");
        }
        if (columnInfo.getNotnull() != null) {
            modifySql.append(", ");
            modifySql.append("ALTER ");
            modifySql.append("COLUMN ");
            modifySql.append(columnName);
            modifySql.append(columnInfo.getNotnull() != false ? " SET " : " DROP ");
            modifySql.append("NOT NULL");
        }
        if (columnInfo.getDfltValue() != null) {
            modifySql.append(", ");
            modifySql.append("ALTER ");
            modifySql.append("COLUMN ");
            modifySql.append(columnName);
            if (StringUtil.isNotEmpty(columnInfo.getDfltValue())) {
                modifySql.append(" SET ");
                modifySql.append("DEFAULT");
                modifySql.append(" ");
                modifySql.append(SqlBeanUtil.getSqlValue(alter, columnInfo.getDfltValue(), jdbcType));
            } else {
                modifySql.append(" DROP ");
                modifySql.append("DEFAULT");
            }
        }
        return modifySql.toString();
    }

    private static String changeColumn(Alter alter) {
        StringBuffer changeSql = new StringBuffer();
        changeSql.append("ALTER TABLE ");
        changeSql.append(JavaMapPostgresqlType.getFullName(alter, alter.getTable()));
        changeSql.append("RENAME ");
        changeSql.append("COLUMN ");
        changeSql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getOldColumnName().toUpperCase() : alter.getOldColumnName());
        changeSql.append(" TO ");
        changeSql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getColumnInfo().getName().toUpperCase() : alter.getColumnInfo().getName());
        return changeSql.toString();
    }

    public static String addRemarks(boolean isTable, Alter item, String transferred) {
        StringBuffer remarksSql = new StringBuffer();
        if (StringUtil.isNotBlank(item.getColumnInfo().getRemarks())) {
            remarksSql.append("COMMENT");
            remarksSql.append(" ON ");
            remarksSql.append(isTable ? "TABLE " : "COLUMN ");
            remarksSql.append(JavaMapPostgresqlType.getFullName(item, item.getTable()));
            if (!isTable) {
                remarksSql.append(".");
                remarksSql.append(transferred);
                remarksSql.append(item.getColumnInfo().getName());
                remarksSql.append(transferred);
            }
            remarksSql.append(" IS ");
            remarksSql.append("'");
            remarksSql.append(item.getColumnInfo().getRemarks());
            remarksSql.append("'");
        }
        return remarksSql.toString();
    }
}

