/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.enumerate;

import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public enum JavaMapSqlServerType {
    INT(new Class[]{Integer.TYPE, Integer.class}),
    BIGINT(new Class[]{Long.TYPE, Long.class}),
    SMALLINT(new Class[]{Short.TYPE, Short.class}),
    REAL(new Class[]{Float.TYPE, Float.class}),
    FLOAT(new Class[]{Double.TYPE, Double.class}),
    NUMERIC(new Class[]{BigDecimal.class}),
    NCHAR(new Class[]{Character.TYPE, Character.class}),
    NVARCHAR(new Class[]{String.class}),
    TINYINT(new Class[]{Byte.TYPE, Byte.class}),
    BIT(new Class[]{Boolean.TYPE, Boolean.class}),
    DATE(new Class[]{Date.class, LocalDate.class}),
    TIME(new Class[]{Time.class, LocalTime.class}),
    DATETIME2(new Class[]{Timestamp.class}),
    DATETIME(new Class[]{java.util.Date.class, LocalDateTime.class}),
    NTEXT(new Class[]{Clob.class}),
    IMAGE(new Class[]{Blob.class, Object.class});

    private Class<?>[] classes;

    private JavaMapSqlServerType(Class<?>[] classes) {
        this.classes = classes;
    }

    public static JavaMapSqlServerType getType(Class<?> clazz) {
        for (JavaMapSqlServerType javaType : JavaMapSqlServerType.values()) {
            for (Class<?> thisClazz : javaType.classes) {
                if (thisClazz != clazz) continue;
                return javaType;
            }
        }
        return null;
    }

    public static String getTypeName(Class<?> clazz) {
        return JavaMapSqlServerType.getType(clazz).name();
    }

    public static String getTableListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT o.name, p.value AS remarks ");
        sql.append("FROM sysobjects o ");
        sql.append("LEFT JOIN sys.extended_properties p ");
        sql.append("ON p.major_id = o.id AND p.minor_id = 0 ");
        sql.append("WHERE o.xtype='U'");
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND o.name = '" + tableName + "'");
        }
        return sql.toString();
    }

    public static String getColumnListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT a.cid, a.name, a.type, (CASE a.notnull WHEN 0 THEN 1 ELSE 0 END) AS notnull, ");
        sql.append("(CASE LEFT(constraint_name, 2) WHEN 'PK' THEN 1 ELSE 0 END) AS pk, ");
        sql.append("(CASE LEFT(constraint_name, 2) WHEN 'FK' THEN 1 ELSE 0 END) AS fk, ");
        sql.append("a.length, a.scale, c.value AS remarks ");
        sql.append("FROM (");
        sql.append("SELECT syscolumns.id, syscolumns.colid AS cid, syscolumns.name AS name, syscolumns.prec AS length, syscolumns.scale, systypes.name AS type, syscolumns.isnullable AS notnull, '");
        sql.append(tableName);
        sql.append("' AS table_name ");
        sql.append("FROM syscolumns, systypes ");
        sql.append("WHERE syscolumns.xusertype = systypes.xusertype AND syscolumns.id = object_id('");
        sql.append(tableName);
        sql.append("')) a ");
        sql.append("LEFT JOIN information_schema.key_column_usage b ON a.name = b.column_name AND a.table_name = b.table_name ");
        sql.append("LEFT JOIN sys.extended_properties c ON c.major_id = a.id AND c.minor_id = a.cid ");
        sql.append("ORDER BY a.cid");
        return sql.toString();
    }

    public static List<String> alterTable(List<Alter> alterList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        StringBuffer remarksSql = new StringBuffer();
        for (int i = 0; i < alterList.size(); ++i) {
            Alter alter = alterList.get(i);
            if (alter.getType() == AlterType.ADD) {
                sql.append("ALTER TABLE ");
                sql.append(JavaMapSqlServerType.getFullName(alter, alter.getTable(), null));
                sql.append("ADD ");
                sql.append(SqlBeanUtil.addColumn(alter, alter.getColumnInfo(), alter.getAfterColumnName()));
                remarksSql.append(JavaMapSqlServerType.addRemarks(alter));
            } else if (alter.getType() == AlterType.CHANGE) {
                sql.append("EXEC sp_rename ");
                sql.append(JavaMapSqlServerType.getFullName(alter, alter.getTable(), alter.getOldColumnName()));
                sql.append(", ");
                sql.append("'");
                sql.append(alter.getColumnInfo().getName());
                sql.append("'");
                sql.append(", ");
                sql.append("'");
                sql.append("COLUMN ");
                sql.append("'");
                sql.append(" ");
                sql.append(";");
                StringBuffer modifySql = JavaMapSqlServerType.modifyColumn(alter);
                if (modifySql.length() > 0) {
                    sql.append("ALTER TABLE ");
                    sql.append(modifySql);
                }
                remarksSql.append(JavaMapSqlServerType.addRemarks(alter));
            } else if (alter.getType() == AlterType.MODIFY) {
                sql.append("ALTER TABLE ");
                sql.append(JavaMapSqlServerType.modifyColumn(alter));
                remarksSql.append(JavaMapSqlServerType.addRemarks(alter));
            } else if (alter.getType() == AlterType.DROP) {
                sql.append("ALTER TABLE ");
                sql.append(JavaMapSqlServerType.getFullName(alter, alter.getTable(), null));
                sql.append("DROP ");
                sql.append("COLUMN ");
                sql.append("[");
                sql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getColumnInfo().getName().toUpperCase() : alter.getColumnInfo().getName());
                sql.append("]");
            }
            sql.append(" ");
            sql.append(";");
        }
        sqlList.add(sql.toString());
        sqlList.add(remarksSql.toString());
        return sqlList;
    }

    private static String getFullName(Alter alter, Table table, String columnName) {
        boolean rename;
        StringBuffer sql = new StringBuffer();
        boolean bl = rename = alter.getType() == AlterType.CHANGE && StringUtil.isNotBlank(columnName);
        if (rename) {
            sql.append("'");
        }
        if (StringUtil.isNotBlank(table.getSchema())) {
            sql.append("[");
            sql.append(table.getSchema());
            sql.append("]");
            sql.append(".");
        }
        sql.append("[");
        sql.append("DBO");
        sql.append("]");
        sql.append(".");
        sql.append("[");
        sql.append(SqlBeanUtil.isToUpperCase(alter) ? table.getName().toUpperCase() : table.getName());
        sql.append("]");
        if (rename) {
            sql.append(".");
            sql.append("[");
            sql.append(columnName);
            sql.append("]");
            sql.append("'");
        }
        sql.append(" ");
        return sql.toString();
    }

    private static StringBuffer modifyColumn(Alter alter) {
        StringBuffer modifySql = new StringBuffer();
        modifySql.append(JavaMapSqlServerType.getFullName(alter, alter.getTable(), null));
        modifySql.append("ALTER ");
        modifySql.append("COLUMN ");
        modifySql.append(SqlBeanUtil.addColumn(alter, alter.getColumnInfo(), alter.getAfterColumnName()));
        return modifySql;
    }

    private static String addRemarks(Alter item) {
        StringBuffer remarksSql = new StringBuffer();
        if (StringUtil.isNotBlank(item.getColumnInfo().getRemarks())) {
            remarksSql.append("IF ((SELECT COUNT(*) FROM ::fn_listextendedproperty(");
            remarksSql.append("'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'" + item.getTable().getName() + "', 'COLUMN', N'" + item.getColumnInfo().getName() + "'");
            remarksSql.append(")) > 0)");
            remarksSql.append("\n  EXEC sp_updateextendedproperty ");
            remarksSql.append("'MS_Description', N'" + item.getColumnInfo().getRemarks() + "', 'SCHEMA', N'dbo', 'TABLE', N'" + item.getTable().getName() + "', 'COLUMN', N'" + item.getColumnInfo().getName() + "'");
            remarksSql.append("\nELSE");
            remarksSql.append("\n  EXEC sp_addextendedproperty ");
            remarksSql.append("'MS_Description', N'" + item.getColumnInfo().getRemarks() + "', 'SCHEMA', N'dbo', 'TABLE', N'" + item.getTable().getName() + "', 'COLUMN', N'" + item.getColumnInfo().getName() + "'");
            remarksSql.append(";");
        }
        return remarksSql.toString();
    }
}

