/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.enumerate;

import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public enum JavaMapDerbyType {
    INTEGER(new Class[]{Integer.TYPE, Integer.class}),
    BIGINT(new Class[]{Long.TYPE, Long.class}),
    SMALLINT(new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Boolean.TYPE, Boolean.class}),
    FLOAT(new Class[]{Float.TYPE, Float.class}),
    DOUBLE(new Class[]{Double.TYPE, Double.class}),
    NUMERIC(new Class[]{BigDecimal.class}),
    CHAR(new Class[]{Character.TYPE, Character.class}),
    VARCHAR(new Class[]{String.class}),
    DATE(new Class[]{Date.class, LocalDate.class}),
    TIME(new Class[]{Time.class, LocalTime.class}),
    TIMESTAMP(new Class[]{Timestamp.class, java.util.Date.class, LocalDateTime.class}),
    CLOB(new Class[]{Clob.class}),
    BLOB(new Class[]{Blob.class, Object.class});

    private Class<?>[] classes;

    private JavaMapDerbyType(Class<?>[] classes) {
        this.classes = classes;
    }

    public static JavaMapDerbyType getType(Field field) {
        Class<?> clazz = SqlBeanUtil.getEntityClassFieldType(field);
        for (JavaMapDerbyType javaType : JavaMapDerbyType.values()) {
            for (Class<?> thisClazz : javaType.classes) {
                if (thisClazz != clazz) continue;
                return javaType;
            }
        }
        throw new SqlBeanException(field.getDeclaringClass().getName() + "\u5b9e\u4f53\u7c7b\u4e0d\u652f\u6301\u6b64\u5b57\u6bb5\u7c7b\u578b\uff1a" + clazz.getSimpleName());
    }

    public static String getTableListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT tb.TABLENAME AS \"name\", sc.SCHEMANAME AS \"schema\" ");
        sql.append("FROM SYS.SYSTABLES tb ");
        sql.append("INNER JOIN SYS.SYSSCHEMAS sc ");
        sql.append("ON sc.SCHEMAID = tb.SCHEMAID ");
        sql.append("WHERE TABLETYPE = 'T' AND sc.SCHEMANAME = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("'SA'");
        }
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND tablename = '" + tableName + "'");
        }
        return sql.toString();
    }

    public static String getColumnListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT cl.COLUMNNUMBER AS cid, cl.COLUMNNAME AS name, cl.COLUMNDATATYPE AS type, cl.COLUMNDEFAULT AS dflt_value, ");
        sql.append("(CASE WHEN cl.COLUMNNUMBER = 1 THEN '1' ELSE '0' END) AS pk, 0 AS pk ");
        sql.append("FROM SYS.SYSTABLES AS tb ");
        sql.append("INNER JOIN SYS.SYSCOLUMNS cl ");
        sql.append("ON cl.REFERENCEID = tb.TABLEID ");
        sql.append("INNER JOIN SYS.SYSSCHEMAS sc ");
        sql.append("ON sc.SCHEMAID = tb.SCHEMAID ");
        sql.append("WHERE sc.SCHEMANAME = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("'SA'");
        }
        sql.append(" AND tb.TABLENAME = '");
        sql.append(tableName);
        sql.append("' ORDER BY cl.COLUMNNUMBER");
        return sql.toString();
    }

    public static List<String> alterTable(List<Alter> alterList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (int i = 0; i < alterList.size(); ++i) {
            StringBuffer sql;
            Alter alter = alterList.get(i);
            if (alter.getType() == AlterType.ADD) {
                sql = new StringBuffer();
                sql.append("ALTER TABLE ");
                sql.append(JavaMapDerbyType.getFullName(alter, alter.getTable(), null));
                sql.append("ADD ");
                sql.append("COLUMN ");
                sql.append(SqlBeanUtil.addColumn(alter, alter.getColumnInfo(), alter.getAfterColumnName()));
                sqlList.add(sql.toString());
                continue;
            }
            if (alter.getType() == AlterType.CHANGE) {
                sqlList.add(JavaMapDerbyType.changeColumn(alter));
                StringBuffer modifySql = JavaMapDerbyType.modifyColumn(alter);
                if (modifySql.length() <= 0) continue;
                sqlList.add("ALTER TABLE " + modifySql);
                continue;
            }
            if (alter.getType() == AlterType.MODIFY) {
                sqlList.add("ALTER TABLE " + JavaMapDerbyType.modifyColumn(alter));
                continue;
            }
            if (alter.getType() != AlterType.DROP) continue;
            sql = new StringBuffer();
            sql.append("ALTER TABLE ");
            sql.append(JavaMapDerbyType.getFullName(alter, alter.getTable(), null));
            sql.append("DROP ");
            sql.append("COLUMN ");
            sql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getColumnInfo().getName().toUpperCase() : alter.getColumnInfo().getName());
            sqlList.add(sql.toString());
        }
        return sqlList;
    }

    private static String getFullName(Alter alter, Table table, String columnName) {
        boolean rename = alter.getType() == AlterType.CHANGE && StringUtil.isNotBlank(columnName);
        boolean toUpperCase = SqlBeanUtil.isToUpperCase(alter);
        StringBuffer sql = new StringBuffer();
        if (StringUtil.isNotBlank(table.getSchema())) {
            sql.append(toUpperCase ? table.getSchema().toUpperCase() : table.getSchema());
            sql.append(".");
        }
        sql.append(toUpperCase ? table.getName().toUpperCase() : table.getName());
        if (rename) {
            sql.append(".");
            sql.append(SqlBeanUtil.isToUpperCase(alter) ? columnName : columnName);
        }
        sql.append(" ");
        return sql.toString();
    }

    private static StringBuffer modifyColumn(Alter alter) {
        ColumnInfo columnInfo = alter.getColumnInfo();
        StringBuffer modifySql = new StringBuffer();
        modifySql.append(JavaMapDerbyType.getFullName(alter, alter.getTable(), null));
        modifySql.append("ALTER ");
        modifySql.append("COLUMN ");
        modifySql.append(SqlBeanUtil.getTableFieldName(alter, columnInfo.getName()));
        if (columnInfo.getNotnull() != null && columnInfo.getNotnull().booleanValue()) {
            modifySql.append(" ");
            modifySql.append("NOT NULL");
        } else if (alter.getType() == AlterType.MODIFY && columnInfo.getNotnull() != null && !columnInfo.getNotnull().booleanValue()) {
            modifySql.append(" ");
            modifySql.append("NULL");
        }
        return modifySql;
    }

    private static String changeColumn(Alter alter) {
        StringBuffer changeSql = new StringBuffer();
        changeSql.append("RENAME ");
        changeSql.append("COLUMN ");
        changeSql.append(JavaMapDerbyType.getFullName(alter, alter.getTable(), alter.getOldColumnName()));
        changeSql.append(" TO ");
        changeSql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getColumnInfo().getName().toUpperCase() : alter.getColumnInfo().getName());
        return changeSql.toString();
    }
}

