/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.processor;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.uitls.JavaParserUtil;
import cn.vonce.sql.uitls.StringUtil;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class SqlConstantProcessor
extends AbstractProcessor {
    private Messager messager;
    private Filer filer;
    public static final String PREFIX = "$";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        try {
            for (TypeElement typeElement : annotations) {
                for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                    SqlTable sqlTable = element.getAnnotation(SqlTable.class);
                    if (sqlTable != null && !sqlTable.constant()) continue;
                    ArrayList<Element> subElementList = new ArrayList<Element>();
                    DeclaredType superClassDeclaredType = (DeclaredType)((TypeElement)element).getSuperclass();
                    do {
                        if (superClassDeclaredType.toString().equals("java.lang.Object")) continue;
                        for (Element element2 : superClassDeclaredType.asElement().getEnclosedElements()) {
                            if (!element2.getKind().isField() || element2.getModifiers().contains((Object)Modifier.STATIC)) continue;
                            subElementList.add(element2);
                        }
                        superClassDeclaredType = (DeclaredType)((TypeElement)superClassDeclaredType.asElement()).getSuperclass();
                    } while (!superClassDeclaredType.toString().equals("java.lang.Object") && !superClassDeclaredType.toString().equals("java.lang.Object"));
                    for (Element element3 : element.getEnclosedElements()) {
                        if (!element3.getKind().isField() || element3.getModifiers().contains((Object)Modifier.STATIC)) continue;
                        subElementList.add(element3);
                    }
                    Element enclosingElement = element.getEnclosingElement();
                    String string = ((PackageElement)enclosingElement).getQualifiedName().toString() + ".sql";
                    String className = element.getSimpleName().toString() + PREFIX;
                    try {
                        JavaFileObject fileObject = this.filer.createSourceFile(string + "." + className, enclosingElement);
                        Writer writer = fileObject.openWriter();
                        writer.write(this.buildCode(element, subElementList, sqlTable, string, className).toString());
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        return true;
    }

    private StringBuffer buildCode(Element element, List<Element> subElementList, SqlTable sqlTable, String packageName, String className) {
        StringBuffer code = new StringBuffer();
        try {
            String schema = "";
            String tableAlias = "";
            String tableRemarks = "";
            String tableName = element.getSimpleName().toString();
            URL url = this.getClass().getClassLoader().getResource("");
            TypeDeclaration typeDeclaration = null;
            List<FieldDeclaration> fieldDeclarationList = null;
            if (url != null) {
                String sourceRoot = url.getPath().substring(1, url.getPath().lastIndexOf("/target/classes/")) + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
                String javaFilePath = sourceRoot + ((PackageElement)element.getEnclosingElement()).getQualifiedName().toString().replace(".", File.separator) + File.separator + element.getSimpleName().toString() + ".java";
                CompilationUnit compilationUnit = this.getCompilationUnit(javaFilePath);
                if (compilationUnit != null && compilationUnit.getTypes() != null && compilationUnit.getTypes().size() > 0) {
                    NodeList typeDeclarations = compilationUnit.getTypes();
                    typeDeclaration = (TypeDeclaration)typeDeclarations.get(0);
                }
                if (typeDeclaration != null) {
                    fieldDeclarationList = JavaParserUtil.getAllFieldDeclaration(sourceRoot, compilationUnit, typeDeclaration);
                    if (typeDeclaration.getComment().isPresent()) {
                        tableRemarks = JavaParserUtil.getCommentContent(((Comment)typeDeclaration.getComment().get()).getContent());
                    }
                }
            }
            if (sqlTable != null) {
                schema = sqlTable.schema();
                tableName = sqlTable.value();
                tableAlias = sqlTable.alias();
            }
            if (StringUtil.isEmpty(tableAlias)) {
                tableAlias = tableName;
            }
            code.append("/** The code is generated by the Sqlbean. Do not modify!*/\n\n");
            code.append(String.format("package %s;\n\n", packageName));
            code.append("import cn.vonce.sql.bean.Column;\n\n");
            code.append(String.format("public class %s {\n\n", className));
            code.append(String.format("\tpublic static final String _schema = \"%s\";\n", schema));
            code.append(String.format("\tpublic static final String _tableName = \"%s\";\n", tableName));
            code.append(String.format("\tpublic static final String _tableAlias = \"%s\";\n", tableAlias));
            code.append(String.format("\tpublic static final String _remarks = \"%s\";\n", tableRemarks));
            code.append(String.format("\tpublic static final String _all = \"%s.*\";\n", tableAlias));
            code.append("\tpublic static final String _count = \"COUNT(*)\";\n");
            for (Element subElement : subElementList) {
                SqlColumn sqlColumn = subElement.getAnnotation(SqlColumn.class);
                if (sqlColumn != null && sqlColumn.ignore()) continue;
                String sqlFieldName = subElement.getSimpleName().toString();
                String sqlFieldRemarks = JavaParserUtil.getFieldCommentContent(sqlFieldName, fieldDeclarationList);
                if (sqlColumn != null && StringUtil.isNotEmpty(sqlColumn.value())) {
                    sqlFieldName = sqlColumn.value();
                } else if (sqlTable != null && sqlTable.mapUsToCc()) {
                    sqlFieldName = StringUtil.humpToUnderline(sqlFieldName);
                }
                code.append(String.format("\tpublic static final String %s = \"%s\";\n", sqlFieldName, sqlFieldName));
                code.append(String.format("\tpublic static final Column %s$ = new Column(true,_tableAlias,%s,\"\",\"%s\");\n", sqlFieldName, sqlFieldName, sqlFieldRemarks));
            }
            code.append("\n}");
        }
        catch (Exception e) {
            System.out.println("error:" + e.getMessage());
        }
        return code;
    }

    private CompilationUnit getCompilationUnit(String javaFilePath) throws FileNotFoundException {
        JavaParser javaParser = new JavaParser();
        ParseResult result = javaParser.parse(new File(javaFilePath));
        Optional compilationUnitOptional = result.getResult();
        if (compilationUnitOptional.isPresent()) {
            return (CompilationUnit)compilationUnitOptional.get();
        }
        return null;
    }
}

