/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.uitls;

import cn.vonce.sql.uitls.StringUtil;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class JavaParserUtil {
    public static String getCommentContent(String rawComment) {
        String[] texts = JavaParserUtil.getCommentTexts(rawComment);
        if (texts.length == 1) {
            return texts[0];
        }
        texts = (String[])Arrays.stream(texts).filter(text -> text.charAt(0) != '@').toArray(String[]::new);
        StringBuffer content = new StringBuffer();
        for (int i = 0; i < texts.length; ++i) {
            String text2 = texts[i];
            content.append(text2);
            if (i >= texts.length - 1) continue;
            content.append(" ");
        }
        return content.toString();
    }

    public static String[] getCommentTexts(String rawComment) {
        if (StringUtil.isEmpty(rawComment)) {
            return new String[]{""};
        }
        rawComment = rawComment.replaceAll("\\*", "").replaceAll("\\/", "").replaceAll("\\r", "").trim();
        String[] texts = rawComment.split("\\n");
        return (String[])Arrays.stream(texts).filter(text -> !StringUtil.isEmpty(text.trim())).map(text -> text.trim().replace("\"", "\\\"")).toArray(String[]::new);
    }

    public static String getFieldCommentContent(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration == null) {
            return "";
        }
        Optional fieldComment = fieldDeclaration.getComment();
        if (fieldComment.isPresent()) {
            return JavaParserUtil.getCommentContent(((Comment)fieldComment.get()).getContent());
        }
        return "";
    }

    public static String getFieldCommentContent(String fieldName, List<FieldDeclaration> fieldDeclarationList) {
        return JavaParserUtil.getFieldCommentContent(JavaParserUtil.getFieldDeclaration(fieldName, fieldDeclarationList));
    }

    public static FieldDeclaration getFieldDeclaration(String fieldName, List<FieldDeclaration> fieldDeclarationList) {
        if (StringUtil.isEmpty(fieldName) || fieldDeclarationList == null || fieldDeclarationList.size() == 0) {
            return null;
        }
        for (FieldDeclaration fieldDeclaration : fieldDeclarationList) {
            if (!((VariableDeclarator)fieldDeclaration.getVariables().get(0)).getNameAsString().equals(fieldName)) continue;
            return fieldDeclaration;
        }
        return null;
    }

    public static List<FieldDeclaration> getAllFieldDeclaration(String sourceRoot, CompilationUnit compilationUnit, TypeDeclaration typeDeclaration) {
        NodeList classOrInterfaceTypeNodeList;
        ArrayList<FieldDeclaration> fieldDeclarationList = new ArrayList<FieldDeclaration>();
        fieldDeclarationList.addAll(typeDeclaration.getFields());
        String superClassName = null;
        List classOrInterfaceDeclarationList = compilationUnit.findAll(ClassOrInterfaceDeclaration.class);
        if (classOrInterfaceDeclarationList != null && classOrInterfaceDeclarationList.size() > 0 && (classOrInterfaceTypeNodeList = ((ClassOrInterfaceDeclaration)classOrInterfaceDeclarationList.get(0)).getExtendedTypes()) != null && classOrInterfaceTypeNodeList.size() > 0) {
            superClassName = ((ClassOrInterfaceType)classOrInterfaceTypeNodeList.get(0)).getNameAsString();
        }
        if (StringUtil.isNotEmpty(superClassName) && !"Object".equals(superClassName)) {
            Optional packageDeclaration = compilationUnit.getPackageDeclaration();
            if (!packageDeclaration.isPresent()) {
                return fieldDeclarationList;
            }
            String superClassPath = JavaParserUtil.getSuperClassPath(sourceRoot, ((PackageDeclaration)packageDeclaration.get()).getNameAsString(), superClassName, (List<ImportDeclaration>)compilationUnit.getImports());
            try {
                JavaParser javaParser = new JavaParser();
                ParseResult result = javaParser.parse(new File(sourceRoot + superClassPath));
                if (result == null || !result.isSuccessful() || !result.getResult().isPresent()) {
                    return null;
                }
                CompilationUnit superCompilationUnit = (CompilationUnit)result.getResult().get();
                fieldDeclarationList.addAll(JavaParserUtil.getAllFieldDeclaration(sourceRoot, superCompilationUnit, (TypeDeclaration)superCompilationUnit.getTypes().get(0)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return fieldDeclarationList;
    }

    public static String getSuperClassPath(String sourceRoot, String packageName, String superClassName, List<ImportDeclaration> importDeclarationList) {
        if (superClassName != null) {
            if (importDeclarationList != null && importDeclarationList.size() > 0) {
                ArrayList<String> importAsteriskList = new ArrayList<String>();
                for (ImportDeclaration importDeclaration : importDeclarationList) {
                    String fullName = importDeclaration.getNameAsString();
                    if (!importDeclaration.isAsterisk() && fullName.endsWith("." + superClassName)) {
                        importAsteriskList.clear();
                        return fullName.replace(".", File.separator) + ".java";
                    }
                    if (!importDeclaration.isAsterisk()) continue;
                    importAsteriskList.add(fullName);
                }
                for (String asterisk : importAsteriskList) {
                    String packPath = asterisk.replace(".", File.separator);
                    File directory = new File(sourceRoot + packPath);
                    if (directory == null || !directory.exists() || !directory.isDirectory()) continue;
                    for (File file : directory.listFiles()) {
                        if (!file.exists() || !file.isFile() || !file.getName().equals(superClassName + ".java")) continue;
                        return packPath + File.separator + superClassName;
                    }
                }
            }
            return packageName.replace(".", File.separator) + File.separator + superClassName + ".java";
        }
        return null;
    }
}

