/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.processor;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.uitls.StringUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public abstract class SqlConstantProcessor
extends AbstractProcessor {
    private final Logger logger = Logger.getLogger(SqlConstantProcessor.class.getName());
    private Messager messager;
    private Filer filer;
    public static final String PREFIX = "$";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        try {
            for (TypeElement typeElement : annotations) {
                for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                    SqlTable sqlTable = element.getAnnotation(SqlTable.class);
                    if (sqlTable != null && !sqlTable.constant()) continue;
                    ArrayList<Element> subElementList = new ArrayList<Element>();
                    DeclaredType superClassDeclaredType = (DeclaredType)((TypeElement)element).getSuperclass();
                    do {
                        if (superClassDeclaredType.toString().equals("java.lang.Object")) continue;
                        for (Element element2 : superClassDeclaredType.asElement().getEnclosedElements()) {
                            if (!element2.getKind().isField() || element2.getModifiers().contains((Object)Modifier.STATIC)) continue;
                            subElementList.add(element2);
                        }
                        superClassDeclaredType = (DeclaredType)((TypeElement)superClassDeclaredType.asElement()).getSuperclass();
                    } while (!superClassDeclaredType.toString().equals("java.lang.Object") && !superClassDeclaredType.toString().equals("java.lang.Object"));
                    for (Element element3 : element.getEnclosedElements()) {
                        if (!element3.getKind().isField() || element3.getModifiers().contains((Object)Modifier.STATIC)) continue;
                        subElementList.add(element3);
                    }
                    Element enclosingElement = element.getEnclosingElement();
                    String string = ((PackageElement)enclosingElement).getQualifiedName().toString() + ".sql";
                    String className = element.getSimpleName().toString() + PREFIX;
                    try {
                        JavaFileObject fileObject = this.filer.createSourceFile(string + "." + className, enclosingElement);
                        Writer writer = fileObject.openWriter();
                        writer.write(this.buildCode(element, subElementList, sqlTable, string, className).toString());
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        return true;
    }

    public abstract String getTableRemarks(Element var1);

    public abstract String getFieldRemarks(String var1);

    private StringBuffer buildCode(Element element, List<Element> subElementList, SqlTable sqlTable, String packageName, String className) {
        StringBuffer code = new StringBuffer();
        try {
            String schema = "";
            String tableAlias = "";
            String tableRemarks = this.getTableRemarks(element);
            String tableName = element.getSimpleName().toString();
            if (sqlTable != null) {
                schema = sqlTable.schema();
                tableName = sqlTable.value();
                tableAlias = sqlTable.alias();
            }
            if (StringUtil.isEmpty(tableAlias)) {
                tableAlias = tableName;
            }
            code.append("/** The code is generated by the Sqlbean. Do not modify!*/\n\n");
            code.append(String.format("package %s;\n\n", packageName));
            code.append("import cn.vonce.sql.bean.Column;\n\n");
            code.append(String.format("public class %s {\n\n", className));
            code.append(String.format("\tpublic static final String _schema = \"%s\";\n", schema));
            code.append(String.format("\tpublic static final String _tableName = \"%s\";\n", tableName));
            code.append(String.format("\tpublic static final String _tableAlias = \"%s\";\n", tableAlias));
            code.append(String.format("\tpublic static final String _remarks = \"%s\";\n", tableRemarks));
            code.append(String.format("\tpublic static final String _all = \"%s.*\";\n", tableAlias));
            code.append("\tpublic static final String _count = \"COUNT(*)\";\n");
            for (Element subElement : subElementList) {
                SqlColumn sqlColumn = subElement.getAnnotation(SqlColumn.class);
                if (sqlColumn != null && sqlColumn.ignore()) continue;
                String sqlFieldName = subElement.getSimpleName().toString();
                String sqlFieldRemarks = this.getFieldRemarks(sqlFieldName);
                if (sqlColumn != null && StringUtil.isNotEmpty(sqlColumn.value())) {
                    sqlFieldName = sqlColumn.value();
                } else if (sqlTable != null && sqlTable.mapUsToCc()) {
                    sqlFieldName = StringUtil.humpToUnderline(sqlFieldName);
                }
                code.append(String.format("\tpublic static final String %s = \"%s\";\n", sqlFieldName, sqlFieldName));
                code.append(String.format("\tpublic static final Column %s$ = new Column(true,_tableAlias,%s,\"\",\"%s\");\n", sqlFieldName, sqlFieldName, sqlFieldRemarks));
            }
            code.append("\n}");
        }
        catch (Exception e) {
            this.logger.warning("error [" + e.getMessage() + "]");
        }
        return code;
    }
}

