/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.json;

public class JSONReader {
    private final String json;
    private int position;

    public JSONReader(String json) {
        this.json = json;
        this.position = 0;
    }

    public char peek() throws Exception {
        if (this.position >= this.json.length()) {
            throw new IllegalStateException("Unexpected end of JSON");
        }
        return this.json.charAt(this.position);
    }

    public char next() throws Exception {
        char c = this.peek();
        ++this.position;
        return c;
    }

    public void expect(char expected) throws Exception {
        char actual = this.next();
        if (actual != expected) {
            throw new IllegalArgumentException("Expected '" + expected + "' but got '" + actual + "'");
        }
    }

    public void expect(String expected) throws Exception {
        for (char c : expected.toCharArray()) {
            this.expect(c);
        }
    }

    public void skipWhitespace() {
        while (this.position < this.json.length() && Character.isWhitespace(this.json.charAt(this.position))) {
            ++this.position;
        }
    }

    public String read(int length) throws Exception {
        if (this.position + length > this.json.length()) {
            throw new IllegalStateException("Unexpected end of JSON");
        }
        String result = this.json.substring(this.position, this.position + length);
        this.position += length;
        return result;
    }
}

