/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.dialect;

import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.Copy;
import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.dialect.SqlDialect;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.enumerate.JavaMapSqliteType;
import cn.vonce.sql.enumerate.JdbcType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SqliteDialect
implements SqlDialect<JavaMapSqliteType> {
    @Override
    public JavaMapSqliteType getType(Field field) {
        Class<?> clazz = SqlBeanUtil.getEntityClassFieldType(field);
        for (JavaMapSqliteType javaType : JavaMapSqliteType.values()) {
            for (Class<?> thisClazz : javaType.getClasses()) {
                if (thisClazz != clazz) continue;
                return javaType;
            }
        }
        throw new SqlBeanException(field.getDeclaringClass().getName() + "\u5b9e\u4f53\u7c7b\u4e0d\u652f\u6301\u6b64\u5b57\u6bb5\u7c7b\u578b\uff1a" + clazz.getSimpleName());
    }

    @Override
    public JdbcType getJdbcType(Field field) {
        return JdbcType.getType(this.getType(field).name());
    }

    @Override
    public String getTableListSql(SqlBeanMeta sqlBeanMeta, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT name ");
        sql.append("FROM sqlite_master ");
        sql.append("WHERE type='table'");
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND name = '" + tableName + "'");
        }
        return sql.toString();
    }

    @Override
    public String getColumnListSql(SqlBeanMeta sqlBeanMeta, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("pragma table_info('");
        sql.append(tableName);
        sql.append("')");
        return sql.toString();
    }

    @Override
    public List<String> alterTable(List<Alter> alterList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        SqlBeanMeta sqlBeanMeta = alterList.get(0).getSqlBeanMeta();
        Table table = alterList.get(0).getTable();
        Class<?> beanClass = alterList.get(0).getBeanClass();
        SqlTable sqlTable = beanClass.getAnnotation(SqlTable.class);
        String oldTableName = "_" + table.getName() + "_" + "old" + "_" + DateUtil.dateToString(new Date(), "yyyyMMddHHmmss");
        StringBuffer alterTableSql = new StringBuffer();
        alterTableSql.append("ALTER TABLE ");
        alterTableSql.append("\"");
        alterTableSql.append(table.getName());
        alterTableSql.append("\"");
        alterTableSql.append(" ");
        alterTableSql.append("RENAME TO ");
        alterTableSql.append("\"");
        alterTableSql.append(oldTableName);
        alterTableSql.append("\"");
        sqlList.add(alterTableSql.toString());
        Create create = new Create();
        create.setSqlBeanMeta(sqlBeanMeta);
        create.setBeanClass(beanClass);
        create.setTable(beanClass);
        sqlList.add(SqlHelper.buildCreateSql(create));
        HashMap<String, Alter> alterMap = new HashMap<String, Alter>();
        for (Alter alter : alterList) {
            alterMap.put(alter.getColumnInfo().getName(), alter);
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        ArrayList<Column> targetColumnList = new ArrayList<Column>();
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(beanClass);
        for (Field field : fieldList) {
            String columnName;
            Alter alter;
            if (SqlBeanUtil.isIgnore(field) || (alter = (Alter)alterMap.get(columnName = SqlBeanUtil.getTableFieldName(field, sqlTable))) != null && (alter.getType() == AlterType.ADD || alter.getType() == AlterType.DROP)) continue;
            String targetColumnName = alter != null && alter.getType() == AlterType.CHANGE ? alter.getOldColumnName() : columnName;
            Column column = new Column();
            column.setTableAlias(table.getAlias());
            column.setName(columnName);
            column.setAlias(column.getName());
            columnList.add(column);
            Column targetColumn = new Column();
            targetColumn.setTableAlias(table.getAlias());
            targetColumn.setName(targetColumnName);
            targetColumn.setAlias(column.getName());
            targetColumnList.add(targetColumn);
        }
        Copy copy = new Copy();
        copy.setSqlBeanMeta(sqlBeanMeta);
        copy.setBeanClass(beanClass);
        copy.setTable(beanClass);
        copy.setColumns(columnList.toArray(new Column[0]));
        copy.setTargetTableName(oldTableName);
        copy.setTargetColumns(targetColumnList.toArray(new Column[0]));
        sqlList.add(SqlHelper.buildCopy(copy));
        return sqlList;
    }

    @Override
    public String addRemarks(boolean isTable, Alter item, String escape) {
        return null;
    }

    @Override
    public String getSchemaSql(SqlBeanMeta sqlBeanMeta, String schemaName) {
        return null;
    }

    @Override
    public String getCreateSchemaSql(SqlBeanMeta sqlBeanMeta, String schemaName) {
        return null;
    }

    @Override
    public String getDropSchemaSql(SqlBeanMeta sqlBeanMeta, String schemaName) {
        return null;
    }
}

