/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.uitls;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlId;
import cn.vonce.sql.annotation.SqlJSON;
import cn.vonce.sql.annotation.SqlJoin;
import cn.vonce.sql.annotation.SqlLogically;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.annotation.SqlVersion;
import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Common;
import cn.vonce.sql.bean.Condition;
import cn.vonce.sql.bean.Join;
import cn.vonce.sql.bean.RawValue;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.define.ColumnFun;
import cn.vonce.sql.define.JoinOn;
import cn.vonce.sql.define.SqlEnum;
import cn.vonce.sql.define.SqlFun;
import cn.vonce.sql.enumerate.AlterDifference;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.IdType;
import cn.vonce.sql.enumerate.JdbcType;
import cn.vonce.sql.enumerate.WhatType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.json.JSONConvert;
import cn.vonce.sql.json.JSONConvertImpl;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.LambdaUtil;
import cn.vonce.sql.uitls.Md5Util;
import cn.vonce.sql.uitls.ReflectJdkUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class SqlBeanUtil {
    private static final Logger logger = Logger.getLogger(SqlBeanUtil.class.getName());
    private static boolean isAndroidEnv;
    private static final WeakHashMap<Class<?>, SqlTable> sqlTableMap;

    public static boolean isAndroidEnv() {
        return isAndroidEnv;
    }

    public static SqlTable getSqlTable(Class<?> clazz) {
        if (sqlTableMap.containsKey(clazz)) {
            return sqlTableMap.get(clazz);
        }
        SqlTable sqlTable = clazz.getAnnotation(SqlTable.class);
        if (sqlTable == null) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                return null;
            }
            do {
                if (superClass == Object.class) continue;
                sqlTable = superClass.getAnnotation(SqlTable.class);
                if (sqlTable != null) break;
                superClass = superClass.getSuperclass();
            } while (superClass != Object.class && superClass != Object.class);
        }
        sqlTableMap.put(clazz, sqlTable);
        return sqlTable;
    }

    public static boolean sqlTableIsConsistent(Class<?> clazz1, Class<?> clazz2) {
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz1);
        SqlTable sqlTable2 = SqlBeanUtil.getSqlTable(clazz2);
        return sqlTable != null && sqlTable2 != null && sqlTable.schema().equals(sqlTable2.schema()) && sqlTable.value().equals(sqlTable2.value());
    }

    public static Table getTable(Class<?> clazz) {
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
        if (sqlTable != null) {
            return new Table(sqlTable.schema(), sqlTable.value(), StringUtil.isEmpty(sqlTable.alias()) ? sqlTable.value() : sqlTable.alias());
        }
        String tableName = clazz.getSimpleName();
        return new Table("", tableName, tableName);
    }

    public static Table getTable(Class<?> clazz, SqlJoin sqlJoin) {
        Table table = new Table();
        if (sqlJoin != null) {
            table.setSchema(sqlJoin.schema());
            table.setName(sqlJoin.table());
            table.setAlias(sqlJoin.tableAlias());
        }
        Table classTable = SqlBeanUtil.getTable(clazz);
        if (StringUtil.isEmpty(table.getSchema())) {
            table.setSchema(classTable.getSchema());
        }
        if (StringUtil.isEmpty(table.getName())) {
            table.setName(classTable.getName());
        }
        if (StringUtil.isEmpty(table.getAlias())) {
            table.setAlias(classTable.getAlias());
        }
        if (StringUtil.isEmpty(table.getAlias())) {
            table.setAlias(classTable.getName());
        }
        return table;
    }

    public static String getTableName(Table table, Common common) {
        String tableName = SqlBeanUtil.getTableName(common, table.getSchema(), table.getName());
        return SqlBeanUtil.isToUpperCase(common) ? tableName.toUpperCase() : tableName;
    }

    public static String getTableName(Common common, String schema, String tableName) {
        String escape = SqlBeanUtil.getEscape(common);
        if (StringUtil.isNotEmpty(schema)) {
            tableName = escape + schema + escape + "." + escape + tableName + escape;
        }
        return tableName;
    }

    public static String getTableFieldName(Common common, Field field, SqlTable sqlTable) {
        return SqlBeanUtil.getTableFieldName(common, SqlBeanUtil.getTableFieldName(field, sqlTable));
    }

    public static String getTableFieldName(Common common, String name) {
        if (SqlBeanUtil.isToUpperCase(common)) {
            name = name.toUpperCase();
        }
        String escape = SqlBeanUtil.getEscape(common);
        return escape + name + escape;
    }

    public static String getTableFieldName(Field field, SqlTable sqlTable) {
        SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
        String name = field.getName();
        if (sqlColumn != null && StringUtil.isNotBlank(sqlColumn.value())) {
            name = sqlColumn.value();
        } else if (sqlTable == null || sqlTable.mapUsToCc()) {
            name = StringUtil.humpToUnderline(name);
        }
        return name;
    }

    public static Column getTableColumn(Field field, Table table, SqlTable sqlTable) {
        return new Column(table.getAlias(), SqlBeanUtil.getTableFieldName(field, sqlTable), "");
    }

    public static String getTableFieldFullName(Common common, String tableAlias, String tableFieldName) {
        String escape = SqlBeanUtil.getEscape(common);
        StringBuffer fullName = new StringBuffer();
        if (StringUtil.isNotEmpty(tableAlias)) {
            fullName.append(escape);
            fullName.append(tableAlias);
            fullName.append(escape);
            fullName.append(".");
        }
        fullName.append(escape);
        fullName.append(SqlBeanUtil.isToUpperCase(common) ? tableFieldName.toUpperCase() : tableFieldName);
        fullName.append(escape);
        return fullName.toString();
    }

    public static String getTableFieldFullName(Common common, Column column) {
        String escape = SqlBeanUtil.getEscape(common);
        StringBuffer fullName = new StringBuffer();
        if (StringUtil.isNotEmpty(column.getTableAlias())) {
            fullName.append(escape);
            fullName.append(column.getTableAlias());
            fullName.append(escape);
            fullName.append(".");
        }
        fullName.append(column.isNameEscape() ? escape : "");
        fullName.append(column.getName(SqlBeanUtil.isToUpperCase(common)));
        fullName.append(column.isNameEscape() ? escape : "");
        return fullName.toString();
    }

    public static String getTableFieldFullName(Common common, String tableAlias, Field field, SqlTable sqlTable) {
        return SqlBeanUtil.getTableFieldFullName(common, tableAlias, SqlBeanUtil.getTableFieldName(field, sqlTable));
    }

    public static String fromFullName(String schema, String tableName, String tableAlias, Common common) {
        String escape = SqlBeanUtil.getEscape(common);
        StringBuffer fromSql = new StringBuffer();
        if (SqlBeanUtil.isToUpperCase(common)) {
            tableName = tableName.toUpperCase();
            schema = schema.toUpperCase();
        }
        if (StringUtil.isNotEmpty(schema)) {
            fromSql.append(schema);
            fromSql.append(".");
        }
        fromSql.append(tableName);
        fromSql.append(" ");
        fromSql.append(escape);
        fromSql.append(tableAlias);
        fromSql.append(escape);
        return fromSql.toString();
    }

    public static Field getIdField(Class<?> clazz) throws SqlBeanException {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        Field idField = null;
        int existId = 0;
        for (Field field : fieldList) {
            SqlId sqlBeanField = field.getAnnotation(SqlId.class);
            if (sqlBeanField != null) {
                idField = field;
                ++existId;
            }
            if (existId <= 1) continue;
            throw new SqlBeanException("\u8bf7\u6b63\u786e\u6807\u8bc6@SqlId\u6ce8\u89e3\uff0cid\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728\u300a" + field.getDeclaringClass().getName() + "\u300b\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
        }
        if (existId == 0) {
            throw new SqlBeanException("\u8bf7\u68c0\u67e5\u5b9e\u4f53\u7c7b\u300a" + clazz.getName() + "\u300b\u7684id\u5b57\u6bb5\u662f\u5426\u6b63\u786e\u6807\u8bc6@SqlId\u6ce8\u89e3");
        }
        return idField;
    }

    public static Field getLogicallyField(Class<?> clazz) throws SqlBeanException {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        Field logicallyField = null;
        int existLogicallyField = 0;
        for (Field field : fieldList) {
            SqlLogically sqlLogically = field.getAnnotation(SqlLogically.class);
            if (sqlLogically != null) {
                logicallyField = field;
                ++existLogicallyField;
            }
            if (existLogicallyField <= 1) continue;
            throw new SqlBeanException("\u8bf7\u6b63\u786e\u6807\u8bc6@SqlLogically\u6ce8\u89e3\uff0c\u903b\u8f91\u5220\u9664\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728'" + field.getDeclaringClass().getName() + "'\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
        }
        if (existLogicallyField == 0) {
            throw new SqlBeanException("\u8bf7\u68c0\u67e5\u5b9e\u4f53\u7c7b\u7533\u660e\u903b\u8f91\u5220\u9664\u7684\u5b57\u6bb5\u662f\u5426\u6b63\u786e\u6807\u8bc6@SqlLogically\u6ce8\u89e3");
        }
        return logicallyField;
    }

    public static ColumnInfo buildColumnInfo(SqlBeanMeta sqlBeanMeta, Field field) {
        return SqlBeanUtil.buildColumnInfo(sqlBeanMeta, field, field.getDeclaringClass().getAnnotation(SqlTable.class), field.getAnnotation(SqlColumn.class), field.getDeclaringClass());
    }

    public static ColumnInfo buildColumnInfo(SqlBeanMeta sqlBeanMeta, Field field, SqlTable sqlTable, SqlColumn sqlColumn, Class constantClass) {
        String columnName = SqlBeanUtil.getTableFieldName(field, sqlTable);
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setName(SqlBeanUtil.isToUpperCase(sqlBeanMeta) ? columnName.toUpperCase() : columnName);
        SqlId sqlId = field.getAnnotation(SqlId.class);
        columnInfo.setPk(sqlId != null);
        columnInfo.setAutoIncr(sqlId == null ? false : sqlId.type() == IdType.AUTO);
        JdbcType jdbcType = sqlColumn != null && sqlColumn.type() != JdbcType.NOTHING ? sqlColumn.type() : sqlBeanMeta.getDbType().getSqlDialect().getJdbcType(field);
        columnInfo.setType(jdbcType.name());
        if (sqlColumn != null) {
            if (columnInfo.getPk().booleanValue()) {
                columnInfo.setNotnull(true);
            } else {
                columnInfo.setNotnull(sqlColumn.notNull());
            }
        }
        if (sqlColumn != null && sqlColumn.length() != 0L) {
            columnInfo.setLength(sqlColumn.length());
            columnInfo.setScale(sqlColumn.scale());
        } else {
            columnInfo.setLength(jdbcType.getLength() > 0L ? Long.valueOf(jdbcType.getLength()) : null);
        }
        if (sqlColumn != null && sqlColumn.scale() != 0) {
            columnInfo.setScale(sqlColumn.scale());
        } else {
            columnInfo.setScale(jdbcType.getScale() > 0 ? Integer.valueOf(jdbcType.getScale()) : null);
        }
        if (sqlColumn != null && StringUtil.isNotEmpty(sqlColumn.def())) {
            columnInfo.setDfltValue(sqlColumn.def());
        }
        if (sqlColumn != null && StringUtil.isNotEmpty(sqlColumn.remarks())) {
            columnInfo.setRemarks(sqlColumn.remarks());
        } else {
            columnInfo.setRemarks(SqlBeanUtil.getFiledRemarks(constantClass, columnInfo.getName()));
        }
        return columnInfo;
    }

    public static List<AlterDifference> columnInfoCompare(SqlBeanMeta sqlBeanMeta, ColumnInfo columnInfo, ColumnInfo toColumnInfo) {
        ArrayList<AlterDifference> alterDifferenceList = new ArrayList<AlterDifference>();
        if (!columnInfo.getPk().equals(toColumnInfo.getPk())) {
            alterDifferenceList.add(AlterDifference.PK);
        }
        if (!columnInfo.getName().equals(toColumnInfo.getName())) {
            alterDifferenceList.add(AlterDifference.NAME);
        }
        if (!columnInfo.getType().equalsIgnoreCase(toColumnInfo.getType())) {
            alterDifferenceList.add(AlterDifference.TYPE);
        }
        if (columnInfo.getNotnull() != null && !columnInfo.getNotnull().equals(toColumnInfo.getNotnull())) {
            alterDifferenceList.add(AlterDifference.NOT_NULL);
        }
        if (sqlBeanMeta.getDbType() != DbType.SQLServer && (columnInfo.getDfltValue() == null && columnInfo.getDfltValue() != toColumnInfo.getDfltValue() || columnInfo.getDfltValue() != null && !columnInfo.getDfltValue().equals(toColumnInfo.getDfltValue()))) {
            alterDifferenceList.add(AlterDifference.DFLT_VALUE);
        }
        if (!(columnInfo.getLength() == null || columnInfo.getLength().equals(toColumnInfo.getLength()) || sqlBeanMeta.getDbType() == DbType.MySQL && (sqlBeanMeta.getDbType() != DbType.MySQL || sqlBeanMeta.getDatabaseMajorVersion() >= 8) && (sqlBeanMeta.getDbType() != DbType.MySQL || sqlBeanMeta.getDatabaseMajorVersion() < 8 || columnInfo.getType().equalsIgnoreCase("tinyint") || columnInfo.getType().equalsIgnoreCase("smallint") || columnInfo.getType().equalsIgnoreCase("mediumint") || columnInfo.getType().equalsIgnoreCase("int") || columnInfo.getType().equalsIgnoreCase("bigint")))) {
            alterDifferenceList.add(AlterDifference.LENGTH);
        }
        if (columnInfo.getScale() != null && !columnInfo.getScale().equals(toColumnInfo.getScale())) {
            alterDifferenceList.add(AlterDifference.SCALE);
        }
        if (sqlBeanMeta.getDbType() != DbType.SQLite && sqlBeanMeta.getDbType() != DbType.Derby && StringUtil.isNotBlank(columnInfo.getRemarks()) && !columnInfo.getRemarks().equals(toColumnInfo.getRemarks())) {
            alterDifferenceList.add(AlterDifference.REMARKS);
        }
        if (!(sqlBeanMeta.getDbType() != DbType.MySQL && sqlBeanMeta.getDbType() != DbType.MariaDB || columnInfo.getAutoIncr().equals(toColumnInfo.getAutoIncr()))) {
            alterDifferenceList.add(AlterDifference.AUTO_INCR);
        }
        return alterDifferenceList;
    }

    public static boolean checkLogically(Class<?> clazz) {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        for (Field field : fieldList) {
            SqlLogically sqlLogically = field.getAnnotation(SqlLogically.class);
            if (sqlLogically == null) continue;
            return true;
        }
        return false;
    }

    public static Field getVersionField(Class<?> clazz) throws SqlBeanException {
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        Field versionField = null;
        int existVersionField = 0;
        for (Field field : fieldList) {
            SqlVersion sqlVersion = field.getAnnotation(SqlVersion.class);
            if (sqlVersion != null) {
                versionField = field;
                ++existVersionField;
            }
            if (existVersionField <= 1) continue;
            throw new SqlBeanException("\u8bf7\u6b63\u786e\u6807\u8bc6SqlVersion\u6ce8\u89e3\uff0cversion\u5b57\u6bb5\u53ea\u80fd\u6807\u8bc6\u4e00\u4e2a\uff0c\u4f46\u6211\u4eec\u5728'" + field.getDeclaringClass().getName() + "'\u6b64\u5b9e\u4f53\u7c7b\u6216\u5176\u7236\u7c7b\u627e\u5230\u4e86\u4e0d\u6b62\u4e00\u5904");
        }
        return versionField;
    }

    public static boolean isIgnore(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return true;
        }
        SqlJoin sqlJoin = field.getAnnotation(SqlJoin.class);
        if (sqlJoin != null) {
            return true;
        }
        SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
        if (sqlColumn != null) {
            return sqlColumn.ignore();
        }
        return false;
    }

    public static boolean isFilter(String[] filterTableFields, String tableFieldName) {
        if (filterTableFields != null) {
            for (String filter : filterTableFields) {
                if (!tableFieldName.equals(filter)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFilter(List<Column> filterColumns, Column column) {
        if (filterColumns != null) {
            for (Column item : filterColumns) {
                if ((!StringUtil.isNotBlank(item.getTableAlias()) || !column.getTableAlias().equals(item.getTableAlias()) || !column.getName().equals(item.getName())) && (!StringUtil.isBlank(item.getTableAlias()) || !column.getName().equals(item.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Field> getBeanAllField(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> superClass = clazz.getSuperclass();
        do {
            if (superClass == null || superClass == Object.class) continue;
            fieldList.addAll(Arrays.asList(superClass.getDeclaredFields()));
            superClass = superClass.getSuperclass();
        } while ((superClass == null || superClass != Object.class) && superClass != null && superClass != Object.class);
        fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fieldList;
    }

    public static Field getFieldByTableFieldName(List<Field> fieldList, String tableFieldName) {
        Field thisField = null;
        for (Field field : fieldList) {
            SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
            if ((sqlColumn == null || !sqlColumn.value().equals(tableFieldName)) && !StringUtil.humpToUnderline(field.getName()).equals(tableFieldName) && !field.getName().equals(tableFieldName)) continue;
            thisField = field;
        }
        return thisField;
    }

    public static List<Column> getSelectColumns(Class<?> clazz, List<Column> filterColumns, List<Column> columnList) throws SqlBeanException {
        if (clazz == null) {
            return null;
        }
        LinkedHashSet<Column> columnSet = new LinkedHashSet<Column>();
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
        Table table = SqlBeanUtil.getTable(clazz);
        String tableAlias = table.getAlias();
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        for (Field field : fieldList) {
            boolean isBean;
            SqlColumn sqlColumn;
            if (Modifier.isStatic(field.getModifiers()) || (sqlColumn = field.getAnnotation(SqlColumn.class)) != null && sqlColumn.ignore() || SqlBeanUtil.isFilter(filterColumns, SqlBeanUtil.getTableColumn(field, table, sqlTable))) continue;
            SqlJoin sqlJoin = field.getAnnotation(SqlJoin.class);
            boolean bl = isBean = !SqlBeanUtil.isBaseType(field.getType());
            if (sqlJoin != null && isBean) {
                Class<?> subBeanClazz = field.getType();
                if (sqlJoin.from() != null && sqlJoin.from() != Void.TYPE) {
                    subBeanClazz = sqlJoin.from();
                }
                SqlTable subSqlTable = SqlBeanUtil.getSqlTable(subBeanClazz);
                List<Field> subBeanFieldList = SqlBeanUtil.getBeanAllField(subBeanClazz);
                if (sqlJoin.value().length > 0 && !sqlJoin.value()[0].equals("")) {
                    for (String fieldName : sqlJoin.value()) {
                        Field javaField = SqlBeanUtil.getFieldByTableFieldName(subBeanFieldList, fieldName);
                        if (javaField == null) {
                            throw new SqlBeanException("\u8be5\u8868\u8fde\u63a5\u67e5\u8be2\u7684\u5b57\u6bb5\u672a\u4e0ejava\u5b57\u6bb5\u5173\u8054\uff1a" + subBeanClazz.getName() + "\u7c7b\u4e2d\u627e\u4e0d\u5230" + fieldName);
                        }
                        Table subTable = SqlBeanUtil.getTable(subBeanClazz, sqlJoin);
                        columnSet.add(new Column(subSqlTable == null ? "" : subTable.getAlias(), fieldName, SqlBeanUtil.getColumnAlias(subSqlTable == null ? "" : subTable.getAlias(), javaField.getName())));
                    }
                    continue;
                }
                Table subTable = SqlBeanUtil.getTable(subBeanClazz, sqlJoin);
                for (Field subBeanField : subBeanFieldList) {
                    SqlColumn subSqlColumn;
                    if (Modifier.isStatic(subBeanField.getModifiers()) || (subSqlColumn = subBeanField.getAnnotation(SqlColumn.class)) != null && subSqlColumn.ignore() || SqlBeanUtil.isFilter(filterColumns, SqlBeanUtil.getTableColumn(subBeanField, subTable, subSqlTable))) continue;
                    columnSet.add(new Column(subTable.getAlias(), SqlBeanUtil.getTableFieldName(subBeanField, subSqlTable), SqlBeanUtil.getColumnAlias(subTable.getAlias(), subBeanField.getName())));
                }
                continue;
            }
            if (sqlJoin != null) {
                String tableFieldName = sqlJoin.value()[0];
                if (StringUtil.isEmpty(tableFieldName)) {
                    throw new SqlBeanException("\u9700\u6307\u5b9a\u8fde\u63a5\u67e5\u8be2\u7684\u5b57\u6bb5\uff1a@SqlJoin > value = {\u201cxxx\u201d}");
                }
                String subTableAlias = StringUtil.isEmpty(sqlJoin.tableAlias()) ? sqlJoin.table() : sqlJoin.tableAlias();
                columnSet.add(new Column(subTableAlias, tableFieldName, SqlBeanUtil.getColumnAlias(subTableAlias, field.getName())));
                continue;
            }
            if (columnList != null && columnList.size() != 0) continue;
            columnSet.add(new Column(tableAlias, SqlBeanUtil.getTableFieldName(field, sqlTable), field.getName()));
        }
        return new ArrayList<Column>(columnSet);
    }

    public static Map<String, Join> setJoin(Select select, Class<?> clazz) throws SqlBeanException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(clazz);
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        HashMap<String, Join> joinFieldMap = new HashMap<String, Join>();
        for (Field field : fieldList) {
            boolean isBean;
            SqlJoin sqlJoin;
            if (Modifier.isStatic(field.getModifiers()) || (sqlJoin = field.getAnnotation(SqlJoin.class)) == null) continue;
            String key = null;
            Class<?> subClazz = field.getType();
            Table table = null;
            boolean bl = isBean = !SqlBeanUtil.isBaseType(field.getType());
            if (isBean) {
                if (sqlJoin.from() != null && sqlJoin.from() != Void.TYPE) {
                    subClazz = sqlJoin.from();
                }
                table = SqlBeanUtil.getTable(subClazz, sqlJoin);
            }
            Join join = new Join();
            join.setJoinType(sqlJoin.type());
            join.setSchema(table != null ? table.getSchema() : sqlJoin.schema());
            join.setTableName(table != null ? table.getName() : sqlJoin.table());
            join.setTableAlias(table != null ? table.getAlias() : (StringUtil.isEmpty(sqlJoin.tableAlias()) ? sqlJoin.table() : sqlJoin.tableAlias()));
            if (sqlJoin.on() != null && sqlJoin.on() != Void.TYPE) {
                JoinOn joinOn;
                key = Md5Util.encode(sqlJoin.on() + sqlJoin.on().getClassLoader().toString());
                if (joinFieldMap.containsKey(key)) continue;
                select.addJoin(join);
                if (sqlJoin.on().getEnclosingClass() != null && !Modifier.isStatic(sqlJoin.on().getModifiers())) {
                    Object enclosingInstance = sqlJoin.on().getEnclosingClass().newInstance();
                    Constructor<?> constructor = sqlJoin.on().getDeclaredConstructor(sqlJoin.on().getEnclosingClass());
                    joinOn = (JoinOn)constructor.newInstance(enclosingInstance);
                } else {
                    joinOn = (JoinOn)sqlJoin.on().newInstance();
                }
                Condition condition = new Condition();
                joinOn.on(condition);
                join.on().setDataList(condition.getDataList());
            } else if (!isBean) {
                key = Md5Util.encode(sqlJoin.table().toLowerCase() + sqlJoin.tableKeyword().toLowerCase() + sqlJoin.mainKeyword().toLowerCase());
                if (joinFieldMap.containsKey(key)) continue;
                select.addJoin(join);
                join.on(join.getTableAlias(), sqlJoin.tableKeyword(), new RawValue(SqlBeanUtil.getTableFieldFullName(select, select.getTable().getAlias(), sqlJoin.mainKeyword())));
            } else {
                String tableKeyword = SqlBeanUtil.getTableFieldName(SqlBeanUtil.getIdField(subClazz), sqlTable);
                key = Md5Util.encode(join.getTableName().toLowerCase() + tableKeyword.toLowerCase() + sqlJoin.mainKeyword().toLowerCase());
                if (joinFieldMap.containsKey(key)) continue;
                select.addJoin(join);
                join.on(join.getTableAlias(), tableKeyword, new RawValue(SqlBeanUtil.getTableFieldFullName(select, select.getTable().getAlias(), sqlJoin.mainKeyword())));
            }
            joinFieldMap.put(key, join);
        }
        return joinFieldMap;
    }

    public static String getColumnAlias(String tableAlias, String fieldName) {
        return tableAlias + "_" + fieldName;
    }

    public static String getCondition(Common common, String where, Object[] args) {
        if (where == null || where.equals("")) {
            return "";
        }
        StringBuffer conditionSql = new StringBuffer();
        int index = 0;
        for (char c : where.toCharArray()) {
            if ('?' == c) {
                StringBuffer value = new StringBuffer();
                Object[] objects = null;
                objects = args[index] == null ? null : (args[index].getClass().isArray() ? (Object[])args[index] : (args[index] instanceof Collection ? ((Collection)args[index]).toArray() : new Object[]{args[index]}));
                if (objects != null) {
                    for (Object object : objects) {
                        value.append(SqlBeanUtil.getActualValue(common, object));
                        value.append(", ");
                    }
                    value.delete(value.length() - ", ".length(), value.length());
                }
                conditionSql.append(value);
                ++index;
                continue;
            }
            if ('&' == c) {
                conditionSql.append(SqlBeanUtil.getColumn(common, args[index]));
                ++index;
                continue;
            }
            conditionSql.append(c);
        }
        return conditionSql.toString();
    }

    public static String getColumn(Common common, Object columnObject) {
        StringBuffer value = new StringBuffer();
        Column column = null;
        if (columnObject instanceof Column) {
            column = (Column)columnObject;
        }
        if (column != null) {
            String escape = SqlBeanUtil.getEscape(common);
            if (StringUtil.isNotEmpty(column.getTableAlias())) {
                value.append(escape);
                value.append(column.getTableAlias());
                value.append(escape);
                value.append(".");
            }
            value.append(column.getName());
        } else {
            value.append(columnObject);
        }
        return value.toString();
    }

    public static Object getActualValue(Common common, Object value) {
        if (value instanceof SqlFun) {
            return SqlBeanUtil.getSqlFunction(common, (SqlFun)value);
        }
        if (value instanceof Column) {
            Column column = (Column)value;
            return SqlBeanUtil.getTableFieldFullName(common, column);
        }
        if (value instanceof ColumnFun) {
            Column column = LambdaUtil.getColumn((ColumnFun)value);
            return SqlBeanUtil.getTableFieldFullName(common, column);
        }
        if (value instanceof RawValue) {
            Object raw = ((RawValue)value).getValue();
            if (raw instanceof SqlFun) {
                return SqlBeanUtil.getSqlFunction(common, (SqlFun)raw);
            }
            return raw;
        }
        return SqlBeanUtil.getSqlValue(common, value);
    }

    public static String getSqlFunction(Common common, SqlFun sqlFun) {
        StringBuffer fun = new StringBuffer();
        fun.append(sqlFun.getFunName());
        fun.append("(");
        if (sqlFun.getValues() != null && sqlFun.getValues().length > 0) {
            for (Object value : sqlFun.getValues()) {
                fun.append(SqlBeanUtil.getActualValue(common, value));
                fun.append(", ");
            }
            fun.deleteCharAt(fun.length() - ", ".length());
        }
        fun.append(")");
        return fun.toString();
    }

    public static String getCondition(Common common, String where, Object bean) {
        if (where == null || bean == null) {
            return "";
        }
        String prefix = "${";
        String suffix = "}";
        StringBuffer conditionSql = new StringBuffer(where);
        int startIndex = conditionSql.indexOf(prefix);
        while (startIndex != -1) {
            int endIndex = conditionSql.indexOf(suffix, startIndex + prefix.length());
            if (endIndex != -1) {
                String name = conditionSql.substring(startIndex + prefix.length(), endIndex);
                int nextIndex = endIndex + suffix.length();
                String value = SqlBeanUtil.getSqlValue(common, ReflectJdkUtil.instance().get(bean.getClass(), bean, name));
                conditionSql.replace(startIndex, endIndex + suffix.length(), value);
                nextIndex = startIndex + value.length();
                startIndex = conditionSql.indexOf(prefix, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return conditionSql.toString();
    }

    public static WhatType whatType(Class<?> type) {
        if (type == String.class || type == Character.TYPE || type == Character.class || type == Byte.TYPE || type == Byte.class) {
            return WhatType.STRING_TYPE;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return WhatType.BOOL_TYPE;
        }
        if (type == Short.TYPE || type == Short.class || type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == Float.TYPE || type == Float.class || type == Double.TYPE || type == Double.class) {
            return WhatType.VALUE_TYPE;
        }
        return SqlBeanUtil.jdk8DateType(type);
    }

    private static WhatType jdk8DateType(Class<?> type) {
        if (isAndroidEnv ? type == java.util.Date.class || type == Date.class || type == Timestamp.class || type == Timestamp.class || type == Time.class : type == java.util.Date.class || type == Date.class || type == Timestamp.class || type == Timestamp.class || type == Time.class || type == LocalDate.class || type == LocalTime.class || type == LocalDateTime.class) {
            return WhatType.DATE_TYPE;
        }
        return WhatType.OBJECT_TYPE;
    }

    public static WhatType whatType(JdbcType jdbcType) {
        WhatType whatType;
        switch (jdbcType) {
            case CHAR: 
            case NCHAR: 
            case VARCHAR: 
            case VARCHAR2: 
            case NVARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case NTEXT: 
            case LONGTEXT: {
                whatType = WhatType.STRING_TYPE;
                break;
            }
            case DATE: 
            case TIME: 
            case DATETIME: 
            case DATETIME2: 
            case TIMESTAMP: {
                whatType = WhatType.DATE_TYPE;
                break;
            }
            case BIT: {
                whatType = WhatType.BOOL_TYPE;
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case NUMERIC: 
            case MONEY: 
            case SMALLMONEY: {
                whatType = WhatType.VALUE_TYPE;
                break;
            }
            default: {
                whatType = WhatType.OBJECT_TYPE;
            }
        }
        return whatType;
    }

    public static boolean isBaseType(Class<?> type) {
        return type == String.class || type == Character.TYPE || type == Character.class || type == Boolean.TYPE || type == Boolean.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class || type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == Float.TYPE || type == Float.class || type == Double.TYPE || type == Double.class || type == java.util.Date.class || type == Date.class || type == Timestamp.class || type == Timestamp.class || type == Time.class || type == BigDecimal.class || SqlBeanUtil.jdk8IsBaseType(type);
    }

    private static boolean jdk8IsBaseType(Class<?> type) {
        if (!isAndroidEnv) {
            return type == LocalDate.class || type == LocalTime.class || type == LocalDateTime.class;
        }
        return false;
    }

    public static boolean isMap(Class<?> type) {
        return type == Map.class || type == HashMap.class;
    }

    public static String getSqlValue(Common common, Object value) {
        return SqlBeanUtil.getSqlValue(common, value, null);
    }

    public static String getSqlValue(Common common, Object value, JdbcType jdbcType) {
        String sqlValue;
        if (value == null) {
            return "NULL";
        }
        String single_quotation_mark = "'";
        WhatType whatType = jdbcType == null ? SqlBeanUtil.whatType(value.getClass()) : SqlBeanUtil.whatType(jdbcType);
        switch (whatType) {
            case VALUE_TYPE: {
                if (SqlBeanUtil.jdk8DateType(value.getClass()) == WhatType.DATE_TYPE) {
                    sqlValue = DateUtil.unifyDateToTimestamp(value).toString();
                    break;
                }
                sqlValue = value.toString();
                break;
            }
            case BOOL_TYPE: {
                DbType dbType = common.getSqlBeanMeta().getDbType();
                if (dbType == DbType.Postgresql) {
                    sqlValue = Boolean.parseBoolean(value.toString()) ? "'1'" : "'0'";
                    break;
                }
                if (dbType == DbType.H2 || dbType == DbType.Hsql) {
                    sqlValue = Boolean.parseBoolean(value.toString()) ? "true" : "false";
                    break;
                }
                sqlValue = Boolean.parseBoolean(value.toString()) ? "1" : "0";
                break;
            }
            case DATE_TYPE: {
                if (Objects.requireNonNull(common.getSqlBeanMeta().getDbType()) == DbType.Oracle) {
                    sqlValue = "to_timestamp(" + single_quotation_mark + DateUtil.unifyDateToString(value) + single_quotation_mark + ", 'syyyy-mm-dd hh24:mi:ss.ff')";
                    break;
                }
                sqlValue = single_quotation_mark + DateUtil.unifyDateToString(value) + single_quotation_mark;
                break;
            }
            default: {
                sqlValue = value instanceof SqlEnum ? ((SqlEnum)value).getCode().toString() : (value instanceof java.util.Date ? single_quotation_mark + DateUtil.unifyDateToString(value) + single_quotation_mark : single_quotation_mark + SqlBeanUtil.filterSQLInject(value.toString()) + single_quotation_mark);
            }
        }
        return sqlValue;
    }

    public static boolean isUsePage(Select select) {
        return select.getPage() != null && select.getPage().getPagenum() != null && select.getPage().getPagesize() != null;
    }

    public static String filterSQLInject(String str) {
        return str.replace("'", "\\'");
    }

    public static String getEscape(Common common) {
        String escape = "\"";
        DbType dbType = common.getSqlBeanMeta().getDbType();
        if (dbType == DbType.MySQL || dbType == DbType.MariaDB) {
            escape = "`";
        }
        return escape;
    }

    public static boolean isToUpperCase(Common common) {
        return common.getSqlBeanMeta().getSqlBeanConfig().getToUpperCase() != null && common.getSqlBeanMeta().getSqlBeanConfig().getToUpperCase() != false;
    }

    public static boolean isToUpperCase(SqlBeanMeta sqlBeanMeta) {
        return sqlBeanMeta.getSqlBeanConfig().getToUpperCase() != null && sqlBeanMeta.getSqlBeanConfig().getToUpperCase() != false;
    }

    public static Object updateVersion(Class<?> type, Object value) {
        if (type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class) {
            long val = 0L;
            if (value != null) {
                val = Long.parseLong(value.toString());
            }
            ++val;
            if (type == Integer.TYPE || type == Integer.class) {
                return (int)val;
            }
            return val;
        }
        if (type == java.util.Date.class || type == Timestamp.class) {
            return new java.util.Date();
        }
        return SqlBeanUtil.jdk8UpdateVersion(type, value);
    }

    private static Object jdk8UpdateVersion(Class<?> type, Object value) {
        if (!isAndroidEnv && type == LocalDateTime.class) {
            return LocalDateTime.now();
        }
        return null;
    }

    public static boolean versionEffectiveness(Class<?> type) {
        return type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == java.util.Date.class || SqlBeanUtil.jdk8VersionEffectiveness(type);
    }

    public static boolean jdk8VersionEffectiveness(Class<?> type) {
        if (!isAndroidEnv) {
            return type == LocalDateTime.class;
        }
        return false;
    }

    public static Object[] getObjectArray(Object bean) {
        Object[] objects;
        if (bean.getClass().isArray()) {
            objects = (Object[])bean;
        } else if (bean instanceof Collection) {
            Collection list = (Collection)bean;
            objects = list.toArray();
        } else {
            objects = new Object[]{bean};
        }
        return objects;
    }

    public static Object assignInitialValue(Class<?> type) {
        if (type == Byte.class || type == Byte.TYPE) {
            return new Byte("0");
        }
        if (type == Short.class || type == Short.TYPE) {
            return new Short("0");
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.class || type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.class || type == Double.TYPE) {
            return 0.0;
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return false;
        }
        if (type == String.class) {
            return "";
        }
        if (type == java.util.Date.class) {
            return new java.util.Date();
        }
        if (type == Timestamp.class) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(0);
        }
        return SqlBeanUtil.jdk8AssignInitialValue(type);
    }

    private static Object jdk8AssignInitialValue(Class<?> type) {
        if (!isAndroidEnv) {
            if (type == LocalDate.class) {
                return LocalDate.now();
            }
            if (type == LocalTime.class) {
                return LocalTime.now();
            }
            if (type == LocalDateTime.class) {
                return LocalDateTime.now();
            }
        }
        return null;
    }

    public static Object getDefaultValue(Class<?> type) {
        if (type == Byte.TYPE) {
            return new Byte("0");
        }
        if (type == Short.TYPE) {
            return new Short("0");
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    public static Object getValueConvert(Class<?> type, Object value) {
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.parseByte(value.toString());
        }
        if (type == Short.class || type == Short.TYPE) {
            return Short.parseShort(value.toString());
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(value.toString());
        }
        if (type == Long.class || type == Long.TYPE) {
            return Integer.parseInt(value.toString());
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.parseDouble(value.toString());
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf(value.toString().charAt(0));
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Boolean.parseBoolean(value.toString());
        }
        if (type == String.class) {
            return value.toString();
        }
        if (type == java.util.Date.class || type == Timestamp.class) {
            return DateUtil.stringToDate(value.toString());
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value.toString());
        }
        return SqlBeanUtil.jdk8DateValueConvert(type, value);
    }

    private static Object jdk8DateValueConvert(Class<?> type, Object value) {
        block4: {
            try {
                Class.forName("android.content.Context");
            }
            catch (ClassNotFoundException e) {
                if (type == LocalDate.class) {
                    LocalDateTime localDateTime = DateUtil.strTimeToLocalDateTime(value.toString());
                    return localDateTime.toLocalDate();
                }
                if (type == LocalTime.class) {
                    LocalDateTime localDateTime = DateUtil.strTimeToLocalDateTime(value.toString());
                    return localDateTime.toLocalTime();
                }
                if (type != LocalDateTime.class) break block4;
                return DateUtil.strTimeToLocalDateTime(value.toString());
            }
        }
        return null;
    }

    public static String addColumn(Common common, ColumnInfo columnInfo, String afterColumnName) {
        Alter alter;
        StringBuffer sql = new StringBuffer();
        JdbcType jdbcType = JdbcType.getType(columnInfo.getType());
        sql.append(SqlBeanUtil.getTableFieldName(common, columnInfo.getName()));
        sql.append(" ");
        sql.append(jdbcType.name());
        if (columnInfo.getLength() != null && columnInfo.getLength() > 0L) {
            sql.append("(");
            sql.append(columnInfo.getLength());
            if (jdbcType.isFloat()) {
                sql.append(", ");
                sql.append(columnInfo.getScale() == null ? 0 : columnInfo.getScale());
            }
            sql.append(")");
        }
        if (columnInfo.getAutoIncr() != null && columnInfo.getAutoIncr().booleanValue() && (common.getSqlBeanMeta().getDbType() == DbType.MySQL || common.getSqlBeanMeta().getDbType() == DbType.MariaDB)) {
            sql.append(" ");
            sql.append("AUTO_INCREMENT");
        }
        if (StringUtil.isNotBlank(columnInfo.getDfltValue())) {
            sql.append(" ");
            sql.append("DEFAULT");
            sql.append(" ");
            sql.append(SqlBeanUtil.getSqlValue(common, columnInfo.getDfltValue(), jdbcType));
        }
        if (columnInfo.getNotnull() != null && columnInfo.getNotnull().booleanValue() || columnInfo.getPk().booleanValue()) {
            sql.append(" ");
            sql.append("NOT NULL");
        } else if (common instanceof Alter && (alter = (Alter)common).getType() == AlterType.MODIFY && columnInfo.getNotnull() != null && !columnInfo.getNotnull().booleanValue()) {
            sql.append(" ");
            sql.append("NULL");
        }
        if (common.getSqlBeanMeta().getDbType() == DbType.MySQL || common.getSqlBeanMeta().getDbType() == DbType.MariaDB) {
            if (StringUtil.isNotBlank(columnInfo.getRemarks())) {
                sql.append(" ");
                sql.append("COMMENT");
                sql.append(" ");
                sql.append("'");
                sql.append(columnInfo.getRemarks());
                sql.append("'");
            }
            if (StringUtil.isNotBlank(afterColumnName)) {
                String escape = SqlBeanUtil.getEscape(common);
                sql.append(" ");
                sql.append("AFTER ");
                sql.append(" ");
                sql.append(escape);
                sql.append(afterColumnName);
                sql.append(escape);
            }
        }
        return sql.toString();
    }

    public static void isNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void check(Common common) {
        SqlBeanUtil.isNull(common.getSqlBeanMeta(), "\u8bf7\u8bbe\u7f6esqlBeanConfig");
        SqlBeanUtil.isNull((Object)common.getSqlBeanMeta().getDbType(), "\u8bf7\u8bbe\u7f6esqlBeanConfig -> dbType");
    }

    public static Column getColumnByField(Field field, Class<?> clazz) {
        Table table = SqlBeanUtil.getTable(clazz);
        return new Column(table.getAlias(), SqlBeanUtil.getTableFieldName(field, SqlBeanUtil.getSqlTable(field.getDeclaringClass())), "");
    }

    public static Column getColumnByLambda(SerializedLambda lambda) {
        String getter = lambda.getImplMethodName();
        String fieldName = Introspector.decapitalize(getter.replace("get", ""));
        try {
            String tableAlias;
            Class<?> tableClass = Class.forName(lambda.getImplClass().replace("/", "."));
            String methodType = lambda.getInstantiatedMethodType();
            SqlTable sqlTable = SqlBeanUtil.getSqlTable(Class.forName(methodType.substring(methodType.indexOf("(L") + 2, methodType.indexOf(";")).replace("/", ".")));
            String string = sqlTable != null ? (StringUtil.isNotBlank(sqlTable.alias()) ? sqlTable.alias() : sqlTable.value()) : (tableAlias = tableClass.getSimpleName());
            if ("class".equals(fieldName)) {
                return new Column(tableAlias, "*", "", false);
            }
            Field field = tableClass.getDeclaredField(fieldName);
            String columnName = SqlBeanUtil.getTableFieldName(field, sqlTable);
            return new Column(tableAlias, columnName, "");
        }
        catch (ClassNotFoundException e) {
            throw new SqlBeanException("\u627e\u4e0d\u5230\u7c7b\uff1a" + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new SqlBeanException("\u627e\u4e0d\u5230\u5b57\u6bb5,\u8bf7\u68c0\u67e5:" + getter + "\u65b9\u6cd5\u540d\u4e0e\u6240\u5bf9\u5e94\u7684\u5b57\u6bb5\u540d\u662f\u5426\u7b26\u5408\u6807\u51c6,\u5982\uff1aid\u5b57\u6bb5\u5bf9\u5e94\u7684get\u65b9\u6cd5\u540d\u5e94\u8be5\u4e3agetId()");
        }
    }

    public static <T, R> Column[] funToColumn(ColumnFun<T, R>[] filterColumns) {
        Column[] columns = new Column[filterColumns.length];
        for (int i = 0; i < filterColumns.length; ++i) {
            columns[i] = LambdaUtil.getColumn(filterColumns[i]);
        }
        return columns;
    }

    public static <T> T copy(T target) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(target);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            return (T)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Class<?>> getGenericTypeBySuperclass(Class<?> clazz) {
        Type[] typeArray = new Type[]{clazz.getGenericSuperclass()};
        return SqlBeanUtil.getGenericType(typeArray);
    }

    public static List<Class<?>> getGenericTypeByInterfaces(Class<?> clazz) {
        return SqlBeanUtil.getGenericType(clazz.getGenericInterfaces());
    }

    public static List<Class<?>> getGenericType(Type[] typeArray) {
        ArrayList classes = new ArrayList();
        for (Type type : typeArray) {
            Type[] types;
            if (!(type instanceof ParameterizedType)) continue;
            for (Type t : types = ((ParameterizedType)type).getActualTypeArguments()) {
                Class trueTypeClass = (Class)t;
                try {
                    classes.add(SqlBeanUtil.class.getClassLoader().loadClass(trueTypeClass.getName()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return classes;
    }

    public static Class<?> getEntityClassFieldType(Field field) {
        Class<?> clazz = field.getType();
        if (clazz.isEnum() && SqlEnum.class.isAssignableFrom(clazz)) {
            Type[] typeArray = clazz.getGenericInterfaces();
            if ((clazz = SqlBeanUtil.getGenericType(typeArray).get(0)) == null) {
                throw new SqlBeanException(field.getDeclaringClass().getName() + "\u5b9e\u4f53\u7c7b\u4e2d\u7684\u679a\u4e3e\u7c7b\u5b57\u6bb5\uff1a" + field.getType().getSimpleName() + "\u5728\u5b9e\u73b0SqlEnum\u63a5\u53e3\u65f6\u5fc5\u987b\u6307\u5b9a\u6cdb\u578b\u7c7b\u578b");
            }
            if (!SqlBeanUtil.isBaseType(clazz)) {
                throw new SqlBeanException(field.getDeclaringClass().getName() + "\u5b9e\u4f53\u7c7b\u4e2d\u7684\u679a\u4e3e\u7c7b\u5b57\u6bb5\uff1a" + field.getType().getSimpleName() + "\u5728\u5b9e\u73b0SqlEnum\u63a5\u53e3\u65f6\u6307\u5b9a\u7684\u6cdb\u578b\u7c7b\u578b\u4e0d\u652f\u6301");
            }
        }
        return clazz;
    }

    public static SqlEnum<?> matchEnum(Field field, Object value) {
        SqlEnum[] sqlEnums;
        for (SqlEnum item : sqlEnums = (SqlEnum[])field.getType().getEnumConstants()) {
            if (!item.getCode().equals(value)) continue;
            return item;
        }
        return null;
    }

    public static Class<?> getConstantClass(Class<?> clazz) {
        String name = clazz.getName();
        String constantClassName = name.substring(0, name.indexOf(clazz.getSimpleName())) + "sql." + clazz.getSimpleName() + "$";
        try {
            return Class.forName(constantClassName);
        }
        catch (ClassNotFoundException e) {
            logger.warning("ClassNotFoundException [" + e.getMessage() + "]");
            return null;
        }
    }

    public static String getBeanRemarks(Class<?> constantClass) {
        if (constantClass == null) {
            return "";
        }
        try {
            return (String)constantClass.getField("_remarks").get(null);
        }
        catch (NoSuchFieldException e) {
            logger.warning("NoSuchFieldException [" + e.getMessage() + "]");
        }
        catch (IllegalAccessException e) {
            logger.warning("IllegalAccessException [" + e.getMessage() + "]");
        }
        return "";
    }

    public static String getFiledRemarks(Class<?> constantClass, String fieldName) {
        if (constantClass == null || StringUtil.isEmpty(fieldName)) {
            return "";
        }
        try {
            return ((Column)constantClass.getField(fieldName + "$").get(null)).getRemarks();
        }
        catch (IllegalAccessException e) {
            logger.warning("IllegalAccessException [" + e.getMessage() + "]");
        }
        catch (NoSuchFieldException e) {
            logger.warning("NoSuchFieldException [" + e.getMessage() + "]");
        }
        return "";
    }

    public static JdbcType getJdbcType(SqlBeanMeta sqlBeanMeta, Field field) {
        SqlColumn sqlColumn = field.getAnnotation(SqlColumn.class);
        if (sqlColumn != null && sqlColumn.type() != JdbcType.NOTHING) {
            return sqlColumn.type();
        }
        return sqlBeanMeta.getDbType().getSqlDialect().getJdbcType(field);
    }

    public static String getJSONValue(SqlJSON sqlJSON, Object value) {
        JSONConvert jsonConvert = null;
        if (sqlJSON != null && sqlJSON.convert() != JSONConvert.class && sqlJSON.convert() != JSONConvertImpl.class) {
            try {
                jsonConvert = sqlJSON.convert().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            jsonConvert = new JSONConvertImpl();
        }
        if (value == null) {
            return null;
        }
        return jsonConvert.toJSONString(value);
    }

    public static Object convertJSON(JSONConvert convert, String json, Field field) {
        if (StringUtil.isEmpty(json)) {
            return null;
        }
        if (json.startsWith("[") && json.endsWith("]")) {
            ParameterizedType pt;
            Type[] typeArray;
            int n;
            int n2;
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType && (n2 = 0) < (n = (typeArray = (pt = (ParameterizedType)genericType).getActualTypeArguments()).length)) {
                Type typeArg = typeArray[n2];
                return convert.parseArray(json, (Class)typeArg);
            }
            return convert.parse(json);
        }
        if (json.startsWith("{") && json.endsWith("}")) {
            return convert.parseObject(json, field.getType());
        }
        return null;
    }

    static {
        try {
            Class.forName("dalvik.system.BaseDexClassLoader");
            isAndroidEnv = true;
        }
        catch (Exception e) {
            isAndroidEnv = false;
        }
        sqlTableMap = new WeakHashMap();
    }
}

