/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.java.config;

import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.service.AdvancedDbManageService;
import cn.vonce.sql.service.DbManageService;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class BaseAutoCreateTableListener {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public abstract <T> T getBean(String var1);

    public abstract <T> List<T> getBeansForType(Class<T> var1);

    public abstract List<String> getBeanNamesForType(Class<?> var1);

    public void processSqlBeanServices() {
        List<SqlBeanService> beanServiceList = this.getBeansForType(SqlBeanService.class);
        HashMap<Class, SqlBeanService> beanServiceMap = null;
        if (beanServiceList != null && !beanServiceList.isEmpty()) {
            beanServiceMap = new HashMap<Class, SqlBeanService>();
            for (SqlBeanService sqlBeanService : beanServiceList) {
                beanServiceMap.put(sqlBeanService.getBeanClass(), sqlBeanService);
            }
        }
        if (beanServiceMap != null) {
            HashMap<String, SqlBeanService> schemaMap = new HashMap<String, SqlBeanService>();
            for (SqlBeanService sqlBeanService : beanServiceMap.values()) {
                Class clazz = sqlBeanService.getBeanClass();
                if (clazz == null) continue;
                SqlTable sqlTable = SqlBeanUtil.getSqlTable((Class)clazz);
                schemaMap.put(sqlTable.schema(), sqlBeanService);
            }
            for (Map.Entry entry : schemaMap.entrySet()) {
                if (StringUtil.isNotBlank(entry.getKey())) {
                    if (((SqlBeanService)entry.getValue()).getSqlBeanMeta().getDbType() == DbType.SQLite || ((SqlBeanService)entry.getValue()).getSqlBeanMeta().getDbType() == DbType.Oracle) continue;
                    List databases = ((AdvancedDbManageService)entry.getValue()).getSchemas((String)entry.getKey());
                    if (databases == null || databases.isEmpty()) {
                        ((AdvancedDbManageService)entry.getValue()).createSchema((String)entry.getKey());
                        this.logger.info(String.format("-----Schema:[%s]\u4e0d\u5b58\u5728,\u5df2\u4e3a\u4f60\u81ea\u52a8\u521b\u5efa-----", entry.getKey()));
                    }
                }
                List tableList = ((DbManageService)entry.getValue()).getTableList();
                for (SqlBeanService sqlBeanService : beanServiceMap.values()) {
                    Class clazz = sqlBeanService.getBeanClass();
                    if (clazz == null) continue;
                    SqlTable sqlTable = SqlBeanUtil.getSqlTable((Class)clazz);
                    Table table = SqlBeanUtil.getTable((Class)clazz);
                    if (sqlTable == null || sqlTable.isView() || !sqlTable.schema().equals(entry.getKey())) continue;
                    boolean isExist = false;
                    for (TableInfo tableInfo : tableList) {
                        if (!tableInfo.getName().equalsIgnoreCase(table.getName())) continue;
                        isExist = true;
                        String remarks = sqlTable.remarks();
                        if (StringUtil.isEmpty((Object)remarks)) {
                            remarks = SqlBeanUtil.getBeanRemarks((Class)SqlBeanUtil.getConstantClass((Class)clazz));
                        }
                        if (!sqlTable.autoAlter() || remarks.equals(tableInfo.getRemarks())) break;
                        ((AdvancedDbManageService)sqlBeanService).alterRemarks(remarks);
                        break;
                    }
                    if (!isExist && sqlTable.autoCreate()) {
                        try {
                            ((AdvancedDbManageService)sqlBeanService).createTable();
                            this.logger.info(String.format("-----Table:[%s]\u4e0d\u5b58\u5728,\u5df2\u4e3a\u4f60\u81ea\u52a8\u521b\u5efa-----", StringUtil.isNotEmpty((Object)table.getSchema()) ? table.getSchema() + "." + table.getName() : table.getName()));
                            continue;
                        }
                        catch (Exception e) {
                            this.logger.warning(String.format("\u521b\u5efa\u8868\u7ed3\u6784\u51fa\u9519\uff1a" + e.getMessage(), new Object[0]));
                        }
                    }
                    if (!isExist || !sqlTable.autoAlter()) continue;
                    try {
                        ((AdvancedDbManageService)sqlBeanService).alter(table, ((AdvancedDbManageService)sqlBeanService).getColumnInfoList(table.getName()));
                    }
                    catch (Exception e) {
                        this.logger.warning(String.format("\u66f4\u65b0\u8868\u7ed3\u6784\u51fa\u9519\uff1a" + e.getMessage(), new Object[0]));
                    }
                }
            }
            schemaMap.clear();
        }
    }
}

