/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.java.config;

import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.java.config.RegisterAutoConfigMultiDataSourceBean;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public abstract class BaseAutoConfigMultiDataSource {
    protected static final Map<String, String> fieldMap = new HashMap<String, String>(8);
    protected static final String DRUID_DATA_SOURCE_CLASS = "com.alibaba.druid.pool.DruidDataSource";

    public Class<?> getTypeClass(String type) {
        Class<?> typeClass = null;
        try {
            typeClass = StringUtil.isEmpty((Object)type) ? Class.forName(DRUID_DATA_SOURCE_CLASS) : Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new SqlBeanException("\u672a\u627e\u5230\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + e.getMessage());
        }
        return typeClass;
    }

    public abstract Map<String, Object> getPropertyMap();

    public abstract String getProperty(String var1);

    public abstract String getDataSourceType();

    public abstract String getDataSourcePrefix();

    public void config(Set<String> dataSourceNameSet, String defaultDataSource, RegisterAutoConfigMultiDataSourceBean register) {
        if (dataSourceNameSet == null || dataSourceNameSet.isEmpty()) {
            return;
        }
        DataSource defaultTargetDataSource = null;
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(8);
        Class<?> typeClass = this.getTypeClass(this.getProperty(this.getDataSourceType()));
        String dataSourcePrefix = this.getDataSourcePrefix();
        for (String dataSourceName : dataSourceNameSet) {
            DataSource dataSource = null;
            try {
                dataSource = (DataSource)typeClass.newInstance();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            for (Map.Entry<String, Object> property : this.getPropertyMap().entrySet()) {
                String fieldName;
                String prefix = dataSourcePrefix + "." + dataSourceName;
                if (!property.getKey().startsWith(prefix) || property.getKey().length() <= prefix.length() || StringUtil.isBlank((Object)(fieldName = property.getKey().substring(prefix.length() + 1)))) continue;
                Field field = ReflectUtil.getField((Object)dataSource, (String)fieldName);
                if (field == null) {
                    field = ReflectUtil.getField((Object)dataSource, (String)StringUtil.underlineToHump((String)fieldName));
                }
                if (field == null && fieldMap.containsKey(fieldName)) {
                    field = ReflectUtil.getField((Object)dataSource, (String)fieldMap.get(fieldName));
                }
                if (field == null && fieldMap.containsKey(fieldName)) {
                    field = ReflectUtil.getField((Object)dataSource, (String)fieldMap.get(StringUtil.underlineToHump((String)fieldName)));
                }
                if (field == null) continue;
                try {
                    field.setAccessible(true);
                    field.set(dataSource, SqlBeanUtil.getValueConvert(field.getType(), (Object)property.getValue()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (dataSourceName.equals(defaultDataSource)) {
                defaultTargetDataSource = dataSource;
            }
            dataSourceMap.put(dataSourceName, dataSource);
        }
        register.registerBean(defaultTargetDataSource, dataSourceMap);
    }

    static {
        fieldMap.put("jdbcUrl", "url");
        fieldMap.put("url", "jdbcUrl");
        fieldMap.put("driverClassName", "driverClass");
        fieldMap.put("driverClass", "driverClassName");
        fieldMap.put("minIdle", "minimumIdle");
        fieldMap.put("minimumIdle", "minIdle");
    }
}

