/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.java.config;

import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.service.AdvancedDbManageService;
import cn.vonce.sql.service.DbManageService;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAutoCreateTableListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract <T> T getBean(String var1);

    public abstract <T> List<T> getBeansForType(Class<T> var1);

    public abstract List<String> getBeanNamesForType(Class<?> var1);

    public void processSqlBeanServices() {
        List<SqlBeanService> beanServiceList = this.getBeansForType(SqlBeanService.class);
        if (beanServiceList != null && !beanServiceList.isEmpty()) {
            HashMap<String, SqlBeanService> schemaMap = new HashMap<String, SqlBeanService>();
            for (SqlBeanService sqlBeanService : beanServiceList) {
                Class clazz = sqlBeanService.getBeanClass();
                if (clazz == null) continue;
                SqlTable sqlTable = SqlBeanUtil.getSqlTable((Class)clazz);
                schemaMap.put(sqlTable.schema(), sqlBeanService);
            }
            for (Map.Entry entry : schemaMap.entrySet()) {
                if (StringUtil.isNotBlank(entry.getKey())) {
                    if (((SqlBeanService)entry.getValue()).getSqlBeanDB().getDbType() == DbType.SQLite || ((SqlBeanService)entry.getValue()).getSqlBeanDB().getDbType() == DbType.Oracle) continue;
                    List databases = ((AdvancedDbManageService)entry.getValue()).getSchemas((String)entry.getKey());
                    if (databases == null || databases.isEmpty()) {
                        ((AdvancedDbManageService)entry.getValue()).createSchema((String)entry.getKey());
                        this.logger.info("-----Schema:[{}]\u4e0d\u5b58\u5728,\u5df2\u4e3a\u4f60\u81ea\u52a8\u521b\u5efa-----", entry.getKey());
                    }
                }
                List tableList = ((DbManageService)entry.getValue()).getTableList();
                for (SqlBeanService sqlBeanService : beanServiceList) {
                    Class clazz = sqlBeanService.getBeanClass();
                    if (clazz == null) continue;
                    SqlTable sqlTable = SqlBeanUtil.getSqlTable((Class)clazz);
                    Table table = SqlBeanUtil.getTable((Class)clazz);
                    if (sqlTable == null || sqlTable.isView() || !sqlTable.schema().equals(entry.getKey())) continue;
                    boolean isExist = false;
                    for (TableInfo tableInfo : tableList) {
                        if (!tableInfo.getName().equalsIgnoreCase(table.getName())) continue;
                        isExist = true;
                        String remarks = sqlTable.remarks();
                        if (StringUtil.isEmpty((Object)remarks)) {
                            remarks = SqlBeanUtil.getBeanRemarks((Class)SqlBeanUtil.getConstantClass((Class)clazz));
                        }
                        if (!sqlTable.autoAlter() || remarks.equals(tableInfo.getRemarks())) break;
                        ((AdvancedDbManageService)sqlBeanService).alterRemarks(remarks);
                        break;
                    }
                    if (!isExist && sqlTable.autoCreate()) {
                        ((AdvancedDbManageService)sqlBeanService).createTable();
                        this.logger.info("-----Table:[{}]\u4e0d\u5b58\u5728,\u5df2\u4e3a\u4f60\u81ea\u52a8\u521b\u5efa-----", (Object)(StringUtil.isNotEmpty((Object)table.getSchema()) ? table.getSchema() + "." + table.getName() : table.getName()));
                        continue;
                    }
                    if (!isExist || !sqlTable.autoAlter()) continue;
                    try {
                        ((AdvancedDbManageService)sqlBeanService).alter(table, ((AdvancedDbManageService)sqlBeanService).getColumnInfoList(table.getName()));
                    }
                    catch (Exception e) {
                        this.logger.error("\u66f4\u65b0\u8868\u7ed3\u6784\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                    }
                }
            }
            schemaMap.clear();
        }
    }
}

