/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.java.service;

import cn.vonce.sql.annotation.SqlId;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.IdType;
import cn.vonce.sql.enumerate.JdbcType;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class BaseSqlBeanServiceImpl {
    private SqlBeanDB sqlBeanDB;

    protected abstract SqlBeanConfig getSqlBeanConfig();

    public abstract SqlBeanDB initDBInfo();

    public SqlBeanDB getSqlBeanDB() {
        if (this.sqlBeanDB == null) {
            this.sqlBeanDB = this.initDBInfo();
            this.sqlBeanDB.setSqlBeanConfig(this.getSqlBeanConfig());
            boolean isUserConfig = true;
            if (this.sqlBeanDB.getSqlBeanConfig() == null) {
                isUserConfig = false;
                this.sqlBeanDB.setSqlBeanConfig(new SqlBeanConfig());
            }
            if (!isUserConfig) {
                switch (Objects.requireNonNull(this.sqlBeanDB.getDbType())) {
                    case Oracle: 
                    case DB2: 
                    case Derby: 
                    case Hsql: 
                    case H2: {
                        this.sqlBeanDB.getSqlBeanConfig().setToUpperCase(Boolean.valueOf(true));
                    }
                }
            }
        }
        return this.sqlBeanDB;
    }

    public void handleColumnInfo(List<ColumnInfo> columnInfoList) {
        block21: {
            DbType dbType;
            block23: {
                block22: {
                    block20: {
                        dbType = this.getSqlBeanDB().getDbType();
                        if (dbType != DbType.Derby) break block20;
                        for (ColumnInfo info : columnInfoList) {
                            String[] values = info.getType().split(" ");
                            info.setType(StringUtil.getWord((String)values[0]));
                            if (values.length > 1) {
                                info.setNotnull(Boolean.valueOf(true));
                            } else {
                                info.setNotnull(Boolean.valueOf(false));
                            }
                            String[] range = StringUtil.getBracketContent((String)values[0]).split(",");
                            info.setLength(Long.valueOf("".equals(range[0]) ? 0L : Long.parseLong(range[0])));
                            info.setScale(Integer.valueOf(range.length == 1 ? 0 : Integer.parseInt(range[1])));
                            info.setDfltValue(this.processDefaultValue(info.getDfltValue()));
                        }
                        break block21;
                    }
                    if (dbType != DbType.H2 && dbType != DbType.Postgresql) break block22;
                    Boolean toUpperCase = this.getSqlBeanDB().getSqlBeanConfig().getToUpperCase();
                    for (ColumnInfo info : columnInfoList) {
                        String deftValue;
                        if ("CHARACTER VARYING".equalsIgnoreCase(info.getType())) {
                            info.setType(JdbcType.VARCHAR.getName(toUpperCase));
                        } else if ("CHARACTER LARGE OBJECT".equalsIgnoreCase(info.getType())) {
                            info.setType(JdbcType.LONGTEXT.getName(toUpperCase));
                        } else if ("BINARY VARYING".equalsIgnoreCase(info.getType())) {
                            info.setType(JdbcType.BLOB.getName(toUpperCase));
                        } else if ("BINARY LARGE OBJECT".equalsIgnoreCase(info.getType())) {
                            info.setType(JdbcType.LONGBLOB.getName(toUpperCase));
                        } else if ("TIMESTAMP WITHOUT TIME ZONE".equalsIgnoreCase(info.getType())) {
                            info.setType(JdbcType.TIMESTAMP.getName(toUpperCase));
                        } else if ("TIME WITHOUT TIME ZONE".equalsIgnoreCase(info.getType())) {
                            info.setType(JdbcType.TIME.getName(toUpperCase));
                        }
                        if ((deftValue = info.getDfltValue()) == null || !StringUtil.isNotBlank((Object)deftValue) || deftValue.indexOf("'::") <= -1) continue;
                        info.setDfltValue(deftValue.substring(1, deftValue.indexOf("'::")));
                    }
                    break block21;
                }
                if (dbType != DbType.Oracle && dbType != DbType.DB2) break block23;
                for (ColumnInfo info : columnInfoList) {
                    info.setDfltValue(this.processDefaultValue(info.getDfltValue()));
                }
                break block21;
            }
            if (dbType != DbType.SQLite) break block21;
            for (ColumnInfo info : columnInfoList) {
                if (info.getType().indexOf("(") > -1 && info.getType().indexOf(")") > -1) {
                    String range = info.getType().substring(info.getType().indexOf("(") + 1, info.getType().indexOf(")"));
                    if (range.indexOf(",") > -1) {
                        String[] ranges = range.split(",");
                        info.setLength(Long.valueOf(Long.parseLong(ranges[0])));
                        info.setScale(Integer.valueOf(Integer.parseInt(ranges[1])));
                    } else {
                        info.setLength(Long.valueOf(Long.parseLong(range)));
                    }
                    info.setType(info.getType().substring(0, info.getType().indexOf("(")));
                }
                info.setDfltValue(this.processDefaultValue(info.getDfltValue()));
            }
        }
    }

    private String processDefaultValue(String dfltValue) {
        if (dfltValue != null) {
            if ((dfltValue = dfltValue.trim()).charAt(0) == '\'' && dfltValue.charAt(dfltValue.length() - 1) == '\'') {
                return dfltValue.substring(1, dfltValue.length() - 1);
            }
            return dfltValue;
        }
        return null;
    }

    public void sqlBeanDBFill(SqlBeanDB sqlBeanDB, DatabaseMetaData metaData) throws SQLException {
        sqlBeanDB.setProductName(metaData.getDatabaseProductName());
        sqlBeanDB.setDatabaseMajorVersion(metaData.getDatabaseMajorVersion());
        sqlBeanDB.setDatabaseMinorVersion(metaData.getDatabaseMinorVersion());
        sqlBeanDB.setDatabaseProductVersion(metaData.getDatabaseProductVersion());
        sqlBeanDB.setJdbcMajorVersion(metaData.getJDBCMajorVersion());
        sqlBeanDB.setJdbcMinorVersion(metaData.getJDBCMinorVersion());
        sqlBeanDB.setDriverMajorVersion(metaData.getDatabaseMajorVersion());
        sqlBeanDB.setDriverMinorVersion(metaData.getDriverMinorVersion());
        sqlBeanDB.setDriverVersion(metaData.getDriverVersion());
        sqlBeanDB.setDriverName(metaData.getDriverName());
        sqlBeanDB.setDbType(DbType.getDbType((String)sqlBeanDB.getProductName()));
    }

    public abstract Long getAutoIncrId();

    public <T> void setAutoIncrId(Class<?> clazz, Collection<T> beanList) {
        if (beanList == null || beanList.size() == 0) {
            return;
        }
        Field idField = SqlBeanUtil.getIdField(clazz);
        if (idField != null && idField.getAnnotation(SqlId.class).type() == IdType.AUTO) {
            Long idBeginValue = this.getAutoIncrId();
            if (idBeginValue == null) {
                return;
            }
            int i = 0;
            for (T t : beanList) {
                Field field = SqlBeanUtil.getIdField(t.getClass());
                if (Number.class.isAssignableFrom(field.getType())) {
                    Long value = idBeginValue + (long)i;
                    Object newValue = ReflectUtil.instance().invoke(field.getType(), null, "valueOf", new Class[]{String.class}, new Object[]{value.toString()});
                    ReflectUtil.instance().set(t.getClass(), t, field.getName(), newValue);
                }
                ++i;
            }
        }
    }
}

