/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.intercept;

import cn.vonce.validator.annotation.VBean;
import cn.vonce.validator.config.EnableValidator;
import cn.vonce.validator.config.ResultConfig;
import cn.vonce.validator.enumerate.ResultCode;
import cn.vonce.validator.enumerate.ResultType;
import cn.vonce.validator.exception.ValidatorException;
import cn.vonce.validator.helper.ValidatorHelper;
import cn.vonce.validator.model.BeanResult;
import cn.vonce.validator.model.FieldResult;
import cn.vonce.validator.utils.RequestDataUtil;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.noear.solon.Solon;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextUtil;

public class ValidatorInterceptor
implements Interceptor {
    private final Logger logger = Logger.getLogger(ValidatorInterceptor.class.getName());

    public Object doIntercept(Invocation inv) throws Throwable {
        String fullName = inv.method().getMethod().getReturnType().getSimpleName() + " " + inv.getTargetClz().getName() + "." + inv.method().getMethod().getName();
        if (fullName.contains("$$")) {
            return inv.invoke();
        }
        if (inv.args().length == 0) {
            return inv.invoke();
        }
        BeanResult beanResult = new BeanResult(true, "\u6821\u9a8c\u901a\u8fc7");
        for (int i = 0; i < inv.args().length; ++i) {
            Object object = inv.args()[i];
            Annotation[] annotations = inv.method().getMethod().getParameterAnnotations()[i];
            VBean validBean = (VBean)ValidatorHelper.getAnnotation((Annotation[])annotations, VBean.class);
            if (validBean != null) {
                beanResult = ValidatorHelper.validBean((Object)object, (String)validBean.group(), (boolean)validBean.interrupt());
                break;
            }
            List validFieldResultList = ValidatorHelper.valid((Annotation[])annotations, (String)(inv.method().getMethod().getName() + "\u65b9\u6cd5\u7b2c" + (i + 1) + "\u4e2a\u53c2\u6570"), (Object)object, null, (String)"", (boolean)true);
            if (validFieldResultList.isEmpty()) continue;
            beanResult = new BeanResult("\u6821\u9a8c\u5b58\u5728" + validFieldResultList.size() + "\u6761\u9519\u8bef", validFieldResultList);
            break;
        }
        this.logger.info("\u6b63\u5728\u6821\u9a8c\u53c2\u6570: " + fullName + "[" + ContextUtil.current().uri() + "]");
        Collection collection = ContextUtil.current().paramNames();
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        for (String key : collection) {
            paramsMap.put(key, ContextUtil.current().paramValues(key));
        }
        this.logger.info("\u8bf7\u6c42URL\u53c2\u6570: " + RequestDataUtil.getParameters(paramsMap));
        if (!beanResult.isPass()) {
            ResultType resultType;
            String tips = ((FieldResult)beanResult.getFieldResultList().get(0)).getTips();
            this.logger.warning(beanResult.getMessage() + "\uff0c\u8be6\u60c5\u8bf7\u770b: " + beanResult.getFieldResultList());
            this.logger.info("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7: " + fullName);
            EnableValidator enableValidator = inv.getTargetClz().getAnnotation(EnableValidator.class);
            if (enableValidator != null) {
                resultType = enableValidator.resultType();
            } else {
                ResultConfig resultConfig = (ResultConfig)Solon.context().getBean(ResultConfig.class);
                resultType = resultConfig.getResultType();
            }
            if (resultType == null || resultType == ResultType.THROW_TIPS) {
                throw new ValidatorException("\u53c2\u6570\u6821\u9a8c\u9519\u8bef[" + tips + "]");
            }
            this.defaultResult(tips, ContextUtil.current().path(), ContextUtil.current());
            return null;
        }
        return inv.invoke();
    }

    private void defaultResult(String tips, String path, Context current) {
        current.charset("UTF-8");
        current.contentType("application/json; charset=utf-8");
        String data = "{\"code\":" + ResultCode.BAD.getCode() + ",\"msg\":\"" + tips + "\"}";
        current.output(data);
        this.logger.info(path + " \u7684\u54cd\u5e94\u5185\u5bb9\uff1a" + data);
    }
}

